/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.build.GradleBuildContext;
import com.android.tools.idea.gradle.project.build.JpsBuildContext;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;

public class AndroidGradleProjectComponent
extends AbstractProjectComponent {
    @NonNls
    private static final String SHOW_MIGRATE_TO_GRADLE_POPUP = "show.migrate.to.gradle.popup";
    @Nullable
    private Disposable myDisposable;

    @NotNull
    public static AndroidGradleProjectComponent getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "getInstance"));
        }
        AndroidGradleProjectComponent component = (AndroidGradleProjectComponent)((Object)project.getComponent(AndroidGradleProjectComponent.class));
        assert (component != null);
        AndroidGradleProjectComponent androidGradleProjectComponent = component;
        if (androidGradleProjectComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "getInstance"));
        }
        return androidGradleProjectComponent;
    }

    public AndroidGradleProjectComponent(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "<init>"));
        }
        super(project);
        CompilerManager.getInstance((Project)this.myProject).addAfterTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                if (Projects.isBuildWithGradle(AndroidGradleProjectComponent.this.myProject)) {
                    PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(context);
                    JpsBuildContext newContext = new JpsBuildContext(context);
                    AndroidProjectBuildNotifications.getInstance(AndroidGradleProjectComponent.this.myProject).notifyBuildComplete(newContext);
                }
                return true;
            }
        });
        GradleInvoker.getInstance(this.myProject).addAfterGradleInvocationTask(new GradleInvoker.AfterGradleInvocationTask(){

            @Override
            public void execute(@NotNull GradleInvocationResult result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent$2", "execute"));
                }
                PostProjectBuildTasksExecutor.getInstance(project).onBuildCompletion(result);
                GradleBuildContext newContext = new GradleBuildContext(result);
                AndroidProjectBuildNotifications.getInstance(AndroidGradleProjectComponent.this.myProject).notifyBuildComplete(newContext);
            }
        });
    }

    public void projectOpened() {
        this.checkForSupportedModules();
        GradleSyncState syncState = GradleSyncState.getInstance(this.myProject);
        if (syncState.isSyncInProgress()) {
            syncState.notifyUser();
        }
        if (AndroidStudioInitializer.isAndroidStudio() && Projects.isLegacyIdeaAndroidProject(this.myProject)) {
            this.trackLegacyIdeaAndroidProject();
            if (this.shouldShowMigrateToGradleNotification()) {
                this.showMigrateToGradleWarning();
            }
            return;
        }
        boolean isGradleProject = Projects.isBuildWithGradle(this.myProject);
        if (isGradleProject) {
            this.configureGradleProject();
        } else if (Projects.canImportAsGradleProject(this.myProject.getBaseDir())) {
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
        }
    }

    private boolean shouldShowMigrateToGradleNotification() {
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_MIGRATE_TO_GRADLE_POPUP, true);
    }

    private void trackLegacyIdeaAndroidProject() {
        if (!UsageTracker.getInstance().canTrack()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                String packageName = null;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)AndroidGradleProjectComponent.this.myProject);
                for (Module module : moduleManager.getModules()) {
                    String modulePackageName;
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null || facet.requiresAndroidModel()) continue;
                    boolean library = facet.isLibraryProject();
                    if (!library) {
                        packageName = AndroidGradleProjectComponent.getPackageNameInLegacyIdeaAndroidModule(facet);
                        if (packageName == null) continue;
                        break;
                    }
                    if (packageName != null || (modulePackageName = AndroidGradleProjectComponent.getPackageNameInLegacyIdeaAndroidModule(facet)) == null) continue;
                    packageName = modulePackageName;
                }
                if (packageName != null) {
                    UsageTracker.getInstance().trackLegacyIdeaAndroidProject(packageName);
                }
            }
        });
    }

    @Nullable
    private static String getPackageNameInLegacyIdeaAndroidModule(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent", "getPackageNameInLegacyIdeaAndroidModule"));
        }
        Manifest manifest = facet.getManifest();
        return manifest != null ? (String)manifest.getPackage().getValue() : null;
    }

    private void showMigrateToGradleWarning() {
        String errMsg = "This project does not use the Gradle build system. We recommend that you migrate to using the Gradle build system.";
        NotificationHyperlink moreInfoHyperlink = new OpenMigrationToGradleUrlHyperlink().setCloseOnClick(true);
        NotificationHyperlink doNotShowAgainHyperlink = new NotificationHyperlink("do.not.show", "Don't show this message again."){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectComponent$4", "execute"));
                }
                PropertiesComponent.getInstance((Project)AndroidGradleProjectComponent.this.myProject).setValue(AndroidGradleProjectComponent.SHOW_MIGRATE_TO_GRADLE_POPUP, Boolean.FALSE.toString());
            }
        };
        AndroidGradleNotification notification = AndroidGradleNotification.getInstance(this.myProject);
        notification.showBalloon("Migrate Project to Gradle?", errMsg, NotificationType.WARNING, moreInfoHyperlink, doNotShowAgainHyperlink);
    }

    public void configureGradleProject() {
        if (this.myDisposable != null) {
            return;
        }
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
        this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        Projects.enforceExternalBuild(this.myProject);
        RunConfigurationProducerService runConfigurationProducerManager = RunConfigurationProducerService.getInstance((Project)this.myProject);
        runConfigurationProducerManager.getState().ignoredProducers.remove(AllInPackageGradleConfigurationProducer.class.getName());
        runConfigurationProducerManager.getState().ignoredProducers.remove(TestMethodGradleConfigurationProducer.class.getName());
        runConfigurationProducerManager.getState().ignoredProducers.remove(TestClassGradleConfigurationProducer.class.getName());
    }

    public void projectClosed() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    public void checkForSupportedModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 0 || !Projects.isBuildWithGradle(this.myProject)) {
            return;
        }
        ArrayList<Module> unsupportedModules = new ArrayList<Module>();
        for (Module module : modules) {
            ModuleType moduleType = ModuleType.get((Module)module);
            if (!(moduleType instanceof JavaModuleType)) continue;
            String externalSystemId = module.getOptionValue("external.system.id");
            if (GradleUtil.GRADLE_SYSTEM_ID.getId().equals(externalSystemId)) continue;
            unsupportedModules.add(module);
        }
        if (unsupportedModules.size() == 0) {
            return;
        }
        String s = StringUtil.join(unsupportedModules, (Function)new Function<Module, String>(){

            public String fun(Module module) {
                return module.getName();
            }
        }, (String)", ");
        AndroidGradleNotification.getInstance(this.myProject).showBalloon("Unsupported Modules Detected", "Compilation is not supported for following modules: " + s + ". Unfortunately you can't have non-Gradle Java modules and Android-Gradle modules in one project.", NotificationType.ERROR);
    }
}

