/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.logcat.AndroidConfiguredLogFilters;
import com.android.tools.idea.logcat.AndroidConsoleWriter;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.logcat.AndroidLogcatUtils;
import com.android.tools.idea.logcat.ConfigureLogcatFormatDialog;
import com.android.tools.idea.logcat.ConfiguredFilter;
import com.android.tools.idea.logcat.EditLogFilterDialog;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLogcatView
implements Disposable {
    public static final Key<AndroidLogcatView> ANDROID_LOGCAT_VIEW_KEY = Key.create((String)"ANDROID_LOGCAT_VIEW_KEY");
    static final String SELECTED_APP_FILTER = AndroidBundle.message("android.logcat.filters.selected", new Object[0]);
    static final String NO_FILTERS = AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    static final String EDIT_FILTER_CONFIGURATION = AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    private final Project myProject;
    private final DeviceContext myDeviceContext;
    private JPanel myPanel;
    private DefaultComboBoxModel myFilterComboBoxModel;
    private volatile IDevice myDevice;
    private final AndroidLogConsole myLogConsole;
    private final AndroidLogFilterModel myLogFilterModel;
    private final IDevice myPreselectedDevice;
    @NotNull
    private ConfiguredFilter mySelectedAppFilter;
    @NotNull
    private ConfiguredFilter myNoFilter;
    @Nullable
    private volatile AndroidLogcatReceiver myReceiver;

    private void notifyDeviceUpdated(final boolean forceReconnect) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AndroidLogcatView.this.myProject.isDisposed()) {
                    return;
                }
                if (forceReconnect) {
                    AndroidLogcatView.this.myDevice = null;
                }
                AndroidLogcatView.this.updateLogConsole();
            }
        });
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView", "getProject"));
        }
        return project;
    }

    @NotNull
    public final LogConsoleBase getLogConsole() {
        AndroidLogConsole androidLogConsole = this.myLogConsole;
        if (androidLogConsole == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView", "getLogConsole"));
        }
        return androidLogConsole;
    }

    public final void clearLogcat(@Nullable IDevice device) {
        if (device == null) {
            return;
        }
        this.myLogFilterModel.beginRejectingOldMessages();
        AndroidLogcatUtils.clearLogcat(this.myProject, device);
        if (device.equals(this.getSelectedDevice())) {
            this.notifyDeviceUpdated(true);
        }
    }

    public AndroidLogcatView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/logcat/AndroidLogcatView", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/logcat/AndroidLogcatView", "<init>"));
        }
        this(project, null, deviceContext);
    }

    private AndroidLogcatView(final Project project, @Nullable IDevice preselectedDevice, @Nullable DeviceContext deviceContext) {
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.myPreselectedDevice = preselectedDevice;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myLogFilterModel = new AndroidLogFilterModel(){
            @Nullable
            private ConfiguredFilter myConfiguredFilter;

            @Override
            protected void saveLogLevel(String logLevelName) {
                AndroidLogcatPreferences.getInstance((Project)project).TOOL_WINDOW_LOG_LEVEL = logLevelName;
            }

            @Override
            public String getSelectedLogLevelName() {
                return AndroidLogcatPreferences.getInstance((Project)project).TOOL_WINDOW_LOG_LEVEL;
            }

            @Override
            protected void setConfiguredFilter(@Nullable ConfiguredFilter filter) {
                AndroidLogcatPreferences.getInstance((Project)project).TOOL_WINDOW_CONFIGURED_FILTER = filter != null ? filter.getName() : "";
                this.myConfiguredFilter = filter;
            }

            @Override
            @Nullable
            protected ConfiguredFilter getConfiguredFilter() {
                return this.myConfiguredFilter;
            }
        };
        AndroidLogcatFormatter logFormatter = new AndroidLogcatFormatter(AndroidLogcatPreferences.getInstance(project));
        this.myLogConsole = new AndroidLogConsole(project, this.myLogFilterModel, (LogFormatter)logFormatter);
        if (preselectedDevice == null && deviceContext != null) {
            DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

                @Override
                public void deviceSelected(@Nullable IDevice device) {
                    AndroidLogcatView.this.notifyDeviceUpdated(false);
                }

                @Override
                public void deviceChanged(@NotNull IDevice device, int changeMask) {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatView$3", "deviceChanged"));
                    }
                    if (device == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                        AndroidLogcatView.this.notifyDeviceUpdated(true);
                    }
                }

                @Override
                public void clientSelected(@Nullable Client c) {
                    boolean reselect = AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem() == AndroidLogcatView.this.mySelectedAppFilter;
                    AndroidConfiguredLogFilters.FilterEntry f = c != null ? AndroidConfiguredLogFilters.getInstance(AndroidLogcatView.this.myProject).createFilterForClient(c.getClientData()) : new AndroidConfiguredLogFilters.FilterEntry();
                    int index = AndroidLogcatView.this.myFilterComboBoxModel.getIndexOf(AndroidLogcatView.this.mySelectedAppFilter);
                    if (index >= 0) {
                        AndroidLogcatView.this.myFilterComboBoxModel.removeElementAt(index);
                        AndroidLogcatView.this.mySelectedAppFilter = ConfiguredFilter.compile(f, SELECTED_APP_FILTER);
                        AndroidLogcatView.this.myFilterComboBoxModel.insertElementAt(AndroidLogcatView.this.mySelectedAppFilter, index);
                    }
                    if (reselect) {
                        AndroidLogcatView.this.myFilterComboBoxModel.setSelectedItem(AndroidLogcatView.this.mySelectedAppFilter);
                    }
                }
            };
            deviceContext.addListener(deviceSelectionListener, this);
        }
        this.mySelectedAppFilter = ConfiguredFilter.compile(new AndroidConfiguredLogFilters.FilterEntry(), SELECTED_APP_FILTER);
        this.myNoFilter = ConfiguredFilter.compile(new AndroidConfiguredLogFilters.FilterEntry(), NO_FILTERS);
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.myLogConsole.getOrCreateActions(), false);
            toolbar.setTargetComponent(console.getComponent());
            JComponent tbComp1 = toolbar.getComponent();
            this.myPanel.add((Component)tbComp1, "West");
        }
        this.myPanel.add((Component)consoleComponent, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myLogConsole);
        this.updateLogConsole();
    }

    @NotNull
    public final JPanel createSearchComponent() {
        JPanel panel = new JPanel();
        final ComboBox editFiltersCombo = new ComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        editFiltersCombo.setModel((ComboBoxModel)this.myFilterComboBoxModel);
        String def = AndroidLogcatPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        if (StringUtil.isEmpty((String)def)) {
            def = this.myDeviceContext != null ? SELECTED_APP_FILTER : NO_FILTERS;
        }
        this.updateFilterCombobox(def);
        this.applySelectedFilter();
        editFiltersCombo.addItemListener(new ItemListener(){
            @Nullable
            private ConfiguredFilter myLastSelected;

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 2) {
                    if (item instanceof ConfiguredFilter) {
                        this.myLastSelected = (ConfiguredFilter)item;
                    }
                } else if (e.getStateChange() == 1) {
                    if (item instanceof ConfiguredFilter) {
                        AndroidLogcatView.this.applySelectedFilter();
                    } else {
                        assert (EDIT_FILTER_CONFIGURATION.equals(item));
                        EditLogFilterDialog dialog = new EditLogFilterDialog(AndroidLogcatView.this, this.myLastSelected == null ? null : this.myLastSelected.getName());
                        dialog.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                        if (dialog.showAndGet()) {
                            AndroidConfiguredLogFilters.FilterEntry newEntry = dialog.getCustomLogFiltersEntry();
                            AndroidLogcatView.this.updateFilterCombobox(newEntry != null ? newEntry.getName() : null);
                        } else {
                            editFiltersCombo.setSelectedItem((Object)this.myLastSelected);
                        }
                    }
                }
            }
        });
        editFiltersCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ConfiguredFilter) {
                    this.setBorder(null);
                    this.append(((ConfiguredFilter)value).getName());
                } else {
                    this.setBorder(IdeBorderFactory.createBorder((int)8));
                    this.append(value.toString());
                }
            }
        });
        panel.add((Component)editFiltersCombo);
        JPanel searchComponent = new JPanel();
        searchComponent.setLayout(new BoxLayout(searchComponent, 0));
        searchComponent.add(this.myLogConsole.getSearchComponent());
        searchComponent.add(panel);
        JPanel jPanel = searchComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView", "createSearchComponent"));
        }
        return jPanel;
    }

    protected abstract boolean isActive();

    public final void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    private void updateLogConsole() {
        IDevice device = this.getSelectedDevice();
        if (this.myDevice != device) {
            this.myDevice = device;
            AndroidLogcatReceiver receiver = this.myReceiver;
            if (receiver != null) {
                receiver.cancel();
            }
            if (device != null) {
                ConsoleView console = this.myLogConsole.getConsole();
                if (console != null) {
                    console.clear();
                }
                this.myReceiver = AndroidLogcatUtils.startLoggingThread(this.myProject, device, false, this.myLogConsole);
            }
        }
    }

    @Nullable
    public final IDevice getSelectedDevice() {
        if (this.myPreselectedDevice != null) {
            return this.myPreselectedDevice;
        }
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    private void applySelectedFilter() {
        final Object filter = this.myFilterComboBoxModel.getSelectedItem();
        if (filter instanceof ConfiguredFilter) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying filter..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/logcat/AndroidLogcatView$6", "run"));
                    }
                    AndroidLogcatView.this.myLogFilterModel.updateConfiguredFilter((ConfiguredFilter)filter);
                }
            });
        }
    }

    private void updateFilterCombobox(String select) {
        AndroidConfiguredLogFilters filters = AndroidConfiguredLogFilters.getInstance(this.myProject);
        List<AndroidConfiguredLogFilters.FilterEntry> entries = filters.getFilterEntries();
        this.myFilterComboBoxModel.removeAllElements();
        if (this.myDeviceContext != null) {
            this.myFilterComboBoxModel.addElement(this.mySelectedAppFilter);
        }
        this.myFilterComboBoxModel.addElement(this.myNoFilter);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION);
        for (AndroidConfiguredLogFilters.FilterEntry entry : entries) {
            String name = entry.getName();
            ConfiguredFilter filter = ConfiguredFilter.compile(entry, entry.getName());
            this.myFilterComboBoxModel.addElement(filter);
            if (!name.equals(select)) continue;
            this.myFilterComboBoxModel.setSelectedItem(filter);
        }
    }

    @NotNull
    public final JPanel getContentPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView", "getContentPanel"));
        }
        return jPanel;
    }

    public final void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    final class AndroidLogConsole
    extends LogConsoleBase
    implements AndroidConsoleWriter {
        private final RegexFilterComponent myRegexFilterComponent;
        private final AndroidLogcatPreferences myPreferences;

        public AndroidLogConsole(Project project, AndroidLogFilterModel logFilterModel, LogFormatter logFormatter) {
            super(project, null, "", false, (LogFilterModel)logFilterModel, GlobalSearchScope.allScope((Project)project), logFormatter);
            this.myRegexFilterComponent = new RegexFilterComponent("LOG_FILTER_HISTORY", 5);
            ConsoleView console = this.getConsole();
            if (console instanceof ConsoleViewImpl) {
                ConsoleViewImpl c = (ConsoleViewImpl)console;
                c.addCustomConsoleAction((AnAction)new Separator());
                c.addCustomConsoleAction((AnAction)new MyRestartAction());
                c.addCustomConsoleAction((AnAction)new MyConfigureLogcatHeaderAction());
                c.addCustomConsoleAction((AnAction)new Separator());
                c.addCustomConsoleAction((AnAction)new BrowserHelpAction("logcat", "http://developer.android.com/r/studio-ui/am-logcat.html"));
            }
            this.myPreferences = AndroidLogcatPreferences.getInstance(project);
            this.myRegexFilterComponent.setFilter(this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER);
            this.myRegexFilterComponent.setIsRegex(this.myPreferences.TOOL_WINDOW_REGEXP_FILTER);
            this.myRegexFilterComponent.addRegexListener(new RegexFilterComponent.Listener(){

                @Override
                public void filterChanged(RegexFilterComponent filter) {
                    ((AndroidLogConsole)AndroidLogConsole.this).myPreferences.TOOL_WINDOW_CUSTOM_FILTER = filter.getFilter();
                    ((AndroidLogConsole)AndroidLogConsole.this).myPreferences.TOOL_WINDOW_REGEXP_FILTER = filter.isRegex();
                    AndroidLogcatView.this.myLogFilterModel.updateCustomPattern(filter.getPattern());
                }
            });
        }

        public boolean isActive() {
            return AndroidLogcatView.this.isActive();
        }

        public void clearLogcat() {
            AndroidLogcatView.this.clearLogcat(AndroidLogcatView.this.getSelectedDevice());
        }

        @NotNull
        protected Component getTextFilterComponent() {
            RegexFilterComponent regexFilterComponent = this.myRegexFilterComponent;
            if (regexFilterComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView$AndroidLogConsole", "getTextFilterComponent"));
            }
            return regexFilterComponent;
        }

        @Override
        public synchronized void addMessage(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/logcat/AndroidLogcatView$AndroidLogConsole", "addMessage"));
            }
            super.addMessage(text);
        }

        public void refresh() {
            this.onTextFilterChange();
        }
    }

    private final class MyConfigureLogcatHeaderAction
    extends AnAction {
        public MyConfigureLogcatHeaderAction() {
            super(AndroidBundle.message("android.configure.logcat.header.text", new Object[0]), AndroidBundle.message("android.configure.logcat.header.description", new Object[0]), AllIcons.General.GearPlain);
        }

        public void actionPerformed(AnActionEvent e) {
            ConfigureLogcatFormatDialog dialog = new ConfigureLogcatFormatDialog(AndroidLogcatView.this.myProject);
            if (dialog.showAndGet()) {
                AndroidLogcatView.this.myLogConsole.refresh();
            }
        }
    }

    private final class MyRestartAction
    extends AnAction {
        public MyRestartAction() {
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLogcatView.this.notifyDeviceUpdated(true);
        }
    }
}

