/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeReference {
    public static final IncludeReference NONE = new IncludeReference(null, null, null);
    public static final String ATTR_RENDER_IN = "showIn";
    @NotNull
    private final VirtualFile myFromFile;
    @Nullable
    private final VirtualFile myToFile;
    @NotNull
    private final Module myModule;

    private IncludeReference(Module module, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        this.myModule = module;
        this.myFromFile = fromFile;
        this.myToFile = toFile;
    }

    public static IncludeReference create(Module module, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        return new IncludeReference(module, fromFile, toFile);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "getModule"));
        }
        return module;
    }

    @NotNull
    public VirtualFile getFromFile() {
        VirtualFile virtualFile = this.myFromFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "getFromFile"));
        }
        return virtualFile;
    }

    @NotNull
    public File getFromPath() {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.myFromFile);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "getFromPath"));
        }
        return file;
    }

    @Nullable
    public VirtualFile getToFile() {
        return this.myToFile;
    }

    @Nullable
    public File getToPath() {
        return this.myToFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)this.myToFile) : null;
    }

    @NotNull
    public String getFromDisplayName() {
        if (this.myToFile != null && this.myToFile.getParent() != null && this.myToFile.getParent().equals(this.myFromFile.getParent())) {
            String string = this.myFromFile.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "getFromDisplayName"));
            }
            return string;
        }
        String string = this.myFromFile.getParent().getName() + '/' + this.myFromFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "getFromDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getFromResourceName() {
        String string = ResourceHelper.getResourceName(this.myFromFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "getFromResourceName"));
        }
        return string;
    }

    @NotNull
    public String getFromResourceUrl() {
        String string = "@layout/" + this.getFromResourceName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "getFromResourceUrl"));
        }
        return string;
    }

    @Nullable
    public static String getIncludingLayout(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/IncludeReference", "getIncludingLayout"));
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                @Nullable
                public String compute() {
                    return IncludeReference.getIncludingLayout(file);
                }
            });
        }
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null && rootTag.isValid()) {
            return rootTag.getAttributeValue(ATTR_RENDER_IN, "http://schemas.android.com/tools");
        }
        return null;
    }

    public static void setIncludingLayout(@NotNull Project project, @NotNull XmlFile xmlFile, @Nullable String layout) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/IncludeReference", "setIncludingLayout"));
        }
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/android/tools/idea/rendering/IncludeReference", "setIncludingLayout"));
        }
        XmlTag tag = xmlFile.getRootTag();
        if (tag != null) {
            SetAttributeFix fix = new SetAttributeFix(project, tag, ATTR_RENDER_IN, "http://schemas.android.com/tools", layout);
            fix.execute();
        }
    }

    @NotNull
    public static IncludeReference get(final @NotNull Module module, final @NotNull XmlFile file, final @NotNull RenderResources resolver) {
        VirtualFile source;
        File path;
        ResourceValue resValue;
        String layout;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/IncludeReference", "get"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/IncludeReference", "get"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/rendering/IncludeReference", "get"));
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            IncludeReference includeReference = (IncludeReference)ApplicationManager.getApplication().runReadAction((Computable)new Computable<IncludeReference>(){

                @NotNull
                public IncludeReference compute() {
                    IncludeReference includeReference = IncludeReference.get(module, file, resolver);
                    if (includeReference == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference$2", "compute"));
                    }
                    return includeReference;
                }
            });
            if (includeReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "get"));
            }
            return includeReference;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null && (layout = rootTag.getAttributeValue(ATTR_RENDER_IN, "http://schemas.android.com/tools")) != null && (resValue = resolver.findResValue(layout, false)) != null && (path = ResourceHelper.resolveLayout(resolver, resValue)) != null && (source = LocalFileSystem.getInstance().findFileByIoFile(path)) != null) {
            VirtualFile target = file.getVirtualFile();
            IncludeReference includeReference = IncludeReference.create(module, source, target);
            if (includeReference == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "get"));
            }
            return includeReference;
        }
        IncludeReference includeReference = NONE;
        if (includeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/IncludeReference", "get"));
        }
        return includeReference;
    }
}

