/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderedView;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderedViewHierarchy {
    private final List<RenderedView> myRoots;
    private final PsiFile myFile;
    private final List<RenderedView> myIncludedRoots;

    private RenderedViewHierarchy(@NotNull PsiFile file, @NotNull List<RenderedView> roots, boolean computeIncludeBounds) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/RenderedViewHierarchy", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/android/tools/idea/rendering/RenderedViewHierarchy", "<init>"));
        }
        this.myFile = file;
        this.myRoots = roots;
        if (computeIncludeBounds) {
            this.myIncludedRoots = Lists.newArrayList();
            for (RenderedView root : this.myRoots) {
                this.addIncludedBounds(root);
            }
        } else {
            this.myIncludedRoots = null;
        }
    }

    @NotNull
    public static RenderedViewHierarchy create(@NotNull PsiFile file, @NotNull List<ViewInfo> roots, boolean computeIncludeBounds) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/RenderedViewHierarchy", "create"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/android/tools/idea/rendering/RenderedViewHierarchy", "create"));
        }
        RenderedViewHierarchy renderedViewHierarchy = new RenderedViewHierarchy(file, RenderedViewHierarchy.convert(null, roots, 0, 0), computeIncludeBounds);
        if (renderedViewHierarchy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedViewHierarchy", "create"));
        }
        return renderedViewHierarchy;
    }

    @NotNull
    public List<RenderedView> getRoots() {
        List<RenderedView> list = this.myRoots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedViewHierarchy", "getRoots"));
        }
        return list;
    }

    @Nullable
    public List<RenderedView> getIncludedRoots() {
        return this.myIncludedRoots;
    }

    @NotNull
    private static List<RenderedView> convert(@Nullable RenderedView parent, @NotNull List<ViewInfo> roots, int parentX, int parentY) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/android/tools/idea/rendering/RenderedViewHierarchy", "convert"));
        }
        ArrayList<RenderedView> views = new ArrayList<RenderedView>(roots.size());
        for (ViewInfo info : roots) {
            XmlTag tag = null;
            Object cookie = info.getCookie();
            if (cookie instanceof XmlTag) {
                tag = (XmlTag)cookie;
            }
            ViewInfo bounds = RenderService.getSafeBounds(info);
            int x = bounds.getLeft();
            int y = bounds.getTop();
            int width = bounds.getRight() - x;
            int height = bounds.getBottom() - y;
            RenderedView view = new RenderedView(parent, info, tag, x += parentX, y += parentY, width, height);
            List children = info.getChildren();
            if (children != null && !children.isEmpty()) {
                view.setChildren(RenderedViewHierarchy.convert(view, children, x, y));
            }
            views.add(view);
        }
        ArrayList<RenderedView> arrayList = views;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderedViewHierarchy", "convert"));
        }
        return arrayList;
    }

    private void addIncludedBounds(RenderedView view) {
        if (view.tag != null) {
            this.myIncludedRoots.add(view);
        } else {
            for (RenderedView child : view.getChildren()) {
                this.addIncludedBounds(child);
            }
        }
    }

    @Nullable
    public List<RenderedView> findByOffset(int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.myFile, (int)offset, XmlTag.class, (boolean)false);
        return tag != null ? this.findViewsByTag(tag) : null;
    }

    @Nullable
    public RenderedView findLeafAt(int x, int y) {
        for (int i = this.myRoots.size() - 1; i >= 0; --i) {
            RenderedView view = this.myRoots.get(i);
            RenderedView leaf = view.findLeafAt(x, y);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    public RenderedView findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/RenderedViewHierarchy", "findViewByTag"));
        }
        for (RenderedView view : this.myRoots) {
            RenderedView match = view.findViewByTag(tag);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    @Nullable
    public List<RenderedView> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/RenderedViewHierarchy", "findViewsByTag"));
        }
        List<RenderedView> result = null;
        for (RenderedView view : this.myRoots) {
            List<RenderedView> matches = view.findViewsByTag(tag);
            if (matches == null) continue;
            if (result != null) {
                result.addAll(matches);
                continue;
            }
            result = matches;
        }
        return result;
    }
}

