/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.fd.InstantRunUserFeedback;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.run.RunAsValidityService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DexDeployTask
implements LaunchTask {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final InstantRunBuildInfo myBuildInfo;
    @NotNull
    private final ExecutionEnvironment myEnv;

    public DexDeployTask(@NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull InstantRunBuildInfo buildInfo) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/tasks/DexDeployTask", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/DexDeployTask", "<init>"));
        }
        if (buildInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildInfo", "com/android/tools/idea/run/tasks/DexDeployTask", "<init>"));
        }
        this.myEnv = env;
        this.myFacet = facet;
        this.myBuildInfo = buildInfo;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing restart patches" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/DexDeployTask", "getDescription"));
        }
        return "Installing restart patches";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(final @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/DexDeployTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/DexDeployTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/DexDeployTask", "perform"));
        }
        try {
            InstantRunManager manager = InstantRunManager.get(this.myFacet.getModule().getProject());
            manager.pushArtifacts(device, this.myFacet, UpdateMode.HOT_SWAP, this.myBuildInfo);
            InstantRunStatsService.get(this.myFacet.getModule().getProject()).notifyDeployType(InstantRunStatsService.DeployType.DEX);
            String status = "Instant run applied code changes and restarted the app.";
            new InstantRunUserFeedback(this.myFacet.getModule()).postHtml(NotificationType.INFORMATION, status, null);
            return true;
        }
        catch (InstantRunPushFailedException e) {
            if ("run-as command broken on this device".equals(e.getMessage())) {
                launchStatus.terminateLaunch("Restarting build: This device does not support run-as");
                InstantRunManager.LOG.warn("Restarting build: This device does not support run-as");
                RunAsValidityService.getInstance().addInvalidDevice(device);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InstantRunUtils.setRestartSession(DexDeployTask.this.myEnv, device);
                        ExecutionUtil.restart((ExecutionEnvironment)DexDeployTask.this.myEnv);
                    }
                });
                return true;
            }
            launchStatus.terminateLaunch("Error installing cold swap patches: " + (Object)((Object)e));
            InstantRunManager.LOG.warn("Failed to push dex files: ", (Throwable)e);
            return false;
        }
    }
}

