/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.color.ColorSelector;
import org.jetbrains.android.dom.drawable.DrawableSelector;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.BoolElement;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.FractionElement;
import org.jetbrains.android.dom.resources.IntegerElement;
import org.jetbrains.android.dom.resources.Item;
import org.jetbrains.android.dom.resources.Plurals;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.resources.ScalarResourceElement;
import org.jetbrains.android.dom.resources.StringArray;
import org.jetbrains.android.dom.resources.StringElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.util.AndroidResourceUtil");
    public static final Set<ResourceType> VALUE_RESOURCE_TYPES = EnumSet.of(ResourceType.DRAWABLE, new ResourceType[]{ResourceType.COLOR, ResourceType.DIMEN, ResourceType.STRING, ResourceType.STYLE, ResourceType.ARRAY, ResourceType.PLURALS, ResourceType.ID, ResourceType.BOOL, ResourceType.INTEGER, ResourceType.FRACTION, ResourceType.LAYOUT});
    public static final Set<ResourceType> ALL_VALUE_RESOURCE_TYPES = EnumSet.noneOf(ResourceType.class);
    public static final Set<ResourceType> REFERRABLE_RESOURCE_TYPES = EnumSet.noneOf(ResourceType.class);
    public static final Set<ResourceType> XML_FILE_RESOURCE_TYPES = EnumSet.of(ResourceType.ANIM, new ResourceType[]{ResourceType.ANIMATOR, ResourceType.INTERPOLATOR, ResourceType.LAYOUT, ResourceType.MENU, ResourceType.XML, ResourceType.COLOR, ResourceType.DRAWABLE, ResourceType.MIPMAP, ResourceType.RAW, ResourceType.TRANSITION});
    static final String ROOT_TAG_PROPERTY = "ROOT_TAG";
    static final String LAYOUT_WIDTH_PROPERTY = "LAYOUT_WIDTH";
    static final String LAYOUT_HEIGHT_PROPERTY = "LAYOUT_HEIGHT";
    private static final String RESOURCE_CLASS_SUFFIX = ".R";
    public static final Comparator<PsiElement> RESOURCE_ELEMENT_COMPARATOR = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement e1, PsiElement e2) {
            PsiFile file2;
            if (e1 instanceof LazyValueResourceElementWrapper && e2 instanceof LazyValueResourceElementWrapper) {
                return ((LazyValueResourceElementWrapper)e1).compareTo((LazyValueResourceElementWrapper)e2);
            }
            PsiFile file1 = e1.getContainingFile();
            int delta = AndroidResourceUtil.compareResourceFiles(file1, file2 = e2.getContainingFile());
            if (delta != 0) {
                return delta;
            }
            return e1.getTextOffset() - e2.getTextOffset();
        }
    };

    private AndroidResourceUtil() {
    }

    @NotNull
    public static String normalizeXmlResourceValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/util/AndroidResourceUtil", "normalizeXmlResourceValue"));
        }
        String string = ValueXmlHelper.escapeResourceString((String)value, (boolean)false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "normalizeXmlResourceValue"));
        }
        return string;
    }

    public static String packageToRClass(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/util/AndroidResourceUtil", "packageToRClass"));
        }
        return packageName + RESOURCE_CLASS_SUFFIX;
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull String resourceName, boolean onlyInOwnPackages) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        if (resClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resClassName", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resClassName, Collections.singleton(resourceName), onlyInOwnPackages);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findResourceFields(@NotNull AndroidFacet facet, @NotNull String resClassName, @NotNull Collection<String> resourceNames, boolean onlyInOwnPackages) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        if (resClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resClassName", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        if (resourceNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNames", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        for (PsiClass rClass : AndroidResourceUtil.findRJavaClasses(facet, onlyInOwnPackages)) {
            AndroidResourceUtil.findResourceFieldsFromClass(rClass, resClassName, resourceNames, result);
        }
        PsiField[] psiFieldArray = result.toArray(new PsiField[result.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFields"));
        }
        return psiFieldArray;
    }

    private static void findResourceFieldsFromClass(@NotNull PsiClass rClass, @NotNull String resClassName, @NotNull Collection<String> resourceNames, @NotNull List<PsiField> result) {
        if (rClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rClass", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsFromClass"));
        }
        if (resClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resClassName", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsFromClass"));
        }
        if (resourceNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceNames", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsFromClass"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsFromClass"));
        }
        PsiClass resourceTypeClass = rClass.findInnerClassByName(resClassName, false);
        if (resourceTypeClass != null) {
            for (String resourceName : resourceNames) {
                String fieldName = AndroidResourceUtil.getRJavaFieldName(resourceName);
                PsiField field = resourceTypeClass.findFieldByName(fieldName, false);
                if (field == null) continue;
                result.add(field);
            }
        }
    }

    @NotNull
    private static Set<PsiClass> findRJavaClasses(@NotNull AndroidFacet facet, boolean onlyInOwnPackages) {
        String targetPackage;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "findRJavaClasses"));
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        if (facet.getManifest() == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findRJavaClasses"));
            }
            return set;
        }
        Graph graph = ModuleManager.getInstance((Project)project).moduleGraph();
        HashSet dependentModules = Sets.newHashSet();
        AndroidResourceUtil.collectDependentModules((Graph<Module>)graph, module, dependentModules);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        HashSet rClasses = Sets.newHashSet();
        String string = targetPackage = onlyInOwnPackages ? null : AndroidResourceUtil.manifestPackageForModule(module);
        if (targetPackage != null) {
            GlobalSearchScope[] scopes = new GlobalSearchScope[dependentModules.size()];
            int i = 0;
            for (Module dependentModule : dependentModules) {
                scopes[i++] = dependentModule.getModuleScope();
            }
            rClasses.addAll(Arrays.asList(psiFacade.findClasses(AndroidResourceUtil.packageToRClass(targetPackage), GlobalSearchScope.union((GlobalSearchScope[])scopes))));
        }
        for (Module dependentModule : dependentModules) {
            String dependentPackage = AndroidResourceUtil.manifestPackageForModule(dependentModule);
            if (dependentPackage == null || dependentPackage.equals(targetPackage)) continue;
            rClasses.addAll(Arrays.asList(psiFacade.findClasses(AndroidResourceUtil.packageToRClass(dependentPackage), dependentModule.getModuleScope())));
        }
        HashSet hashSet = rClasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findRJavaClasses"));
        }
        return hashSet;
    }

    @Nullable
    private static String manifestPackageForModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidResourceUtil", "manifestPackageForModule"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return null;
        }
        return (String)manifest.getPackage().getValue();
    }

    private static void collectDependentModules(@NotNull Graph<Module> graph, @NotNull Module module, @NotNull Set<Module> result) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "org/jetbrains/android/util/AndroidResourceUtil", "collectDependentModules"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidResourceUtil", "collectDependentModules"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil", "collectDependentModules"));
        }
        if (result.contains(module)) {
            return;
        }
        result.add(module);
        Iterator out = graph.getOut((Object)module);
        while (out.hasNext()) {
            AndroidResourceUtil.collectDependentModules(graph, (Module)out.next(), result);
        }
    }

    @NotNull
    public static PsiField[] findResourceFieldsForFileResource(@NotNull PsiFile file, boolean onlyInOwnPackages) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForFileResource"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForFileResource"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        String resourceType = facet.getLocalResourceManager().getFileResourceType(file);
        if (resourceType == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForFileResource"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        String resourceName = AndroidCommonUtils.getResourceName((String)resourceType, (String)file.getName());
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resourceType, resourceName, onlyInOwnPackages);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForFileResource"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findResourceFieldsForValueResource(XmlTag tag, boolean onlyInOwnPackages) {
        String resourceType;
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
        if (facet == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForValueResource"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        ResourceFolderType fileResType = ResourceHelper.getFolderType(tag.getContainingFile());
        String string = resourceType = fileResType == ResourceFolderType.VALUES ? AndroidResourceUtil.getResourceTypeByValueResourceTag(tag) : null;
        if (resourceType == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForValueResource"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        String name = tag.getAttributeValue("name");
        if (name == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForValueResource"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, resourceType, name, onlyInOwnPackages);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFieldsForValueResource"));
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiField[] findStyleableAttributeFields(XmlTag tag, boolean onlyInOwnPackages) {
        XmlTag parentTag;
        String tagName = tag.getName();
        if ("declare-styleable".equals(tagName)) {
            String styleableName = tag.getAttributeValue("name");
            if (styleableName == null) {
                if (PsiField.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findStyleableAttributeFields"));
                }
                return PsiField.EMPTY_ARRAY;
            }
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet == null) {
                if (PsiField.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findStyleableAttributeFields"));
                }
                return PsiField.EMPTY_ARRAY;
            }
            HashSet names = Sets.newHashSet();
            for (XmlTag attr : tag.getSubTags()) {
                String attrName;
                if (!"attr".equals(attr.getName()) || (attrName = attr.getAttributeValue("name")) == null) continue;
                names.add(styleableName + '_' + attrName);
            }
            if (!names.isEmpty()) {
                PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), names, onlyInOwnPackages);
                if (psiFieldArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findStyleableAttributeFields"));
                }
                return psiFieldArray;
            }
        } else if ("attr".equals(tagName) && (parentTag = tag.getParentTag()) != null && "declare-styleable".equals(parentTag.getName())) {
            String styleName = parentTag.getAttributeValue("name");
            String attributeName = tag.getAttributeValue("name");
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)tag);
            if (facet != null && styleName != null && attributeName != null) {
                PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.STYLEABLE.getName(), styleName + '_' + attributeName, onlyInOwnPackages);
                if (psiFieldArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findStyleableAttributeFields"));
                }
                return psiFieldArray;
            }
        }
        if (PsiField.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findStyleableAttributeFields"));
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public static String getRJavaFieldName(@NotNull String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/util/AndroidResourceUtil", "getRJavaFieldName"));
        }
        if (resourceName.indexOf(46) == -1) {
            String string = resourceName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getRJavaFieldName"));
            }
            return string;
        }
        String[] identifiers = resourceName.split("\\.");
        StringBuilder result = new StringBuilder(resourceName.length());
        int n = identifiers.length;
        for (int i = 0; i < n; ++i) {
            result.append(identifiers[i]);
            if (i >= n - 1) continue;
            result.append('_');
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getRJavaFieldName"));
        }
        return string;
    }

    public static boolean isCorrectAndroidResourceName(@NotNull String resourceName) {
        String[] identifiers;
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/util/AndroidResourceUtil", "isCorrectAndroidResourceName"));
        }
        if (resourceName.length() == 0) {
            return false;
        }
        if (resourceName.startsWith(".") || resourceName.endsWith(".")) {
            return false;
        }
        for (String identifier : identifiers = resourceName.split("\\.")) {
            if (StringUtil.isJavaIdentifier((String)identifier)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String getResourceTypeByValueResourceTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/util/AndroidResourceUtil", "getResourceTypeByValueResourceTag"));
        }
        String resClassName = tag.getName();
        String string = resClassName = resClassName.equals("item") ? tag.getAttributeValue("type", null) : AndroidCommonUtils.getResourceTypeByTagName((String)resClassName);
        if (resClassName != null) {
            String resourceName = tag.getAttributeValue("name");
            return resourceName != null ? resClassName : null;
        }
        return null;
    }

    @Nullable
    public static ResourceType getResourceForResourceTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/util/AndroidResourceUtil", "getResourceForResourceTag"));
        }
        String typeName = AndroidResourceUtil.getResourceTypeByValueResourceTag(tag);
        if (typeName != null) {
            return ResourceType.getEnum((String)typeName);
        }
        return null;
    }

    @Nullable
    public static String getResourceClassName(@NotNull PsiField field) {
        PsiClass parentClass;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/util/AndroidResourceUtil", "getResourceClassName"));
        }
        PsiClass resourceClass = field.getContainingClass();
        if (resourceClass != null && (parentClass = resourceClass.getContainingClass()) != null && "R".equals(parentClass.getName()) && parentClass.getContainingClass() == null) {
            return resourceClass.getName();
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> findResourcesByField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/util/AndroidResourceUtil", "findResourcesByField"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)field);
        List<PsiElement> list = facet != null ? facet.getLocalResourceManager().findResourcesByField(field) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findResourcesByField"));
        }
        return list;
    }

    public static boolean isResourceField(@NotNull PsiField field) {
        PsiFile file;
        AndroidFacet facet;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/android/util/AndroidResourceUtil", "isResourceField"));
        }
        PsiClass c = field.getContainingClass();
        if (c == null) {
            return false;
        }
        return (c = c.getContainingClass()) != null && "R".equals(c.getName()) && (facet = AndroidFacet.getInstance((PsiElement)field)) != null && (file = c.getContainingFile()) != null && AndroidResourceUtil.isRJavaFile(facet, file);
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/util/AndroidResourceUtil", "findIdFields"));
        }
        if (value.getParent() instanceof XmlAttribute) {
            PsiField[] psiFieldArray = AndroidResourceUtil.findIdFields((XmlAttribute)value.getParent());
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findIdFields"));
            }
            return psiFieldArray;
        }
        if (PsiField.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findIdFields"));
        }
        return PsiField.EMPTY_ARRAY;
    }

    public static boolean isIdDeclaration(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@+id/");
    }

    public static boolean isIdReference(@Nullable String attrValue) {
        return attrValue != null && attrValue.startsWith("@id/");
    }

    public static boolean isIdDeclaration(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/util/AndroidResourceUtil", "isIdDeclaration"));
        }
        return AndroidResourceUtil.isIdDeclaration(value.getValue());
    }

    @NotNull
    public static PsiField[] findIdFields(@NotNull XmlAttribute attribute) {
        AndroidFacet facet;
        String id;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/android/util/AndroidResourceUtil", "findIdFields"));
        }
        XmlAttributeValue value = attribute.getValueElement();
        if (value != null && AndroidResourceUtil.isIdDeclaration(value) && (id = AndroidResourceUtil.getResourceNameByReferenceText(attribute.getValue())) != null && (facet = AndroidFacet.getInstance((PsiElement)attribute)) != null) {
            PsiField[] psiFieldArray = AndroidResourceUtil.findResourceFields(facet, ResourceType.ID.getName(), id, false);
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findIdFields"));
            }
            return psiFieldArray;
        }
        if (PsiField.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "findIdFields"));
        }
        return PsiField.EMPTY_ARRAY;
    }

    @Nullable
    public static String getResourceNameByReferenceText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/android/util/AndroidResourceUtil", "getResourceNameByReferenceText"));
        }
        int i = text.indexOf(47);
        if (i < text.length() - 1) {
            return text.substring(i + 1, text.length());
        }
        return null;
    }

    @NotNull
    public static ResourceElement addValueResource(@NotNull ResourceType resType, @NotNull Resources resources, @Nullable String value) {
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        switch (resType) {
            case STRING: {
                StringElement stringElement = resources.addString();
                if (stringElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return stringElement;
            }
            case PLURALS: {
                Plurals plurals = resources.addPlurals();
                if (plurals == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return plurals;
            }
            case DIMEN: {
                if (value != null && value.trim().endsWith("%")) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    Item item2 = item;
                    if (item2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                    }
                    return item2;
                }
                if (value != null && value.indexOf(46) > 0) {
                    Item item = resources.addItem();
                    item.getType().setStringValue(ResourceType.DIMEN.getName());
                    item.getFormat().setStringValue("float");
                    Item item3 = item;
                    if (item3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                    }
                    return item3;
                }
                ScalarResourceElement scalarResourceElement = resources.addDimen();
                if (scalarResourceElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return scalarResourceElement;
            }
            case COLOR: {
                ScalarResourceElement scalarResourceElement = resources.addColor();
                if (scalarResourceElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return scalarResourceElement;
            }
            case DRAWABLE: {
                ScalarResourceElement scalarResourceElement = resources.addDrawable();
                if (scalarResourceElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return scalarResourceElement;
            }
            case STYLE: {
                Style style = resources.addStyle();
                if (style == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return style;
            }
            case ARRAY: {
                StringArray stringArray = resources.addStringArray();
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return stringArray;
            }
            case INTEGER: {
                IntegerElement integerElement = resources.addInteger();
                if (integerElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return integerElement;
            }
            case FRACTION: {
                FractionElement fractionElement = resources.addFraction();
                if (fractionElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return fractionElement;
            }
            case BOOL: {
                BoolElement boolElement = resources.addBool();
                if (boolElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return boolElement;
            }
            case ID: {
                Item item = resources.addItem();
                item.getType().setValue((Object)ResourceType.ID.getName());
                Item item4 = item;
                if (item4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return item4;
            }
            case ATTR: {
                Attr attr = resources.addAttr();
                if (attr == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return attr;
            }
            case STYLEABLE: {
                DeclareStyleable declareStyleable = resources.addDeclareStyleable();
                if (declareStyleable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
                }
                return declareStyleable;
            }
        }
        throw new IllegalArgumentException("Incorrect resource type");
    }

    @NotNull
    public static List<VirtualFile> getResourceSubdirs(@Nullable String resourceType, @NotNull VirtualFile[] resourceDirs) {
        if (resourceDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDirs", "org/jetbrains/android/util/AndroidResourceUtil", "getResourceSubdirs"));
        }
        if (resourceType != null && ResourceFolderType.getTypeByName((String)resourceType) == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getResourceSubdirs"));
            }
            return list;
        }
        ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
        for (VirtualFile resourcesDir : resourceDirs) {
            if (resourcesDir == null || !resourcesDir.isValid()) continue;
            if (resourceType == null) {
                ContainerUtil.addAll(dirs, (Object[])resourcesDir.getChildren());
                continue;
            }
            for (VirtualFile child : resourcesDir.getChildren()) {
                String type = AndroidCommonUtils.getResourceTypeByDirName((String)child.getName());
                if (!resourceType.equals(type)) continue;
                dirs.add(child);
            }
        }
        ArrayList<VirtualFile> arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getResourceSubdirs"));
        }
        return arrayList;
    }

    @Nullable
    public static String getDefaultResourceFileName(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/util/AndroidResourceUtil", "getDefaultResourceFileName"));
        }
        if (ResourceType.PLURALS == type || ResourceType.STRING == type) {
            return "strings.xml";
        }
        if (VALUE_RESOURCE_TYPES.contains(type)) {
            if (type == ResourceType.LAYOUT || type == ResourceType.DRAWABLE && !ApplicationManager.getApplication().isUnitTestMode()) {
                return "refs.xml";
            }
            return type.getName() + "s.xml";
        }
        if (ResourceType.ATTR == type || ResourceType.STYLEABLE == type) {
            return "attrs.xml";
        }
        return null;
    }

    @NotNull
    public static List<ResourceElement> getValueResourcesFromElement(@NotNull String resourceType, @NotNull Resources resources) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/util/AndroidResourceUtil", "getValueResourcesFromElement"));
        }
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/android/util/AndroidResourceUtil", "getValueResourcesFromElement"));
        }
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        if (resourceType.equals(ResourceType.STRING.getName())) {
            result.addAll(resources.getStrings());
        } else if (resourceType.equals(ResourceType.PLURALS.getName())) {
            result.addAll(resources.getPluralss());
        } else if (resourceType.equals(ResourceType.DRAWABLE.getName())) {
            result.addAll(resources.getDrawables());
        } else if (resourceType.equals(ResourceType.COLOR.getName())) {
            result.addAll(resources.getColors());
        } else if (resourceType.equals(ResourceType.DIMEN.getName())) {
            result.addAll(resources.getDimens());
        } else if (resourceType.equals(ResourceType.STYLE.getName())) {
            result.addAll(resources.getStyles());
        } else if (resourceType.equals(ResourceType.ARRAY.getName())) {
            result.addAll(resources.getStringArrays());
            result.addAll(resources.getIntegerArrays());
            result.addAll(resources.getArrays());
        } else if (resourceType.equals(ResourceType.INTEGER.getName())) {
            result.addAll(resources.getIntegers());
        } else if (resourceType.equals(ResourceType.FRACTION.getName())) {
            result.addAll(resources.getFractions());
        } else if (resourceType.equals(ResourceType.BOOL.getName())) {
            result.addAll(resources.getBools());
        }
        for (Item item : resources.getItems()) {
            String type = (String)item.getType().getValue();
            if (!resourceType.equals(type)) continue;
            result.add(item);
        }
        ArrayList<ResourceElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getValueResourcesFromElement"));
        }
        return arrayList;
    }

    public static boolean isInResourceSubdirectory(@NotNull PsiFile file, @Nullable String resourceType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/util/AndroidResourceUtil", "isInResourceSubdirectory"));
        }
        PsiDirectory dir = (file = file.getOriginalFile()).getContainingDirectory();
        if (dir == null) {
            return false;
        }
        return AndroidResourceUtil.isResourceSubdirectory(dir, resourceType);
    }

    public static boolean isResourceSubdirectory(@NotNull PsiDirectory directory, @Nullable String resourceType) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/android/util/AndroidResourceUtil", "isResourceSubdirectory"));
        }
        PsiDirectory dir = directory;
        String dirName = dir.getName();
        if (resourceType != null && !dirName.equals(resourceType) && !dirName.startsWith(resourceType + '-')) {
            return false;
        }
        if ((dir = dir.getParent()) == null) {
            return false;
        }
        if ("default".equals(dir.getName())) {
            dir = dir.getParentDirectory();
        }
        return dir != null && AndroidResourceUtil.isResourceDirectory(dir);
    }

    public static boolean isLocalResourceDirectory(@NotNull VirtualFile dir, @NotNull Project project) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/android/util/AndroidResourceUtil", "isLocalResourceDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/util/AndroidResourceUtil", "isLocalResourceDirectory"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)project);
        if (module != null) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && facet.getLocalResourceManager().isResourceDir(dir);
        }
        return false;
    }

    public static boolean isResourceFile(@NotNull VirtualFile file, @NotNull AndroidFacet facet) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/util/AndroidResourceUtil", "isResourceFile"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "isResourceFile"));
        }
        VirtualFile parent = file.getParent();
        VirtualFile resDir = parent != null ? parent.getParent() : null;
        return resDir != null && facet.getLocalResourceManager().isResourceDir(resDir);
    }

    public static boolean isResourceDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/android/util/AndroidResourceUtil", "isResourceDirectory"));
        }
        PsiDirectory dir = directory;
        VirtualFile vf = dir.getVirtualFile();
        if (AndroidResourceUtil.isLocalResourceDirectory(vf, dir.getProject())) {
            return true;
        }
        if (!"res".equals(dir.getName())) {
            return false;
        }
        if ((dir = dir.getParent()) != null) {
            if (dir.findFile("AndroidManifest.xml") != null) {
                return true;
            }
            if ((dir = dir.getParent()) != null) {
                if (AndroidResourceUtil.containsAndroidJar(dir)) {
                    return true;
                }
                if ((dir = dir.getParent()) != null) {
                    return AndroidResourceUtil.containsAndroidJar(dir);
                }
            }
        }
        return false;
    }

    private static boolean containsAndroidJar(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "org/jetbrains/android/util/AndroidResourceUtil", "containsAndroidJar"));
        }
        return psiDirectory.findFile("android.jar") != null;
    }

    public static boolean isRJavaFile(@NotNull AndroidFacet facet, @NotNull PsiFile file) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "isRJavaFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/util/AndroidResourceUtil", "isRJavaFile"));
        }
        if (file.getName().equals("R.java") && file instanceof PsiJavaFile) {
            String manifestPackage;
            PsiJavaFile javaFile = (PsiJavaFile)file;
            Manifest manifest = facet.getManifest();
            if (manifest != null && (manifestPackage = (String)manifest.getPackage().getValue()) != null && javaFile.getPackageName().equals(manifestPackage)) {
                return true;
            }
            for (String aPackage : AndroidUtils.getDepLibsPackages(facet.getModule())) {
                if (!javaFile.getPackageName().equals(aPackage)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isManifestJavaFile(@NotNull AndroidFacet facet, @NotNull PsiFile file) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "isManifestJavaFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/util/AndroidResourceUtil", "isManifestJavaFile"));
        }
        if (file.getName().equals("Manifest.java") && file instanceof PsiJavaFile) {
            Manifest manifest = facet.getManifest();
            PsiJavaFile javaFile = (PsiJavaFile)file;
            return manifest != null && javaFile.getPackageName().equals(manifest.getPackage().getValue());
        }
        return false;
    }

    public static List<String> getNames(@NotNull Collection<ResourceType> resourceTypes) {
        if (resourceTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceTypes", "org/jetbrains/android/util/AndroidResourceUtil", "getNames"));
        }
        if (resourceTypes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType type : resourceTypes) {
            result.add(type.getName());
        }
        return result;
    }

    @NotNull
    public static String[] getNamesArray(@NotNull Collection<ResourceType> resourceTypes) {
        if (resourceTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceTypes", "org/jetbrains/android/util/AndroidResourceUtil", "getNamesArray"));
        }
        List<String> names = AndroidResourceUtil.getNames(resourceTypes);
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getNamesArray"));
        }
        return stringArray;
    }

    public static boolean createValueResource(@NotNull Module module, @NotNull String resourceName, @Nullable String resourceValue, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull Processor<ResourceElement> afterAddedProcessor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (afterAddedProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterAddedProcessor", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        Project project = module.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        try {
            return AndroidResourceUtil.addValueResource(facet, resourceName, resourceType, fileName, dirNames, resourceValue, afterAddedProcessor);
        }
        catch (Exception e) {
            String message = CreateElementActionBase.filterMessage((String)e.getMessage());
            if (message == null || message.length() == 0) {
                LOG.error((Throwable)e);
            } else {
                LOG.info((Throwable)e);
                AndroidUtils.reportError(project, message);
            }
            return false;
        }
    }

    public static boolean createValueResource(@NotNull Module module, @NotNull String resourceName, @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, @NotNull String value) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        return AndroidResourceUtil.createValueResource(module, resourceName, resourceType, fileName, dirNames, value, null);
    }

    public static boolean createValueResource(@NotNull Module module, @NotNull String resourceName, final @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, final @NotNull String value, final @Nullable List<ResourceElement> outTags) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/android/util/AndroidResourceUtil", "createValueResource"));
        }
        return AndroidResourceUtil.createValueResource(module, resourceName, value, resourceType, fileName, dirNames, new Processor<ResourceElement>(){

            public boolean process(ResourceElement element) {
                if (value.length() > 0) {
                    String s = resourceType == ResourceType.STRING ? AndroidResourceUtil.normalizeXmlResourceValue(value) : value;
                    element.setStringValue(s);
                } else if (resourceType == ResourceType.STYLEABLE || resourceType == ResourceType.STYLE) {
                    element.setStringValue("value");
                    element.getXmlTag().getValue().setText("");
                }
                if (outTags != null) {
                    outTags.add(element);
                }
                return true;
            }
        });
    }

    private static boolean addValueResource(@NotNull AndroidFacet facet, final @NotNull String resourceName, final @NotNull ResourceType resourceType, @NotNull String fileName, @NotNull List<String> dirNames, final @Nullable String resourceValue, final @NotNull Processor<ResourceElement> afterAddedProcessor) throws Exception {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        if (afterAddedProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterAddedProcessor", "org/jetbrains/android/util/AndroidResourceUtil", "addValueResource"));
        }
        if (dirNames.size() == 0) {
            return false;
        }
        VirtualFile[] resFiles = new VirtualFile[dirNames.size()];
        int n = dirNames.size();
        for (int i = 0; i < n; ++i) {
            VirtualFile resFile = AndroidResourceUtil.findOrCreateResourceFile(facet, fileName, dirNames.get(i));
            if (resFile == null) {
                return false;
            }
            resFiles[i] = resFile;
        }
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)facet.getModule().getProject(), (VirtualFile[])resFiles)) {
            return false;
        }
        final Resources[] resourcesElements = new Resources[resFiles.length];
        for (int i = 0; i < resFiles.length; ++i) {
            Resources resources = AndroidUtils.loadDomElement(facet.getModule(), resFiles[i], Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(facet.getModule().getProject(), AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.length);
        Project project = facet.getModule().getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] files = psiFiles.toArray(new PsiFile[psiFiles.size()]);
        WriteCommandAction<Void> action = new WriteCommandAction<Void>(project, "Add Resource", files){

            protected void run(@NotNull Result<Void> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$3", "run"));
                }
                for (Resources resources : resourcesElements) {
                    ResourceElement element = AndroidResourceUtil.addValueResource(resourceType, resources, resourceValue);
                    element.getName().setValue((Object)resourceName);
                    afterAddedProcessor.process((Object)element);
                }
            }
        };
        action.execute();
        return true;
    }

    public static boolean changeColorResource(@NotNull AndroidFacet facet, final @NotNull String colorName, final @NotNull String newValue, @NotNull String fileName, @NotNull List<String> dirNames, final boolean useGlobalCommand) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "changeColorResource"));
        }
        if (colorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorName", "org/jetbrains/android/util/AndroidResourceUtil", "changeColorResource"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "org/jetbrains/android/util/AndroidResourceUtil", "changeColorResource"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "changeColorResource"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "org/jetbrains/android/util/AndroidResourceUtil", "changeColorResource"));
        }
        if (dirNames.isEmpty()) {
            return false;
        }
        ArrayList resFiles = Lists.newArrayListWithExpectedSize((int)dirNames.size());
        for (String dirName : dirNames) {
            VirtualFile resFile = AndroidResourceUtil.findResourceFile(facet, fileName, dirName);
            if (resFile == null) continue;
            resFiles.add(resFile);
        }
        if (!AndroidResourceUtil.ensureFilesWritable(facet.getModule().getProject(), resFiles)) {
            return false;
        }
        final Resources[] resourcesElements = new Resources[resFiles.size()];
        for (int i = 0; i < resFiles.size(); ++i) {
            Resources resources = AndroidUtils.loadDomElement(facet.getModule(), (VirtualFile)resFiles.get(i), Resources.class);
            if (resources == null) {
                AndroidUtils.reportError(facet.getModule().getProject(), AndroidBundle.message("not.resource.file.error", fileName));
                return false;
            }
            resourcesElements[i] = resources;
        }
        ArrayList psiFiles = Lists.newArrayListWithExpectedSize((int)resFiles.size());
        final Project project = facet.getModule().getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : resFiles) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] files = psiFiles.toArray(new PsiFile[psiFiles.size()]);
        WriteCommandAction<Boolean> action = new WriteCommandAction<Boolean>(project, "Change Color Resource", files){

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$4", "run"));
                }
                if (useGlobalCommand) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                }
                result.setResult((Object)false);
                for (Resources resources : resourcesElements) {
                    for (ScalarResourceElement colorElement : resources.getColors()) {
                        String colorValue = colorElement.getName().getStringValue();
                        if (!colorName.equals(colorValue)) continue;
                        colorElement.setStringValue(newValue);
                        result.setResult((Object)true);
                    }
                }
            }
        };
        return (Boolean)action.execute().getResultObject();
    }

    @Nullable
    private static VirtualFile findResourceFile(@NotNull AndroidFacet facet, @NotNull String fileName, @NotNull String dirName) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFile"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "org/jetbrains/android/util/AndroidResourceUtil", "findResourceFile"));
        }
        VirtualFile resDir = facet.getPrimaryResourceDir();
        if (resDir == null) {
            return null;
        }
        VirtualFile dir = resDir.findChild(dirName);
        if (dir == null) {
            return null;
        }
        return dir.findChild(fileName);
    }

    @Nullable
    private static VirtualFile findOrCreateResourceFile(@NotNull AndroidFacet facet, @NotNull String fileName, @NotNull String dirName) throws Exception {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateResourceFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateResourceFile"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateResourceFile"));
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        VirtualFile resDir = facet.getPrimaryResourceDir();
        if (resDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
            return null;
        }
        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
        if (dir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.dir.error", dirPath));
            return null;
        }
        VirtualFile file = dir.findChild(fileName);
        if (file != null) {
            return file;
        }
        AndroidFileTemplateProvider.createFromTemplate(project, dir, "valueResourceFile.xml", fileName);
        VirtualFile result = dir.findChild(fileName);
        if (result == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("android.cannot.create.file.error", dirPath + File.separatorChar + fileName));
        }
        return result;
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, boolean localOnly) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "getReferredResourceOrManifestField"));
        }
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/jetbrains/android/util/AndroidResourceUtil", "getReferredResourceOrManifestField"));
        }
        return AndroidResourceUtil.getReferredResourceOrManifestField(facet, exp, null, localOnly);
    }

    @Nullable
    public static MyReferredResourceFieldInfo getReferredResourceOrManifestField(@NotNull AndroidFacet facet, @NotNull PsiReferenceExpression exp, @Nullable String className, boolean localOnly) {
        String qName;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/util/AndroidResourceUtil", "getReferredResourceOrManifestField"));
        }
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/jetbrains/android/util/AndroidResourceUtil", "getReferredResourceOrManifestField"));
        }
        String resFieldName = exp.getReferenceName();
        if (resFieldName == null || resFieldName.length() == 0) {
            return null;
        }
        PsiExpression qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression resClassReference = (PsiReferenceExpression)qExp;
        String resClassName = resClassReference.getReferenceName();
        if (resClassName == null || resClassName.length() == 0 || className != null && !className.equals(resClassName)) {
            return null;
        }
        qExp = resClassReference.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolvedElement = ((PsiReferenceExpression)qExp).resolve();
        if (!(resolvedElement instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)resolvedElement;
        String classShortName = aClass.getName();
        boolean fromManifest = "Manifest".equals(classShortName);
        if (!fromManifest && !"R".equals(classShortName)) {
            return null;
        }
        if (!localOnly && ("android.R".equals(qName = aClass.getQualifiedName()) || "com.android.internal.R".equals(qName))) {
            return new MyReferredResourceFieldInfo(resClassName, resFieldName, true, false);
        }
        PsiFile containingFile = resolvedElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (fromManifest ? !AndroidResourceUtil.isManifestJavaFile(facet, containingFile) : !AndroidResourceUtil.isRJavaFile(facet, containingFile)) {
            return null;
        }
        return new MyReferredResourceFieldInfo(resClassName, resFieldName, false, fromManifest);
    }

    public static int compareResourceFiles(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        if (file1 != null && file1.equals(file2) || file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            VirtualFile parent1 = file1.getParent();
            VirtualFile parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getPath().compareTo(file2.getPath());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static int compareResourceFiles(@Nullable PsiFile file1, @Nullable PsiFile file2) {
        if (file1 == file2) {
            return 0;
        }
        if (file1 != null && file2 != null) {
            boolean xml2;
            boolean xml1 = file1.getFileType() == StdFileTypes.XML;
            boolean bl = xml2 = file2.getFileType() == StdFileTypes.XML;
            if (xml1 != xml2) {
                return xml1 ? -1 : 1;
            }
            PsiDirectory parent1 = file1.getParent();
            PsiDirectory parent2 = file2.getParent();
            if (parent1 != null && parent2 != null && parent1 != parent2) {
                boolean qualifier2;
                String parentName1 = parent1.getName();
                String parentName2 = parent2.getName();
                boolean qualifier1 = parentName1.indexOf(45) != -1;
                boolean bl2 = qualifier2 = parentName2.indexOf(45) != -1;
                if (qualifier1 != qualifier2) {
                    return qualifier1 ? 1 : -1;
                }
                if (qualifier1) {
                    FolderConfiguration config1 = FolderConfiguration.getConfigForFolder((String)parentName1);
                    FolderConfiguration config2 = FolderConfiguration.getConfigForFolder((String)parentName2);
                    if (config1 != null && config2 != null) {
                        return config1.compareTo(config2);
                    }
                    if (config1 != null) {
                        return -1;
                    }
                    if (config2 != null) {
                        return 1;
                    }
                    int delta = parentName1.compareTo(parentName2);
                    if (delta != 0) {
                        return delta;
                    }
                }
            }
            return file1.getName().compareTo(file2.getName());
        }
        if (file1 != null) {
            return -1;
        }
        return 1;
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/util/AndroidResourceUtil", "ensureFilesWritable"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/android/util/AndroidResourceUtil", "ensureFilesWritable"));
        }
        return !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files).hasReadonlyFiles();
    }

    @Nullable
    public static ResourceType getType(@NotNull XmlTag node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/android/util/AndroidResourceUtil", "getType"));
        }
        String nodeName = node.getLocalName();
        String typeString = null;
        if ("item".equals(nodeName)) {
            String attribute = node.getAttributeValue("type");
            if (attribute != null) {
                typeString = attribute;
            }
        } else {
            typeString = nodeName;
        }
        return typeString == null ? null : ResourceType.getEnum((String)typeString);
    }

    @NotNull
    public static XmlFile createFileResource(@NotNull String fileName, @NotNull PsiDirectory resSubdir, @NotNull String rootTagName, @NotNull String resourceType, boolean valuesResourceFile) throws Exception {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/android/util/AndroidResourceUtil", "createFileResource"));
        }
        if (resSubdir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resSubdir", "org/jetbrains/android/util/AndroidResourceUtil", "createFileResource"));
        }
        if (rootTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTagName", "org/jetbrains/android/util/AndroidResourceUtil", "createFileResource"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/util/AndroidResourceUtil", "createFileResource"));
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)resSubdir.getProject());
        String templateName = AndroidResourceUtil.getTemplateName(resourceType, valuesResourceFile, rootTagName);
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        Properties properties = new Properties();
        if (!valuesResourceFile) {
            properties.setProperty(ROOT_TAG_PROPERTY, rootTagName);
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)resSubdir);
            AndroidPlatform platform = module != null ? AndroidPlatform.getInstance(module) : null;
            int apiLevel = platform != null ? platform.getApiLevel() : -1;
            String value = apiLevel == -1 || apiLevel >= 8 ? "match_parent" : "fill_parent";
            properties.setProperty(LAYOUT_WIDTH_PROPERTY, value);
            properties.setProperty(LAYOUT_HEIGHT_PROPERTY, value);
        }
        PsiElement createdElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)resSubdir);
        assert (createdElement instanceof XmlFile);
        XmlFile xmlFile = (XmlFile)createdElement;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "createFileResource"));
        }
        return xmlFile;
    }

    private static String getTemplateName(String resourceType, boolean valuesResourceFile, String rootTagName) {
        if (valuesResourceFile) {
            return "valueResourceFile.xml";
        }
        if (ResourceType.LAYOUT.getName().equals(resourceType)) {
            return "LinearLayout".equals(rootTagName) ? "layoutResourceFile_vertical.xml" : "layoutResourceFile.xml";
        }
        return "resourceFile.xml";
    }

    @NotNull
    public static String getFieldNameByResourceName(@NotNull String styleName) {
        if (styleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleName", "org/jetbrains/android/util/AndroidResourceUtil", "getFieldNameByResourceName"));
        }
        int n = styleName.length();
        for (int i = 0; i < n; ++i) {
            char c = styleName.charAt(i);
            if (c != '.' && c != '-' && c != ':') continue;
            String string = styleName.replace('.', '_').replace('-', '_').replace(':', '_');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getFieldNameByResourceName"));
            }
            return string;
        }
        String string = styleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil", "getFieldNameByResourceName"));
        }
        return string;
    }

    @Nullable
    public static List<VirtualFile> findOrCreateStateListFiles(@NotNull Module module, final @NotNull ResourceFolderType folderType, final @NotNull ResourceType resourceType, final @NotNull String stateListName, final @NotNull List<String> dirNames) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateStateListFiles"));
        }
        if (folderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateStateListFiles"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateStateListFiles"));
        }
        if (stateListName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateListName", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateStateListFiles"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "org/jetbrains/android/util/AndroidResourceUtil", "findOrCreateStateListFiles"));
        }
        final Project project = module.getProject();
        final PsiManager manager = PsiManager.getInstance((Project)project);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        final VirtualFile resDir = facet.getPrimaryResourceDir();
        if (resDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
            return null;
        }
        final ArrayList files = Lists.newArrayListWithCapacity((int)dirNames.size());
        boolean foundFiles = (Boolean)new WriteCommandAction<Boolean>(project, "Find statelists files", new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/util/AndroidResourceUtil$5", "run"));
                }
                result.setResult((Object)true);
                try {
                    String fileName = stateListName;
                    if (!stateListName.endsWith(".xml")) {
                        fileName = fileName + ".xml";
                    }
                    for (String dirName : dirNames) {
                        String dirPath = FileUtil.toSystemDependentName((String)(resDir.getPath() + '/' + dirName));
                        VirtualFile dir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, dirName);
                        if (dir == null) {
                            throw new IOException("cannot make " + resDir + File.separatorChar + dirName);
                        }
                        VirtualFile file = dir.findChild(fileName);
                        if (file != null) {
                            files.add(file);
                            continue;
                        }
                        PsiDirectory directory = manager.findDirectory(dir);
                        if (directory == null) {
                            throw new IOException("cannot find " + resDir + File.separatorChar + dirName);
                        }
                        AndroidResourceUtil.createFileResource(fileName, directory, CreateTypedResourceFileAction.getDefaultRootTagByResourceType(folderType), resourceType.getName(), false);
                        file = dir.findChild(fileName);
                        if (file == null) {
                            throw new IOException("cannot find " + Joiner.on((char)File.separatorChar).join((Object)resDir, (Object)dirPath, new Object[]{fileName}));
                        }
                        files.add(file);
                    }
                }
                catch (Exception e) {
                    LOG.error(e.getMessage());
                    result.setResult((Object)false);
                }
            }
        }.execute().getResultObject();
        return foundFiles ? files : null;
    }

    public static void updateStateList(@NotNull Module module, final @NotNull ResourceHelper.StateList stateList, @NotNull List<VirtualFile> files) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/util/AndroidResourceUtil", "updateStateList"));
        }
        if (stateList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateList", "org/jetbrains/android/util/AndroidResourceUtil", "updateStateList"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/android/util/AndroidResourceUtil", "updateStateList"));
        }
        Project project = module.getProject();
        if (!AndroidResourceUtil.ensureFilesWritable(project, files)) {
            return;
        }
        ArrayList psiFiles = Lists.newArrayListWithCapacity((int)files.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        final ArrayList selectors = Lists.newArrayListWithCapacity((int)files.size());
        Class selectorClass = stateList.getFolderType() == ResourceFolderType.COLOR ? ColorSelector.class : DrawableSelector.class;
        for (VirtualFile file : files) {
            AndroidDomElement selector = AndroidUtils.loadDomElement(module, file, selectorClass);
            if (selector == null) {
                AndroidUtils.reportError(project, file.getName() + " is not a statelist file");
                return;
            }
            selectors.add(selector);
        }
        new WriteCommandAction.Simple(project, "Change State List", psiFiles.toArray(new PsiFile[psiFiles.size()])){

            protected void run() {
                for (AndroidDomElement selector : selectors) {
                    XmlTag tag = selector.getXmlTag();
                    for (XmlTag subtag : tag.getSubTags()) {
                        subtag.delete();
                    }
                    for (ResourceHelper.StateListState state : stateList.getStates()) {
                        XmlTag child = tag.createChildTag("item", tag.getNamespace(), null, false);
                        child = tag.addSubTag(child, false);
                        Map<String, Boolean> attributes = state.getAttributes();
                        for (String attributeName : attributes.keySet()) {
                            child.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", attributes.get(attributeName).toString());
                        }
                        if (!StringUtil.isEmpty((String)state.getAlpha())) {
                            child.setAttribute("alpha", "http://schemas.android.com/apk/res/android", state.getAlpha());
                        }
                        if (selector instanceof ColorSelector) {
                            child.setAttribute("color", "http://schemas.android.com/apk/res/android", state.getValue());
                            continue;
                        }
                        if (!(selector instanceof DrawableSelector)) continue;
                        child.setAttribute("drawable", "http://schemas.android.com/apk/res/android", state.getValue());
                    }
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }.execute();
    }

    static {
        REFERRABLE_RESOURCE_TYPES.addAll(Arrays.asList(ResourceType.values()));
        REFERRABLE_RESOURCE_TYPES.remove(ResourceType.ATTR);
        REFERRABLE_RESOURCE_TYPES.remove(ResourceType.STYLEABLE);
        ALL_VALUE_RESOURCE_TYPES.addAll(VALUE_RESOURCE_TYPES);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.ATTR);
        ALL_VALUE_RESOURCE_TYPES.add(ResourceType.STYLEABLE);
    }

    public static class MyReferredResourceFieldInfo {
        private final String myClassName;
        private final String myFieldName;
        private final boolean mySystem;
        private final boolean myFromManifest;

        public MyReferredResourceFieldInfo(@NotNull String className, @NotNull String fieldName, boolean system, boolean fromManifest) {
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo", "<init>"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo", "<init>"));
            }
            this.myClassName = className;
            this.myFieldName = fieldName;
            this.mySystem = system;
            this.myFromManifest = fromManifest;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo", "getClassName"));
            }
            return string;
        }

        @NotNull
        public String getFieldName() {
            String string = this.myFieldName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidResourceUtil$MyReferredResourceFieldInfo", "getFieldName"));
            }
            return string;
        }

        public boolean isSystem() {
            return this.mySystem;
        }

        public boolean isFromManifest() {
            return this.myFromManifest;
        }
    }
}

