/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ClassExtensionPoint;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;

public class RegisterExtensionFix
implements IntentionAction {
    private final PsiClass myExtensionClass;
    private final List<ExtensionPointCandidate> myEPCandidates;
    private static final Map<String, String> KEY_MAP = ContainerUtil.immutableMapBuilder().put((Object)KeyedFactoryEPBean.class.getName(), (Object)"key").put((Object)KeyedLazyInstanceEP.class.getName(), (Object)"key").put((Object)FileTypeExtensionPoint.class.getName(), (Object)"filetype").put((Object)LanguageExtensionPoint.class.getName(), (Object)"language").put((Object)ClassExtensionPoint.class.getName(), (Object)"forClass").build();

    public RegisterExtensionFix(PsiClass extensionClass, List<ExtensionPointCandidate> epCandidates) {
        this.myExtensionClass = extensionClass;
        this.myEPCandidates = epCandidates;
    }

    @NotNull
    public String getText() {
        if ("Register extension" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix", "getText"));
        }
        return "Register extension";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix", "isAvailable"));
        }
        return !DumbService.isDumb((Project)project);
    }

    public void invoke(@NotNull Project project, final Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix", "invoke"));
        }
        PluginDescriptorChooser.show(project, editor, file, new Consumer<DomFileElement<IdeaPlugin>>(){

            public void consume(DomFileElement<IdeaPlugin> element) {
                RegisterExtensionFix.this.doFix(editor, (DomFileElement<IdeaPlugin>)element);
            }
        });
    }

    private void doFix(Editor editor, final DomFileElement<IdeaPlugin> element) {
        if (this.myEPCandidates.size() == 1) {
            this.registerExtension(element, this.myEPCandidates.get(0));
        } else {
            BaseListPopupStep<ExtensionPointCandidate> popupStep = new BaseListPopupStep<ExtensionPointCandidate>("Choose Extension Point", this.myEPCandidates){

                public PopupStep onChosen(ExtensionPointCandidate selectedValue, boolean finalChoice) {
                    RegisterExtensionFix.this.registerExtension((DomFileElement<IdeaPlugin>)element, selectedValue);
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
        }
    }

    private void registerExtension(final DomFileElement<IdeaPlugin> selectedValue, final ExtensionPointCandidate candidate) {
        PsiElement navTarget = (PsiElement)new WriteCommandAction<PsiElement>(selectedValue.getFile().getProject(), new PsiFile[]{selectedValue.getFile()}){

            protected void run(@NotNull Result<PsiElement> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/devkit/inspections/quickfix/RegisterExtensionFix$3", "run"));
                }
                Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<IdeaPlugin>)selectedValue, candidate.epName);
                Extension extension = extensions.addExtension(candidate.epName);
                XmlTag tag = extension.getXmlTag();
                XmlAttributeValue navTarget = null;
                String keyAttrName = (String)KEY_MAP.get(candidate.beanClassName);
                if (keyAttrName != null) {
                    XmlAttribute attr = tag.setAttribute(keyAttrName, "");
                    navTarget = attr.getValueElement();
                }
                if (candidate.attributeName != null) {
                    tag.setAttribute(candidate.attributeName, RegisterExtensionFix.this.myExtensionClass.getQualifiedName());
                } else {
                    XmlTag subTag = tag.createChildTag(candidate.tagName, null, RegisterExtensionFix.this.myExtensionClass.getQualifiedName(), false);
                    tag.addSubTag(subTag, false);
                }
                result.setResult(navTarget != null ? navTarget : extension.getXmlTag());
            }
        }.execute().throwException().getResultObject();
        PsiNavigateUtil.navigate((PsiElement)navTarget);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

