/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.consts;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;

public class PrimitiveConstant
extends PooledConstant {
    public int index;
    public Object value;
    public boolean isArray;

    public PrimitiveConstant(int type, Object value) {
        this.type = type;
        this.value = value;
        this.initConstant();
    }

    public PrimitiveConstant(int type, int index) {
        this.type = type;
        this.index = index;
    }

    public int getInt() {
        return (Integer)this.value;
    }

    public long getLong() {
        return (Long)this.value;
    }

    public float getFloat() {
        return ((Float)this.value).floatValue();
    }

    public double getDouble() {
        return (Double)this.value;
    }

    public String getString() {
        return (String)this.value;
    }

    @Override
    public void resolveConstant(ConstantPool pool) {
        if (this.type == 7 || this.type == 8 || this.type == 16) {
            this.value = pool.getPrimitiveConstant(this.index).getString();
            this.initConstant();
        }
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        switch (this.type) {
            case 3: {
                out.writeInt(this.getInt());
                break;
            }
            case 4: {
                out.writeFloat(this.getFloat());
                break;
            }
            case 5: {
                out.writeLong(this.getLong());
                break;
            }
            case 6: {
                out.writeDouble(this.getDouble());
                break;
            }
            case 1: {
                out.writeUTF(this.getString());
                break;
            }
            default: {
                out.writeShort(this.index);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof PrimitiveConstant)) {
            return false;
        }
        PrimitiveConstant cn = (PrimitiveConstant)o;
        return this.type == cn.type && this.isArray == cn.isArray && this.value.equals(cn.value);
    }

    private void initConstant() {
        if (this.type == 7) {
            String className = this.getString();
            this.isArray = className.length() > 0 && className.charAt(0) == '[';
        }
    }
}

