/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerAdapter;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import icons.MavenIcons;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigatorPanel;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigatorState;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

@State(name="MavenProjectNavigator", storages={@Storage(value="$WORKSPACE_FILE$")})
public class MavenProjectsNavigator
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsNavigatorState> {
    public static final String TOOL_WINDOW_ID = "Maven Projects";
    private static final URL ADD_ICON_URL = MavenProjectsNavigator.class.getResource("/general/add.png");
    private static final URL SYNC_ICON_URL = MavenProjectsNavigator.class.getResource("/actions/refresh.png");
    private MavenProjectsNavigatorState myState = new MavenProjectsNavigatorState();
    private MavenProjectsManager myProjectsManager;
    private MavenTasksManager myTasksManager;
    private MavenShortcutsManager myShortcutsManager;
    private SimpleTree myTree;
    private MavenProjectsStructure myStructure;
    private ToolWindowEx myToolWindow;

    public static MavenProjectsNavigator getInstance(Project project) {
        return (MavenProjectsNavigator)((Object)project.getComponent(MavenProjectsNavigator.class));
    }

    public MavenProjectsNavigator(Project project, MavenProjectsManager projectsManager, MavenTasksManager tasksManager, MavenShortcutsManager shortcutsManager) {
        super(project);
        this.myProjectsManager = projectsManager;
        this.myTasksManager = tasksManager;
        this.myShortcutsManager = shortcutsManager;
    }

    public MavenProjectsNavigatorState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myStructure != null) {
            try {
                this.myState.treeState = new Element("root");
                TreeState.createOn((JTree)this.myTree).writeExternal(this.myState.treeState);
            }
            catch (WriteExternalException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return this.myState;
    }

    public void loadState(MavenProjectsNavigatorState state) {
        this.myState = state;
        this.scheduleStructureUpdate();
    }

    public boolean getGroupModules() {
        return this.myState.groupStructurally;
    }

    public void setGroupModules(boolean value) {
        if (this.myState.groupStructurally != value) {
            this.myState.groupStructurally = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getShowIgnored() {
        return this.myState.showIgnored;
    }

    public void setShowIgnored(boolean value) {
        if (this.myState.showIgnored != value) {
            this.myState.showIgnored = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getShowBasicPhasesOnly() {
        return this.myState.showBasicPhasesOnly;
    }

    public void setShowBasicPhasesOnly(boolean value) {
        if (this.myState.showBasicPhasesOnly != value) {
            this.myState.showBasicPhasesOnly = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getAlwaysShowArtifactId() {
        return this.myState.alwaysShowArtifactId;
    }

    public void setAlwaysShowArtifactId(boolean value) {
        if (this.myState.alwaysShowArtifactId != value) {
            this.myState.alwaysShowArtifactId = value;
            this.scheduleStructureUpdate();
        }
    }

    public boolean getShowVersions() {
        return this.myState.showVersions;
    }

    public void setShowVersions(boolean value) {
        if (this.myState.showVersions != value) {
            this.myState.showVersions = value;
            this.scheduleStructureUpdate();
        }
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        this.doInit();
    }

    public void initForTests() {
        this.doInit();
        this.initTree();
        this.initStructure();
    }

    private void doInit() {
        this.listenForProjectsChanges();
        if (this.isUnitTestMode()) {
            return;
        }
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)new DumbAwareRunnable(){

            public void run() {
                if (MavenProjectsNavigator.this.myProject.isDisposed()) {
                    return;
                }
                MavenProjectsNavigator.this.initToolWindow();
            }
        });
    }

    public void disposeComponent() {
        this.myToolWindow = null;
        this.myProjectsManager = null;
    }

    private void listenForProjectsChanges() {
        this.myProjectsManager.addProjectsTreeListener(new MyProjectsListener());
        this.myShortcutsManager.addListener(new MavenShortcutsManager.Listener(){

            @Override
            public void shortcutsUpdated() {
                MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectsNavigator.this.myStructure.updateGoals();
                    }
                });
            }
        });
        this.myTasksManager.addListener(new MavenTasksManager.Listener(){

            @Override
            public void compileTasksChanged() {
                MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectsNavigator.this.myStructure.updateGoals();
                    }
                });
            }
        });
        RunManagerEx.getInstanceEx((Project)this.myProject).addRunManagerListener((RunManagerListener)new RunManagerAdapter(){

            public void beforeRunTasksChanged() {
                MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectsNavigator.this.myStructure.updateGoals();
                    }
                });
            }
        });
        MavenRunner.getInstance(this.myProject).getSettings().addListener(new MavenRunnerSettings.Listener(){

            @Override
            public void skipTestsChanged() {
                MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectsNavigator.this.myStructure.updateGoals();
                    }
                });
            }
        });
        ((RunManagerEx)RunManager.getInstance((Project)this.myProject)).addRunManagerListener((RunManagerListener)new RunManagerAdapter(){

            private void changed() {
                MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectsNavigator.this.myStructure.updateRunConfigurations();
                    }
                });
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator$6", "runConfigurationAdded"));
                }
                this.changed();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator$6", "runConfigurationRemoved"));
                }
                this.changed();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/maven/navigator/MavenProjectsNavigator$6", "runConfigurationChanged"));
                }
                this.changed();
            }
        });
    }

    private void initToolWindow() {
        this.initTree();
        MavenProjectsNavigatorPanel panel = new MavenProjectsNavigatorPanel(this.myProject, this.myTree);
        AnAction removeAction = EmptyAction.wrap((AnAction)ActionManager.getInstance().getAction("Maven.RemoveRunConfiguration"));
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.myTree, (Disposable)this.myProject);
        AnAction editSource = EmptyAction.wrap((AnAction)ActionManager.getInstance().getAction("Maven.EditRunConfiguration"));
        editSource.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)this.myTree, (Disposable)this.myProject);
        ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx((Project)this.myProject);
        this.myToolWindow = (ToolWindowEx)manager.registerToolWindow(TOOL_WINDOW_ID, false, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(MavenIcons.ToolWindowMaven);
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        Content content = contentFactory.createContent((JComponent)((Object)panel), "", false);
        ContentManager contentManager = this.myToolWindow.getContentManager();
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, false);
        ToolWindowManagerAdapter listener = new ToolWindowManagerAdapter(){
            boolean wasVisible = false;

            public void stateChanged() {
                if (MavenProjectsNavigator.this.myToolWindow.isDisposed()) {
                    return;
                }
                boolean visible = MavenProjectsNavigator.this.myToolWindow.isVisible();
                if (!visible || this.wasVisible) {
                    return;
                }
                MavenProjectsNavigator.this.scheduleStructureUpdate();
                this.wasVisible = true;
            }
        };
        manager.addToolWindowManagerListener((ToolWindowManagerListener)listener, (Disposable)this.myProject);
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(actionManager.getAction("Maven.GroupProjects"));
        group.add(actionManager.getAction("Maven.ShowIgnored"));
        group.add(actionManager.getAction("Maven.ShowBasicPhasesOnly"));
        group.add(actionManager.getAction("Maven.AlwaysShowArtifactId"));
        group.add(actionManager.getAction("Maven.ShowVersions"));
        this.myToolWindow.setAdditionalGearActions((ActionGroup)group);
    }

    private void initTree() {
        this.myTree = new SimpleTree(){
            private final JLabel myLabel = new JLabel(ProjectBundle.message("maven.navigator.nothing.to.display", MavenUtil.formatHtmlImage(MavenProjectsNavigator.access$700()), MavenUtil.formatHtmlImage(MavenProjectsNavigator.access$800())));

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (MavenProjectsNavigator.this.myProjectsManager.hasProjects()) {
                    return;
                }
                this.myLabel.setFont(this.getFont());
                this.myLabel.setBackground(this.getBackground());
                this.myLabel.setForeground(this.getForeground());
                Rectangle bounds = this.getBounds();
                Dimension size = this.myLabel.getPreferredSize();
                this.myLabel.setBounds(0, 0, size.width, size.height);
                int x = (bounds.width - size.width) / 2;
                Graphics g2 = g.create(bounds.x + x, bounds.y + 20, bounds.width, bounds.height);
                try {
                    this.myLabel.paint(g2);
                }
                finally {
                    g2.dispose();
                }
            }
        };
        this.myTree.getEmptyText().clear();
        this.myTree.getSelectionModel().setSelectionMode(4);
    }

    public MavenProjectsStructure getStructureForTests() {
        return this.myStructure;
    }

    public void selectInTree(final MavenProject project) {
        this.scheduleStructureRequest(new Runnable(){

            @Override
            public void run() {
                MavenProjectsNavigator.this.myStructure.select(project);
            }
        });
    }

    private void scheduleStructureRequest(final Runnable r) {
        if (this.isUnitTestMode()) {
            if (this.myStructure != null) {
                r.run();
            }
            return;
        }
        if (this.myToolWindow == null) {
            return;
        }
        MavenUtil.invokeLater(this.myProject, new Runnable(){

            @Override
            public void run() {
                boolean shouldCreate;
                if (!MavenProjectsNavigator.this.myToolWindow.isVisible()) {
                    return;
                }
                boolean bl = shouldCreate = MavenProjectsNavigator.this.myStructure == null;
                if (shouldCreate) {
                    MavenProjectsNavigator.this.initStructure();
                }
                r.run();
                if (shouldCreate && ((MavenProjectsNavigator)MavenProjectsNavigator.this).myState.treeState != null) {
                    TreeState treeState = new TreeState();
                    try {
                        treeState.readExternal(((MavenProjectsNavigator)MavenProjectsNavigator.this).myState.treeState);
                        treeState.applyTo((JTree)MavenProjectsNavigator.this.myTree);
                    }
                    catch (InvalidDataException e) {
                        MavenLog.LOG.info((Throwable)e);
                    }
                }
            }
        });
    }

    private void initStructure() {
        this.myStructure = new MavenProjectsStructure(this.myProject, this.myProjectsManager, this.myTasksManager, this.myShortcutsManager, this, this.myTree);
    }

    private void scheduleStructureUpdate() {
        this.scheduleStructureRequest(new Runnable(){

            @Override
            public void run() {
                MavenProjectsNavigator.this.myStructure.update();
            }
        });
    }

    static /* synthetic */ URL access$700() {
        return ADD_ICON_URL;
    }

    static /* synthetic */ URL access$800() {
        return SYNC_ICON_URL;
    }

    private class MyProjectsListener
    extends MavenProjectsTree.ListenerAdapter
    implements MavenProjectsManager.Listener {
        private MyProjectsListener() {
        }

        @Override
        public void activated() {
            MavenProjectsNavigator.this.scheduleStructureUpdate();
        }

        @Override
        public void projectsScheduled() {
        }

        @Override
        public void importAndResolveScheduled() {
        }

        @Override
        public void projectsIgnoredStateChanged(final List<MavenProject> ignored, final List<MavenProject> unignored, boolean fromImport) {
            MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                @Override
                public void run() {
                    MavenProjectsNavigator.this.myStructure.updateIgnored(ContainerUtil.concat((List)ignored, (List)unignored));
                }
            });
        }

        @Override
        public void profilesChanged() {
            MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                @Override
                public void run() {
                    MavenProjectsNavigator.this.myStructure.updateProfiles();
                }
            });
        }

        @Override
        public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
            this.scheduleUpdateProjects(MavenUtil.collectFirsts(updated), deleted);
        }

        @Override
        public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
            this.scheduleUpdateProjects(Collections.singletonList(projectWithChanges.first), Collections.emptyList());
        }

        @Override
        public void pluginsResolved(MavenProject project) {
            this.scheduleUpdateProjects(Collections.singletonList(project), Collections.emptyList());
        }

        private void scheduleUpdateProjects(final List<MavenProject> projects, final List<MavenProject> deleted) {
            MavenProjectsNavigator.this.scheduleStructureRequest(new Runnable(){

                @Override
                public void run() {
                    MavenProjectsNavigator.this.myStructure.updateProjects(projects, deleted);
                }
            });
        }
    }
}

