/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.actions.TargetAction;
import com.intellij.lang.ant.config.impl.AntBeforeRunTask;
import com.intellij.lang.ant.config.impl.AntBeforeRunTaskProvider;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntBuildModelImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.AntWorkspaceConfiguration;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.ExecuteAfterCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteBeforeCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteCompositeTargetEvent;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.lang.ant.config.impl.WrongNameFormatException;
import com.intellij.lang.ant.dom.AntDomFileDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ActionRunner;
import com.intellij.util.EventDispatcher;
import com.intellij.util.StringSetSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ValueProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AntConfiguration", storages={@Storage(value="ant.xml")})
public class AntConfigurationImpl
extends AntConfigurationBase
implements PersistentStateComponent<Element> {
    public static final ValueProperty<AntReference> DEFAULT_ANT = new ValueProperty("defaultAnt", (Object)AntReference.BUNDLED_ANT);
    public static final ValueProperty<AntConfiguration> INSTANCE = new ValueProperty("$instance", null);
    public static final AbstractProperty<String> DEFAULT_JDK_NAME = new AbstractProperty<String>(){

        public String getName() {
            return "$defaultJDKName";
        }

        @Nullable
        public String getDefault(AbstractProperty.AbstractPropertyContainer container) {
            return this.get(container);
        }

        @Nullable
        public String get(AbstractProperty.AbstractPropertyContainer container) {
            if (!container.hasProperty((AbstractProperty)this)) {
                return null;
            }
            AntConfiguration antConfiguration = (AntConfiguration)((Object)INSTANCE.get(container));
            return ProjectRootManager.getInstance((Project)antConfiguration.getProject()).getProjectSdkName();
        }

        public String copy(String jdkName) {
            return jdkName;
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.AntConfigurationImpl");
    @NonNls
    private static final String BUILD_FILE = "buildFile";
    @NonNls
    private static final String CONTEXT_MAPPING = "contextMapping";
    @NonNls
    private static final String CONTEXT = "context";
    @NonNls
    private static final String URL = "url";
    @NonNls
    private static final String EXECUTE_ON_ELEMENT = "executeOn";
    @NonNls
    private static final String EVENT_ELEMENT = "event";
    @NonNls
    private static final String TARGET_ELEMENT = "target";
    private final PsiManager myPsiManager;
    private final Map<ExecutionEvent, Pair<AntBuildFile, String>> myEventToTargetMap = new com.intellij.util.containers.HashMap();
    private final List<AntBuildFileBase> myBuildFiles = new ArrayList<AntBuildFileBase>();
    private volatile AntBuildFileBase[] myBuildFilesArray = null;
    private final Map<AntBuildFile, AntBuildModelBase> myModelToBuildFileMap = new com.intellij.util.containers.HashMap();
    private final Map<VirtualFile, VirtualFile> myAntFileToContextFileMap = new HashMap<VirtualFile, VirtualFile>();
    private final EventDispatcher<AntConfigurationListener> myEventDispatcher = EventDispatcher.create(AntConfigurationListener.class);
    private final AntWorkspaceConfiguration myAntWorkspaceConfiguration;
    private final StartupManager myStartupManager;
    private volatile Boolean myIsInitialized = null;
    private volatile Thread myInitThread = null;

    public AntConfigurationImpl(Project project, AntWorkspaceConfiguration antWorkspaceConfiguration, final DaemonCodeAnalyzer daemon) {
        super(project);
        this.getProperties().registerProperty(DEFAULT_ANT, AntReference.EXTERNALIZER);
        this.getProperties().rememberKey(INSTANCE);
        this.getProperties().rememberKey(DEFAULT_JDK_NAME);
        INSTANCE.set((AbstractProperty.AbstractPropertyContainer)this.getProperties(), (Object)this);
        this.myAntWorkspaceConfiguration = antWorkspaceConfiguration;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myStartupManager = StartupManager.getInstance((Project)project);
        this.addAntConfigurationListener(new AntConfigurationListener(){

            @Override
            public void configurationLoaded() {
                this.restartDaemon();
            }

            @Override
            public void buildFileChanged(AntBuildFile buildFile) {
                this.restartDaemon();
            }

            @Override
            public void buildFileAdded(AntBuildFile buildFile) {
                this.restartDaemon();
            }

            @Override
            public void buildFileRemoved(AntBuildFile buildFile) {
                this.restartDaemon();
            }

            private void restartDaemon() {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    daemon.restart();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            daemon.restart();
                        }
                    });
                }
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", AntConfigurationImpl.EVENT_ELEMENT, "com/intellij/lang/ant/config/impl/AntConfigurationImpl$3", "beforeFileDeletion"));
                }
                VirtualFile vFile = event.getFile();
                for (AntBuildFileBase file : AntConfigurationImpl.this.getBuildFiles()) {
                    if (!vFile.equals(file.getVirtualFile())) continue;
                    AntConfigurationImpl.this.removeBuildFile(file);
                    break;
                }
                Iterator it = AntConfigurationImpl.this.myAntFileToContextFileMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!vFile.equals(entry.getKey()) && !vFile.equals(entry.getValue())) continue;
                    it.remove();
                }
            }
        }, (Disposable)project);
    }

    public Element getState() {
        try {
            Element e = new Element("state");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean isInitialized() {
        Boolean initialized = this.myIsInitialized;
        return initialized == null || initialized != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AntBuildFileBase[] getBuildFiles() {
        AntBuildFileBase[] result = this.myBuildFilesArray;
        if (result == null) {
            List<AntBuildFileBase> list = this.myBuildFiles;
            synchronized (list) {
                result = this.myBuildFilesArray;
                if (result == null) {
                    result = this.myBuildFiles.toArray(new AntBuildFileBase[this.myBuildFiles.size()]);
                    this.myBuildFilesArray = result;
                }
            }
        }
        return result;
    }

    @Override
    public AntBuildFile addBuildFile(final VirtualFile file) throws AntNoFileException {
        final AntBuildFile[] result = new AntBuildFile[]{null};
        final AntNoFileException[] ex = new AntNoFileException[]{null};
        final String title = AntBundle.message("register.ant.build.progress", file.getPresentableUrl());
        ProgressManager.getInstance().run((Task)new Task.Modal(this.getProject(), title, false){

            @Nullable
            public Task.NotificationInfo getNotificationInfo() {
                return new Task.NotificationInfo("Ant", "Ant Task Finished", "");
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/ant/config/impl/AntConfigurationImpl$4", "run"));
                }
                indicator.setIndeterminate(true);
                indicator.pushState();
                try {
                    indicator.setText(title);
                    AntConfigurationImpl.this.incModificationCount();
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                result[0] = AntConfigurationImpl.this.addBuildFileImpl(file);
                                AntConfigurationImpl.this.updateRegisteredActions();
                            }
                            catch (AntNoFileException e) {
                                ex[0] = e;
                            }
                        }
                    });
                    if (result[0] != null) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((AntConfigurationListener)AntConfigurationImpl.this.myEventDispatcher.getMulticaster()).buildFileAdded(result[0]);
                            }
                        });
                    }
                }
                finally {
                    indicator.popState();
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return result[0];
    }

    @Override
    public void removeBuildFile(AntBuildFile file) {
        this.incModificationCount();
        this.removeBuildFileImpl(file);
        this.updateRegisteredActions();
    }

    @Override
    public void addAntConfigurationListener(AntConfigurationListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeAntConfigurationListener(AntConfigurationListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public boolean isFilterTargets() {
        return this.myAntWorkspaceConfiguration.FILTER_TARGETS;
    }

    @Override
    public void setFilterTargets(boolean value) {
        this.myAntWorkspaceConfiguration.FILTER_TARGETS = value;
    }

    @Override
    public AntBuildTarget[] getMetaTargets(AntBuildFile buildFile) {
        List<ExecutionEvent> events = this.getEventsByClass(ExecuteCompositeTargetEvent.class);
        if (events.size() == 0) {
            return AntBuildTargetBase.EMPTY_ARRAY;
        }
        ArrayList<MetaTarget> targets = new ArrayList<MetaTarget>();
        for (ExecutionEvent event : events) {
            MetaTarget target = (MetaTarget)this.getTargetForEvent(event);
            if (target == null || !buildFile.equals(target.getBuildFile())) continue;
            targets.add(target);
        }
        return targets.toArray(new AntBuildTargetBase[targets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExecutionEvent> getEventsForTarget(AntBuildTarget target) {
        ArrayList<ExecutionEvent> list = new ArrayList<ExecutionEvent>();
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            for (ExecutionEvent event : this.myEventToTargetMap.keySet()) {
                AntBuildTarget targetForEvent = this.getTargetForEvent(event);
                if (!target.equals(targetForEvent)) continue;
                list.add(event);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AntBuildTarget getTargetForEvent(ExecutionEvent event) {
        Pair<AntBuildFile, String> pair;
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            pair = this.myEventToTargetMap.get(event);
        }
        if (pair == null) {
            return null;
        }
        AntBuildFileBase buildFile = (AntBuildFileBase)pair.first;
        List<AntBuildFileBase> list = this.myBuildFiles;
        synchronized (list) {
            if (!this.myBuildFiles.contains(buildFile)) {
                return null;
            }
        }
        String targetName = (String)pair.second;
        AntBuildTarget antBuildTarget = buildFile.getModel().findTarget(targetName);
        if (antBuildTarget != null) {
            return antBuildTarget;
        }
        List<ExecutionEvent> events = this.getEventsByClass(ExecuteCompositeTargetEvent.class);
        if (events.size() == 0) {
            return null;
        }
        for (ExecutionEvent ev : events) {
            String name = "compositeTask".equals(ev.getTypeId()) ? ((ExecuteCompositeTargetEvent)ev).getMetaTargetName() : ev.getPresentableName();
            if (!Comparing.strEqual((String)targetName, (String)name)) continue;
            return new MetaTarget(buildFile, ev.getPresentableName(), ((ExecuteCompositeTargetEvent)ev).getTargetNames());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTargetForEvent(AntBuildFile buildFile, String targetName, ExecutionEvent event) {
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            this.myEventToTargetMap.put(event, (Pair<AntBuildFile, String>)Pair.create((Object)buildFile, (Object)targetName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTargetForEvent(ExecutionEvent event) {
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            this.myEventToTargetMap.remove(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTargetRename(String oldTargetName, String newTargetName) {
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            for (Map.Entry<ExecutionEvent, Pair<AntBuildFile, String>> entry : this.myEventToTargetMap.entrySet()) {
                Pair<AntBuildFile, String> pair = entry.getValue();
                if (pair == null || !Comparing.equal((String)((String)pair.getSecond()), (String)oldTargetName)) continue;
                entry.setValue((Pair<AntBuildFile, String>)Pair.create((Object)pair.getFirst(), (Object)newTargetName));
            }
        }
    }

    @Override
    public void updateBuildFile(AntBuildFile buildFile) {
        this.incModificationCount();
        ((AntConfigurationListener)this.myEventDispatcher.getMulticaster()).buildFileChanged(buildFile);
        this.updateRegisteredActions();
    }

    @Override
    public boolean isAutoScrollToSource() {
        return this.myAntWorkspaceConfiguration.IS_AUTOSCROLL_TO_SOURCE;
    }

    @Override
    public void setAutoScrollToSource(boolean value) {
        this.myAntWorkspaceConfiguration.IS_AUTOSCROLL_TO_SOURCE = value;
    }

    @Override
    public AntInstallation getProjectDefaultAnt() {
        return ((AntReference)DEFAULT_ANT.get((AbstractProperty.AbstractPropertyContainer)this.getProperties())).find(GlobalAntConfiguration.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AntBuildModel getModelIfRegistered(AntBuildFile buildFile) {
        List<AntBuildFileBase> list = this.myBuildFiles;
        synchronized (list) {
            if (!this.myBuildFiles.contains(buildFile)) {
                return null;
            }
        }
        return this.getModel(buildFile);
    }

    private void readExternal(final Element parentNode) throws InvalidDataException {
        this.myIsInitialized = Boolean.FALSE;
        this.myAntWorkspaceConfiguration.loadFromProjectSettings(parentNode);
        this.getProperties().readExternal(parentNode);
        this.runWhenInitialized(new Runnable(){

            @Override
            public void run() {
                AntConfigurationImpl.this.loadBuildFileProjectProperties(parentNode);
            }
        });
    }

    private void runWhenInitialized(final Runnable runnable) {
        if (this.getProject().isInitialized()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        } else {
            this.myStartupManager.runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }
    }

    private void writeExternal(final Element parentNode) throws WriteExternalException {
        this.getProperties().writeExternal(parentNode);
        try {
            ActionRunner.runInsideReadAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                public void run() throws WriteExternalException {
                    for (AntBuildFileBase buildFile : AntConfigurationImpl.this.getBuildFiles()) {
                        Element element = new Element(AntConfigurationImpl.BUILD_FILE);
                        element.setAttribute(AntConfigurationImpl.URL, buildFile.getVirtualFile().getUrl());
                        buildFile.writeProperties(element);
                        AntConfigurationImpl.this.saveEvents(element, buildFile);
                        parentNode.addContent(element);
                    }
                    ArrayList files = new ArrayList(AntConfigurationImpl.this.myAntFileToContextFileMap.keySet());
                    Collections.sort(files, new Comparator<VirtualFile>(){

                        @Override
                        public int compare(VirtualFile o1, VirtualFile o2) {
                            return o1.getUrl().compareTo(o2.getUrl());
                        }
                    });
                    for (VirtualFile file : files) {
                        Element element = new Element(AntConfigurationImpl.CONTEXT_MAPPING);
                        VirtualFile contextFile = (VirtualFile)AntConfigurationImpl.this.myAntFileToContextFileMap.get(file);
                        element.setAttribute(AntConfigurationImpl.URL, file.getUrl());
                        element.setAttribute(AntConfigurationImpl.CONTEXT, contextFile.getUrl());
                        parentNode.addContent(element);
                    }
                }
            });
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEvents(Element element, AntBuildFile buildFile) {
        ArrayList<Element> events = null;
        HashSet<String> savedEvents = new HashSet<String>();
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            for (ExecutionEvent event : this.myEventToTargetMap.keySet()) {
                Pair<AntBuildFile, String> pair = this.myEventToTargetMap.get(event);
                if (!buildFile.equals(pair.first)) continue;
                Element eventElement = new Element(EXECUTE_ON_ELEMENT);
                eventElement.setAttribute(EVENT_ELEMENT, event.getTypeId());
                eventElement.setAttribute(TARGET_ELEMENT, (String)pair.second);
                String id = event.writeExternal(eventElement, this.getProject());
                if (savedEvents.contains(id)) continue;
                savedEvents.add(id);
                if (events == null) {
                    events = new ArrayList<Element>();
                }
                events.add(eventElement);
            }
        }
        if (events != null) {
            Collections.sort(events, EventElementComparator.INSTANCE);
            for (Element eventElement : events) {
                element.addContent(eventElement);
            }
        }
    }

    @Override
    public AntBuildModel getModel(AntBuildFile buildFile) {
        AntBuildModelBase model = this.myModelToBuildFileMap.get(buildFile);
        if (model == null) {
            model = this.createModel(buildFile);
            this.myModelToBuildFileMap.put(buildFile, model);
        }
        return model;
    }

    @Override
    @Nullable
    public AntBuildFile findBuildFileByActionId(String id) {
        for (AntBuildFileBase buildFile : this.getBuildFiles()) {
            AntBuildModelBase model = (AntBuildModelBase)buildFile.getModel();
            if (id.equals(model.getDefaultTargetActionId())) {
                return buildFile;
            }
            if (!model.hasTargetWithActionId(id)) continue;
            return buildFile;
        }
        return null;
    }

    private AntBuildModelBase createModel(AntBuildFile buildFile) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        }
        return new AntBuildModelImpl(buildFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AntBuildFileBase addBuildFileImpl(VirtualFile file) throws AntNoFileException {
        PsiFile xmlFile = this.myPsiManager.findFile(file);
        if (!(xmlFile instanceof XmlFile)) {
            throw new AntNoFileException("the file is not an xml file", file);
        }
        AntSupport.markFileAsAntFile(file, xmlFile.getProject(), true);
        if (!AntDomFileDescription.isAntFile((XmlFile)xmlFile)) {
            throw new AntNoFileException("the file is not recognized as an ANT file", file);
        }
        AntBuildFileImpl buildFile = new AntBuildFileImpl((XmlFile)xmlFile, this);
        List<AntBuildFileBase> list = this.myBuildFiles;
        synchronized (list) {
            this.myBuildFilesArray = null;
            this.myBuildFiles.add(buildFile);
        }
        return buildFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateRegisteredActions() {
        Project project = this.getProject();
        if (project.isDisposed()) {
            return;
        }
        ArrayList<Pair<String, AnAction>> actionList = new ArrayList<Pair<String, AnAction>>();
        for (AntBuildFileBase antBuildFileBase : this.getBuildFiles()) {
            AntBuildModelBase model = (AntBuildModelBase)antBuildFileBase.getModel();
            String string = model.getDefaultTargetActionId();
            if (string != null) {
                TargetAction action = new TargetAction(antBuildFileBase, TargetAction.DEFAULT_TARGET_NAME, new String[]{TargetAction.DEFAULT_TARGET_NAME}, null);
                actionList.add((Pair<String, AnAction>)new Pair((Object)string, (Object)action));
            }
            AntConfigurationImpl.collectTargetActions(model.getFilteredTargets(), actionList, antBuildFileBase);
            AntConfigurationImpl.collectTargetActions(this.getMetaTargets(antBuildFileBase), actionList, antBuildFileBase);
        }
        AntConfigurationImpl antConfigurationImpl = this;
        synchronized (antConfigurationImpl) {
            void var8_17;
            String[] oldIds;
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            String[] stringArray = oldIds = actionManager.getActionIds(AntConfiguration.getActionIdPrefix(project));
            int n = stringArray.length;
            boolean bl = false;
            while (var8_17 < n) {
                String oldId = stringArray[var8_17];
                actionManager.unregisterAction(oldId);
                ++var8_17;
            }
            Set set = StringSetSpinAllocator.alloc();
            try {
                for (Pair pair : actionList) {
                    if (set.contains(pair.first)) continue;
                    set.add(pair.first);
                    actionManager.registerAction((String)pair.first, (AnAction)pair.second);
                }
            }
            finally {
                StringSetSpinAllocator.dispose((Set)set);
            }
        }
    }

    private static void collectTargetActions(AntBuildTarget[] targets, List<Pair<String, AnAction>> actionList, AntBuildFile buildFile) {
        for (AntBuildTarget target : targets) {
            String actionId = ((AntBuildTargetBase)target).getActionId();
            if (actionId == null) continue;
            TargetAction action = new TargetAction(buildFile, target.getName(), new String[]{target.getName()}, target.getNotEmptyDescription());
            actionList.add((Pair<String, AnAction>)new Pair((Object)actionId, (Object)action));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBuildFileImpl(AntBuildFile buildFile) {
        XmlFile antFile = buildFile.getAntFile();
        if (antFile != null) {
            AntSupport.markFileAsAntFile(antFile.getOriginalFile().getVirtualFile(), antFile.getProject(), false);
        }
        List<AntBuildFileBase> list = this.myBuildFiles;
        synchronized (list) {
            this.myBuildFilesArray = null;
            this.myBuildFiles.remove(buildFile);
        }
        this.myModelToBuildFileMap.remove(buildFile);
        ((AntConfigurationListener)this.myEventDispatcher.getMulticaster()).buildFileRemoved(buildFile);
    }

    @Override
    public boolean executeTargetBeforeCompile(DataContext context) {
        return this.runTargetSynchronously(context, ExecuteBeforeCompilationEvent.getInstance());
    }

    @Override
    public boolean executeTargetAfterCompile(DataContext context) {
        return this.runTargetSynchronously(context, ExecuteAfterCompilationEvent.getInstance());
    }

    private boolean runTargetSynchronously(DataContext dataContext, ExecutionEvent event) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            throw new IllegalStateException("Called in the event dispatch thread");
        }
        AntBuildTarget target = this.getTargetForEvent(event);
        if (target == null) {
            return true;
        }
        return AntConfigurationImpl.executeTargetSynchronously(dataContext, target);
    }

    public static boolean executeTargetSynchronously(DataContext dataContext, AntBuildTarget target) {
        return AntConfigurationImpl.executeTargetSynchronously(dataContext, target, Collections.emptyList());
    }

    public static boolean executeTargetSynchronously(final DataContext dataContext, final AntBuildTarget target, final List<BuildFileProperty> additionalProperties) {
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        final Ref result = Ref.create((Object)Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                    if (project == null || project.isDisposed()) {
                        targetDone.up();
                    } else {
                        target.run(dataContext, additionalProperties, new AntBuildListener(){

                            @Override
                            public void buildFinished(int state, int errorCount) {
                                result.set((Object)(state == 0 && errorCount == 0 ? 1 : 0));
                                targetDone.up();
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    targetDone.up();
                    LOG.error(e);
                }
            }
        });
        targetDone.waitFor();
        return (Boolean)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExecutionEvent> getEventsByClass(Class eventClass) {
        Thread initThread = this.myInitThread;
        if (initThread == null || initThread != Thread.currentThread()) {
            this.ensureInitialized();
        }
        ArrayList<ExecutionEvent> list = new ArrayList<ExecutionEvent>();
        Map<ExecutionEvent, Pair<AntBuildFile, String>> map = this.myEventToTargetMap;
        synchronized (map) {
            for (ExecutionEvent event : this.myEventToTargetMap.keySet()) {
                if (!eventClass.isInstance(event)) continue;
                list.add(event);
            }
        }
        return list;
    }

    private void loadBuildFileProjectProperties(Element parentNode) {
        String url;
        Element element;
        final ArrayList<Pair> files = new ArrayList<Pair>();
        final VirtualFileManager vfManager = VirtualFileManager.getInstance();
        for (Object o : parentNode.getChildren(BUILD_FILE)) {
            element = (Element)o;
            url = element.getAttributeValue(URL);
            if (url == null) continue;
            files.add(Pair.create((Object)element, (Object)url));
        }
        this.myAntFileToContextFileMap.clear();
        for (Object o : parentNode.getChildren(CONTEXT_MAPPING)) {
            element = (Element)o;
            url = element.getAttributeValue(URL);
            String contextUrl = element.getAttributeValue(CONTEXT);
            VirtualFile file = vfManager.findFileByUrl(url);
            VirtualFile contextFile = vfManager.findFileByUrl(contextUrl);
            if (file == null || contextFile == null) continue;
            this.myAntFileToContextFileMap.put(file, contextFile);
        }
        final String title = AntBundle.message("loading.ant.config.progress", new Object[0]);
        AntConfigurationImpl.queueLater((Task)new Task.Backgroundable(this.getProject(), title, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/ant/config/impl/AntConfigurationImpl$10", "run"));
                }
                if (this.getProject().isDisposed()) {
                    return;
                }
                indicator.setIndeterminate(true);
                indicator.pushState();
                try {
                    indicator.setText(title);
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            try {
                                AntConfigurationImpl.this.myInitThread = Thread.currentThread();
                                for (AntBuildFileBase file : AntConfigurationImpl.this.getBuildFiles()) {
                                    AntConfigurationImpl.this.removeBuildFileImpl(file);
                                }
                                ArrayList<Pair> buildFiles = new ArrayList<Pair>(files.size());
                                for (Pair pair : files) {
                                    Element element = (Element)pair.getFirst();
                                    VirtualFile file = vfManager.findFileByUrl((String)pair.getSecond());
                                    if (file == null) continue;
                                    try {
                                        AntBuildFileBase buildFile = AntConfigurationImpl.this.addBuildFileImpl(file);
                                        buildFile.readProperties(element);
                                        buildFiles.add(Pair.create((Object)element, (Object)buildFile));
                                    }
                                    catch (AntNoFileException buildFile) {
                                    }
                                    catch (InvalidDataException e) {
                                        LOG.error((Throwable)e);
                                    }
                                }
                                Iterator iterator = buildFiles.iterator();
                                block19: while (true) {
                                    if (!iterator.hasNext()) {
                                        AntWorkspaceConfiguration.getInstance(this.getProject()).loadFileProperties();
                                        try {
                                            AntConfigurationImpl.this.incModificationCount();
                                            AntConfigurationImpl.this.updateRegisteredActions();
                                        }
                                        catch (Throwable throwable) {
                                            AntConfigurationImpl.this.myInitThread = null;
                                            AntConfigurationImpl.this.myIsInitialized = Boolean.TRUE;
                                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    ((AntConfigurationListener)AntConfigurationImpl.this.myEventDispatcher.getMulticaster()).configurationLoaded();
                                                }
                                            }, ModalityState.any());
                                            throw throwable;
                                        }
                                        AntConfigurationImpl.this.myInitThread = null;
                                        AntConfigurationImpl.this.myIsInitialized = Boolean.TRUE;
                                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.any());
                                        return;
                                    }
                                    Pair pair = (Pair)iterator.next();
                                    AntBuildFileBase buildFile = (AntBuildFileBase)pair.getSecond();
                                    buildFile.updateProperties();
                                    VirtualFile vFile = buildFile.getVirtualFile();
                                    String buildFileUrl = vFile != null ? vFile.getUrl() : null;
                                    Iterator iterator2 = ((Element)pair.getFirst()).getChildren(AntConfigurationImpl.EXECUTE_ON_ELEMENT).iterator();
                                    while (true) {
                                        if (!iterator2.hasNext()) continue block19;
                                        Object o1 = iterator2.next();
                                        Element e = (Element)o1;
                                        String eventId = e.getAttributeValue(AntConfigurationImpl.EVENT_ELEMENT);
                                        ExecutionEvent event = null;
                                        String targetName = e.getAttributeValue(AntConfigurationImpl.TARGET_ELEMENT);
                                        if ("beforeCompilation".equals(eventId)) {
                                            event = ExecuteBeforeCompilationEvent.getInstance();
                                        } else if ("afterCompilation".equals(eventId)) {
                                            event = ExecuteAfterCompilationEvent.getInstance();
                                        } else if ("beforeRun".equals(eventId)) {
                                            String configType = e.getAttributeValue("runConfigurationType");
                                            String configName = e.getAttributeValue("runConfigurationName");
                                            AntConfigurationImpl.convertToBeforeRunTask(myProject, buildFileUrl, targetName, configType, configName);
                                        } else if ("compositeTask".equals(eventId)) {
                                            try {
                                                event = new ExecuteCompositeTargetEvent(targetName);
                                            }
                                            catch (WrongNameFormatException e1) {
                                                LOG.info((Throwable)e1);
                                                event = null;
                                            }
                                        }
                                        if (event == null) continue;
                                        try {
                                            event.readExternal(e, this.getProject());
                                            AntConfigurationImpl.this.setTargetForEvent(buildFile, targetName, event);
                                        }
                                        catch (InvalidDataException readFailed) {
                                            LOG.info(readFailed.getMessage());
                                        }
                                    }
                                    break;
                                }
                            }
                            catch (InvalidDataException e) {
                                try {
                                    LOG.error((Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        AntConfigurationImpl.this.incModificationCount();
                                        AntConfigurationImpl.this.updateRegisteredActions();
                                    }
                                    catch (Throwable throwable2) {
                                        AntConfigurationImpl.this.myInitThread = null;
                                        AntConfigurationImpl.this.myIsInitialized = Boolean.TRUE;
                                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.any());
                                        throw throwable2;
                                    }
                                    AntConfigurationImpl.this.myInitThread = null;
                                    AntConfigurationImpl.this.myIsInitialized = Boolean.TRUE;
                                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.any());
                                    throw throwable;
                                }
                                try {
                                    AntConfigurationImpl.this.incModificationCount();
                                    AntConfigurationImpl.this.updateRegisteredActions();
                                }
                                catch (Throwable throwable) {
                                    AntConfigurationImpl.this.myInitThread = null;
                                    AntConfigurationImpl.this.myIsInitialized = Boolean.TRUE;
                                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.any());
                                    throw throwable;
                                }
                                AntConfigurationImpl.this.myInitThread = null;
                                AntConfigurationImpl.this.myIsInitialized = Boolean.TRUE;
                                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.any());
                                return;
                            }
                        }
                    });
                }
                finally {
                    indicator.popState();
                }
            }
        });
    }

    private static void convertToBeforeRunTask(Project project, String buildFileUrl, String targetName, String configType, String configName) {
        if (buildFileUrl == null || targetName == null || configType == null) {
            return;
        }
        RunManagerImpl runManager = (RunManagerImpl)RunManagerEx.getInstanceEx((Project)project);
        ConfigurationType type = runManager.getConfigurationType(configType);
        if (type == null) {
            return;
        }
        if (configName != null) {
            for (RunConfiguration configuration : runManager.getConfigurationsList(type)) {
                List tasks;
                if (!configName.equals(configuration.getName()) || (tasks = runManager.getBeforeRunTasks(configuration, AntBeforeRunTaskProvider.ID)).isEmpty()) continue;
                AntBeforeRunTask task = (AntBeforeRunTask)((Object)tasks.get(0));
                task.setEnabled(true);
                task.setTargetName(targetName);
                task.setAntFileUrl(buildFileUrl);
            }
        } else {
            for (ConfigurationFactory factory : type.getConfigurationFactories()) {
                RunConfiguration template = runManager.getConfigurationTemplate(factory).getConfiguration();
                List tasks = runManager.getBeforeRunTasks(template, AntBeforeRunTaskProvider.ID);
                if (tasks.isEmpty()) continue;
                AntBeforeRunTask task = (AntBeforeRunTask)((Object)tasks.get(0));
                task.setEnabled(true);
                task.setTargetName(targetName);
                task.setAntFileUrl(buildFileUrl);
            }
        }
    }

    private static void queueLater(final Task task) {
        Application app = ApplicationManager.getApplication();
        if (!app.isDispatchThread() || task.isHeadless()) {
            app.invokeLater(new Runnable(){

                @Override
                public void run() {
                    task.queue();
                }
            }, ModalityState.any());
        } else {
            task.queue();
        }
    }

    @Override
    public void setContextFile(@NotNull XmlFile file, @Nullable XmlFile context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ant/config/impl/AntConfigurationImpl", "setContextFile"));
        }
        if (context != null) {
            this.myAntFileToContextFileMap.put(file.getVirtualFile(), context.getVirtualFile());
        } else {
            this.myAntFileToContextFileMap.remove(file.getVirtualFile());
        }
    }

    @Override
    @Nullable
    public XmlFile getContextFile(@Nullable XmlFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile context = this.myAntFileToContextFileMap.get(file.getVirtualFile());
        if (context == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(context);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        return AntDomFileDescription.isAntFile(xmlFile) ? xmlFile : null;
    }

    @Override
    @Nullable
    public AntBuildFileBase getAntBuildFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ant/config/impl/AntConfigurationImpl", "getAntBuildFile"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null) {
            for (AntBuildFileBase bFile : this.getBuildFiles()) {
                if (!vFile.equals(bFile.getVirtualFile())) continue;
                return bFile;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public XmlFile getEffectiveContextFile(XmlFile file) {
        return new Object(){

            @Nullable
            XmlFile findContext(XmlFile file, Set<PsiElement> processed) {
                if (file != null) {
                    processed.add((PsiElement)file);
                    XmlFile contextFile = AntConfigurationImpl.this.getContextFile(file);
                    return contextFile == null || processed.contains(contextFile) ? file : this.findContext(contextFile, processed);
                }
                return null;
            }
        }.findContext(file, new HashSet<PsiElement>());
    }

    private static class EventElementComparator
    implements Comparator<Element> {
        static final Comparator<? super Element> INSTANCE = new EventElementComparator();
        private static final String[] COMPARABLE_ATTRIB_NAMES = new String[]{"event", "target", "presentableName"};

        private EventElementComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            for (String attribName : COMPARABLE_ATTRIB_NAMES) {
                int valuesEqual = Comparing.compare((Comparable)((Object)o1.getAttributeValue(attribName)), (Comparable)((Object)o2.getAttributeValue(attribName)));
                if (valuesEqual == 0) continue;
                return valuesEqual;
            }
            return 0;
        }
    }
}

