/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.lang.ant.AntImportsIndex;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.dom.AntDomFileDescription;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;

public class AntHectorConfigurable
extends HectorComponentPanel {
    @NonNls
    private static final String NONE = "<None>";
    @NonNls
    public static final String CONTEXTS_COMBO_KEY = "AntContextsComboBox";
    private final XmlFile myFile;
    private final String myLocalPath;
    private final Map<String, XmlFile> myPathToFileMap = new HashMap<String, XmlFile>();
    private String myOriginalContext = "<None>";
    private JComboBox myCombo;
    private final GlobalSearchScope myFileFilter;
    private final Project myProject;

    public AntHectorConfigurable(XmlFile file) {
        this.myFile = file;
        this.myProject = file.getProject();
        VirtualFile selfVFile = this.myFile.getVirtualFile();
        this.myLocalPath = PathUtil.getLocalPath((VirtualFile)selfVFile);
        this.myFileFilter = GlobalSearchScope.projectScope((Project)this.myProject);
    }

    public boolean canClose() {
        return !this.myCombo.isPopupVisible();
    }

    public JComponent createComponent() {
        String path;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"File Context", (boolean)false));
        this.myCombo = new ComboBox();
        this.myCombo.putClientProperty(CONTEXTS_COMBO_KEY, Boolean.TRUE);
        panel.add((Component)new JLabel("Included into:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)5, (int)0), 0, 0));
        panel.add((Component)this.myCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)5, (int)5, (int)5, (int)0), 0, 0));
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        FileBasedIndex fbi = FileBasedIndex.getInstance();
        Collection antFiles = fbi.getContainingFiles(AntImportsIndex.INDEX_NAME, (Object)AntImportsIndex.ANT_FILES_WITH_IMPORTS_KEY, this.myFileFilter);
        for (Object file : antFiles) {
            XmlFile xmlFile;
            PsiFile psiFile = psiManager.findFile((VirtualFile)file);
            if (!(psiFile instanceof XmlFile) || (xmlFile = (XmlFile)psiFile).equals(this.myFile) || !AntDomFileDescription.isAntFile(xmlFile)) continue;
            path = PathUtil.getLocalPath((VirtualFile)file);
            XmlFile previous = this.myPathToFileMap.put(path, xmlFile);
            assert (previous == null);
        }
        ArrayList<String> paths = new ArrayList<String>(this.myPathToFileMap.keySet());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        this.myCombo.addItem(NONE);
        for (String path2 : paths) {
            this.myCombo.addItem(path2);
        }
        AntConfigurationBase antConfig = AntConfigurationBase.getInstance(this.myProject);
        XmlFile currentContext = antConfig.getContextFile(this.myFile);
        if (currentContext != null) {
            VirtualFile vFile = currentContext.getVirtualFile();
            assert (vFile != null);
            path = PathUtil.getLocalPath((VirtualFile)vFile);
            if (!FileUtil.pathsEqual((String)path, (String)this.myLocalPath)) {
                this.myOriginalContext = path;
            }
        }
        this.myCombo.setSelectedItem(this.myOriginalContext);
        return panel;
    }

    public boolean isModified() {
        return !FileUtil.pathsEqual((String)this.myOriginalContext, (String)((String)this.myCombo.getSelectedItem()));
    }

    public void apply() throws ConfigurationException {
        this.applyItem((String)this.myCombo.getSelectedItem());
    }

    public void reset() {
        this.applyItem(this.myOriginalContext);
    }

    private void applyItem(String contextStr) {
        XmlFile context = null;
        if (!NONE.equals(contextStr)) {
            context = this.myPathToFileMap.get(contextStr);
            assert (context != null);
        }
        AntConfigurationBase.getInstance(this.myProject).setContextFile(this.myFile, context);
    }

    public void disposeUIResources() {
        this.myPathToFileMap.clear();
    }
}

