/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.reflect.DirectInstantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileWatcherFactory
implements FileWatcherFactory,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileWatcherFactory.class);
    private static final int STOP_TIMEOUT_SECONDS = 10;
    private final StoppableExecutor executor;
    private final JavaVersion javaVersion;
    private final ClassLoader classLoader;
    private FileWatcherFactory fileWatcherFactory;

    public DefaultFileWatcherFactory(ExecutorFactory executorFactory) {
        this(JavaVersion.current(), DefaultFileWatcherFactory.class.getClassLoader(), executorFactory);
    }

    DefaultFileWatcherFactory(JavaVersion javaVersion, ClassLoader classLoader, ExecutorFactory executorFactory) {
        this.javaVersion = javaVersion;
        this.classLoader = classLoader;
        this.executor = executorFactory.create("filewatcher");
    }

    protected FileWatcherFactory createFileWatcherFactory() {
        if (this.javaVersion.isJava7Compatible()) {
            try {
                Class<?> clazz = this.classLoader.loadClass("org.gradle.internal.filewatch.jdk7.Jdk7FileWatcherFactory");
                return (FileWatcherFactory)Cast.uncheckedCast((Object)DirectInstantiator.instantiate(clazz, (Object[])new Object[]{this.executor}));
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException("File watching requires Java 7 or later.");
    }

    public void stop() {
        try {
            this.executor.stop(10, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.debug("Problem shutting down executor. The problem might be caused by JDK-8011537.", (Throwable)e);
        }
    }

    @Override
    public FileWatcher watch(Action<? super Throwable> onError, FileWatcherListener listener) {
        if (this.fileWatcherFactory == null) {
            this.fileWatcherFactory = this.createFileWatcherFactory();
        }
        return this.fileWatcherFactory.watch(onError, listener);
    }
}

