/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.PathKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.table.TableModelEditor;
import gnu.trove.THashSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.UpstreamEditorKt;
import org.jetbrains.settingsRepository.UtilKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\"$\u0010\u0000\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\b\u0001\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\t"}, d2={"COLUMNS", "", "Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "", "[Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "createReadOnlySourcesEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "settings-repository"})
public final class ReadOnlySourcesEditorKt {
    private static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Object>[] COLUMNS;

    @NotNull
    public static final ConfigurableUi<IcsSettings> createReadOnlySourcesEditor() {
        TableModelEditor.DialogItemEditor<ReadonlySource> itemEditor2 = new TableModelEditor.DialogItemEditor<ReadonlySource>(){

            @NotNull
            public ReadonlySource clone(@NotNull ReadonlySource item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new ReadonlySource(item.getUrl(), item.getActive());
            }

            @NotNull
            public Class<ReadonlySource> getItemClass() {
                return ReadonlySource.class;
            }

            public void edit(@NotNull ReadonlySource item, @NotNull Function<ReadonlySource, ReadonlySource> mutator, boolean isAdd) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull(mutator, (String)"mutator");
                DialogBuilder dialogBuilder = new DialogBuilder();
                TextFieldWithBrowseButton urlField = new TextFieldWithBrowseButton(new JTextField(20));
                urlField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
                urlField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(dialogBuilder, urlField){
                    final /* synthetic */ DialogBuilder $dialogBuilder;
                    final /* synthetic */ TextFieldWithBrowseButton $urlField;

                    protected void textChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        this.$dialogBuilder.setOkActionEnabled(UpstreamEditorKt.checkUrl(UtilKt.nullize(this.$urlField.getText())));
                    }
                    {
                        this.$dialogBuilder = $captured_local_variable$0;
                        this.$urlField = $captured_local_variable$1;
                    }
                });
                dialogBuilder.title("Add read-only source").resizable(false).centerPanel((JComponent)FormBuilder.createFormBuilder().addLabeledComponent("URL:", (JComponent)urlField).getPanel()).setPreferredFocusComponent((JComponent)urlField);
                if (dialogBuilder.showAndGet()) {
                    ((ReadonlySource)mutator.fun((Object)item)).setUrl(urlField.getText());
                }
            }

            public void applyEdited(@NotNull ReadonlySource oldItem, @NotNull ReadonlySource newItem) {
                Intrinsics.checkParameterIsNotNull((Object)oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        TableModelEditor editor = new TableModelEditor((ColumnInfo[])COLUMNS, (CollectionItemEditor)itemEditor2, "No sources configured");
        editor.reset(IcsManagerKt.getIcsManager().getSettings().getReadOnlySources());
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor){
            final /* synthetic */ TableModelEditor $editor;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            public void apply(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List<ReadonlySource> oldList = settings.getReadOnlySources();
                THashSet toDelete = new THashSet(oldList.size());
                for (ReadonlySource oldSource : oldList) {
                    ContainerUtil.addIfNotNull((Collection)((Collection)toDelete), (Object)oldSource.getPath());
                }
                THashSet toCheckout = new THashSet();
                List newList = this.$editor.apply();
                for (ReadonlySource newSource : newList) {
                    String path = newSource.getPath();
                    if (path == null || toDelete.remove((Object)path)) continue;
                    toCheckout.add((Object)newSource);
                }
                if (toDelete.isEmpty() && toCheckout.isEmpty()) {
                    return;
                }
                ProgressManager.getInstance().run((Task)new Task.Modal(toDelete, toCheckout, newList, null, IcsBundleKt.icsMessage("task.sync.title", new Object[0]), true){
                    final /* synthetic */ THashSet $toDelete;
                    final /* synthetic */ THashSet $toCheckout;
                    final /* synthetic */ List $newList;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        indicator.setIndeterminate(true);
                        Path root = IcsManagerKt.getIcsManager().getReadOnlySourcesManager().getRootDir();
                        Collection $receiver$iv = (Collection)this.$toDelete;
                        if (!$receiver$iv.isEmpty()) {
                            indicator.setText("Deleting old repositories");
                            for (String path : this.$toDelete) {
                                indicator.checkCanceled();
                                try {
                                    indicator.setText2(path);
                                    PathKt.deleteRecursively((Path)root.resolve(path));
                                }
                                catch (Exception e) {
                                    IcsManagerKt.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        $receiver$iv = (Collection)this.$toCheckout;
                        if (!$receiver$iv.isEmpty()) {
                            for (ReadonlySource source : this.$toCheckout) {
                                indicator.checkCanceled();
                                try {
                                    Path dir;
                                    StringBuilder stringBuilder = new StringBuilder().append("Cloning ");
                                    String string = source.getUrl();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    indicator.setText(stringBuilder.append(StringUtil.trimMiddle((String)string, (int)255)).toString());
                                    String string2 = source.getPath();
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    if (PathKt.exists((Path)(dir = root.resolve(string2)))) {
                                        PathKt.deleteRecursively((Path)dir);
                                    }
                                    String string3 = source.getUrl();
                                    if (string3 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Path path = dir;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir");
                                    NotNullLazyValue notNullLazyValue = (NotNullLazyValue)IcsManagerKt.getIcsManager().getCredentialsStore();
                                    ProgressMonitor progressMonitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressMonitor, (String)"indicator.asProgressMonitor()");
                                    GitExKt.cloneBare(string3, path, (NotNullLazyValue<CredentialsStore>)notNullLazyValue, progressMonitor).close();
                                }
                                catch (Exception e) {
                                    IcsManagerKt.getLOG().error((Throwable)e);
                                }
                            }
                        }
                        ReadOnlySourcesManager readOnlySourcesManager = IcsManagerKt.getIcsManager().getReadOnlySourcesManager();
                        List list = this.$newList;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"newList");
                        readOnlySourcesManager.setSources(list);
                    }
                    {
                        this.$toDelete = $captured_local_variable$0;
                        this.$toCheckout = $captured_local_variable$1;
                        this.$newList = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                    }
                });
            }

            public void reset(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                this.$editor.reset(settings.getReadOnlySources());
            }

            @NotNull
            public JComponent getComponent() {
                return this.$editor.createComponent();
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        };
    }

    static {
        TableModelEditor.EditableColumnInfo[] elements$iv = new TableModelEditor.EditableColumnInfo[]{(TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, Boolean>(){

            @NotNull
            public Class<Boolean> getColumnClass() {
                return Boolean.TYPE;
            }

            @NotNull
            public Boolean valueOf(@NotNull ReadonlySource item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return item.getActive();
            }

            public void setValue(@NotNull ReadonlySource item, boolean value) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setActive(value);
            }
        }, (TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, String>(){

            @Nullable
            public String valueOf(@NotNull ReadonlySource item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return item.getUrl();
            }

            public void setValue(@NotNull ReadonlySource item, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                item.setUrl(value);
            }
        }};
        COLUMNS = (TableModelEditor.EditableColumnInfo[])((Object[])elements$iv);
    }
}

