/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingDecoratorWrapper;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.widgets.ImagePanel;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.futures.SingleInFlight;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class ImagePanelController
extends Controller {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ImagePanelController.class);
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    private final SingleInFlight myImageRequestController;
    @NotNull
    private final ImagePanel myImagePanel;

    public ImagePanelController(@NotNull GfxTraceEditor editor, String emptyText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ImagePanelController", "<init>"));
        }
        super(editor);
        this.myPanel = new JPanel(new BorderLayout());
        this.myImagePanel = new ImagePanel();
        this.myImagePanel.getEmptyText().setText(emptyText);
        LoadingDecorator loadingDecorator = new LoadingDecorator(this.myImagePanel, (Disposable)this.myEditor.getProject(), -1){

            protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
                NonOpaquePanel result = super.customizeLoadingLayer(parent, text, icon);
                result.setOpaque(true);
                result.setBackground(UIUtil.getPanelBackground());
                result.setBorder(JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)new JBColor(0, 0xFFFFFF), (int)1), (Border)JBUI.Borders.empty((int)5), (boolean)false));
                return result;
            }
        };
        this.myPanel.add((Component)loadingDecorator.getComponent(), "Center");
        this.myImageRequestController = new SingleInFlight((SingleInFlight.Listener)new LoadingDecoratorWrapper(loadingDecorator));
    }

    protected void initToolbar(DefaultActionGroup group, boolean enableVerticalFlip) {
        this.myImagePanel.addToolbarActions(group, enableVerticalFlip);
        this.myPanel.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false).getComponent(), "West");
    }

    protected void setEmptyText(String text) {
        this.myImagePanel.clearImage();
        this.myImagePanel.getEmptyText().setText(text);
    }

    protected void setImage(ListenableFuture<FetchedImage> imageFuture) {
        if (imageFuture == null) {
            this.myImagePanel.setImage(null);
            return;
        }
        Rpc.listen(imageFuture, (Logger)LOG, (FutureController)this.myImageRequestController, (Rpc.Callback)new UiErrorCallback<FetchedImage, BufferedImage, String>(){

            @Override
            protected UiErrorCallback.ResultOrError<BufferedImage, String> onRpcThread(Rpc.Result<FetchedImage> result) throws RpcException, ExecutionException {
                try {
                    return this.success(((FetchedImage)result.get()).image);
                }
                catch (ErrDataUnavailable e) {
                    return this.error(e.getMessage());
                }
            }

            @Override
            protected void onUiThreadSuccess(BufferedImage result) {
                ImagePanelController.this.myImagePanel.setImage(result);
            }

            @Override
            protected void onUiThreadError(String error) {
                ImagePanelController.this.setEmptyText(error);
            }
        });
    }
}

