/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.android.designer.propertyTable.JavadocParser;
import com.intellij.android.designer.propertyTable.editors.StringsComboEditor;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CenterProperty
extends Property<RadViewComponent>
implements IXmlAttributeLocator {
    private static final String[] COMBO_ITEMS = new String[]{"horizontal", "vertical", "both"};
    private static final String[] ATTR_ITEMS = new String[]{"layout_centerHorizontal", "layout_centerVertical", "layout_centerInParent"};
    private static final String JAVA_DOC = JavadocParser.build("layout:centerInParent", "Set centers this child horizontally or vertically within its parent.");
    private final PropertyRenderer myRenderer = new LabelPropertyRenderer(null);
    private final PropertyEditor myEditor = new StringsComboEditor(COMBO_ITEMS);

    public CenterProperty() {
        super(null, "layout:centerInParent");
        this.setImportant(true);
    }

    public Object getValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/layout/relative/CenterProperty", "getValue"));
        }
        XmlTag tag = component.getTag();
        boolean[] values = new boolean[3];
        for (int i = 0; i < ATTR_ITEMS.length; ++i) {
            values[i] = "true".equals(tag.getAttributeValue(ATTR_ITEMS[i], "http://schemas.android.com/apk/res/android"));
        }
        if (values[2] || values[0] && values[1]) {
            return COMBO_ITEMS[2];
        }
        if (values[0]) {
            return COMBO_ITEMS[0];
        }
        if (values[1]) {
            return COMBO_ITEMS[1];
        }
        return null;
    }

    public void setValue(final @NotNull RadViewComponent component, Object value) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/layout/relative/CenterProperty", "setValue"));
        }
        final int index = ArrayUtil.indexOf((Object[])COMBO_ITEMS, (Object)value);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XmlTag tag = component.getTag();
                for (int i = 0; i < ATTR_ITEMS.length; ++i) {
                    if (i == index) {
                        tag.setAttribute(ATTR_ITEMS[i], "http://schemas.android.com/apk/res/android", "true");
                        continue;
                    }
                    RadComponentOperations.deleteAttribute(tag, ATTR_ITEMS[i]);
                }
            }
        });
    }

    public boolean isDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/layout/relative/CenterProperty", "isDefaultValue"));
        }
        XmlTag tag = component.getTag();
        for (String attribute : ATTR_ITEMS) {
            if (tag.getAttribute(attribute, "http://schemas.android.com/apk/res/android") == null) continue;
            return false;
        }
        return true;
    }

    public void setDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/layout/relative/CenterProperty", "setDefaultValue"));
        }
        this.setValue(component, null);
    }

    public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/model/layout/relative/CenterProperty", "createForNewPresentation"));
        }
        return null;
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/relative/CenterProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return this.myEditor;
    }

    public String getJavadocText() {
        return JAVA_DOC;
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        XmlTag tag = component.getTag();
        for (String name : ATTR_ITEMS) {
            if (tag.getAttribute(name, "http://schemas.android.com/apk/res/android") != attribute) continue;
            return true;
        }
        return false;
    }
}

