/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.uiDesigner.GuiDesignerConfiguration;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.AbstractCreateFormAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public final class CreateDialogAction
extends AbstractCreateFormAction {
    private boolean myRecentGenerateOK;
    private boolean myRecentGenerateCancel;
    private boolean myRecentGenerateMain;

    public CreateDialogAction() {
        super(UIDesignerBundle.message("action.create.dialog", new Object[0]), UIDesignerBundle.message("action.description.create.dialog", new Object[0]), PlatformIcons.UI_FORM_ICON);
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        final AbstractCreateFormAction.JavaNameValidator validator = new AbstractCreateFormAction.JavaNameValidator(project, directory);
        final MyContentPane contentPane = new MyContentPane();
        DialogWrapper dialog = new DialogWrapper(project, true){
            {
                super(arg0, arg1);
                this.init();
                this.setTitle(UIDesignerBundle.message("title.new.dialog", new Object[0]));
            }

            protected JComponent createCenterPanel() {
                return contentPane.getPanel();
            }

            protected void doOKAction() {
                CreateDialogAction.this.myRecentGenerateOK = contentPane.myChkGenerateOK.isSelected();
                CreateDialogAction.this.myRecentGenerateCancel = contentPane.myChkGenerateCancel.isSelected();
                CreateDialogAction.this.myRecentGenerateMain = contentPane.myChkGenerateMain.isSelected();
                String inputString = contentPane.myTfClassName.getText().trim();
                if (validator.checkInput(inputString) && validator.canClose(inputString)) {
                    this.close(0);
                }
            }

            public JComponent getPreferredFocusedComponent() {
                return contentPane.myTfClassName;
            }
        };
        dialog.show();
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/actions/CreateDialogAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    protected String getCommandName() {
        return UIDesignerBundle.message("command.create.dialog", new Object[0]);
    }

    protected String getErrorTitle() {
        return UIDesignerBundle.message("error.cannot.create.dialog", new Object[0]);
    }

    private static String createClassBody(String className, boolean generateOK, boolean generateCancel, boolean generateMain) {
        StringBuffer result = new StringBuffer(1024);
        result.append("public class ").append(className).append(" extends javax.swing.JDialog {\n");
        result.append("private javax.swing.JPanel contentPane;\n");
        result.append("private javax.swing.JButton buttonOK;\n");
        result.append("private javax.swing.JButton buttonCancel;\n");
        result.append("\n");
        result.append("public ").append(className).append("(){\n");
        result.append("setContentPane(contentPane);\n");
        result.append("setModal(true);\n");
        result.append("getRootPane().setDefaultButton(buttonOK);\n");
        if (generateOK) {
            result.append("\n");
            result.append("buttonOK.addActionListener(");
            result.append("new java.awt.event.ActionListener(){");
            result.append("public void actionPerformed(java.awt.event.ActionEvent e){");
            result.append("onOK();");
            result.append("}});\n");
        }
        if (generateCancel) {
            result.append("\n");
            result.append("buttonCancel.addActionListener(");
            result.append("new java.awt.event.ActionListener(){");
            result.append("public void actionPerformed(java.awt.event.ActionEvent e){");
            result.append("onCancel();");
            result.append("}});\n");
            result.append("\n ");
            result.append(UIDesignerBundle.message("comment.call.onCancel.cross", new Object[0])).append("\n");
            result.append("setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);\n");
            result.append("addWindowListener(new java.awt.event.WindowAdapter() {\n");
            result.append("  public void windowClosing(java.awt.event.WindowEvent e) {\n");
            result.append("   onCancel();\n");
            result.append("  }\n");
            result.append("});\n");
            result.append("\n ");
            result.append(UIDesignerBundle.message("comment.call.onCancel.escape", new Object[0])).append("\n");
            result.append("contentPane.registerKeyboardAction(");
            result.append("  new java.awt.event.ActionListener() {");
            result.append("    public void actionPerformed(java.awt.event.ActionEvent e) {");
            result.append("      onCancel();\n");
            result.append("    }");
            result.append("  },");
            result.append("  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0),");
            result.append("  javax.swing.JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            result.append(");");
        }
        result.append("}\n");
        if (generateOK) {
            result.append("\n");
            result.append("private void onOK(){\n ");
            result.append(UIDesignerBundle.message("comment.onok", new Object[0])).append("\n");
            result.append("dispose();\n");
            result.append("}\n");
        }
        if (generateCancel) {
            result.append("\n");
            result.append("private void onCancel(){\n ");
            result.append(UIDesignerBundle.message("comment.oncancel", new Object[0])).append("\n");
            result.append("dispose();\n");
            result.append("}\n");
        }
        if (generateMain) {
            result.append("\n");
            result.append("public static void main(String[] args){\n");
            result.append(className).append(" dialog = new ").append(className).append("();\n");
            result.append("dialog.pack();\n");
            result.append("dialog.setVisible(true);\n");
            result.append("System.exit(0);\n");
            result.append("}\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws IncorrectOperationException {
        PsiFile sourceFile = PsiFileFactory.getInstance((Project)directory.getProject()).createFileFromText(newName + ".java", CreateDialogAction.createClassBody(newName, this.myRecentGenerateOK, this.myRecentGenerateCancel, this.myRecentGenerateMain));
        sourceFile = (PsiFile)directory.add((PsiElement)sourceFile);
        JavaCodeStyleManager.getInstance((Project)directory.getProject()).shortenClassReferences((PsiElement)sourceFile);
        CodeStyleManager.getInstance((Project)directory.getProject()).reformat((PsiElement)sourceFile);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String packageName = aPackage.getQualifiedName();
        String fqClassName = packageName.length() == 0 ? newName : packageName + "." + newName;
        String formBody = this.createFormBody(fqClassName, "/com/intellij/uiDesigner/NewDialog.xml", GuiDesignerConfiguration.getInstance((Project)directory.getProject()).DEFAULT_LAYOUT_MANAGER);
        PsiFile formFile = PsiFileFactory.getInstance((Project)directory.getProject()).createFileFromText(newName + ".form", formBody);
        PsiElement createdFile = directory.add((PsiElement)formFile);
        PsiClass[] classes = ((PsiJavaFile)sourceFile).getClasses();
        PsiElement[] psiElementArray = new PsiElement[]{createdFile, classes[0]};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/actions/CreateDialogAction", "create"));
        }
        return psiElementArray;
    }

    private static final class MyContentPane {
        private JPanel myPanel;
        private JCheckBox myChkGenerateCancel;
        private JCheckBox myChkGenerateOK;
        private JCheckBox myChkGenerateMain;
        private JTextField myTfClassName;

        public MyContentPane() {
            this.$$$setupUI$$$();
        }

        public JPanel getPanel() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JTextField jTextField;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("edit.dialog.class.name"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myTfClassName = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myChkGenerateMain = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.generate.main"));
            jCheckBox3.setSelected(true);
            jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myChkGenerateOK = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.generate.ok"));
            jCheckBox2.setSelected(true);
            jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myChkGenerateCancel = jCheckBox = new JCheckBox();
            jCheckBox.setFocusTraversalPolicyProvider(true);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("checkbox.generate.cancel"));
            jCheckBox.setSelected(true);
            jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

