/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmRuntimeTypes;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenUtil;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends KtVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{KtTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create((IElementType[])new IElementType[]{KtTokens.PLUS, KtTokens.MINUS, KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.RANGE, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.IDENTIFIER})});
    private final Map<String, Integer> anonymousSubclassesCount;
    private final Stack<ClassDescriptor> classStack;
    private final Stack<String> nameStack;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmRuntimeTypes runtimeTypes;
    private final JvmFileClassesProvider fileClassesProvider;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "<init>"));
        }
        this.anonymousSubclassesCount = new HashMap<String, Integer>();
        this.classStack = new Stack();
        this.nameStack = new Stack();
        this.bindingTrace = state.getBindingTrace();
        this.bindingContext = state.getBindingContext();
        this.filter = state.getGenerateDeclaredClassFilter();
        this.runtimeTypes = state.getJvmRuntimeTypes();
        this.fileClassesProvider = state.getFileClassesProvider();
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element2, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes2, @NotNull String name2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        String simpleName = name2.substring(name2.lastIndexOf(47) + 1);
        SyntheticClassDescriptorForLambda classDescriptor = new SyntheticClassDescriptorForLambda(this.correctContainerForLambda(callableDescriptor, element2), Name.special("<closure-" + simpleName + ">"), supertypes2, element2);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_CALLABLE, callableDescriptor, classDescriptor);
        SyntheticClassDescriptorForLambda syntheticClassDescriptorForLambda = classDescriptor;
        if (syntheticClassDescriptorForLambda == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClassForCallable"));
        }
        return syntheticClassDescriptorForLambda;
    }

    @NotNull
    private DeclarationDescriptor correctContainerForLambda(@NotNull CallableDescriptor descriptor2, @NotNull KtElement function2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(container2.getContainingDeclaration())) {
            KtElement element2 = function2;
            while (element2 != null) {
                KtElement child = element2;
                if (this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2 = element2.getParent()) == container2) {
                    DeclarationDescriptor declarationDescriptor = container2;
                    if (declarationDescriptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
                    }
                    return declarationDescriptor;
                }
                if (!(element2 instanceof KtObjectDeclaration) || !(element2.getParent() instanceof KtObjectLiteralExpression) || !(child instanceof KtSuperTypeList)) continue;
                container2 = container2.getContainingDeclaration().getContainingDeclaration();
            }
        }
        DeclarationDescriptor declarationDescriptor = container2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "correctContainerForLambda"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private String inventAnonymousClassName() {
        String top = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        String string = top + "$" + (cnt + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "inventAnonymousClassName"));
        }
        return string;
    }

    @Override
    public void visitKtElement(@NotNull KtElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitKtElement"));
        }
        super.visitKtElement(element2);
        element2.acceptChildren(this);
    }

    @Override
    public void visitScript(@NotNull KtScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitScript"));
        }
        this.classStack.push((Object)this.bindingContext.get(BindingContext.SCRIPT, script));
        this.nameStack.push((Object)AsmUtil.internalNameByFqNameWithoutInnerClasses(script.getFqName()));
        script.acceptChildren(this);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitKtFile(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitKtFile"));
        }
        this.nameStack.push((Object)AsmUtil.internalNameByFqNameWithoutInnerClasses(file.getPackageFqName()));
        file.acceptChildren(this);
        this.nameStack.pop();
    }

    @Override
    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitEnumEntry"));
        }
        if (enumEntry.getDeclarations().isEmpty()) {
            for (KtSuperTypeListEntry specifier : enumEntry.getSuperTypeListEntries()) {
                specifier.accept(this);
            }
            return;
        }
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        if (descriptor2 == null) {
            return;
        }
        this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor2);
        super.visitEnumEntry(enumEntry);
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitObjectDeclaration"));
        }
        if (!this.filter.shouldAnnotateClass(declaration)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (classDescriptor == null) {
            return;
        }
        String name2 = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name2);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name2);
        super.visitObjectDeclaration(declaration);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitClass"));
        }
        if (!this.filter.shouldAnnotateClass(klass)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass);
        if (classDescriptor == null) {
            return;
        }
        String name2 = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name2);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name2);
        super.visitClass(klass);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Name descriptorName = SpecialNames.safeIdentifier(classDescriptor.getName());
        return DescriptorUtils.isTopLevelDeclaration(classDescriptor) ? (base.isEmpty() ? descriptorName.asString() : base + '/' + descriptorName) : base + '$' + descriptorName;
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitObjectLiteralExpression"));
        }
        KtObjectDeclaration object = expression2.getObjectDeclaration();
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, object);
        if (classDescriptor == null) {
            super.visitObjectLiteralExpression(expression2);
            return;
        }
        String name2 = this.inventAnonymousClassName();
        this.recordClosure(classDescriptor, name2);
        KtSuperTypeList delegationSpecifierList = object.getSuperTypeList();
        if (delegationSpecifierList != null) {
            delegationSpecifierList.accept(this);
        }
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)CodegenBinding.getAsmType(this.bindingContext, classDescriptor).getInternalName());
        KtClassBody body2 = object.getBody();
        if (body2 != null) {
            super.visitClassBody(body2);
        }
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitLambdaExpression"));
        }
        KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
        if (functionDescriptor == null) {
            return;
        }
        String name2 = this.inventAnonymousClassName();
        Collection<KotlinType> supertypes2 = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
        ClassDescriptor classDescriptor = this.recordClassForCallable(functionLiteral, functionDescriptor, supertypes2, name2);
        this.recordClosure(classDescriptor, name2);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name2);
        super.visitLambdaExpression(lambdaExpression);
        this.nameStack.pop();
        this.classStack.pop();
    }

    @Override
    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
        Collection<KotlinType> supertypes2;
        CallableDescriptor callableDescriptor;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitCallableReferenceExpression"));
        }
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCall(expression2.getCallableReference(), this.bindingContext);
        if (referencedFunction == null) {
            return;
        }
        CallableDescriptor target = referencedFunction.getResultingDescriptor();
        if (target instanceof FunctionDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = this.runtimeTypes.getSupertypesForFunctionReference((FunctionDescriptor)target);
        } else if (target instanceof PropertyDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes2 = Collections.singleton(this.runtimeTypes.getSupertypeForPropertyReference((PropertyDescriptor)target));
        } else {
            return;
        }
        String name2 = this.inventAnonymousClassName();
        ClassDescriptor classDescriptor = this.recordClassForCallable(expression2, callableDescriptor, supertypes2, name2);
        this.recordClosure(classDescriptor, name2);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name2);
        super.visitCallableReferenceExpression(expression2);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private void recordClosure(@NotNull ClassDescriptor classDescriptor, @NotNull String name2) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        CodegenBinding.recordClosure(this.bindingTrace, classDescriptor, CodegenAnnotatingVisitor.peekFromStack(this.classStack), Type.getObjectType((String)name2), this.fileClassesProvider);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitProperty"));
        }
        DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
        if (descriptor2 == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(descriptor2);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
        } else {
            this.nameStack.push((Object)(CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + '$' + SpecialNames.safeIdentifier(property2.getNameAsSafeName()).asString()));
        }
        KtPropertyDelegate delegate2 = property2.getDelegate();
        if (delegate2 != null && descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            String name2 = this.inventAnonymousClassName();
            KotlinType supertype = this.runtimeTypes.getSupertypeForPropertyReference(propertyDescriptor);
            ClassDescriptor classDescriptor = this.recordClassForCallable(delegate2, propertyDescriptor, Collections.singleton(supertype), name2);
            this.recordClosure(classDescriptor, name2);
        }
        super.visitProperty(property2);
        this.nameStack.pop();
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
        if (functionDescriptor == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
            super.visitNamedFunction(function2);
            this.nameStack.pop();
        } else {
            String name2 = this.inventAnonymousClassName();
            Collection<KotlinType> supertypes2 = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
            ClassDescriptor classDescriptor = this.recordClassForCallable(function2, functionDescriptor, supertypes2, name2);
            this.recordClosure(classDescriptor, name2);
            this.classStack.push((Object)classDescriptor);
            this.nameStack.push((Object)name2);
            super.visitNamedFunction(function2);
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getNameForClassOrPackageMember"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        String peek = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        String name2 = SpecialNames.safeIdentifier(descriptor2.getName()).asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name2;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
            assert (containingFile != null) : "File not found for " + descriptor2;
            return FileClasses.getFileClassInternalName(this.fileClassesProvider, containingFile) + '$' + name2;
        }
        return null;
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitCallExpression"));
        }
        super.visitCallExpression(expression2);
        this.checkSamCall(expression2);
    }

    private void checkSamCall(@NotNull KtCallElement expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "checkSamCall"));
        }
        ResolvedCall<? extends CallableDescriptor> call = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (call == null) {
            return;
        }
        CallableDescriptor descriptor2 = call.getResultingDescriptor();
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        this.recordSamConstructorIfNeeded(expression2, call);
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor2);
        if (original == null) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call.getValueArgumentsByIndex();
        if (valueArguments2 == null) {
            return;
        }
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments2.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
        }
    }

    @Override
    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitSuperTypeCallEntry"));
        }
        super.visitSuperTypeCallEntry(call);
        this.checkSamCall(call);
    }

    private void recordSamConstructorIfNeeded(@NotNull KtCallElement expression2, @NotNull ResolvedCall<?> call) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordSamConstructorIfNeeded"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "recordSamConstructorIfNeeded"));
        }
        Object callableDescriptor = call.getResultingDescriptor();
        if (!(callableDescriptor.getOriginal() instanceof SamConstructorDescriptor)) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call.getValueArgumentsByIndex();
        if (valueArguments2 == null || valueArguments2.size() != 1) {
            return;
        }
        ResolvedValueArgument valueArgument = valueArguments2.get(0);
        if (!(valueArgument instanceof ExpressionValueArgument)) {
            return;
        }
        ValueArgument argument2 = ((ExpressionValueArgument)valueArgument).getValueArgument();
        if (argument2 == null) {
            return;
        }
        KtExpression argumentExpression = argument2.getArgumentExpression();
        this.bindingTrace.record(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2, argumentExpression);
        SamType samType = SamType.create(callableDescriptor.getReturnType());
        this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitBinaryExpression"));
        }
        super.visitBinaryExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        SamType samType = SamType.create(original.getValueParameters().get(0).getType());
        if (samType == null) {
            return;
        }
        IElementType token = expression2.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getRight(), samType);
        } else if (token == KtTokens.IN_KEYWORD || token == KtTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getLeft(), samType);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitArrayAccessExpression"));
        }
        super.visitArrayAccessExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List<KtExpression> indexExpressions = expression2.getIndexExpressions();
        List<ValueParameterDescriptor> parameters2 = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters2) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters2.size() - 1) {
                PsiElement parent2 = expression2.getParent();
                if (!(parent2 instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.EQ) continue;
                KtExpression right = ((KtBinaryExpression)parent2).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            KtExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "visitWhenExpression"));
        }
        super.visitWhenExpression(expression2);
        if (!this.isWhenWithEnums(expression2)) {
            return;
        }
        String currentClassName = this.getCurrentTopLevelClassOrPackagePartInternalName(expression2.getContainingKtFile());
        if (this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName) == null) {
            this.bindingTrace.record(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName, new ArrayList(1));
        }
        List<WhenByEnumsMapping> mappings = this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName);
        assert (mappings != null) : "guaranteed by contract";
        int fieldNumber = mappings.size();
        assert (expression2.getSubjectExpression() != null) : "subject expression should be not null in a valid when by enums";
        KotlinType type2 = this.bindingContext.getType(expression2.getSubjectExpression());
        assert (type2 != null) : "should not be null in a valid when by enums";
        ClassDescriptor classDescriptor = (ClassDescriptor)type2.getConstructor().getDeclarationDescriptor();
        assert (classDescriptor != null) : "because it's enum";
        WhenByEnumsMapping mapping = new WhenByEnumsMapping(classDescriptor, currentClassName, fieldNumber);
        for (ConstantValue<?> constant : SwitchCodegenUtil.getAllConstants(expression2, this.bindingContext)) {
            if (constant instanceof NullValue) continue;
            assert (constant instanceof EnumValue) : "expression in when should be EnumValue";
            mapping.putFirstTime((EnumValue)constant, mapping.size() + 1);
        }
        mappings.add(mapping);
        this.bindingTrace.record(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression2, mapping);
    }

    private boolean isWhenWithEnums(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "isWhenWithEnums"));
        }
        return WhenChecker.isWhenByEnum(expression2, this.bindingContext) && SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression2, this.bindingContext, new Function1<ConstantValue<?>, Boolean>(){

            public Boolean invoke(@NotNull ConstantValue<?> constant) {
                if (constant == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor$1", "invoke"));
                }
                return constant instanceof EnumValue || constant instanceof NullValue;
            }
        });
    }

    @NotNull
    private String getCurrentTopLevelClassOrPackagePartInternalName(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptor previous = (ClassDescriptor)iterator2.previous();
            if (!DescriptorUtils.isTopLevelOrInnerClass(previous)) continue;
            String string = CodegenBinding.getAsmType(this.bindingContext, previous).getInternalName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
            }
            return string;
        }
        String string = FileClasses.getFacadeClassInternalName(this.fileClassesProvider, file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        return string;
    }

    private static <T> T peekFromStack(@NotNull Stack<T> stack) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor", "peekFromStack"));
        }
        return (T)(stack.empty() ? null : stack.peek());
    }
}

