/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5;

import java.util.List;
import org.junit.gen5.engine.EngineDiscoveryRequest;
import org.junit.gen5.engine.FilterResult;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.discovery.ClassFilter;
import org.junit.gen5.engine.junit5.descriptor.ClassTestDescriptor;
import org.junit.gen5.engine.junit5.descriptor.NestedClassTestDescriptor;

class DiscoveryFilterApplier {
    DiscoveryFilterApplier() {
    }

    void applyAllFilters(EngineDiscoveryRequest discoveryRequest, TestDescriptor engineDescriptor) {
        this.applyClassFilters(discoveryRequest.getDiscoveryFiltersByType(ClassFilter.class), engineDescriptor);
    }

    private void applyClassFilters(List<ClassFilter> classFilters, TestDescriptor engineDescriptor) {
        if (classFilters.isEmpty()) {
            return;
        }
        TestDescriptor.Visitor filteringVisitor = (descriptor, remove) -> {
            if (descriptor instanceof ClassTestDescriptor && !this.includeClass((ClassTestDescriptor)descriptor, classFilters)) {
                remove.run();
            }
        };
        engineDescriptor.accept(filteringVisitor);
    }

    private boolean includeClass(ClassTestDescriptor classTestDescriptor, List<ClassFilter> classFilters) {
        if (classTestDescriptor instanceof NestedClassTestDescriptor) {
            return true;
        }
        Class<?> testClass = classTestDescriptor.getTestClass();
        return classFilters.stream().map(filter -> filter.filter((Object)testClass)).noneMatch(FilterResult::excluded);
    }
}

