/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.discovery;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.gen5.commons.util.PreconditionViolationException;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.commons.util.StringUtils;
import org.junit.gen5.engine.junit5.discovery.IsNestedTestClass;
import org.junit.gen5.engine.junit5.discovery.IsPotentialTestContainer;
import org.junit.gen5.engine.junit5.discovery.IsTestMethod;
import org.junit.gen5.engine.junit5.discovery.JUnit5Class;
import org.junit.gen5.engine.junit5.discovery.JUnit5Method;
import org.junit.gen5.engine.junit5.discovery.JUnit5NestedClass;
import org.junit.gen5.engine.junit5.discovery.JUnit5Testable;

class JUnit5TestableFactory {
    private static final String SEPARATORS = ":@#";
    private static final IsPotentialTestContainer isPotentialTestContainer = new IsPotentialTestContainer();
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();
    private static final IsTestMethod isTestMethod = new IsTestMethod();

    JUnit5TestableFactory() {
    }

    JUnit5Testable fromUniqueId(String uniqueId, String engineId) {
        Preconditions.notBlank((String)uniqueId, (String)"Unique ID must not be null or empty");
        List<String> parts = this.split(uniqueId);
        Preconditions.condition((boolean)parts.remove(0).equals(engineId), (String)"uniqueId must start with engineId");
        return this.createTestable(uniqueId, engineId, parts, null);
    }

    JUnit5Testable fromClass(Class<?> clazz, String engineId) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        Preconditions.notBlank((String)engineId, (String)"Engine ID must not be null or empty");
        if (isPotentialTestContainer.test(clazz)) {
            String uniqueId = engineId + ":" + clazz.getName();
            return new JUnit5Class(uniqueId, clazz);
        }
        if (isNestedTestClass.test(clazz)) {
            return this.createNestedClassTestable(clazz, clazz.getEnclosingClass(), engineId);
        }
        this.throwCannotResolveClassException(clazz);
        return null;
    }

    private JUnit5Testable createNestedClassTestable(Class<?> testClass, Class<?> container, String engineId) {
        String uniqueId = this.fromClass(container, engineId).getUniqueId() + "@" + testClass.getSimpleName();
        return new JUnit5NestedClass(uniqueId, testClass, container);
    }

    JUnit5Testable fromMethod(Method testMethod, Class<?> clazz, String engineId) {
        if (!isTestMethod.test(testMethod)) {
            JUnit5TestableFactory.throwCannotResolveMethodException(testMethod);
        }
        String uniqueId = String.format("%s#%s(%s)", this.fromClass(clazz, engineId).getUniqueId(), testMethod.getName(), StringUtils.nullSafeToString((Class[])testMethod.getParameterTypes()));
        return new JUnit5Method(uniqueId, testMethod, clazz);
    }

    private List<String> split(String uniqueId) {
        ArrayList<String> parts = new ArrayList<String>();
        String currentPart = "";
        for (char c : uniqueId.toCharArray()) {
            if (SEPARATORS.contains(Character.toString(c))) {
                parts.add(currentPart);
                currentPart = "";
            }
            currentPart = currentPart + c;
        }
        parts.add(currentPart);
        return parts;
    }

    private JUnit5Testable createTestable(String uniqueId, String engineId, List<String> parts, JUnit5Testable last) {
        if (parts.isEmpty()) {
            return last;
        }
        JUnit5Testable next = null;
        String head = parts.remove(0);
        switch (head.charAt(0)) {
            case ':': {
                next = this.fromClass(this.findTopLevelClass(head), engineId);
                break;
            }
            case '@': {
                Class<?> container = ((JUnit5Class)last).getJavaClass();
                next = this.fromClass(this.findNestedClass(head, container), engineId);
                break;
            }
            case '#': {
                Class<?> container = ((JUnit5Class)last).getJavaClass();
                next = this.fromMethod(this.findMethod(head, container, uniqueId), container, engineId);
                break;
            }
            default: {
                throw JUnit5TestableFactory.createCannotResolveUniqueIdException(uniqueId, head);
            }
        }
        return this.createTestable(uniqueId, engineId, parts, next);
    }

    private Method findMethod(String methodSpecPart, Class<?> clazz, String uniqueId) {
        int startParams = methodSpecPart.indexOf(40);
        String methodName = methodSpecPart.substring(1, startParams);
        int endParams = methodSpecPart.lastIndexOf(41);
        String paramsPart = methodSpecPart.substring(startParams + 1, endParams);
        Class<?>[] parameterTypes = this.resolveParameterTypes(paramsPart, uniqueId);
        return this.findMethod(clazz, methodName, parameterTypes);
    }

    private Class<?>[] resolveParameterTypes(String paramsPart, String uniqueId) {
        if (paramsPart.isEmpty()) {
            return new Class[0];
        }
        List<Class> types = Arrays.stream(paramsPart.split(",")).map(className -> this.loadRequiredClass((String)className, uniqueId, paramsPart)).collect(Collectors.toList());
        return types.toArray(new Class[types.size()]);
    }

    private Method findMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        return (Method)ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])parameterTypes).orElseThrow(() -> new PreconditionViolationException(String.format("No method with name '%s' and parameter types '%s'", methodName, StringUtils.nullSafeToString((Class[])parameterTypes))));
    }

    private Class<?> findNestedClass(String nameExtension, Class<?> containerClass) {
        return this.classByName(containerClass.getName() + "$" + nameExtension.substring(1));
    }

    private Class<?> findTopLevelClass(String classNamePart) {
        return this.loadClassByName(classNamePart.substring(1));
    }

    private Class<?> classByName(String className) {
        return (Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> new PreconditionViolationException(String.format("Cannot resolve class name '%s'", className)));
    }

    private Class<?> loadClassByName(String className) {
        return (Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> new PreconditionViolationException(String.format("Cannot load class '%s'", className)));
    }

    private Class<?> loadRequiredClass(String className, String fullUniqueId, String uniqueIdPart) {
        return (Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> JUnit5TestableFactory.createCannotResolveUniqueIdException(fullUniqueId, uniqueIdPart));
    }

    private static RuntimeException createCannotResolveUniqueIdException(String fullUniqueId, String uniqueIdPart) {
        return new PreconditionViolationException(String.format("Cannot resolve part '%s' of unique ID '%s'", uniqueIdPart, fullUniqueId));
    }

    private static void throwCannotResolveMethodException(Method method) {
        throw new PreconditionViolationException(String.format("Method '%s' is not a test method.", method.getName()));
    }

    private void throwCannotResolveClassException(Class<?> clazz) {
        throw new PreconditionViolationException(String.format("Cannot resolve class name '%s' because it's not a test container", clazz.getName()));
    }
}

