/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.execution;

import org.junit.gen5.api.extension.ExtensionContext;
import org.junit.gen5.commons.JUnitException;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.junit5.execution.TestInstanceProvider;
import org.junit.gen5.engine.junit5.extension.ExtensionRegistry;
import org.junit.gen5.engine.support.hierarchical.EngineExecutionContext;

@API(value=API.Usage.Internal)
public class JUnit5EngineExecutionContext
implements EngineExecutionContext {
    private final State state;

    public JUnit5EngineExecutionContext(EngineExecutionListener executionListener) {
        this(new State(executionListener));
    }

    private JUnit5EngineExecutionContext(State state) {
        this.state = state;
    }

    public EngineExecutionListener getExecutionListener() {
        return this.state.executionListener;
    }

    public TestInstanceProvider getTestInstanceProvider() {
        return this.state.testInstanceProvider;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.state.extensionRegistry;
    }

    public ExtensionContext getExtensionContext() {
        return this.state.extensionContext;
    }

    public Builder extend() {
        return JUnit5EngineExecutionContext.builder(this);
    }

    public static Builder builder(JUnit5EngineExecutionContext context) {
        return new Builder(context.state, null);
    }

    public static class Builder {
        private State originalState;
        private State newState;

        private Builder(State originalState, State state) {
            this.originalState = originalState;
            this.newState = state;
        }

        public Builder withTestInstanceProvider(TestInstanceProvider testInstanceProvider) {
            this.newState().testInstanceProvider = testInstanceProvider;
            return this;
        }

        public Builder withExtensionRegistry(ExtensionRegistry extensionRegistry) {
            this.newState().extensionRegistry = extensionRegistry;
            return this;
        }

        public Builder withExtensionContext(ExtensionContext extensionContext) {
            this.newState().extensionContext = extensionContext;
            return this;
        }

        public JUnit5EngineExecutionContext build() {
            if (this.newState != null) {
                this.originalState = this.newState;
                this.newState = null;
            }
            return new JUnit5EngineExecutionContext(this.originalState);
        }

        private State newState() {
            if (this.newState == null) {
                this.newState = this.originalState.clone();
            }
            return this.newState;
        }
    }

    private static final class State
    implements Cloneable {
        final EngineExecutionListener executionListener;
        TestInstanceProvider testInstanceProvider;
        ExtensionRegistry extensionRegistry;
        ExtensionContext extensionContext;

        public State(EngineExecutionListener executionListener) {
            this.executionListener = executionListener;
        }

        public State clone() {
            try {
                return (State)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JUnitException("State could not be cloned", (Throwable)e);
            }
        }
    }
}

