/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.extension;

import java.lang.reflect.Parameter;
import org.junit.gen5.api.TestInfo;
import org.junit.gen5.api.extension.ExtensionContext;
import org.junit.gen5.api.extension.MethodInvocationContext;
import org.junit.gen5.api.extension.MethodParameterResolver;
import org.junit.gen5.commons.util.ToStringBuilder;

class TestInfoParameterResolver
implements MethodParameterResolver {
    TestInfoParameterResolver() {
    }

    public boolean supports(Parameter parameter, MethodInvocationContext methodInvocationContext, ExtensionContext extensionContext) {
        return parameter.getType() == TestInfo.class;
    }

    public TestInfo resolve(Parameter parameter, MethodInvocationContext methodInvocationContext, ExtensionContext extensionContext) {
        return new DefaultTestInfo(extensionContext.getName(), extensionContext.getDisplayName());
    }

    private static class DefaultTestInfo
    implements TestInfo {
        private final String name;
        private final String displayName;

        DefaultTestInfo(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("displayName", (Object)this.displayName).toString();
        }
    }
}

