/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public class HgStatusCommand {
    private static final Logger LOG = Logger.getInstance((String)HgStatusCommand.class.getName());
    private static final int ITEM_COUNT = 3;
    private static final int STATUS_INDEX = 0;
    @NotNull
    private final Project myProject;
    private final boolean myIncludeAdded;
    private final boolean myIncludeModified;
    private final boolean myIncludeRemoved;
    private final boolean myIncludeDeleted;
    private final boolean myIncludeUnknown;
    private final boolean myIncludeIgnored;
    private final boolean myIncludeCopySource;
    private boolean myCleanStatus;
    @Nullable
    private final HgRevisionNumber myBaseRevision;
    @Nullable
    private final HgRevisionNumber myTargetRevision;

    public void cleanFilesOption(boolean clean) {
        this.myCleanStatus = clean;
    }

    private HgStatusCommand(@NotNull Project project, @NotNull Builder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgStatusCommand", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/zmlx/hg4idea/command/HgStatusCommand", "<init>"));
        }
        this.myCleanStatus = false;
        this.myProject = project;
        this.myIncludeAdded = builder.includeAdded;
        this.myIncludeModified = builder.includeModified;
        this.myIncludeRemoved = builder.includeRemoved;
        this.myIncludeDeleted = builder.includeDeleted;
        this.myIncludeUnknown = builder.includeUnknown;
        this.myIncludeIgnored = builder.includeIgnored;
        this.myIncludeCopySource = builder.includeCopySource;
        this.myBaseRevision = builder.baseRevision;
        this.myTargetRevision = builder.targetRevision;
    }

    public Set<HgChange> executeInCurrentThread(VirtualFile repo) {
        return this.executeInCurrentThread(repo, null);
    }

    public Set<HgChange> executeInCurrentThread(VirtualFile repo, @Nullable Collection<FilePath> paths) {
        if (repo == null) {
            return Collections.emptySet();
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(true);
        LinkedList<String> options = new LinkedList<String>();
        if (this.myIncludeAdded) {
            options.add("--added");
        }
        if (this.myIncludeModified) {
            options.add("--modified");
        }
        if (this.myIncludeRemoved) {
            options.add("--removed");
        }
        if (this.myIncludeDeleted) {
            options.add("--deleted");
        }
        if (this.myIncludeUnknown) {
            options.add("--unknown");
        }
        if (this.myIncludeIgnored) {
            options.add("--ignored");
        }
        if (this.myIncludeCopySource) {
            options.add("--copies");
        }
        if (this.myCleanStatus) {
            options.add("--clean");
        }
        if (!(this.myBaseRevision == null || this.myBaseRevision.getRevision().isEmpty() && this.myBaseRevision.getChangeset().isEmpty())) {
            options.add("--rev");
            options.add(StringUtil.isEmptyOrSpaces((String)this.myBaseRevision.getChangeset()) ? this.myBaseRevision.getRevision() : this.myBaseRevision.getChangeset());
            if (this.myTargetRevision != null) {
                options.add("--rev");
                options.add(this.myTargetRevision.getChangeset());
            }
        }
        HashSet<HgChange> changes = new HashSet<HgChange>();
        if (paths != null) {
            List chunked = VcsFileUtil.chunkPaths((VirtualFile)repo, paths);
            for (List chunk : chunked) {
                ArrayList<String> args = new ArrayList<String>();
                args.addAll(options);
                args.addAll(chunk);
                HgCommandResult result = executor.executeInCurrentThread(repo, "status", args);
                changes.addAll(this.parseChangesFromResult(repo, result, args));
            }
        } else {
            HgCommandResult result = executor.executeInCurrentThread(repo, "status", options);
            changes.addAll(this.parseChangesFromResult(repo, result, options));
        }
        return changes;
    }

    private Collection<HgChange> parseChangesFromResult(VirtualFile repo, HgCommandResult result, List<String> args) {
        HashSet<HgChange> changes = new HashSet<HgChange>();
        HgChange previous = null;
        if (result == null) {
            return changes;
        }
        List<String> errors = result.getErrorLines();
        if (errors != null && !errors.isEmpty()) {
            if (result.getExitValue() != 0 && !this.myProject.isDisposed()) {
                String title = "Could not execute hg status command ";
                LOG.warn(title + errors.toString());
                VcsNotifier.getInstance((Project)this.myProject).logInfo(title, errors.toString());
                return changes;
            }
            LOG.warn(errors.toString());
        }
        for (String line : result.getOutputLines()) {
            if (StringUtil.isEmptyOrSpaces((String)line) || line.length() < 3) {
                LOG.warn("Unexpected line in status '" + line + '\'');
                continue;
            }
            char statusChar = line.charAt(0);
            HgFileStatusEnum status = HgFileStatusEnum.parse(statusChar);
            if (status == null) {
                LOG.error("Unknown status [" + statusChar + "] in line [" + line + "]" + "\n with arguments " + args);
                continue;
            }
            File ioFile = new File(repo.getPath(), line.substring(2));
            if (HgFileStatusEnum.COPY == status && previous != null && previous.getStatus() == HgFileStatusEnum.ADDED) {
                previous.setStatus(HgFileStatusEnum.COPY);
                previous.setBeforeFile(new HgFile(repo, ioFile));
                previous = null;
                continue;
            }
            previous = new HgChange(new HgFile(repo, ioFile), status);
            changes.add(previous);
        }
        return changes;
    }

    @NotNull
    public Collection<VirtualFile> getHgUntrackedFiles(@NotNull VirtualFile repo, @NotNull List<VirtualFile> files) throws VcsException {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgStatusCommand", "getHgUntrackedFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/zmlx/hg4idea/command/HgStatusCommand", "getHgUntrackedFiles"));
        }
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        List filePaths = ObjectsConvertor.vf2fp(files);
        Set<HgChange> change = this.executeInCurrentThread(repo, filePaths);
        for (HgChange hgChange : change) {
            untrackedFiles.add(hgChange.afterFile().toFilePath().getVirtualFile());
        }
        HashSet<VirtualFile> hashSet = untrackedFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgStatusCommand", "getHgUntrackedFiles"));
        }
        return hashSet;
    }

    public static class Builder {
        private boolean includeAdded;
        private boolean includeModified;
        private boolean includeRemoved;
        private boolean includeDeleted;
        private boolean includeUnknown;
        private boolean includeIgnored;
        private boolean includeCopySource;
        private HgRevisionNumber baseRevision;
        private HgRevisionNumber targetRevision;

        public Builder(boolean initValue) {
            this.includeAdded = initValue;
            this.includeModified = initValue;
            this.includeRemoved = initValue;
            this.includeDeleted = initValue;
            this.includeUnknown = initValue;
            this.includeIgnored = initValue;
            this.includeCopySource = initValue;
            this.baseRevision = null;
            this.targetRevision = null;
        }

        public Builder removed(boolean val) {
            this.includeRemoved = val;
            return this;
        }

        public Builder unknown(boolean val) {
            this.includeUnknown = val;
            return this;
        }

        public Builder ignored(boolean val) {
            this.includeIgnored = val;
            return this;
        }

        public Builder copySource(boolean val) {
            this.includeCopySource = val;
            return this;
        }

        public Builder baseRevision(HgRevisionNumber val) {
            this.baseRevision = val;
            return this;
        }

        public Builder targetRevision(HgRevisionNumber val) {
            this.targetRevision = val;
            return this;
        }

        public HgStatusCommand build(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgStatusCommand$Builder", "build"));
            }
            return new HgStatusCommand(project, this);
        }
    }
}

