/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.update.SvnRevisionPanel;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class CreateBranchOrTagDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.dialogs.CopyDialog");
    private final File mySrcFile;
    private String mySrcURL;
    private final Project myProject;
    private String myURL;
    private TextFieldWithBrowseButton myToURLText;
    private JTextArea myCommentText;
    private JPanel myTopPanel;
    private JRadioButton myWorkingCopyRadioButton;
    private JRadioButton myRepositoryRadioButton;
    private TextFieldWithBrowseButton myWorkingCopyField;
    private TextFieldWithBrowseButton myRepositoryField;
    private SvnRevisionPanel myRevisionPanel;
    private ComboboxWithBrowseButton myBranchTagBaseComboBox;
    private JTextField myBranchTextField;
    private JRadioButton myBranchOrTagRadioButton;
    private JRadioButton myAnyLocationRadioButton;
    private JButton myProjectButton;
    private JLabel myErrorLabel;
    private JLabel myUseThisVariantToLabel;
    private JBCheckBox mySwitchOnCreate;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.branch";
    private SvnBranchConfigurationNew myBranchConfiguration;
    private final VirtualFile mySrcVirtualFile;
    private final String myWcRootUrl;

    public CreateBranchOrTagDialog(final Project project, boolean canBeParent, File file) throws VcsException {
        super(project, canBeParent);
        this.mySrcFile = file;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setResizable(true);
        this.setTitle(SvnBundle.message("dialog.title.branch", new Object[0]));
        this.getHelpAction().setEnabled(true);
        this.myUseThisVariantToLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)10));
        this.myProjectButton.setIcon(AllIcons.Nodes.IdeaProject);
        this.myBranchTagBaseComboBox.setPreferredSize(new Dimension(this.myBranchTagBaseComboBox.getPreferredSize().width, this.myWorkingCopyField.getPreferredSize().height));
        this.myWorkingCopyField.addBrowseFolderListener("Select Working Copy Location", "Select Location to Copy From:", project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myWorkingCopyField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateBranchOrTagDialog.this.updateControls();
            }
        });
        this.myRepositoryField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SVNURL url = SelectLocationDialog.selectLocation(project, CreateBranchOrTagDialog.this.mySrcURL);
                if (url != null) {
                    CreateBranchOrTagDialog.this.myRepositoryField.setText(url.toString());
                }
            }
        });
        this.myRepositoryField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateBranchOrTagDialog.this.updateToURL();
            }
        });
        this.myToURLText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = CreateBranchOrTagDialog.this.myToURLText.getText();
                String dstName = SVNPathUtil.tail((String)CreateBranchOrTagDialog.this.mySrcURL);
                dstName = SVNEncodingUtil.uriDecode((String)dstName);
                url = SelectLocationDialog.selectCopyDestination(CreateBranchOrTagDialog.this.myProject, SVNPathUtil.removeTail((String)url), SvnBundle.message("label.copy.select.location.dialog.copy.as", new Object[0]), dstName, false);
                if (url != null) {
                    CreateBranchOrTagDialog.this.myToURLText.setText(url);
                }
            }
        });
        RootUrlInfo root = SvnVcs.getInstance(this.myProject).getSvnFileUrlMapping().getWcRootForFilePath(file);
        if (root == null) {
            throw new VcsException("Can not find working copy for file: " + file.getPath());
        }
        VirtualFile srcVirtualFile = root.getVirtualFile();
        if (srcVirtualFile == null) {
            throw new VcsException("Can not find working copy for file: " + file.getPath());
        }
        this.mySrcVirtualFile = srcVirtualFile;
        this.myWcRootUrl = root.getUrl();
        this.myRevisionPanel.setRoot(this.mySrcVirtualFile);
        this.myRevisionPanel.setProject(this.myProject);
        this.myRevisionPanel.setUrlProvider(new SvnRevisionPanel.UrlProvider(){

            @Override
            public String getUrl() {
                return CreateBranchOrTagDialog.this.mySrcURL;
            }
        });
        this.updateBranchTagBases();
        this.myRevisionPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CreateBranchOrTagDialog.this.getOKAction().setEnabled(CreateBranchOrTagDialog.this.isOKActionEnabled());
            }
        });
        this.init();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateBranchOrTagDialog.this.updateControls();
            }
        };
        this.myWorkingCopyRadioButton.addActionListener(listener);
        this.myRepositoryRadioButton.addActionListener(listener);
        this.myBranchOrTagRadioButton.addActionListener(listener);
        this.myAnyLocationRadioButton.addActionListener(listener);
        this.updateControls();
        this.myBranchTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateBranchOrTagDialog.this.updateToURL();
            }
        });
        this.updateToURL();
        this.myProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateBranchOrTagDialog.this.myRepositoryField.setText(CreateBranchOrTagDialog.this.myWcRootUrl);
            }
        });
        this.myBranchTagBaseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchConfigurationDialog.configureBranches(project, CreateBranchOrTagDialog.this.mySrcVirtualFile);
                CreateBranchOrTagDialog.this.updateBranchTagBases();
                CreateBranchOrTagDialog.this.updateControls();
            }
        });
        this.myBranchTagBaseComboBox.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateBranchOrTagDialog.this.updateToURL();
                CreateBranchOrTagDialog.this.updateControls();
            }
        });
    }

    private void updateBranchTagBases() {
        this.myBranchConfiguration = SvnBranchConfigurationManager.getInstance(this.myProject).get(this.mySrcVirtualFile);
        String[] strings = ArrayUtil.toStringArray(this.myBranchConfiguration.getBranchUrls());
        this.myBranchTagBaseComboBox.getComboBox().setModel(new DefaultComboBoxModel<String>(strings));
    }

    private void updateToURL() {
        if (this.myBranchConfiguration == null) {
            return;
        }
        String relativeUrl = this.myWorkingCopyRadioButton.isSelected() ? this.myBranchConfiguration.getRelativeUrl(this.mySrcURL) : this.myBranchConfiguration.getRelativeUrl(this.myRepositoryField.getText());
        Object selectedBranch = this.myBranchTagBaseComboBox.getComboBox().getSelectedItem();
        if (relativeUrl != null && selectedBranch != null) {
            this.myToURLText.setText(selectedBranch.toString() + "/" + this.myBranchTextField.getText() + relativeUrl);
        }
    }

    private String getToURLTextFromBranch() {
        Object selectedBranch = this.myBranchTagBaseComboBox.getComboBox().getSelectedItem();
        if (selectedBranch != null) {
            return selectedBranch + "/" + this.myBranchTextField.getText();
        }
        return null;
    }

    private void updateControls() {
        this.myWorkingCopyField.setEnabled(this.myWorkingCopyRadioButton.isSelected());
        this.mySwitchOnCreate.setEnabled(this.myWorkingCopyRadioButton.isSelected());
        this.myRepositoryField.setEnabled(this.myRepositoryRadioButton.isSelected());
        this.myRevisionPanel.setEnabled(this.myRepositoryRadioButton.isSelected());
        this.myProjectButton.setEnabled(this.myRepositoryRadioButton.isSelected());
        this.myBranchTagBaseComboBox.setEnabled(this.myBranchOrTagRadioButton.isSelected());
        this.myBranchTextField.setEnabled(this.myBranchOrTagRadioButton.isSelected());
        this.myToURLText.setEnabled(this.myAnyLocationRadioButton.isSelected());
        this.myUseThisVariantToLabel.setForeground(this.myWorkingCopyRadioButton.isSelected() ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/CreateBranchOrTagDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected void init() {
        super.init();
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        String revStr = "";
        Info info = vcs.getInfo(this.mySrcFile);
        if (info != null) {
            this.mySrcURL = info.getURL() == null ? null : info.getURL().toString();
            revStr = String.valueOf(info.getRevision());
            this.myURL = this.mySrcURL;
        }
        if (this.myURL == null) {
            return;
        }
        this.myWorkingCopyField.setText(this.mySrcFile.toString());
        this.myRepositoryField.setText(this.mySrcURL);
        this.myToURLText.setText(this.myURL);
        this.myRevisionPanel.setRevisionText(revStr);
        this.updateControls();
        this.myWorkingCopyRadioButton.setSelected(true);
    }

    public String getComment() {
        return this.myCommentText.getText();
    }

    public SVNRevision getRevision() {
        if (this.myWorkingCopyRadioButton.isSelected()) {
            return SVNRevision.WORKING;
        }
        try {
            return this.myRevisionPanel.getRevision();
        }
        catch (ConfigurationException e) {
            return SVNRevision.UNDEFINED;
        }
    }

    public String getToURL() {
        if (this.myBranchOrTagRadioButton.isSelected()) {
            return this.getToURLTextFromBranch();
        }
        return this.myToURLText.getText();
    }

    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myToURLText;
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    protected String getDimensionServiceKey() {
        return "svn.copyDialog";
    }

    public boolean isOKActionEnabled() {
        this.myErrorLabel.setText(" ");
        if (this.myURL == null) {
            return false;
        }
        if (this.myBranchOrTagRadioButton.isSelected() && this.myBranchTagBaseComboBox.getComboBox().getSelectedItem() == null) {
            this.myErrorLabel.setText(SvnBundle.message("create.branch.no.base.location.error", new Object[0]));
            return false;
        }
        String url = this.getToURL();
        if (url != null && url.trim().length() > 0) {
            if (this.myRepositoryRadioButton.isSelected()) {
                SVNRevision revision;
                try {
                    revision = this.myRevisionPanel.getRevision();
                }
                catch (ConfigurationException e) {
                    revision = SVNRevision.UNDEFINED;
                }
                if (!revision.isValid() || revision.isLocal()) {
                    this.myErrorLabel.setText(SvnBundle.message("create.branch.invalid.revision.error", this.myRevisionPanel.getRevisionText()));
                    return false;
                }
                return true;
            }
            if (this.myWorkingCopyRadioButton.isSelected()) {
                String srcUrl;
                Info info = SvnVcs.getInstance(this.myProject).getInfo(this.mySrcFile);
                String string = srcUrl = info != null && info.getURL() != null ? info.getURL().toString() : null;
                if (srcUrl == null) {
                    this.myErrorLabel.setText(SvnBundle.message("create.branch.no.working.copy.error", this.myWorkingCopyField.getText()));
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCopyFromWorkingCopy() {
        return this.myWorkingCopyRadioButton.isSelected();
    }

    public String getCopyFromPath() {
        return this.myWorkingCopyField.getText();
    }

    public String getCopyFromUrl() {
        return this.myRepositoryField.getText();
    }

    public boolean isSwitchOnCreate() {
        return this.mySwitchOnCreate.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JLabel jLabel2;
        JButton jButton;
        SvnRevisionPanel svnRevisionPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton3;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JRadioButton jRadioButton4;
        JTextArea jTextArea;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JBScrollPane jBScrollPane = new JBScrollPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jBScrollPane, gridBagConstraints);
        this.myCommentText = jTextArea = new JTextArea();
        jTextArea.setColumns(25);
        jTextArea.setRows(4);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jBScrollPane.setViewportView(jTextArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.fill = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Copy From", (int)0, (int)0, null, null));
        this.myWorkingCopyRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Working Copy");
        jRadioButton4.setMnemonic('W');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jRadioButton4.setSelected(true);
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myWorkingCopyField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 0, 1, 4, 0, 3, 6, 0, null, null, null, 2));
        this.myRepositoryRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Repository Location:");
        jRadioButton3.setMnemonic('R');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRepositoryField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(5, 0, 1, 3, 0, 3, 6, 0, null, null, null, 2));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Revision:");
        jLabel3.setDisplayedMnemonic('V');
        jLabel3.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myRevisionPanel = svnRevisionPanel = new SvnRevisionPanel();
        JComponent jComponent = svnRevisionPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myProjectButton = jButton = new JButton();
        jButton.setText("");
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setToolTipText("Use project location");
        jPanel2.add((Component)jButton, new GridConstraints(5, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUseThisVariantToLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("dialog.create.branch.or.tag.from.working.copy.warning"));
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        this.mySwitchOnCreate = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("create.branch.switch.on.create.title"));
        jBCheckBox.setMargin(new Insets(0, -1, 2, 3));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.fill = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints3);
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Copy To", (int)0, (int)0, null, null));
        this.myToURLText = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 2, 8, 1, 6, 0, null, null, null, 2));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Base URL:");
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myBranchTagBaseComboBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel3.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Name:");
        jPanel3.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myBranchTextField = jTextField = new JTextField();
        jTextField.setText("new_branch");
        jTextField.setColumns(25);
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(90, -1), null));
        this.myBranchOrTagRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Branch or Tag");
        jRadioButton2.setSelected(true);
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAnyLocationRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Any Location");
        jPanel3.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        ((Component)jLabel).setForeground(Color.red);
        jLabel.setText(" ");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints4);
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.copy.comment"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.fill = 2;
        jPanel.add((Component)titledSeparator, gridBagConstraints5);
        jLabel4.setLabelFor((Component)comboboxWithBrowseButton);
        jLabel5.setLabelFor(jTextField);
        titledSeparator.setLabelFor((Component)jTextArea);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

