/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.proxy;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedProxyConfig {
    private static final File CONFIG_FILE = new File(PathManager.getConfigPath(), "proxy_config");
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private static final Key ENCRYPTION_KEY;

    public static boolean clear() {
        return FileUtil.delete((File)CONFIG_FILE);
    }

    @Nullable
    public static ProxyParameters load() {
        try {
            byte[] bytes = SharedProxyConfig.decrypt(FileUtil.loadFileBytes((File)CONFIG_FILE));
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(bytes));
            String password = props.getProperty(PASSWORD, "");
            return new ProxyParameters(props.getProperty(HOST, null), Integer.parseInt(props.getProperty(PORT, "0")), props.getProperty(LOGIN, null), password.toCharArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean store(@NotNull ProxyParameters params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/util/proxy/SharedProxyConfig", "store"));
        }
        if (params.host != null) {
            try {
                Properties props = new Properties();
                props.setProperty(HOST, params.host);
                props.setProperty(PORT, String.valueOf(params.port));
                if (params.login != null) {
                    props.setProperty(LOGIN, params.login);
                    props.setProperty(PASSWORD, new String(params.password));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                props.store(out, "Proxy Configuration");
                out.close();
                FileUtil.writeToFile((File)CONFIG_FILE, (byte[])SharedProxyConfig.encrypt(out.toByteArray()));
                return true;
            }
            catch (Exception exception) {}
        } else {
            FileUtil.delete((File)CONFIG_FILE);
        }
        return false;
    }

    private static byte[] encrypt(byte[] bytes) throws Exception {
        return SharedProxyConfig.encrypt(bytes, ENCRYPTION_KEY);
    }

    private static byte[] decrypt(byte[] bytes) throws Exception {
        return SharedProxyConfig.decrypt(bytes, ENCRYPTION_KEY);
    }

    private static byte[] encrypt(byte[] msgBytes, Key key) throws Exception {
        Cipher ciph = Cipher.getInstance("AES/CBC/PKCS5Padding");
        ciph.init(1, key);
        byte[] body = ciph.doFinal(msgBytes);
        byte[] iv = ciph.getIV();
        byte[] data = new byte[4 + iv.length + body.length];
        int length = body.length;
        data[0] = (byte)(length >> 24 & 0xFF);
        data[1] = (byte)(length >> 16 & 0xFF);
        data[2] = (byte)(length >> 8 & 0xFF);
        data[3] = (byte)(length & 0xFF);
        System.arraycopy(iv, 0, data, 4, iv.length);
        System.arraycopy(body, 0, data, 4 + iv.length, body.length);
        return data;
    }

    private static byte[] decrypt(byte[] data, Key key) throws Exception {
        int bodyLength = data[0] & 0xFF;
        bodyLength = (bodyLength << 8) + data[1] & 0xFF;
        bodyLength = (bodyLength << 8) + data[2] & 0xFF;
        bodyLength = (bodyLength << 8) + data[3] & 0xFF;
        int ivlength = data.length - 4 - bodyLength;
        Cipher ciph = Cipher.getInstance("AES/CBC/PKCS5Padding");
        ciph.init(2, key, new IvParameterSpec(data, 4, ivlength));
        return ciph.doFinal(data, 4 + ivlength, bodyLength);
    }

    static {
        byte[] bytes = new byte[16];
        new SecureRandom().nextBytes(bytes);
        ENCRYPTION_KEY = new SecretKeySpec(bytes, "AES");
    }

    public static final class ProxyParameters {
        @Nullable
        public final String host;
        public final int port;
        @Nullable
        public final String login;
        @NotNull
        public final char[] password;

        public ProxyParameters(@Nullable String host, int port) {
            this(host, port, null, new char[0]);
        }

        public ProxyParameters(@Nullable String host, int port, @Nullable String login, @NotNull char[] password) {
            if (password == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SharedProxyConfig.PASSWORD, "com/intellij/util/proxy/SharedProxyConfig$ProxyParameters", "<init>"));
            }
            this.host = host;
            this.port = port;
            this.login = login;
            this.password = password;
        }
    }
}

