/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.theoryinpractice.testng.model.TestClassFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.Assert;
import org.testng.ITestNGListener;
import org.testng.TestNG;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Configuration;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

public class TestNGUtil {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    public static final String TESTNG_GROUP_NAME = "TestNG";
    public static boolean hasDocTagsSupport = TestNGUtil.hasDocTagsSupport();
    public static final String TEST_ANNOTATION_FQN = Test.class.getName();
    public static final String FACTORY_ANNOTATION_FQN = Factory.class.getName();
    public static final String[] CONFIG_ANNOTATIONS_FQN = new String[]{Configuration.class.getName(), Factory.class.getName(), ObjectFactory.class.getName(), DataProvider.class.getName(), BeforeClass.class.getName(), BeforeGroups.class.getName(), BeforeMethod.class.getName(), BeforeSuite.class.getName(), BeforeTest.class.getName(), AfterClass.class.getName(), AfterGroups.class.getName(), AfterMethod.class.getName(), AfterSuite.class.getName(), AfterTest.class.getName()};
    public static final String[] CONFIG_ANNOTATIONS_FQN_NO_TEST_LEVEL = new String[]{Configuration.class.getName(), Factory.class.getName(), ObjectFactory.class.getName(), BeforeClass.class.getName(), BeforeGroups.class.getName(), BeforeSuite.class.getName(), BeforeTest.class.getName(), AfterClass.class.getName(), AfterGroups.class.getName(), AfterSuite.class.getName(), AfterTest.class.getName()};
    @NonNls
    private static final String[] CONFIG_JAVADOC_TAGS = new String[]{"testng.configuration", "testng.before-class", "testng.before-groups", "testng.before-method", "testng.before-suite", "testng.before-test", "testng.after-class", "testng.after-groups", "testng.after-method", "testng.after-suite", "testng.after-test"};
    private static final List<String> JUNIT_ANNOTATIONS = Arrays.asList("org.junit.Test", "org.junit.Before", "org.junit.BeforeClass", "org.junit.After", "org.junit.AfterClass");
    @NonNls
    private static final String SUITE_TAG_NAME = "suite";

    private static boolean hasDocTagsSupport() {
        String testngJarPath = PathUtil.getJarPathForClass(Test.class);
        String version = JarUtil.getJarAttribute((File)new File(testngJarPath), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return version != null && StringUtil.compareVersionNumbers((String)version, (String)"5.12") <= 0;
    }

    public static boolean hasConfig(PsiModifierListOwner element) {
        return TestNGUtil.hasConfig(element, CONFIG_ANNOTATIONS_FQN);
    }

    public static boolean hasConfig(PsiModifierListOwner element, String[] configAnnotationsFqn) {
        if (element instanceof PsiClass) {
            for (PsiMethod method : ((PsiClass)element).getAllMethods()) {
                if (!TestNGUtil.isConfigMethod(method, configAnnotationsFqn)) continue;
                return true;
            }
        } else {
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            return TestNGUtil.isConfigMethod((PsiMethod)element, configAnnotationsFqn);
        }
        return false;
    }

    private static boolean isConfigMethod(PsiMethod method, String[] configAnnotationsFqn) {
        PsiDocComment comment;
        for (String fqn : configAnnotationsFqn) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)fqn, (boolean)false)) continue;
            return true;
        }
        if (hasDocTagsSupport && (comment = method.getDocComment()) != null) {
            for (String javadocTag : CONFIG_JAVADOC_TAGS) {
                if (comment.findTagByName(javadocTag) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static String getConfigAnnotation(PsiMethod method) {
        if (method != null) {
            for (String fqn : CONFIG_ANNOTATIONS_FQN) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)fqn, (boolean)false)) continue;
                return fqn;
            }
        }
        return null;
    }

    public static boolean isTestNGAnnotation(PsiAnnotation annotation) {
        String qName = annotation.getQualifiedName();
        if (qName != null) {
            if (qName.equals(TEST_ANNOTATION_FQN)) {
                return true;
            }
            for (String qn : CONFIG_ANNOTATIONS_FQN) {
                if (!qName.equals(qn)) continue;
                return true;
            }
            if (qName.equals(TEST_ANNOTATION_FQN)) {
                return true;
            }
            for (String qn : CONFIG_ANNOTATIONS_FQN) {
                if (!qName.equals(qn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasTest(PsiModifierListOwner element) {
        return TestNGUtil.hasTest(element, true);
    }

    public static boolean hasTest(PsiModifierListOwner element, boolean checkDisabled) {
        return TestNGUtil.hasTest(element, true, checkDisabled, hasDocTagsSupport);
    }

    public static boolean hasTest(PsiModifierListOwner element, boolean checkHierarchy, boolean checkDisabled, boolean checkJavadoc) {
        boolean hasAnnotation = AnnotationUtil.isAnnotated((PsiModifierListOwner)element, (String)TEST_ANNOTATION_FQN, (boolean)checkHierarchy, (boolean)true);
        if (hasAnnotation) {
            PsiAnnotation annotation;
            return !checkDisabled || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (boolean)true, (String[])new String[]{TEST_ANNOTATION_FQN})) == null || !TestNGUtil.isDisabled(annotation);
        }
        if (element instanceof PsiDocCommentOwner && checkJavadoc && TestNGUtil.getTextJavaDoc((PsiDocCommentOwner)element) != null) {
            return true;
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            for (PsiMethod method : psiClass.getAllMethods()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{TEST_ANNOTATION_FQN});
                if (annotation != null) {
                    if (checkDisabled && TestNGUtil.isDisabled(annotation)) continue;
                    return true;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)FACTORY_ANNOTATION_FQN, (boolean)false, (boolean)true)) {
                    return true;
                }
                if (!checkJavadoc || TestNGUtil.getTextJavaDoc((PsiDocCommentOwner)method) == null) continue;
                return true;
            }
            return false;
        }
        if (element instanceof PsiMethod) {
            if (element.hasModifierProperty("private") || element.hasModifierProperty("static")) {
                return false;
            }
            PsiClass psiClass = ((PsiMethod)element).getContainingClass();
            if (psiClass != null) {
                PsiAnnotation annotation;
                PsiAnnotation psiAnnotation = annotation = checkHierarchy ? AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton(TEST_ANNOTATION_FQN)) : AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (boolean)true, (String[])new String[]{TEST_ANNOTATION_FQN});
                if (annotation != null) {
                    if (checkDisabled && TestNGUtil.isDisabled(annotation)) {
                        return false;
                    }
                    return !TestNGUtil.hasConfig(element);
                }
                if (checkJavadoc && TestNGUtil.getTextJavaDoc((PsiDocCommentOwner)psiClass) != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isDisabled(PsiAnnotation annotation) {
        PsiAnnotationMemberValue attributeValue = annotation.findDeclaredAttributeValue("enabled");
        return attributeValue != null && attributeValue.textMatches((CharSequence)"false");
    }

    private static PsiDocTag getTextJavaDoc(@NotNull PsiDocCommentOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/theoryinpractice/testng/util/TestNGUtil", "getTextJavaDoc"));
        }
        PsiDocComment docComment = element.getDocComment();
        if (docComment != null) {
            return docComment.findTagByName("testng.test");
        }
        return null;
    }

    private static boolean isBrokenPsiClass(PsiClass psiClass) {
        return psiClass == null || psiClass instanceof PsiAnonymousClass || psiClass instanceof PsiSyntheticClass;
    }

    public static Map<PsiClass, Collection<PsiMethod>> filterAnnotations(String parameter, Set<String> values, Collection<PsiClass> classes) {
        HashMap<PsiClass, Collection<PsiMethod>> results = new HashMap<PsiClass, Collection<PsiMethod>>();
        HashSet<String> test = new HashSet<String>(1);
        test.add(TEST_ANNOTATION_FQN);
        ContainerUtil.addAll(test, (Object[])CONFIG_ANNOTATIONS_FQN);
        for (PsiClass psiClass : classes) {
            PsiMethod[] methods;
            PsiAnnotation annotation;
            block9: {
                block8: {
                    if (TestNGUtil.isBrokenPsiClass(psiClass)) continue;
                    try {
                        annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, test);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception trying to findAnnotation on " + psiClass.getClass().getName() + ".\n\n" + e.getMessage());
                        annotation = null;
                    }
                    if (annotation == null) break block8;
                    if (!TestNGUtil.isAnnotatedWithParameter(annotation, parameter, values)) break block9;
                    results.put(psiClass, new LinkedHashSet());
                    break block9;
                }
                Collection<String> matches = TestNGUtil.extractAnnotationValuesFromJavaDoc(TestNGUtil.getTextJavaDoc((PsiDocCommentOwner)psiClass), parameter);
                for (String s : matches) {
                    if (!values.contains(s)) continue;
                    results.put(psiClass, new LinkedHashSet());
                    break;
                }
            }
            for (PsiMethod method : methods = psiClass.getMethods()) {
                if (method == null) continue;
                annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, test);
                if (annotation != null) {
                    if (!TestNGUtil.isAnnotatedWithParameter(annotation, parameter, values)) continue;
                    if (results.get(psiClass) == null) {
                        results.put(psiClass, new LinkedHashSet());
                    }
                    ((Collection)results.get(psiClass)).add(method);
                    continue;
                }
                Collection<String> matches = TestNGUtil.extractAnnotationValuesFromJavaDoc(TestNGUtil.getTextJavaDoc((PsiDocCommentOwner)psiClass), parameter);
                for (String s : matches) {
                    if (!values.contains(s)) continue;
                    ((Collection)results.get(psiClass)).add(method);
                }
            }
        }
        return results;
    }

    public static boolean isAnnotatedWithParameter(PsiAnnotation annotation, String parameter, Set<String> values) {
        PsiAnnotationMemberValue attributeValue = annotation.findDeclaredAttributeValue(parameter);
        if (attributeValue != null) {
            Collection<String> matches = TestNGUtil.extractValuesFromParameter(attributeValue);
            for (String s : matches) {
                if (!values.contains(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getAnnotationValues(String parameter, PsiClass ... classes) {
        HashMap<String, Collection<String>> results = new HashMap<String, Collection<String>>();
        HashSet<String> set = new HashSet<String>();
        results.put(parameter, set);
        TestNGUtil.collectAnnotationValues(results, null, classes);
        return set;
    }

    public static void collectAnnotationValues(Map<String, Collection<String>> results, PsiMethod[] psiMethods, PsiClass ... classes) {
        HashSet<String> test = new HashSet<String>(1);
        test.add(TEST_ANNOTATION_FQN);
        ContainerUtil.addAll(test, (Object[])CONFIG_ANNOTATIONS_FQN);
        if (psiMethods != null) {
            for (PsiMethod psiMethod : psiMethods) {
                ApplicationManager.getApplication().runReadAction(() -> TestNGUtil.appendAnnotationAttributeValues(results, AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (Set)test), (PsiDocCommentOwner)psiMethod));
            }
        } else {
            for (PsiClass psiClass : classes) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (psiClass != null && TestNGUtil.hasTest((PsiModifierListOwner)psiClass)) {
                        PsiMethod[] methods;
                        TestNGUtil.appendAnnotationAttributeValues(results, AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (Set)test), (PsiDocCommentOwner)psiClass);
                        for (PsiMethod method : methods = psiClass.getMethods()) {
                            if (method == null) continue;
                            TestNGUtil.appendAnnotationAttributeValues(results, AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Set)test), (PsiDocCommentOwner)method);
                        }
                    }
                });
            }
        }
    }

    private static void appendAnnotationAttributeValues(Map<String, Collection<String>> results, PsiAnnotation annotation, PsiDocCommentOwner commentOwner) {
        for (String parameter : results.keySet()) {
            Collection<String> values = results.get(parameter);
            if (annotation != null) {
                PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue(parameter);
                if (value == null) continue;
                values.addAll(TestNGUtil.extractValuesFromParameter(value));
                continue;
            }
            values.addAll(TestNGUtil.extractAnnotationValuesFromJavaDoc(TestNGUtil.getTextJavaDoc(commentOwner), parameter));
        }
    }

    private static Collection<String> extractAnnotationValuesFromJavaDoc(PsiDocTag tag, String parameter) {
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\\@testng.test(?:.*)" + parameter + "\\s*=\\s*\"(.*?)\".*").matcher(tag.getText());
        if (matcher.matches()) {
            String[] groups;
            for (String group : groups = matcher.group(1).split("[,\\s]")) {
                String trimmed = group.trim();
                if (trimmed.length() <= 0) continue;
                results.add(trimmed);
            }
        }
        return results;
    }

    private static Collection<String> extractValuesFromParameter(PsiAnnotationMemberValue value) {
        ArrayList<String> results = new ArrayList<String>();
        if (value instanceof PsiArrayInitializerMemberValue) {
            for (PsiElement child : value.getChildren()) {
                if (!(child instanceof PsiLiteralExpression)) continue;
                results.add((String)((PsiLiteralExpression)child).getValue());
            }
        } else if (value instanceof PsiLiteralExpression) {
            results.add((String)((PsiLiteralExpression)value).getValue());
        }
        return results;
    }

    @Nullable
    public static PsiClass[] getAllTestClasses(TestClassFilter filter, boolean sync) {
        PsiClass[][] holder = new PsiClass[1][];
        Runnable process = () -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            LinkedHashSet<PsiClass> set = new LinkedHashSet<PsiClass>();
            PsiManager manager = PsiManager.getInstance((Project)filter.getProject());
            GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
            GlobalSearchScope scope = projectScope.intersectWith(filter.getScope());
            for (PsiClass psiClass : AllClassesSearch.search((SearchScope)scope, (Project)manager.getProject())) {
                if (!filter.isAccepted(psiClass)) continue;
                if (indicator != null) {
                    indicator.setText2("Found test class " + (String)ReadAction.compute(() -> ((PsiClass)psiClass).getQualifiedName()));
                }
                set.add(psiClass);
            }
            holder[0] = set.toArray(new PsiClass[set.size()]);
        };
        if (sync) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, "Searching For Tests...", true, filter.getProject());
        } else {
            process.run();
        }
        return holder[0];
    }

    public static PsiAnnotation[] getTestNGAnnotations(PsiElement element) {
        PsiElement[] annotations = PsiTreeUtil.collectElements((PsiElement)element, (PsiElementFilter)new PsiElementFilter(){

            public boolean isAccepted(PsiElement element) {
                if (!(element instanceof PsiAnnotation)) {
                    return false;
                }
                String name = ((PsiAnnotation)element).getQualifiedName();
                if (null == name) {
                    return false;
                }
                return name.startsWith("org.testng.annotations");
            }
        });
        PsiAnnotation[] array = new PsiAnnotation[annotations.length];
        System.arraycopy(annotations, 0, array, 0, annotations.length);
        return array;
    }

    public static boolean isTestNGClass(PsiClass psiClass) {
        return TestNGUtil.hasTest((PsiModifierListOwner)psiClass, true, false, false);
    }

    public static boolean checkTestNGInClasspath(PsiElement psiElement) {
        Project project = psiElement.getProject();
        PsiManager manager = PsiManager.getInstance((Project)project);
        if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(TestNG.class.getName(), psiElement.getResolveScope()) == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode() && Messages.showOkCancelDialog((Project)psiElement.getProject(), (String)"TestNG will be added to module classpath", (String)"Unable to convert.", (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return false;
            }
            String url = VfsUtil.getUrlForLibraryRoot((File)new File(PathUtil.getJarPathForClass(Assert.class)));
            ModuleRootModificationUtil.addModuleLibrary((Module)module, (String)url);
        }
        return true;
    }

    public static boolean containsJunitAnnotions(PsiClass psiClass) {
        if (psiClass != null) {
            for (PsiMethod method : psiClass.getMethods()) {
                if (!TestNGUtil.containsJunitAnnotions(method)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsJunitAnnotions(PsiMethod method) {
        return method != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, JUNIT_ANNOTATIONS);
    }

    public static boolean inheritsJUnitTestCase(PsiClass psiClass) {
        PsiClass current = psiClass;
        while (current != null) {
            PsiClass[] supers = current.getSupers();
            if (supers.length > 0) {
                PsiClass parent = supers[0];
                if ("junit.framework.TestCase".equals(parent.getQualifiedName())) {
                    return true;
                }
                current = parent;
                if (current != psiClass) continue;
                return false;
            }
            current = null;
        }
        return false;
    }

    public static boolean inheritsITestListener(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/theoryinpractice/testng/util/TestNGUtil", "inheritsITestListener"));
        }
        Project project = psiClass.getProject();
        PsiClass aListenerClass = JavaPsiFacade.getInstance((Project)project).findClass(ITestNGListener.class.getName(), GlobalSearchScope.allScope((Project)project));
        return aListenerClass != null && psiClass.isInheritor(aListenerClass, true);
    }

    public static boolean isTestngXML(VirtualFile virtualFile) {
        String result;
        return "xml".equalsIgnoreCase(virtualFile.getExtension()) && virtualFile.isValid() && (result = NanoXmlUtil.parseHeader((VirtualFile)virtualFile).getRootTagLocalName()) != null && result.equals(SUITE_TAG_NAME);
    }

    public static PsiClass getProviderClass(PsiElement element, PsiClass topLevelClass) {
        PsiTypeElement operand;
        PsiClass psiClass;
        PsiAnnotationMemberValue value;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
        if (annotation != null && (value = annotation.findDeclaredAttributeValue("dataProviderClass")) instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInType((PsiType)(operand = ((PsiClassObjectAccessExpression)value).getOperand()).getType())) != null) {
            return psiClass;
        }
        return topLevelClass;
    }
}

