/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.discovery;

import java.util.regex.Pattern;
import org.junit.gen5.engine.FilterResult;
import org.junit.gen5.engine.discovery.ClassFilter;

class ClassNameFilter
implements ClassFilter {
    private final Pattern pattern;

    ClassNameFilter(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public FilterResult filter(Class<?> testClass) {
        return FilterResult.includedIf(this.pattern.matcher(testClass.getName()).matches(), () -> "Test class matches name pattern: " + this.pattern, () -> "Test class does not match name pattern: " + this.pattern);
    }

    public String toString() {
        return "Filter class names with regular expression: " + this.pattern;
    }
}

