/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.RightMarginForm;
import com.intellij.ide.highlighter.XmlHighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CodeStyleXmlPanel
extends CodeStyleAbstractPanel {
    private JTextField myKeepBlankLines;
    private JComboBox myWrapAttributes;
    private JCheckBox myAlignAttributes;
    private JCheckBox myKeepWhiteSpaces;
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private JCheckBox mySpacesAroundEquality;
    private JCheckBox mySpacesAfterTagName;
    private JCheckBox myKeepLineBreaks;
    private JCheckBox myInEmptyTag;
    private JCheckBox myWrapText;
    private JCheckBox myKeepLineBreaksInText;
    private JComboBox myWhiteSpaceAroundCDATA;
    private JCheckBox myKeepWhitespaceInsideCDATACheckBox;
    private JBScrollPane myJBScrollPane;
    private JPanel myRightMarginPanel;
    private RightMarginForm myRightMarginForm;

    public CodeStyleXmlPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        CodeStyleXmlPanel.fillWrappingCombo(this.myWrapAttributes);
        this.addPanelToWatch(this.myPanel);
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return XmlHighlighterFactory.createXMLHighlighter(scheme);
    }

    @Override
    protected int getRightMargin() {
        return 60;
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        xmlSettings.XML_KEEP_BLANK_LINES = this.getIntValue(this.myKeepBlankLines);
        xmlSettings.XML_KEEP_LINE_BREAKS = this.myKeepLineBreaks.isSelected();
        xmlSettings.XML_KEEP_LINE_BREAKS_IN_TEXT = this.myKeepLineBreaksInText.isSelected();
        xmlSettings.XML_ATTRIBUTE_WRAP = ourWrappings[this.myWrapAttributes.getSelectedIndex()];
        xmlSettings.XML_TEXT_WRAP = this.myWrapText.isSelected() ? 1 : 0;
        xmlSettings.XML_ALIGN_ATTRIBUTES = this.myAlignAttributes.isSelected();
        xmlSettings.XML_KEEP_WHITESPACES = this.myKeepWhiteSpaces.isSelected();
        xmlSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = this.mySpacesAroundEquality.isSelected();
        xmlSettings.XML_SPACE_AFTER_TAG_NAME = this.mySpacesAfterTagName.isSelected();
        xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG = this.myInEmptyTag.isSelected();
        xmlSettings.XML_WHITE_SPACE_AROUND_CDATA = this.myWhiteSpaceAroundCDATA.getSelectedIndex();
        xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA = this.myKeepWhitespaceInsideCDATACheckBox.isSelected();
        this.myRightMarginForm.apply(settings);
    }

    private int getIntValue(JTextField keepBlankLines) {
        try {
            return Integer.parseInt(keepBlankLines.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        this.myKeepBlankLines.setText(String.valueOf(xmlSettings.XML_KEEP_BLANK_LINES));
        this.myWrapAttributes.setSelectedIndex(CodeStyleXmlPanel.getIndexForWrapping(xmlSettings.XML_ATTRIBUTE_WRAP));
        this.myAlignAttributes.setSelected(xmlSettings.XML_ALIGN_ATTRIBUTES);
        this.myKeepWhiteSpaces.setSelected(xmlSettings.XML_KEEP_WHITESPACES);
        this.mySpacesAfterTagName.setSelected(xmlSettings.XML_SPACE_AFTER_TAG_NAME);
        this.mySpacesAroundEquality.setSelected(xmlSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE);
        this.myKeepLineBreaks.setSelected(xmlSettings.XML_KEEP_LINE_BREAKS);
        this.myKeepLineBreaksInText.setSelected(xmlSettings.XML_KEEP_LINE_BREAKS_IN_TEXT);
        this.myInEmptyTag.setSelected(xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG);
        this.myWrapText.setSelected(this.wrapText(settings));
        this.myWhiteSpaceAroundCDATA.setSelectedIndex(xmlSettings.XML_WHITE_SPACE_AROUND_CDATA);
        this.myKeepWhitespaceInsideCDATACheckBox.setSelected(xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA);
        this.myRightMarginForm.reset(settings);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        if (this.myWrapText.isSelected() != this.wrapText(settings)) {
            return true;
        }
        if (xmlSettings.XML_KEEP_BLANK_LINES != this.getIntValue(this.myKeepBlankLines)) {
            return true;
        }
        if (xmlSettings.XML_ATTRIBUTE_WRAP != ourWrappings[this.myWrapAttributes.getSelectedIndex()]) {
            return true;
        }
        if (xmlSettings.XML_ALIGN_ATTRIBUTES != this.myAlignAttributes.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_WHITESPACES != this.myKeepWhiteSpaces.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE != this.mySpacesAroundEquality.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_SPACE_AFTER_TAG_NAME != this.mySpacesAfterTagName.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_LINE_BREAKS != this.myKeepLineBreaks.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_LINE_BREAKS_IN_TEXT != this.myKeepLineBreaksInText.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG != this.myInEmptyTag.isSelected()) {
            return true;
        }
        if (xmlSettings.XML_WHITE_SPACE_AROUND_CDATA != this.myWhiteSpaceAroundCDATA.getSelectedIndex()) {
            return true;
        }
        if (xmlSettings.XML_KEEP_WHITE_SPACES_INSIDE_CDATA != this.myKeepWhitespaceInsideCDATACheckBox.isSelected()) {
            return true;
        }
        return this.myRightMarginForm.isModified(settings);
    }

    private boolean wrapText(CodeStyleSettings settings) {
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        return xmlSettings.XML_TEXT_WRAP == 1;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected String getPreviewText() {
        return CodeStyleXmlPanel.readFromFile(this.getClass(), "preview.xml.template");
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleXmlPanel", "getFileType"));
        }
        return languageFileType;
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }

    private void createUIComponents() {
        this.myJBScrollPane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                return new Dimension(prefSize.width + 15, prefSize.height);
            }
        };
        this.myRightMarginForm = new RightMarginForm(StdFileTypes.XML.getLanguage(), this.getSettings());
        this.myRightMarginPanel = this.myRightMarginForm.getTopPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        JComboBox jComboBox2;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 4, -1, false, false));
        JBScrollPane jBScrollPane = this.myJBScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAlignAttributes = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.align.attributes"));
        jCheckBox9.setMargin(new Insets(0, 0, 0, 0));
        jPanel5.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepWhiteSpaces = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.white.spaces"));
        jCheckBox8.setMargin(new Insets(0, 0, 0, 0));
        jPanel5.add((Component)jCheckBox8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWrapText = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.wrap.text"));
        jCheckBox7.setMargin(new Insets(2, 0, 2, 3));
        jPanel5.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("html.disable", Boolean.TRUE);
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.spaces"), (int)0, (int)0, null, null));
        this.mySpacesAroundEquality = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.around.equals.in.attribute"));
        jCheckBox6.setMargin(new Insets(0, 0, 0, 0));
        jPanel6.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpacesAfterTagName = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.around.tag.name"));
        jCheckBox5.setMargin(new Insets(0, 0, 0, 0));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInEmptyTag = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.in.empty.tag"));
        jCheckBox4.setMargin(new Insets(0, 0, 0, 0));
        jPanel6.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.wrap.attributes"));
        jPanel7.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWrapAttributes = jComboBox2 = new JComboBox();
        ((Component)jComboBox2).setEnabled(true);
        jPanel7.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.keep.blank.lines"));
        jPanel7.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepLineBreaksInText = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.line.breaks.in.text"));
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myKeepBlankLines = jTextField = new JTextField();
        jTextField.setColumns(3);
        jPanel7.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myKeepLineBreaks = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.line.breaks"));
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jPanel7.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel8, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"CDATA", (int)0, (int)0, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Whitespace around:");
        jPanel8.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepWhitespaceInsideCDATACheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Keep whitespace inside");
        jPanel8.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myWhiteSpaceAroundCDATA = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Preserve");
        defaultComboBoxModel.addElement("Remove (keep with tags)");
        defaultComboBoxModel.addElement("Add new lines");
        jComboBox.setModel(defaultComboBoxModel);
        jPanel8.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel9 = this.myRightMarginPanel;
        jPanel3.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

