/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DaemonCodeAnalyzer", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
    private static final Key<List<LineMarkerInfo>> MARKERS_IN_EDITOR_DOCUMENT_KEY = Key.create((String)"MARKERS_IN_EDITOR_DOCUMENT");
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create((String)"FILE_LEVEL_HIGHLIGHTS");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    @NotNull
    private final EditorTracker myEditorTracker;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private DaemonProgressIndicator myUpdateProgress;
    private final Runnable myUpdateRunnable;
    private final Alarm myAlarm;
    private boolean myUpdateByTimerEnabled;
    private final Collection<VirtualFile> myDisabledHintsFiles;
    private final Collection<VirtualFile> myDisabledHighlightingFiles;
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private volatile IntentionHintComponent myLastIntentionHint;
    private volatile boolean myDisposed;
    private volatile boolean myInitialized;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private final PassExecutorService myPassExecutorService;
    private volatile boolean allowToInterrupt;
    private volatile boolean mustWaitForSmartMode;
    private int myDisableCount;
    private final Runnable submitPassesRunnable;

    public DaemonCodeAnalyzerImpl(@NotNull Project project2, @NotNull DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings, @NotNull EditorTracker editorTracker, @NotNull PsiDocumentManager psiDocumentManager, @NotNull NamedScopeManager namedScopeManager, @NotNull DependencyValidationManager dependencyValidationManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (daemonCodeAnalyzerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "daemonCodeAnalyzerSettings", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (editorTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTracker", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (psiDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDocumentManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (namedScopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedScopeManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (dependencyValidationManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyValidationManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        this.myUpdateRunnable = this.createUpdateRunnable();
        this.myAlarm = new Alarm();
        this.myUpdateByTimerEnabled = true;
        this.myDisabledHintsFiles = new THashSet();
        this.myDisabledHighlightingFiles = new THashSet();
        this.allowToInterrupt = true;
        this.mustWaitForSmartMode = true;
        this.submitPassesRunnable = new Runnable(){

            @Override
            public void run() {
                PassExecutorService.log(DaemonCodeAnalyzerImpl.this.getUpdateProgress(), null, "Update Runnable. myUpdateByTimerEnabled:", DaemonCodeAnalyzerImpl.this.myUpdateByTimerEnabled, " something disposed:", PowerSaveMode.isEnabled() || DaemonCodeAnalyzerImpl.this.myDisposed || !DaemonCodeAnalyzerImpl.this.myProject.isInitialized(), " activeEditors:", DaemonCodeAnalyzerImpl.this.myProject.isDisposed() ? null : DaemonCodeAnalyzerImpl.this.getSelectedEditors());
                if (!DaemonCodeAnalyzerImpl.this.myUpdateByTimerEnabled) {
                    return;
                }
                if (DaemonCodeAnalyzerImpl.this.myDisposed) {
                    return;
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Collection activeEditors = DaemonCodeAnalyzerImpl.this.getSelectedEditors();
                if (activeEditors.isEmpty()) {
                    return;
                }
                if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    return;
                }
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)DaemonCodeAnalyzerImpl.this.myPsiDocumentManager;
                if (documentManager.hasUncommitedDocuments()) {
                    documentManager.cancelAndRunWhenAllCommitted("restart daemon when all committed", this);
                    return;
                }
                if (RefResolveService.ENABLED && !RefResolveService.getInstance((Project)DaemonCodeAnalyzerImpl.this.myProject).isUpToDate() && RefResolveService.getInstance((Project)DaemonCodeAnalyzerImpl.this.myProject).getQueueSize() == 1) {
                    return;
                }
                THashMap passes = new THashMap(activeEditors.size());
                for (FileEditor fileEditor : activeEditors) {
                    BackgroundEditorHighlighter highlighter = fileEditor.getBackgroundHighlighter();
                    if (highlighter == null) continue;
                    HighlightingPass[] highlightingPasses = highlighter.createPassesForEditor();
                    passes.put(fileEditor, highlightingPasses);
                }
                DaemonCodeAnalyzerImpl.this.cancelUpdateProgress(true, "Cancel by alarm");
                DaemonCodeAnalyzerImpl.this.myAlarm.cancelAllRequests();
                DaemonProgressIndicator progress = DaemonCodeAnalyzerImpl.this.createUpdateProgress();
                DaemonCodeAnalyzerImpl.this.myPassExecutorService.submitPasses((Map<FileEditor, HighlightingPass[]>)passes, progress);
            }
        };
        this.myProject = project2;
        this.mySettings = daemonCodeAnalyzerSettings;
        this.myEditorTracker = editorTracker;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)daemonCodeAnalyzerSettings).clone();
        this.myFileStatusMap = new FileStatusMap(project2);
        this.myPassExecutorService = new PassExecutorService(project2);
        Disposer.register((Disposable)this, (Disposable)this.myPassExecutorService);
        Disposer.register((Disposable)this, (Disposable)this.myFileStatusMap);
        DaemonProgressIndicator.setDebug(LOG.isDebugEnabled());
        assert (!this.myInitialized) : "Double Initializing";
        Disposer.register((Disposable)this, (Disposable)new StatusBarUpdater(project2));
        this.myInitialized = true;
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty("DCAI init");
        Disposer.register((Disposable)this, () -> {
            assert (this.myInitialized) : "Disposing not initialized component";
            assert (!this.myDisposed) : "Double dispose";
            this.stopProcess(false, "Dispose");
            this.myDisposed = true;
            this.myLastSettings = null;
        });
    }

    public void dispose() {
    }

    @NotNull
    public static List<HighlightInfo> getHighlights(@NotNull Document document2, HighlightSeverity minSeverity, @NotNull Project project2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerImpl.processHighlights(document2, project2, minSeverity, 0, document2.getTextLength(), (Processor<HighlightInfo>)Processors.cancelableCollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<HighlightInfo> getFileLevelHighlights(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project2);
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>();
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            for (HighlightInfo info : infos) {
                result2.add(info);
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        return arrayList;
    }

    @Override
    public void cleanFileLevelHighlights(@NotNull Project project2, int group, PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "cleanFileLevelHighlights"));
        }
        if (psiFile == null) {
            return;
        }
        FileViewProvider provider = psiFile.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project2);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : infos) {
                if (info.getGroup() != group) continue;
                manager.removeTopComponent(fileEditor, info.fileLevelComponent);
                infosToRemove.add(info);
            }
            infos.removeAll(infosToRemove);
        }
    }

    @Override
    public void addFileLevelHighlight(@NotNull Project project2, int group, @NotNull HighlightInfo info, @NotNull PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project2);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            FileLevelIntentionComponent component = new FileLevelIntentionComponent(info.getDescription(), info.getSeverity(), info.getGutterIconRenderer(), info.quickFixActionRanges, project2, psiFile, ((TextEditor)fileEditor).getEditor());
            manager.addTopComponent(fileEditor, (JComponent)((Object)component));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info.fileLevelComponent = component;
            info.setGroup(group);
            fileLevelInfos.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<HighlightInfo> runMainPasses(@NotNull PsiFile psiFile, @NotNull Document document2, @NotNull ProgressIndicator progress) {
        ArrayList<HighlightInfo> result2;
        block13: {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
            }
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new IllegalStateException("Must not run highlighting from under EDT");
            }
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                throw new IllegalStateException("Must run highlighting from under read action");
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (!(indicator instanceof DaemonProgressIndicator)) {
                throw new IllegalStateException("Must run highlighting under progress with DaemonProgressIndicator");
            }
            this.myFileStatusMap.markAllFilesDirty("prepare to run main passes");
            this.stopProcess(false, "disable background daemon");
            this.myPassExecutorService.cancelAll(true);
            try {
                result2 = new ArrayList<HighlightInfo>();
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null || virtualFile.getFileType().isBinary()) break block13;
                List<TextEditorHighlightingPass> passes = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject).instantiateMainPasses(psiFile, document2, HighlightInfoProcessor.getEmpty());
                Collections.sort(passes, (o1, o2) -> {
                    if (o1 instanceof GeneralHighlightingPass) {
                        return -1;
                    }
                    if (o2 instanceof GeneralHighlightingPass) {
                        return 1;
                    }
                    return 0;
                });
                LOG.debug("All passes for " + psiFile.getName() + " started (" + passes + "). progress canceled: " + progress.isCanceled());
                try {
                    for (TextEditorHighlightingPass pass : passes) {
                        pass.doCollectInformation(progress);
                        result2.addAll(pass.getInfos());
                    }
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Canceled: " + progress);
                    throw e;
                }
                LOG.debug("All passes for " + psiFile.getName() + " run. progress canceled: " + progress.isCanceled() + "; infos: " + result2);
            }
            finally {
                this.stopProcess(true, "re-enable background daemon after main passes run");
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
        }
        return arrayList;
    }

    @NotNull
    public List<HighlightInfo> runPasses(@NotNull PsiFile file2, @NotNull Document document2, @NotNull TextEditor textEditor, @NotNull int[] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (textEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        List<HighlightInfo> list = this.runPasses(file2, document2, Collections.singletonList(textEditor), toIgnore, canChangeDocument, callbackWhileWaiting);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        return list;
    }

    public void mustWaitForSmartMode(boolean mustWait, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "mustWaitForSmartMode"));
        }
        boolean old = this.mustWaitForSmartMode;
        this.mustWaitForSmartMode = mustWait;
        Disposer.register((Disposable)parent, () -> {
            this.mustWaitForSmartMode = old;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<HighlightInfo> runPasses(@NotNull PsiFile file2, @NotNull Document document2, @NotNull List<TextEditor> textEditors, @NotNull int[] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (textEditors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditors", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        assert (this.myInitialized);
        assert (!this.myDisposed);
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.assertIsDispatchThread();
        if (application.isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Must not start highlighting from within write action, or deadlock is imminent");
        }
        DaemonProgressIndicator.setDebug(true);
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        UIUtil.dispatchAllInvocationEvents();
        while (RefreshQueueImpl.isRefreshInProgress() || HeavyProcessLatch.INSTANCE.isRunning()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        long dstart = System.currentTimeMillis();
        while (this.mustWaitForSmartMode && DumbService.getInstance((Project)this.myProject).isDumb()) {
            if (System.currentTimeMillis() > dstart + 100000L) {
                throw new IllegalStateException("Timeout waiting for smart mode. If you absolutely want to be dumb, please use DaemonCodeAnalyzerImpl.mustWaitForSmartMode(false).");
            }
            UIUtil.dispatchAllInvocationEvents();
        }
        UIUtil.dispatchAllInvocationEvents();
        Project project2 = file2.getProject();
        FileStatusMap.getAndClearLog();
        FileStatusMap fileStatusMap = this.getFileStatusMap();
        fileStatusMap.allowDirt(canChangeDocument);
        HashMap<FileEditor, HighlightingPass[]> map = new HashMap<FileEditor, HighlightingPass[]>();
        for (TextEditor textEditor : textEditors) {
            TextEditorBackgroundHighlighter highlighter = (TextEditorBackgroundHighlighter)textEditor.getBackgroundHighlighter();
            List<TextEditorHighlightingPass> passes = highlighter.getPasses(toIgnore);
            HighlightingPass[] array = passes.toArray(new HighlightingPass[passes.size()]);
            assert (array.length != 0) : "Highlighting is disabled for the file " + file2;
            map.put((FileEditor)textEditor, array);
        }
        for (Object ignoreId : (Object)toIgnore) {
            fileStatusMap.markFileUpToDate(document2, (int)ignoreId);
        }
        this.myAlarm.cancelAllRequests();
        DaemonProgressIndicator progress = this.createUpdateProgress();
        this.myPassExecutorService.submitPasses(map, progress);
        long start = System.currentTimeMillis();
        while (progress.isRunning() && System.currentTimeMillis() < start + 300000L) {
            DaemonCodeAnalyzerImpl.wrap(() -> {
                progress.checkCanceled();
                if (callbackWhileWaiting != null) {
                    callbackWhileWaiting.run();
                }
                this.waitInOtherThread(50);
                UIUtil.dispatchAllInvocationEvents();
                Throwable savedException = PassExecutorService.getSavedException(progress);
                if (savedException != null) {
                    throw savedException;
                }
            });
        }
        if (progress.isRunning() && !progress.isCanceled()) {
            throw new RuntimeException("Highlighting still running after " + (System.currentTimeMillis() - start) / 1000L + " seconds.\n" + ThreadDumper.dumpThreadsToString());
        }
        HighlightingSessionImpl session2 = (HighlightingSessionImpl)HighlightingSessionImpl.getOrCreateHighlightingSession(file2, textEditors.get(0).getEditor(), progress, null);
        DaemonCodeAnalyzerImpl.wrap(() -> {
            if (!this.waitInOtherThread(60000)) {
                throw new TimeoutException("Unable to complete in 60s");
            }
            session2.waitForHighlightInfosApplied();
        });
        UIUtil.dispatchAllInvocationEvents();
        UIUtil.dispatchAllInvocationEvents();
        assert (progress.isCanceled() && progress.isDisposed());
        List<HighlightInfo> list = DaemonCodeAnalyzerImpl.getHighlights(document2, null, project2);
        List<HighlightInfo> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        return list2;
        finally {
            DaemonProgressIndicator.setDebug(false);
            String log = FileStatusMap.getAndClearLog();
            fileStatusMap.allowDirt(true);
            try {
                this.waitForTermination();
            }
            catch (Throwable e) {
                LOG.error(log, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitInOtherThread(int millis) throws Throwable {
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(PsiModificationTracker.TOPIC, () -> {
            throw new IllegalStateException("You must not perform PSI modifications from inside highlighting");
        });
        try {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    return this.myPassExecutorService.waitFor(millis);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            });
            boolean bl = (Boolean)future2.get();
            return bl;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public void prepareForTest() {
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
    }

    public void cleanupAfterTest() {
        if (this.myProject.isOpen()) {
            this.prepareForTest();
        }
    }

    void waitForTermination() {
        this.myPassExecutorService.cancelAll(true);
    }

    public void settingsChanged() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        if (settings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)settings).clone();
    }

    public void updateVisibleHighlighters(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "updateVisibleHighlighters"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    public void setUpdateByTimerEnabled(boolean value) {
        this.myUpdateByTimerEnabled = value;
        this.stopProcess(value, "Update by timer change");
    }

    public void disableUpdateByTimer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "disableUpdateByTimer"));
        }
        this.setUpdateByTimerEnabled(false);
        ++this.myDisableCount;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register((Disposable)parentDisposable, () -> {
            --this.myDisableCount;
            if (this.myDisableCount == 0) {
                this.setUpdateByTimerEnabled(true);
            }
        });
    }

    boolean isUpdateByTimerEnabled() {
        return this.myUpdateByTimerEnabled;
    }

    public void setImportHintsEnabled(@NotNull PsiFile file2, boolean value) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setImportHintsEnabled"));
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (value) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true, "Import hints change");
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    public void setHighlightingEnabled(@NotNull PsiFile file2, boolean value) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setHighlightingEnabled"));
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        if (value) {
            this.myDisabledHighlightingFiles.remove(virtualFile);
        } else {
            this.myDisabledHighlightingFiles.add(virtualFile);
        }
    }

    public boolean isHighlightingAvailable(@Nullable PsiFile file2) {
        if (file2 == null || !file2.isPhysical()) {
            return false;
        }
        if (this.myDisabledHighlightingFiles.contains(PsiUtilCore.getVirtualFile((PsiElement)file2))) {
            return false;
        }
        if (file2 instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = file2.getFileType();
        return !fileType.isBinary();
    }

    public boolean isImportHintsEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isImportHintsEnabled"));
        }
        return this.isAutohintsAvailable(file2) && !this.myDisabledHintsFiles.contains(file2.getVirtualFile());
    }

    public boolean isAutohintsAvailable(PsiFile file2) {
        return this.isHighlightingAvailable(file2) && !(file2 instanceof PsiCompiledElement);
    }

    public void restart() {
        this.myFileStatusMap.markAllFilesDirty("Global restart");
        this.stopProcess(true, "Global restart");
    }

    public void restart(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "restart"));
        }
        Document document2 = this.myPsiDocumentManager.getCachedDocument(file2);
        if (document2 == null) {
            return;
        }
        String reason = "Psi file restart: " + file2.getName();
        this.myFileStatusMap.markFileScopeDirty(document2, new TextRange(0, document2.getTextLength()), file2.getTextLength(), reason);
        this.stopProcess(true, reason);
    }

    @NotNull
    List<TextEditorHighlightingPass> getPassesToShowProgressFor(Document document2) {
        List<TextEditorHighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        ArrayList<TextEditorHighlightingPass> result2 = new ArrayList<TextEditorHighlightingPass>(allPasses.size());
        for (TextEditorHighlightingPass pass : allPasses) {
            if (pass.getDocument() != document2 && pass.getDocument() != null) continue;
            result2.add(pass);
        }
        ArrayList<TextEditorHighlightingPass> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getPassesToShowProgressFor"));
        }
        return arrayList;
    }

    boolean isAllAnalysisFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isAllAnalysisFinished"));
        }
        if (this.myDisposed) {
            return false;
        }
        Document document2 = this.myPsiDocumentManager.getCachedDocument(file2);
        return document2 != null && document2.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document2);
    }

    @Override
    public boolean isErrorAnalyzingFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isErrorAnalyzingFinished"));
        }
        if (this.myDisposed) {
            return false;
        }
        Document document2 = this.myPsiDocumentManager.getCachedDocument(file2);
        return document2 != null && document2.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document2, 4) == null;
    }

    @Override
    @NotNull
    public FileStatusMap getFileStatusMap() {
        FileStatusMap fileStatusMap = this.myFileStatusMap;
        if (fileStatusMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileStatusMap"));
        }
        return fileStatusMap;
    }

    synchronized boolean isRunning() {
        return this.myUpdateProgress != null && !this.myUpdateProgress.isCanceled();
    }

    boolean isRunningOrPending() {
        return this.isRunning() || !this.myAlarm.isEmpty();
    }

    synchronized void stopProcess(boolean toRestartAlarm, @NonNls String reason) {
        boolean restart;
        if (!this.allowToInterrupt) {
            throw new RuntimeException("Cannot interrupt daemon");
        }
        this.cancelUpdateProgress(toRestartAlarm, reason);
        this.myAlarm.cancelAllRequests();
        boolean bl = restart = toRestartAlarm && !this.myDisposed && this.myInitialized;
        if (restart) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.myAlarm.isEmpty()) {
                    this.myAlarm.addRequest(this.myUpdateRunnable, this.mySettings.AUTOREPARSE_DELAY);
                }
            });
        }
    }

    private synchronized void cancelUpdateProgress(boolean start, @NonNls String reason) {
        PassExecutorService.log(this.myUpdateProgress, null, "Cancel", reason, start);
        if (this.myUpdateProgress != null) {
            this.myUpdateProgress.cancel();
            this.myPassExecutorService.cancelAll(false);
            this.myUpdateProgress = null;
        }
    }

    static boolean processHighlightsNearOffset(@NotNull Document document2, @NotNull Project project2, @NotNull HighlightSeverity minSeverity, int offset, boolean includeFixRange, @NotNull Processor<HighlightInfo> processor2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (minSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        return DaemonCodeAnalyzerImpl.processHighlights(document2, project2, null, 0, document2.getTextLength(), (Processor<HighlightInfo>)((Processor)info -> {
            if (minSeverity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "lambda$processHighlightsNearOffset$9"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "lambda$processHighlightsNearOffset$9"));
            }
            if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, includeFixRange)) {
                return true;
            }
            int compare = info.getSeverity().compareTo(minSeverity);
            return compare < 0 || processor2.process(info);
        }));
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document2, int offset, boolean includeFixRange) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        return this.findHighlightByOffset(document2, offset, includeFixRange, HighlightSeverity.INFORMATION);
    }

    @Nullable
    HighlightInfo findHighlightByOffset(@NotNull Document document2, int offset, boolean includeFixRange, @NotNull HighlightSeverity minSeverity) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        if (minSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        SmartList foundInfoList = new SmartList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(document2, this.myProject, minSeverity, offset, includeFixRange, (Processor<HighlightInfo>)((Processor)arg_0 -> DaemonCodeAnalyzerImpl.lambda$findHighlightByOffset$10((List)foundInfoList, arg_0)));
        if (foundInfoList.isEmpty()) {
            return null;
        }
        if (foundInfoList.size() == 1) {
            return (HighlightInfo)foundInfoList.get(0);
        }
        return new HighlightInfoComposite((List<HighlightInfo>)foundInfoList);
    }

    private static boolean isOffsetInsideHighlightInfo(int offset, @NotNull HighlightInfo info, boolean includeFixRange) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isOffsetInsideHighlightInfo"));
        }
        RangeHighlighterEx highlighter = info.highlighter;
        if (highlighter == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        RangeMarker fixMarker = info.fixMarker;
        if (fixMarker != null) {
            if (!fixMarker.isValid()) {
                return false;
            }
            startOffset = fixMarker.getStartOffset();
            endOffset = fixMarker.getEndOffset();
            return startOffset <= offset && offset <= endOffset;
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo> getLineMarkers(@NotNull Document document2, @NotNull Project project2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getLineMarkers"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getLineMarkers"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModel markup = DocumentMarkupModel.forDocument(document2, project2, true);
        List list = (List)ObjectUtils.notNull((Object)markup.getUserData(MARKERS_IN_EDITOR_DOCUMENT_KEY), Collections.emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getLineMarkers"));
        }
        return list;
    }

    static void setLineMarkers(@NotNull Document document2, @NotNull List<LineMarkerInfo> lineMarkers, @NotNull Project project2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLineMarkers"));
        }
        if (lineMarkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineMarkers", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLineMarkers"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLineMarkers"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModel markup = DocumentMarkupModel.forDocument(document2, project2, true);
        markup.putUserData(MARKERS_IN_EDITOR_DOCUMENT_KEY, lineMarkers);
    }

    void setLastIntentionHint(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions, boolean hasToRecreate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (!editor.getSettings().isShowIntentionBulb()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.hideLastIntentionHint();
        if (editor.getCaretModel().getCaretCount() > 1) {
            return;
        }
        IntentionHintComponent hintComponent = IntentionHintComponent.showIntentionHint(project2, file2, editor, intentions, false);
        if (hasToRecreate) {
            hintComponent.recreate();
        }
        this.myLastIntentionHint = hintComponent;
    }

    void hideLastIntentionHint() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        IntentionHintComponent hint = this.myLastIntentionHint;
        if (hint != null && hint.isVisible()) {
            hint.hide();
            this.myLastIntentionHint = null;
        }
    }

    @Nullable
    public IntentionHintComponent getLastIntentionHint() {
        return this.myLastIntentionHint;
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        if (this.myDisabledHintsFiles.isEmpty()) {
            return state;
        }
        SmartList array = new SmartList();
        for (VirtualFile file2 : this.myDisabledHintsFiles) {
            if (!file2.isValid()) continue;
            array.add(file2.getUrl());
        }
        if (!array.isEmpty()) {
            Collections.sort(array);
            Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
            state.addContent(disableHintsElement);
            for (String url : array) {
                disableHintsElement.addContent(new Element(FILE_TAG).setAttribute(URL_ATT, url));
            }
        }
        return state;
    }

    public void loadState(Element state) {
        this.myDisabledHintsFiles.clear();
        Element element = state.getChild(DISABLE_HINTS_TAG);
        if (element != null) {
            for (Element e : element.getChildren(FILE_TAG)) {
                VirtualFile file2;
                String url = e.getAttributeValue(URL_ATT);
                if (url == null || (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file2);
            }
        }
    }

    @NotNull
    private Runnable createUpdateRunnable() {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (DaemonCodeAnalyzerImpl.this.myDisposed || !DaemonCodeAnalyzerImpl.this.myProject.isInitialized() || PowerSaveMode.isEnabled()) {
                    return;
                }
                if (HeavyProcessLatch.INSTANCE.isRunning()) {
                    final Disposable removeListenerDisposable = Disposer.newDisposable();
                    HeavyProcessLatch.HeavyProcessListener heavyProcessListener = new HeavyProcessLatch.HeavyProcessListener(){

                        public void processStarted() {
                        }

                        public void processFinished() {
                            Disposer.dispose((Disposable)removeListenerDisposable);
                            DaemonCodeAnalyzerImpl.this.myAlarm.addRequest(DaemonCodeAnalyzerImpl.this.myUpdateRunnable, Math.max(((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzerImpl.this).mySettings.AUTOREPARSE_DELAY, 100), ModalityState.NON_MODAL);
                        }
                    };
                    HeavyProcessLatch.INSTANCE.addListener(removeListenerDisposable, heavyProcessListener);
                    Disposer.register((Disposable)DaemonCodeAnalyzerImpl.this, (Disposable)removeListenerDisposable);
                    if (!HeavyProcessLatch.INSTANCE.isRunning()) {
                        heavyProcessListener.processFinished();
                    }
                    return;
                }
                Editor activeEditor = FileEditorManager.getInstance((Project)DaemonCodeAnalyzerImpl.this.myProject).getSelectedTextEditor();
                if (activeEditor == null) {
                    DaemonCodeAnalyzerImpl.this.submitPassesRunnable.run();
                } else {
                    ((PsiDocumentManagerBase)DaemonCodeAnalyzerImpl.this.myPsiDocumentManager).cancelAndRunWhenAllCommitted("start daemon when all committed", DaemonCodeAnalyzerImpl.this.submitPassesRunnable);
                }
            }

            public String toString() {
                return "Daemon update runnable";
            }
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "createUpdateRunnable"));
        }
        return runnable2;
    }

    @NotNull
    private synchronized DaemonProgressIndicator createUpdateProgress() {
        DaemonProgressIndicator old = this.myUpdateProgress;
        if (old != null && !old.isCanceled()) {
            old.cancel();
        }
        DaemonProgressIndicator progress = new DaemonProgressIndicator(){

            @Override
            public void stopIfRunning() {
                super.stopIfRunning();
                ((DaemonCodeAnalyzer.DaemonListener)DaemonCodeAnalyzerImpl.this.myProject.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC)).daemonFinished();
            }
        };
        progress.start();
        this.myUpdateProgress = progress;
        DaemonProgressIndicator daemonProgressIndicator = progress;
        if (daemonProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "createUpdateProgress"));
        }
        return daemonProgressIndicator;
    }

    public void autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "autoImportReferenceAtCursor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "autoImportReferenceAtCursor"));
        }
        for (ReferenceImporter importer : (ReferenceImporter[])Extensions.getExtensions(ReferenceImporter.EP_NAME)) {
            if (importer.autoImportReferenceAtCursor(editor, file2)) break;
        }
    }

    synchronized DaemonProgressIndicator getUpdateProgress() {
        return this.myUpdateProgress;
    }

    void allowToInterrupt(boolean can) {
        this.allowToInterrupt = can;
    }

    @NotNull
    private Collection<FileEditor> getSelectedEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<Editor> editors = this.getActiveEditors();
        THashSet activeTextEditors = new THashSet(editors.size());
        for (Editor editor : editors) {
            if (editor.isDisposed()) continue;
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
            activeTextEditors.add(textEditor);
        }
        if (ApplicationManager.getApplication().getCurrentModalityState() != ModalityState.NON_MODAL) {
            THashSet tHashSet = activeTextEditors;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getSelectedEditors"));
            }
            return tHashSet;
        }
        THashSet result2 = new THashSet();
        THashSet files = new THashSet(activeTextEditors.size());
        FileEditor[] tabEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors();
        for (FileEditor tabEditor : tabEditors) {
            if (!tabEditor.isValid()) continue;
            VirtualFile file2 = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(tabEditor);
            if (file2 != null) {
                files.add(file2);
            }
            result2.add(tabEditor);
        }
        for (FileEditor fileEditor : activeTextEditors) {
            VirtualFile file3 = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(fileEditor);
            if (file3 != null && files.contains(file3)) continue;
            result2.add(fileEditor);
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getSelectedEditors"));
        }
        return tHashSet;
    }

    @NotNull
    private List<Editor> getActiveEditors() {
        List<Editor> list = this.myEditorTracker.getActiveEditors();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getActiveEditors"));
        }
        return list;
    }

    private static void wrap(@NotNull ThrowableRunnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "wrap"));
        }
        try {
            runnable2.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$findHighlightByOffset$10(List foundInfoList, HighlightInfo info) {
        if (info.getSeverity() == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY) {
            return true;
        }
        if (!foundInfoList.isEmpty()) {
            HighlightInfo foundInfo = (HighlightInfo)foundInfoList.get(0);
            int compare = foundInfo.getSeverity().compareTo(info.getSeverity());
            if (compare < 0) {
                foundInfoList.clear();
            } else if (compare > 0) {
                return true;
            }
        }
        foundInfoList.add(info);
        return true;
    }
}

