/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IdentifierHighlighterPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass");
    private final PsiFile myFile;
    private final Editor myEditor;
    private final Collection<TextRange> myReadAccessRanges;
    private final Collection<TextRange> myWriteAccessRanges;
    private final int myCaretOffset;

    protected IdentifierHighlighterPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "<init>"));
        }
        super(project2, editor.getDocument(), false);
        this.myReadAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myWriteAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myFile = file2;
        this.myEditor = editor;
        this.myCaretOffset = this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        PsiElement myTarget;
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "doCollectInformation"));
        }
        HighlightUsagesHandlerBase handler2 = HighlightUsagesHandler.createCustomHandler(this.myEditor, this.myFile);
        if (handler2 != null) {
            List targets = handler2.getTargets();
            handler2.computeUsages(targets);
            List<TextRange> readUsages = handler2.getReadUsages();
            for (TextRange textRange : readUsages) {
                LOG.assertTrue(textRange != null, (Object)("null text range from " + handler2));
            }
            this.myReadAccessRanges.addAll(readUsages);
            List<TextRange> writeUsages = handler2.getWriteUsages();
            for (TextRange writeUsage : writeUsages) {
                LOG.assertTrue(writeUsage != null, (Object)("null text range from " + handler2));
            }
            this.myWriteAccessRanges.addAll(writeUsages);
            if (!handler2.highlightReferences()) {
                return;
            }
        }
        int flags = 3;
        try {
            myTarget = TargetElementUtil.getInstance().findTargetElement(this.myEditor, flags, this.myCaretOffset);
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (myTarget == null && !PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile, this.myCaretOffset);
            myTarget = TargetElementUtil.getInstance().findTargetElement(injectedEditor, flags, injectedEditor.getCaretModel().getOffset());
        }
        if (myTarget != null) {
            this.highlightTargetUsages(myTarget);
        } else {
            ResolveResult[] resolveResultArray;
            PsiReference ref = TargetElementUtil.findReference(this.myEditor);
            if (ref instanceof PsiPolyVariantReference && (resolveResultArray = ((PsiPolyVariantReference)ref).multiResolve(false)).length > 0) {
                for (ResolveResult result2 : resolveResultArray) {
                    PsiElement target = result2.getElement();
                    if (target == null) continue;
                    this.highlightTargetUsages(target);
                }
            }
        }
    }

    @NotNull
    public static Couple<Collection<TextRange>> getHighlightUsages(@NotNull PsiElement target, PsiElement psiElement, boolean withDeclarations) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "getHighlightUsages"));
        }
        Couple<Collection<TextRange>> couple = IdentifierHighlighterPass.getUsages(target, psiElement, withDeclarations, true);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "getHighlightUsages"));
        }
        return couple;
    }

    @NotNull
    public static Collection<TextRange> getUsages(@NotNull PsiElement target, PsiElement psiElement, boolean withDeclarations) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "getUsages"));
        }
        Collection collection = (Collection)IdentifierHighlighterPass.getUsages((PsiElement)target, (PsiElement)psiElement, (boolean)withDeclarations, (boolean)false).first;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "getUsages"));
        }
        return collection;
    }

    @NotNull
    private static Couple<Collection<TextRange>> getUsages(@NotNull PsiElement target, PsiElement psiElement, boolean withDeclarations, boolean detectAccess) {
        TextRange declRange;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "getUsages"));
        }
        ArrayList<TextRange> readRanges = new ArrayList<TextRange>();
        ArrayList<TextRange> writeRanges = new ArrayList<TextRange>();
        ReadWriteAccessDetector detector = detectAccess ? ReadWriteAccessDetector.findDetector((PsiElement)target) : null;
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)target.getProject())).getFindUsagesManager();
        FindUsagesHandler findUsagesHandler = findUsagesManager.getFindUsagesHandler(target, true);
        LocalSearchScope scope = new LocalSearchScope(psiElement);
        Collection refs = findUsagesHandler != null ? findUsagesHandler.findReferencesToHighlight(target, (SearchScope)scope) : ReferencesSearch.search((PsiElement)target, (SearchScope)scope).findAll();
        for (PsiReference psiReference : refs) {
            if (psiReference == null) {
                LOG.error("Null reference returned, findUsagesHandler=" + findUsagesHandler + "; target=" + target + " of " + target.getClass());
                continue;
            }
            ArrayList<TextRange> destination = detector == null || detector.getReferenceAccess(target, psiReference) == ReadWriteAccessDetector.Access.Read ? readRanges : writeRanges;
            HighlightUsagesHandler.collectRangesToHighlight(psiReference, destination);
        }
        if (withDeclarations && (declRange = HighlightUsagesHandler.getNameIdentifierRange(psiElement.getContainingFile(), target)) != null) {
            if (detector != null && detector.isDeclarationWriteAccess(target)) {
                writeRanges.add(declRange);
            } else {
                readRanges.add(declRange);
            }
        }
        Couple couple = Couple.of(readRanges, writeRanges);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "getUsages"));
        }
        return couple;
    }

    private void highlightTargetUsages(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass", "highlightTargetUsages"));
        }
        Couple<Collection<TextRange>> usages = IdentifierHighlighterPass.getHighlightUsages(target, (PsiElement)this.myFile, true);
        this.myReadAccessRanges.addAll((Collection)usages.first);
        this.myWriteAccessRanges.addAll((Collection)usages.second);
    }

    @Override
    public void doApplyInformationToEditor() {
        boolean virtSpace = TargetElementUtil.inVirtualSpace(this.myEditor, this.myEditor.getCaretModel().getOffset());
        List<HighlightInfo> infos = virtSpace ? Collections.emptyList() : this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
    }

    private List<HighlightInfo> getHighlights() {
        if (this.myReadAccessRanges.isEmpty() && this.myWriteAccessRanges.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Pair<Object, TextRange>> existingMarkupTooltips = new HashSet<Pair<Object, TextRange>>();
        for (RangeHighlighter highlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
            existingMarkupTooltips.add(Pair.create((Object)highlighter.getErrorStripeTooltip(), (Object)new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset())));
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(this.myReadAccessRanges.size() + this.myWriteAccessRanges.size());
        for (TextRange range : this.myReadAccessRanges) {
            ContainerUtil.addIfNotNull((Object)this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_READ, existingMarkupTooltips), result2);
        }
        for (TextRange range : this.myWriteAccessRanges) {
            ContainerUtil.addIfNotNull((Object)this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_WRITE, existingMarkupTooltips), result2);
        }
        return result2;
    }

    private HighlightInfo createHighlightInfo(TextRange range, HighlightInfoType type, Set<Pair<Object, TextRange>> existingMarkupTooltips) {
        int start = range.getStartOffset();
        String tooltip = start <= this.myDocument.getTextLength() ? HighlightHandlerBase.getLineTextErrorStripeTooltip(this.myDocument, start, false) : null;
        String unescapedTooltip = existingMarkupTooltips.contains(new Pair((Object)tooltip, (Object)range)) ? null : tooltip;
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type).range(range);
        if (unescapedTooltip != null) {
            builder.unescapedToolTip(unescapedTooltip);
        }
        return builder.createUnconditionally();
    }

    public static void clearMyHighlights(Document document2, Project project2) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document2, project2, true);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            Object tooltip = highlighter.getErrorStripeTooltip();
            if (!(tooltip instanceof HighlightInfo)) continue;
            HighlightInfo info = (HighlightInfo)tooltip;
            if (info.type != HighlightInfoType.ELEMENT_UNDER_CARET_READ && info.type != HighlightInfoType.ELEMENT_UNDER_CARET_WRITE) continue;
            highlighter.dispose();
        }
    }
}

