/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExternalLibraryToDependenciesQuickFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddLibraryToDependenciesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddModuleDependencyFix;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrderEntryFix
implements IntentionAction,
LocalQuickFix {
    protected OrderEntryFix() {
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "applyFix"));
        }
        this.invoke(project2, null, descriptor.getPsiElement().getContainingFile());
    }

    @Nullable
    public static List<LocalQuickFix> registerFixes(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiReference reference) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "registerFixes"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "registerFixes"));
        }
        PsiElement psiElement = reference.getElement();
        String shortReferenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project2 = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return null;
        }
        ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        String fullReferenceText = reference.getCanonicalText();
        for (ExternalLibraryResolver resolver : (ExternalLibraryResolver[])ExternalLibraryResolver.EP_NAME.getExtensions()) {
            ExternalLibraryDescriptor descriptor;
            ExternalLibraryResolver.ExternalClassResolveResult resolveResult = resolver.resolveClass(shortReferenceName, OrderEntryFix.isReferenceToAnnotation(psiElement), currentModule);
            AddExternalLibraryToDependenciesQuickFix fix = null;
            if (resolveResult != null && psiFacade.findClass(resolveResult.getQualifiedClassName(), currentModule.getModuleWithDependenciesAndLibrariesScope(true)) == null) {
                fix = new AddExternalLibraryToDependenciesQuickFix(currentModule, resolveResult.getLibrary(), reference, resolveResult.getQualifiedClassName());
            } else if (!fullReferenceText.equals(shortReferenceName) && (descriptor = resolver.resolvePackage(fullReferenceText)) != null) {
                fix = new AddExternalLibraryToDependenciesQuickFix(currentModule, descriptor, reference, null);
            }
            if (fix == null) continue;
            registrar.register(fix);
            result2.add(fix);
        }
        if (!result2.isEmpty()) {
            return result2;
        }
        THashSet librariesToAdd = new THashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project2).getClassesByName(shortReferenceName, GlobalSearchScope.allScope((Project)project2));
        List<PsiClass> allowedDependencies = OrderEntryFix.filterAllowedDependencies(psiElement, classes);
        if (allowedDependencies.isEmpty()) {
            return result2;
        }
        classes = allowedDependencies.toArray(new PsiClass[allowedDependencies.size()]);
        AddModuleDependencyFix moduleDependencyFix = new AddModuleDependencyFix(currentModule, classVFile, classes, reference);
        registrar.register((IntentionAction)moduleDependencyFix);
        result2.add(moduleDependencyFix);
        for (PsiClass aClass : classes) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)currentModule).getFileIndex();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
                OrderEntry entryForFile;
                VirtualFile jar;
                VirtualFile[] files;
                LibraryOrderEntry libraryEntry;
                Library library;
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || (files = library.getFiles(OrderRootType.CLASSES)).length == 0 || (jar = files[0]) == null || libraryEntry.isModuleLevel() && !librariesToAdd.add(jar) || !librariesToAdd.add(library) || (entryForFile = moduleFileIndex.getOrderEntryForFile(virtualFile)) != null && (!(entryForFile instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entryForFile).getScope() != DependencyScope.TEST || ModuleRootManager.getInstance((Module)currentModule).getFileIndex().isInTestSourceContent(classVFile))) continue;
                AddLibraryToDependenciesFix platformFix = new AddLibraryToDependenciesFix(currentModule, library, reference, aClass.getQualifiedName());
                registrar.register((IntentionAction)platformFix);
                result2.add(platformFix);
            }
        }
        return result2;
    }

    private static List<PsiClass> filterAllowedDependencies(PsiElement element, PsiClass[] classes) {
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance((Project)element.getProject());
        PsiFile fromFile = element.getContainingFile();
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        for (PsiClass psiClass : classes) {
            PsiFile containingFile = psiClass.getContainingFile();
            if (containingFile == null || dependencyValidationManager.getViolatorDependencyRule(fromFile, containingFile) != null) continue;
            result2.add(psiClass);
        }
        return result2;
    }

    private static ThreeState isReferenceToAnnotation(PsiElement psiElement) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiElement)) {
            return ThreeState.NO;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAnnotation.class) != null) {
            return ThreeState.YES;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiImportStatement.class) != null) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    public static void importClass(@NotNull Module currentModule, @Nullable Editor editor, @Nullable PsiReference reference, @Nullable @NonNls String className) {
        if (currentModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "importClass"));
        }
        Project project2 = currentModule.getProject();
        if (editor != null && reference != null && className != null) {
            DumbService.getInstance((Project)project2).withAlternativeResolveEnabled(() -> {
                if (currentModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "lambda$importClass$0"));
                }
                GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)currentModule);
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project2).findClass(className, scope);
                if (aClass != null) {
                    new AddImportAction(project2, reference, editor, aClass).execute();
                }
            });
        }
    }

    public static void addJarToRoots(@NotNull String jarPath, @NotNull Module module2, @Nullable PsiElement location) {
        if (jarPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarPath", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "addJarToRoots"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "addJarToRoots"));
        }
        OrderEntryFix.addJarsToRoots(Collections.singletonList(jarPath), null, module2, location);
    }

    public static void addJarsToRoots(@NotNull List<String> jarPaths, @Nullable String libraryName, @NotNull Module module2, @Nullable PsiElement location) {
        if (jarPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarPaths", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "addJarsToRoots"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "addJarsToRoots"));
        }
        List<String> urls = OrderEntryFix.refreshAndConvertToUrls(jarPaths);
        DependencyScope scope = OrderEntryFix.suggestScopeByLocation(module2, location);
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)libraryName, urls, Collections.emptyList(), (DependencyScope)scope);
    }

    @NotNull
    public static List<String> refreshAndConvertToUrls(@NotNull List<String> jarPaths) {
        if (jarPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarPaths", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "refreshAndConvertToUrls"));
        }
        List list = ContainerUtil.map(jarPaths, path -> OrderEntryFix.refreshAndConvertToUrl(path));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "refreshAndConvertToUrls"));
        }
        return list;
    }

    @NotNull
    public static DependencyScope suggestScopeByLocation(@NotNull Module module2, @Nullable PsiElement location) {
        VirtualFile vFile;
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "suggestScopeByLocation"));
        }
        if (location != null && (vFile = location.getContainingFile().getVirtualFile()) != null && ModuleRootManager.getInstance((Module)module2).getFileIndex().isInTestSourceContent(vFile)) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "suggestScopeByLocation"));
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "suggestScopeByLocation"));
        }
        return dependencyScope;
    }

    @NotNull
    private static String refreshAndConvertToUrl(String jarPath) {
        File libraryRoot = new File(jarPath);
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libraryRoot);
        String string = VfsUtil.getUrlForLibraryRoot((File)libraryRoot);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "refreshAndConvertToUrl"));
        }
        return string;
    }
}

