/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class EditVariableDialog
extends DialogWrapper {
    private ArrayList<Variable> myVariables = new ArrayList();
    private JTable myTable;
    private final Editor myEditor;
    private final List<TemplateContextType> myContextTypes;

    public EditVariableDialog(Editor editor, Component parent, ArrayList<Variable> variables, List<TemplateContextType> contextTypes) {
        super(parent, true);
        this.myContextTypes = contextTypes;
        this.setButtonsMargin(null);
        this.myVariables = variables;
        this.myEditor = editor;
        this.init();
        this.setTitle(CodeInsightBundle.message((String)"templates.dialog.edit.variables.title", (Object[])new Object[0]));
        this.setOKButtonText(CommonBundle.getOkButtonText());
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/EditVariableDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("editing.templates.defineTemplates.editTemplVars");
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.template.impl.EditVariableDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected JComponent createCenterPanel() {
        return this.createVariablesTable();
    }

    private JComponent createVariablesTable() {
        String[] names = new String[]{CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.name", (Object[])new Object[0]), CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.expression", (Object[])new Object[0]), CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.default.value", (Object[])new Object[0]), CodeInsightBundle.message((String)"templates.dialog.edit.variables.table.column.skip.if.defined", (Object[])new Object[0])};
        VariablesModel dataModel = new VariablesModel(names);
        this.myTable = new JBTable((TableModel)dataModel);
        this.myTable.setSelectionMode(0);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(500, this.myTable.getRowHeight() * 8));
        this.myTable.getColumn(names[0]).setPreferredWidth(120);
        this.myTable.getColumn(names[1]).setPreferredWidth(200);
        this.myTable.getColumn(names[2]).setPreferredWidth(200);
        this.myTable.getColumn(names[3]).setPreferredWidth(100);
        if (this.myVariables.size() > 0) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        Predicate<Macro> isAcceptableInContext = macro -> this.myContextTypes.stream().anyMatch(arg_0 -> ((Macro)macro).isAcceptableInContext(arg_0));
        Stream<String> availableMacroNames = Arrays.stream(MacroFactory.getMacros()).filter(isAcceptableInContext).map(Macro::getPresentableName).sorted();
        Set uniqueNames = availableMacroNames.collect(Collectors.toCollection(LinkedHashSet::new));
        ComboBox comboField = new ComboBox();
        uniqueNames.forEach(arg_0 -> comboField.addItem(arg_0));
        comboField.setEditable(true);
        DefaultCellEditor cellEditor = new DefaultCellEditor((JComboBox<?>)comboField);
        cellEditor.setClickCountToStart(1);
        this.myTable.getColumn(names[1]).setCellEditor(cellEditor);
        this.myTable.setRowHeight(comboField.getPreferredSize().height);
        JTextField textField = new JTextField();
        cellEditor = new DefaultCellEditor(textField);
        cellEditor.setClickCountToStart(1);
        this.myTable.setDefaultEditor(String.class, cellEditor);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable).disableAddAction().disableRemoveAction();
        return decorator.createPanel();
    }

    protected void doOKAction() {
        TableCellEditor editor;
        if (this.myTable.isEditing() && (editor = this.myTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        super.doOKAction();
    }

    private void updateTemplateTextByVarNameChange(Variable oldVar, Variable newVar) {
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(null, () -> {
            Document document2 = this.myEditor.getDocument();
            String templateText = document2.getText();
            templateText = templateText.replaceAll("\\$" + oldVar.getName() + "\\$", "\\$" + newVar.getName() + "\\$");
            document2.replaceString(0, document2.getTextLength(), (CharSequence)templateText);
        }, null, null));
    }

    private class VariablesModel
    extends AbstractTableModel
    implements EditableModel {
        private final String[] myNames;

        public VariablesModel(String[] names) {
            this.myNames = names;
        }

        @Override
        public int getColumnCount() {
            return this.myNames.length;
        }

        @Override
        public int getRowCount() {
            return EditVariableDialog.this.myVariables.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Variable variable = (Variable)EditVariableDialog.this.myVariables.get(row);
            if (col == 0) {
                return variable.getName();
            }
            if (col == 1) {
                return variable.getExpressionString();
            }
            if (col == 2) {
                return variable.getDefaultValueString();
            }
            return variable.isAlwaysStopAt() ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            String string = this.myNames[column];
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/EditVariableDialog$VariablesModel", "getColumnName"));
            }
            return string;
        }

        @NotNull
        public Class getColumnClass(int c) {
            if (c <= 2) {
                if (String.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/EditVariableDialog$VariablesModel", "getColumnClass"));
                }
                return String.class;
            }
            if (Boolean.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/EditVariableDialog$VariablesModel", "getColumnClass"));
            }
            return Boolean.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            Variable variable = (Variable)EditVariableDialog.this.myVariables.get(row);
            if (col == 0) {
                String varName = (String)aValue;
                if (TemplateImplUtil.isValidVariableName(varName)) {
                    Variable newVar = new Variable(varName, variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
                    EditVariableDialog.this.myVariables.set(row, newVar);
                    EditVariableDialog.this.updateTemplateTextByVarNameChange(variable, newVar);
                }
            } else if (col == 1) {
                variable.setExpressionString((String)aValue);
            } else if (col == 2) {
                variable.setDefaultValueString((String)aValue);
            } else {
                variable.setAlwaysStopAt((Boolean)aValue == false);
            }
        }

        public void addRow() {
            throw new UnsupportedOperationException();
        }

        public void removeRow(int index) {
            throw new UnsupportedOperationException();
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            Collections.swap(EditVariableDialog.this.myVariables, oldIndex, newIndex);
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }
    }
}

