/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyStreamApiCallChainsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + SimplifyStreamApiCallChainsInspection.class.getName()));
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String STREAM_METHOD = "stream";
    private static final String AS_LIST_METHOD = "asList";
    private static final String OF_METHOD = "of";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiMethodCallExpression qualifierCall;
                if (SimplifyStreamApiCallChainsInspection.isCallOf(methodCall, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                    PsiMethodCallExpression qualifierCall2 = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifierCall2, "java.util.Arrays", SimplifyStreamApiCallChainsInspection.AS_LIST_METHOD, 1)) {
                        PsiExpression[] argumentExpressions = qualifierCall2.getArgumentList().getExpressions();
                        if (argumentExpressions.length == 1 && argumentExpressions[0].getType() instanceof PsiArrayType) {
                            holder.registerProblem((PsiElement)methodCall, null, "Arrays.asList().stream() can be replaced with Arrays.stream()", new LocalQuickFix[]{new ArraysAsListSingleArrayFix()});
                        } else {
                            holder.registerProblem((PsiElement)methodCall, null, "Arrays.asList().stream() can be replaced with Stream.of()", new LocalQuickFix[]{new ArraysAsListVarargFix()});
                        }
                    }
                } else if (SimplifyStreamApiCallChainsInspection.isCallOf(methodCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, 1) && SimplifyStreamApiCallChainsInspection.isCallOf(qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall), "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                    holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.this.getCallChainRange(methodCall, qualifierCall), "Collection.stream().forEach() can be replaced with Collection.forEach()", new LocalQuickFix[]{new CollectionForEachFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static PsiMethodCallExpression getQualifierMethodCall(PsiMethodCallExpression methodCall) {
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)qualifierExpression;
        }
        return null;
    }

    @NotNull
    protected TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethodCallExpression qualifierExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        PsiReferenceExpression qualifierMethodExpression = qualifierExpression.getMethodExpression();
        PsiElement qualifierNameElement = qualifierMethodExpression.getReferenceNameElement();
        int startOffset = (qualifierNameElement != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression.getTextOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        return textRange;
    }

    @Contract(value="null, _, _, _ -> false")
    protected static boolean isCallOf(@Nullable PsiMethodCallExpression expression, @NotNull String className, @NotNull String methodName, int parametersCount) {
        PsiClass containingClass;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (expression == null) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        return method != null && methodName.equals(method.getName()) && method.getParameterList().getParametersCount() == parametersCount && (containingClass = method.getContainingClass()) != null && className.equals(containingClass.getQualifiedName());
    }

    private static class CollectionForEachFix
    extends CallChainFixBase {
        private CollectionForEachFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Collection.stream().forEach() with Collection.forEach()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "getFamilyName"));
            }
            return "Replace Collection.stream().forEach() with Collection.forEach()";
        }

        @Override
        @NotNull
        protected String createExpressionText(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @NotNull PsiExpression qualifierExpression) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "createExpressionText"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "createExpressionText"));
            }
            if (qualifierExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "createExpressionText"));
            }
            String string = qualifierExpression.getText() + "." + SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD + methodCall.getArgumentList().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "createExpressionText"));
            }
            return string;
        }
    }

    private static class ArraysAsListSingleArrayFix
    extends CallChainFixBase {
        private ArraysAsListSingleArrayFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Arrays.asList().stream() with Arrays.stream()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "getFamilyName"));
            }
            return "Replace Arrays.asList().stream() with Arrays.stream()";
        }

        @Override
        @NotNull
        protected String createExpressionText(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @NotNull PsiExpression qualifierExpression) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "createExpressionText"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "createExpressionText"));
            }
            if (qualifierExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "createExpressionText"));
            }
            String string = "java.util.Arrays.stream" + qualifierCall.getArgumentList().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "createExpressionText"));
            }
            return string;
        }
    }

    private static class ArraysAsListVarargFix
    extends CallChainFixBase {
        private ArraysAsListVarargFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Arrays.asList().stream() with Stream.of()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListVarargFix", "getFamilyName"));
            }
            return "Replace Arrays.asList().stream() with Stream.of()";
        }

        @Override
        @NotNull
        protected String createExpressionText(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @NotNull PsiExpression qualifierExpression) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListVarargFix", "createExpressionText"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListVarargFix", "createExpressionText"));
            }
            if (qualifierExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListVarargFix", "createExpressionText"));
            }
            String string = "java.util.stream.Stream.of" + qualifierCall.getArgumentList().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListVarargFix", "createExpressionText"));
            }
            return string;
        }
    }

    private static abstract class CallChainFixBase
    implements LocalQuickFix {
        private CallChainFixBase() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression previousExpression;
                PsiExpression qualifierExpression;
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element.getContainingFile())) {
                    return;
                }
                PsiMethodCallExpression expression = (PsiMethodCallExpression)element;
                PsiExpression forEachMethodQualifier = expression.getMethodExpression().getQualifierExpression();
                if (forEachMethodQualifier instanceof PsiMethodCallExpression && (qualifierExpression = (previousExpression = (PsiMethodCallExpression)forEachMethodQualifier).getMethodExpression().getQualifierExpression()) != null) {
                    PsiExpression newElement;
                    String text = this.createExpressionText(expression, previousExpression, qualifierExpression);
                    try {
                        newElement = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(text, null);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.info("Failed to parse expression '" + text + "'", (Throwable)e);
                        return;
                    }
                    PsiElement shortenedElement = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)newElement);
                    element.replace(shortenedElement);
                }
            }
        }

        @NotNull
        protected abstract String createExpressionText(@NotNull PsiMethodCallExpression var1, @NotNull PsiMethodCallExpression var2, @NotNull PsiExpression var3);
    }
}

