/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0000\u001a0\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a:\u0010\u0017\u001a\u00020\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u001a\u001a\u00020\u0016*\u00020\u001b2\b\b\u0002\u0010\u0011\u001a\u00020\u001cH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"XML_PROLOG", "", "deleteFile", "", "file", "Ljava/io/File;", "requestor", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "detectLineSeparators", "Lcom/intellij/util/LineSeparator;", "chars", "", "defaultSeparator", "doWrite", "content", "lineSeparator", "prependXmlProlog", "", "isEqualContent", "result", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "writeFile", "element", "Lorg/jdom/Element;", "toBufferExposingByteArray", "Lorg/jdom/Parent;", "", "configuration-store-impl"})
public final class FileBasedStorageKt {
    private static final byte[] XML_PROLOG;

    @NotNull
    public static final VirtualFile writeFile(@Nullable File file2, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull Element element, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if (!(file2 == null || virtualFile != null && virtualFile.isValid())) {
            virtualFile2 = StorageUtil.getOrCreateVirtualFile(requestor, file2);
        } else {
            virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
        }
        VirtualFile result2 = virtualFile2;
        if (ComponentStoreImplKt.getLOG().isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            Parent parent = (Parent)element;
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
            BufferExposingByteArrayOutputStream content = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
            VirtualFile virtualFile3 = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"result");
            if (FileBasedStorageKt.isEqualContent(virtualFile3, lineSeparator, content, prependXmlProlog)) {
                throw (Throwable)new IllegalStateException("Content equals, but it must be handled not on this level: " + result2.getName());
            }
            if (StorageUtil.DEBUG_LOG != null && ApplicationManager.getApplication().isUnitTestMode()) {
                StorageUtil.DEBUG_LOG = result2.getPath() + ":" + "\n" + content + "\n" + "Old Content:" + "\n" + LoadTextUtil.loadText(result2) + "\n" + "---------";
            }
        }
        VirtualFile virtualFile4 = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"result");
        FileBasedStorageKt.doWrite(requestor, virtualFile4, element, lineSeparator, prependXmlProlog);
        VirtualFile virtualFile5 = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"result");
        return virtualFile5;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isEqualContent(VirtualFile result2, LineSeparator lineSeparator, BufferExposingByteArrayOutputStream content, boolean prependXmlProlog) {
        int headerLength;
        int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
        if ((int)result2.getLength() != headerLength + content.size()) {
            return false;
        }
        byte[] oldContent = result2.contentsToByteArray();
        if (!(!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes()))) {
            return false;
        }
        int n2 = headerLength;
        int n3 = oldContent.length - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (oldContent[i] != content.getInternalBuffer()[i - headerLength]) {
                    return false;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final void doWrite(Object requestor, VirtualFile file2, Object content, LineSeparator lineSeparator, boolean prependXmlProlog) {
        void $receiver$iv;
        Logger logger = ComponentStoreImplKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            void var8_6 = $receiver$iv;
            String string = "Save " + file2.getPresentableUrl();
            var8_6.debug(string);
        }
        if (!file2.isWritable()) {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
            if (content instanceof Element) {
                Parent parent = (Parent)content;
                String string = lineSeparator.getSeparatorString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
                bufferExposingByteArrayOutputStream = FileBasedStorageKt.toBufferExposingByteArray(parent, string);
            } else {
                Object object = content;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                }
                bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)object;
            }
            BufferExposingByteArrayOutputStream byteArray = bufferExposingByteArrayOutputStream;
            throw (Throwable)new ReadOnlyModificationException(file2, new StateStorage.SaveSession(requestor, file2, byteArray, lineSeparator, prependXmlProlog){
                final /* synthetic */ Object $requestor;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
                final /* synthetic */ LineSeparator $lineSeparator;
                final /* synthetic */ boolean $prependXmlProlog;

                public final void save() {
                    FileBasedStorageKt.access$doWrite(this.$requestor, this.$file, this.$byteArray, this.$lineSeparator, this.$prependXmlProlog);
                }
                {
                    this.$requestor = object;
                    this.$file = virtualFile;
                    this.$byteArray = bufferExposingByteArrayOutputStream;
                    this.$lineSeparator = lineSeparator;
                    this.$prependXmlProlog = bl;
                }
            });
        }
        ActionsKt.runWriteAction((Function0)new Function0<Unit>(file2, requestor, prependXmlProlog, lineSeparator, content){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Object $requestor;
            final /* synthetic */ boolean $prependXmlProlog;
            final /* synthetic */ LineSeparator $lineSeparator;
            final /* synthetic */ Object $content;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Closeable $receiver$iv = this.$file.getOutputStream(this.$requestor);
                boolean closed$iv = false;
                try {
                    OutputStream out = (OutputStream)$receiver$iv;
                    if (this.$prependXmlProlog) {
                        out.write(FileBasedStorageKt.access$getXML_PROLOG$p());
                        out.write(this.$lineSeparator.getSeparatorBytes());
                    }
                    if (this.$content instanceof Element) {
                        JDOMUtil.writeParent((Parent)((Parent)this.$content), (OutputStream)out, (String)this.$lineSeparator.getSeparatorString());
                    } else {
                        Object object = this.$content;
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                        }
                        ((BufferExposingByteArrayOutputStream)object).writeTo(out);
                    }
                    out = Unit.INSTANCE;
                }
                catch (Exception e$iv) {
                    closed$iv = true;
                    try {
                        $receiver$iv.close();
                    }
                    catch (Exception closeException$iv) {
                        // empty catch block
                    }
                    throw (Throwable)e$iv;
                }
                finally {
                    if (!closed$iv) {
                        $receiver$iv.close();
                    }
                }
            }
            {
                this.$file = virtualFile;
                this.$requestor = object;
                this.$prependXmlProlog = bl;
                this.$lineSeparator = lineSeparator;
                this.$content = object2;
                super(0);
            }
        });
    }

    @NotNull
    public static final BufferExposingByteArrayOutputStream toBufferExposingByteArray(Parent $receiver, @NotNull String lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)$receiver, (OutputStream)((OutputStream)out), (String)lineSeparator);
        return out;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferExposingByteArrayOutputStream toBufferExposingByteArray$default(Parent parent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toBufferExposingByteArray");
        }
        if ((n & 1) != 0) {
            string = "\n";
        }
        return FileBasedStorageKt.toBufferExposingByteArray(parent, string);
    }

    @NotNull
    public static final LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        CharIterator charIterator = StringsKt.iterator((CharSequence)chars);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == '\r') {
                return LineSeparator.CRLF;
            }
            if (c != '\n') continue;
            return LineSeparator.LF;
        }
        LineSeparator lineSeparator = defaultSeparator;
        if (lineSeparator == null) {
            LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
            lineSeparator = lineSeparator2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
        }
        return lineSeparator;
    }

    private static final void deleteFile(File file2, Object requestor, VirtualFile virtualFile) {
        if (virtualFile == null) {
            ComponentStoreImplKt.getLOG().warn("Cannot find virtual file " + file2.getAbsolutePath());
        }
        if (virtualFile == null) {
            if (file2.exists()) {
                FileUtil.delete((File)file2);
            }
        } else if (virtualFile.exists()) {
            if (virtualFile.isWritable()) {
                FileBasedStorageKt.deleteFile(requestor, virtualFile);
            } else {
                throw (Throwable)new ReadOnlyModificationException(virtualFile, new StateStorage.SaveSession(requestor, virtualFile){
                    final /* synthetic */ Object $requestor;
                    final /* synthetic */ VirtualFile $virtualFile;

                    public final void save() {
                        FileBasedStorageKt.deleteFile(this.$requestor, this.$virtualFile);
                    }
                    {
                        this.$requestor = object;
                        this.$virtualFile = virtualFile;
                    }
                });
            }
        }
    }

    public static final void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        ActionsKt.runWriteAction((Function0)new Function0<Unit>(virtualFile, requestor){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Object $requestor;

            public final void invoke() {
                this.$virtualFile.delete(this.$requestor);
            }
            {
                this.$virtualFile = virtualFile;
                this.$requestor = object;
                super(0);
            }
        });
    }

    static {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Charset charset = null;
        boolean bl = true;
        Object var3_3 = null;
        if (var3_3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        XML_PROLOG = byArray;
    }

    public static final /* synthetic */ void access$deleteFile(@NotNull File file2, @NotNull Object requestor, @Nullable VirtualFile virtualFile) {
        FileBasedStorageKt.deleteFile(file2, requestor, virtualFile);
    }

    public static final /* synthetic */ void access$doWrite(@NotNull Object requestor, @NotNull VirtualFile file2, @NotNull Object content, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        FileBasedStorageKt.doWrite(requestor, file2, content, lineSeparator, prependXmlProlog);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getXML_PROLOG$p() {
        return XML_PROLOG;
    }
}

