/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.ProjectFileStorageAnnotation;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0006\u0010 \u001a\u00020\u0012J9\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020\u001eJ\u0006\u0010-\u001a\u00020\u0007J\u000e\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u0007J \u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0004R\u0014\u0010\u0006\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00067"}, d2={"Lcom/intellij/configurationStore/ProjectStoreBase;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "(Lcom/intellij/openapi/project/impl/ProjectImpl;)V", "isDirectoryBased", "", "()Z", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "getProject", "()Lcom/intellij/openapi/project/impl/ProjectImpl;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "getScheme", "()Lcom/intellij/openapi/components/StorageScheme;", "setScheme", "(Lcom/intellij/openapi/components/StorageScheme;)V", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "clearStorages", "", "getProjectBasePath", "", "getProjectFilePath", "getStorageScheme", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Lcom/intellij/openapi/components/State;Lcom/intellij/openapi/components/StateStorageOperation;)[Lcom/intellij/openapi/components/Storage;", "getWorkspaceFilePath", "isOptimiseTestLoadSpeed", "loadProjectFromTemplate", "defaultProject", "Lcom/intellij/openapi/project/Project;", "setOptimiseTestLoadSpeed", "value", "setPath", "filePath", "refreshVfs", "useOldWorkspaceContentIfExists", "configuration-store-impl"})
public abstract class ProjectStoreBase
extends ComponentStoreImpl
implements IProjectStore {
    @NotNull
    private StorageScheme scheme;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final ProjectImpl project;

    @NotNull
    public final StorageScheme getScheme() {
        return this.scheme;
    }

    public final void setScheme(@NotNull StorageScheme storageScheme) {
        Intrinsics.checkParameterIsNotNull((Object)storageScheme, (String)"<set-?>");
        this.scheme = storageScheme;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    @Override
    public final boolean isOptimiseTestLoadSpeed() {
        return Intrinsics.areEqual((Object)((Object)this.loadPolicy), (Object)((Object)StateLoadPolicy.LOAD)) ^ true;
    }

    @Override
    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.scheme;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    protected final boolean isDirectoryBased() {
        return Intrinsics.areEqual((Object)this.scheme, (Object)StorageScheme.DIRECTORY_BASED);
    }

    @Override
    public final void setOptimiseTestLoadSpeed(boolean value) {
        this.loadPolicy = value ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.getStorageManager().expandMacro(ProjectStoreImplKt.PROJECT_FILE);
    }

    @Override
    @NotNull
    public final String getWorkspaceFilePath() {
        return this.getStorageManager().expandMacro("$WORKSPACE_FILE$");
    }

    @Override
    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    @Override
    public final void loadProjectFromTemplate(@NotNull Project defaultProject) {
        Intrinsics.checkParameterIsNotNull((Object)defaultProject, (String)"defaultProject");
        defaultProject.save();
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)defaultProject);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        Element element = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element != null) {
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this.getStorageManager(), ProjectStoreImplKt.PROJECT_FILE, null, null, null, 14, null);
            if (stateStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.XmlElementStorage");
            }
            ((XmlElementStorage)stateStorage).setDefaultState(element);
        }
    }

    @Override
    @NotNull
    public final String getProjectBasePath() {
        String string;
        String path = PathUtilRt.getParentPath((String)this.getProjectFilePath());
        if (Intrinsics.areEqual((Object)this.scheme, (Object)StorageScheme.DEFAULT)) {
            String string2 = path;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        } else {
            String string3 = PathUtilRt.getParentPath((String)path);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtilRt.getParentPath(path)");
        }
        return string;
    }

    protected final void setPath(@NotNull String filePath, boolean refreshVfs, boolean useOldWorkspaceContentIfExists) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (FileUtilRt.extensionEquals((String)filePath, (String)"ipr")) {
            this.scheme = StorageScheme.DEFAULT;
            storageManager2.addMacro(ProjectStoreImplKt.PROJECT_FILE, filePath);
            String workspacePath = ProjectStoreImplKt.access$composeWsPath(filePath);
            storageManager2.addMacro("$WORKSPACE_FILE$", workspacePath);
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<Unit>)((Function0)new Function0<Unit>(fs, filePath, workspacePath){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $filePath;
                    final /* synthetic */ String $workspacePath;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$filePath), this.$fs.refreshAndFindFileByPath(this.$workspacePath)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$filePath = string;
                        this.$workspacePath = string2;
                        super(0);
                    }
                }));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!new File(filePath).exists());
            }
        } else {
            File workspace;
            String string;
            this.scheme = StorageScheme.DIRECTORY_BASED;
            File file2 = new File(filePath);
            boolean isDir = !useOldWorkspaceContentIfExists || file2.isDirectory();
            StringBuilder stringBuilder = new StringBuilder();
            if (isDir) {
                string = filePath;
            } else {
                String string2 = PathUtilRt.getParentPath((String)filePath);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getParentPath(filePath)");
            }
            String configDir = stringBuilder.append(string).append("/").append(".idea").toString();
            storageManager2.addMacro(ProjectStoreImplKt.PROJECT_CONFIG_DIR, configDir);
            storageManager2.addMacro(ProjectStoreImplKt.PROJECT_FILE, configDir + "/misc.xml");
            storageManager2.addMacro("$WORKSPACE_FILE$", configDir + "/workspace.xml");
            if (!isDir && !(workspace = new File(this.getWorkspaceFilePath())).exists()) {
                ProjectStoreImplKt.access$useOldWorkspaceContent(filePath, workspace);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.setOptimiseTestLoadSpeed(!file2.exists());
            }
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed((Function0<Unit>)((Function0)new Function0<Unit>(fs, configDir){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $configDir;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$configDir)});
                    }
                    {
                        this.$fs = localFileSystem;
                        this.$configDir = string;
                        super(0);
                    }
                }));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected <T> Storage[] getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        void $receiver$iv;
        Collection elements$iv;
        ProjectFileStorageAnnotation[] storage2;
        List result2;
        ProjectFileStorageAnnotation[] $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Storage[] storages = stateSpec.storages();
        Object[] objectArray = storages;
        if ($receiver$iv2.length == 0) {
            void elements$iv2;
            $receiver$iv2 = new ProjectFileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
            return (Storage[])((Object[])elements$iv2);
        }
        if (this.isDirectoryBased()) {
            void $receiver$iv3;
            Collection elements$iv3;
            ProjectFileStorageAnnotation[] storage3;
            result2 = null;
            for (int i = 0; i < storages.length; ++i) {
                Unit unit;
                storage3 = storages[i];
                if (Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage3), (Object)ProjectStoreImplKt.PROJECT_FILE) ^ true) {
                    if (result2 == null) {
                        result2 = (List)new SmartList();
                    }
                    result2.add(storage3);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = Unit.INSTANCE;
            }
            if (UtilKt.isNullOrEmpty(result2)) {
                storage3 = new ProjectFileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
                return (Storage[])((Object[])elements$iv3);
            }
            List list = result2;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
            result2.add(ProjectStoreImplKt.getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION());
            elements$iv3 = result2;
            void v2 = $receiver$iv3;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v2;
            Storage[] storageArray = thisCollection$iv.toArray(new Storage[thisCollection$iv.size()]);
            if (storageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return (Storage[])((Object[])storageArray);
        }
        result2 = null;
        boolean hasOnlyDeprecatedStorages = true;
        for (int $i$f$toTypedArray = 0; $i$f$toTypedArray < storages.length; ++$i$f$toTypedArray) {
            Unit unit;
            storage2 = storages[$i$f$toTypedArray];
            if (Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage2), (Object)ProjectStoreImplKt.PROJECT_FILE) || Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage2), (Object)"$WORKSPACE_FILE$")) {
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.add(storage2);
                if (!storage2.deprecated()) {
                    hasOnlyDeprecatedStorages = false;
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = Unit.INSTANCE;
                continue;
            }
            unit = Unit.INSTANCE;
        }
        if (UtilKt.isNullOrEmpty(result2)) {
            storage2 = new ProjectFileStorageAnnotation[]{ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION()};
            return (Storage[])((Object[])elements$iv);
        }
        if (hasOnlyDeprecatedStorages) {
            List list = result2;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        List list = result2;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
        elements$iv = result2;
        void v7 = $receiver$iv;
        if (v7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v7;
        Storage[] storageArray = thisCollection$iv.toArray(new Storage[thisCollection$iv.size()]);
        if (storageArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (Storage[])((Object[])storageArray);
    }

    @Override
    @NotNull
    protected final ProjectImpl getProject() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull ProjectImpl project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.scheme = StorageScheme.DEFAULT;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }
}

