/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.JavaAnnotationHelperForKotlin;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StorageVirtualFileTracker;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \\2\u00020\u0001:\u0004\\]^_B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0006\u0010(\u001a\u00020$J\u000e\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003J\"\u0010+\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\b\b\u0001\u0010-\u001a\u00020.H\u0014J \u0010/\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\u0006\u00100\u001a\u000201H\u0014J:\u00102\u001a\u00020\u00192\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0019042\u0006\u0010,\u001a\u00020\u00032\u0006\u00100\u001a\u0002012\u0010\b\u0001\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020.04H\u0014J\u001a\u00106\u001a\u00020$2\u0006\u00107\u001a\u0002082\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u000e\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u0003J\u0010\u0010;\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0016J2\u0010<\u001a\b\u0012\u0004\u0012\u0002080=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030=2\u0016\b\u0002\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010@JR\u0010<\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002080=\u0012\n\u0012\b\u0012\u0004\u0012\u0002080=0A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00030=2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00030=2\u0016\b\u0002\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010@J\b\u0010D\u001a\u0004\u0018\u00010\u0005J\u0012\u0010D\u001a\u0004\u0018\u00010\u00052\u0006\u0010E\u001a\u00020\u0003H\u0014J \u0010F\u001a\u0004\u0018\u00010\u00192\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00032\u0006\u0010J\u001a\u00020KJ\"\u0010L\u001a\u0004\u0018\u00010\u00032\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00032\u0006\u0010J\u001a\u00020KH\u0014J<\u0010M\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u0002012\u0010\b\u0002\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0019042\u0010\b\u0003\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020.04J\u000e\u0010N\u001a\u00020\u00192\u0006\u0010O\u001a\u00020PJ\n\u0010Q\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010R\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u0003H\u0014J\"\u0010S\u001a\u00020$2\u0006\u0010T\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u00032\b\u0010V\u001a\u0004\u0018\u00010WH\u0016J\u0016\u0010X\u001a\u00020$2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010Y\u001a\u00020\u0003J\u0006\u0010Z\u001a\u00020[R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl;", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "rootTagName", "", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "virtualFileTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "(Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/ComponentManager;Lcom/intellij/configurationStore/StorageVirtualFileTracker;)V", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "isUseVfsListener", "Lcom/intellij/util/ThreeState;", "isUseXmlProlog", "", "()Z", "macros", "", "Lcom/intellij/configurationStore/StateStorageManagerImpl$Macro;", "storageLock", "Ljava/util/concurrent/locks/ReentrantLock;", "storages", "Lgnu/trove/THashMap;", "Lcom/intellij/openapi/components/StateStorage;", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "getStreamProvider", "()Lcom/intellij/configurationStore/StreamProvider;", "setStreamProvider", "(Lcom/intellij/configurationStore/StreamProvider;)V", "addMacro", "key", "expansion", "beforeElementLoaded", "", "element", "Lorg/jdom/Element;", "beforeElementSaved", "clearStorages", "collapseMacros", "path", "createDirectoryBasedStorage", "collapsedPath", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "createFileBasedStorage", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "createStateStorage", "storageClass", "Ljava/lang/Class;", "stateSplitter", "dataLoadedFromProvider", "storage", "Lcom/intellij/configurationStore/FileBasedStorage;", "expandMacro", "macro", "expandMacros", "getCachedFileStorages", "", "fileSpecs", "pathNormalizer", "Lkotlin/Function1;", "Lkotlin/Pair;", "changed", "deleted", "getMacroSubstitutor", "fileSpec", "getOldStorage", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getOldStorageSpec", "getOrCreateStorage", "getStateStorage", "storageSpec", "Lcom/intellij/openapi/components/Storage;", "getVirtualFileTracker", "normalizeFileSpec", "pathRenamed", "oldPath", "newPath", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "rename", "newName", "startExternalization", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager$ExternalizationSession;", "Companion", "Macro", "MyDirectoryStorage", "MyFileStorage", "configuration-store-impl"})
public class StateStorageManagerImpl
implements StateStorageManager {
    private final List<Macro> macros;
    private final ReentrantLock storageLock;
    private final THashMap<String, StateStorage> storages;
    @Nullable
    private StreamProvider streamProvider;
    private ThreeState isUseVfsListener;
    private final String rootTagName;
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;
    @Nullable
    private final ComponentManager componentManager;
    private final StorageVirtualFileTracker virtualFileTracker;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final StreamProvider getStreamProvider() {
        return this.streamProvider;
    }

    public final void setStreamProvider(@Nullable StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    protected boolean isUseXmlProlog() {
        return true;
    }

    @Override
    @Nullable
    public final TrackingPathMacroSubstitutor getMacroSubstitutor() {
        return this.pathMacroSubstitutor;
    }

    @Nullable
    public final StorageVirtualFileTracker getVirtualFileTracker() {
        return this.virtualFileTracker;
    }

    public final boolean addMacro(@NotNull String key2, @NotNull String expansion) {
        String value;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)expansion, (String)"expansion");
        CharSequence $receiver$iv = key2;
        boolean value$iv = !($receiver$iv.length() == 0);
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if (StringsKt.contains$default((CharSequence)expansion, (CharSequence)"\\", (boolean)false, (int)2, null)) {
            String message = "Macro " + key2 + " set to system-dependent expansion " + expansion;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)new IllegalArgumentException(message);
            }
            ComponentStoreImplKt.getLOG().warn(message);
            String string = FileUtilRt.toSystemIndependentName((String)expansion);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.toSystemIndependentName(expansion)");
            value = string;
        } else {
            value = expansion;
        }
        for (Macro macro : this.macros) {
            if (!key2.equals(macro.getKey())) continue;
            macro.setValue(value);
            return false;
        }
        this.macros.add(new Macro(key2, value));
        return true;
    }

    public void pathRenamed(@NotNull String oldPath, @NotNull String newPath, @Nullable VFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)oldPath, (String)"oldPath");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        for (Macro macro : this.macros) {
            if (!oldPath.equals(macro.getValue())) continue;
            macro.setValue(newPath);
        }
    }

    @Override
    @NotNull
    public final StateStorage getStateStorage(@NotNull Storage storageSpec) {
        Intrinsics.checkParameterIsNotNull((Object)storageSpec, (String)"storageSpec");
        String string = StateStorageManagerImplKt.getPath(storageSpec);
        RoamingType roamingType = storageSpec.roamingType();
        Class<? extends StateStorage> clazz = JavaAnnotationHelperForKotlin.getStorageClass(storageSpec);
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"JavaAnnotationHelperForK\u2026StorageClass(storageSpec)");
        Class<? extends StateSplitter> clazz2 = JavaAnnotationHelperForKotlin.getStateSplitterClass(storageSpec);
        Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"JavaAnnotationHelperForK\u2026plitterClass(storageSpec)");
        return this.getOrCreateStorage(string, roamingType, clazz, clazz2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String normalizeFileSpec(@NotNull String fileSpec) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        String path = FileUtilRt.toSystemIndependentName((String)fileSpec);
        if (StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
            void endIndex$iv;
            void startIndex$iv;
            void $receiver$iv;
            String string2 = path;
            boolean bl = false;
            int n = path.length() - 1;
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)v0).substring((int)startIndex$iv, (int)endIndex$iv);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            String string4 = path;
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"path");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final StateStorage getOrCreateStorage(@NotNull String collapsedPath, @NotNull RoamingType roamingType, @NotNull Class<? extends StateStorage> storageClass, @NotNull Class<? extends StateSplitter> stateSplitter) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)collapsedPath, (String)"collapsedPath");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(storageClass, (String)"storageClass");
        Intrinsics.checkParameterIsNotNull(stateSplitter, (String)"stateSplitter");
        String normalizedCollapsedPath = this.normalizeFileSpec(collapsedPath);
        String key2 = Intrinsics.areEqual(storageClass, StateStorage.class) ? normalizedCollapsedPath : storageClass.getName();
        Lock lock = this.storageLock;
        $receiver$iv.lock();
        try {
            StateStorage storage2 = (StateStorage)this.storages.get((Object)key2);
            if (storage2 == null) {
                storage2 = this.createStateStorage(storageClass, normalizedCollapsedPath, roamingType, stateSplitter);
                this.storages.put((Object)key2, (Object)storage2);
            }
            StateStorage stateStorage = storage2;
            return stateStorage;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StateStorage getOrCreateStorage$default(StateStorageManagerImpl stateStorageManagerImpl, String string, RoamingType roamingType, Class clazz, Class clazz2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOrCreateStorage");
        }
        if ((n & 2) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 4) != 0) {
            clazz = StateStorage.class;
        }
        if ((n & 8) != 0) {
            clazz2 = StateSplitterEx.class;
        }
        return stateStorageManagerImpl.getOrCreateStorage(string, roamingType, clazz, clazz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Collection<FileBasedStorage>, Collection<FileBasedStorage>> getCachedFileStorages(@NotNull Collection<String> changed, @NotNull Collection<String> deleted, @Nullable Function1<? super String, String> pathNormalizer) {
        Pair pair;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(changed, (String)"changed");
        Intrinsics.checkParameterIsNotNull(deleted, (String)"deleted");
        Lock lock = this.storageLock;
        $receiver$iv.lock();
        try {
            pair = new Pair(this.getCachedFileStorages(changed, pathNormalizer), this.getCachedFileStorages(deleted, pathNormalizer));
        }
        finally {
            $receiver$iv.unlock();
        }
        return pair;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Pair getCachedFileStorages$default(StateStorageManagerImpl stateStorageManagerImpl, Collection collection, Collection collection2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCachedFileStorages");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return stateStorageManagerImpl.getCachedFileStorages(collection, collection2, (Function1<? super String, String>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<FileBasedStorage> getCachedFileStorages(@NotNull Collection<String> fileSpecs, @Nullable Function1<? super String, String> pathNormalizer) {
        Intrinsics.checkParameterIsNotNull(fileSpecs, (String)"fileSpecs");
        if (fileSpecs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Lock $receiver$iv = this.storageLock;
        $receiver$iv.lock();
        try {
            List result2 = null;
            for (String fileSpec : fileSpecs) {
                String path;
                StateStorage storage2;
                Object object = pathNormalizer;
                if (object == null || (object = (String)object.invoke((Object)fileSpec)) == null) {
                    object = fileSpec;
                }
                if (!((storage2 = (StateStorage)this.storages.get((Object)(path = this.normalizeFileSpec((String)object)))) instanceof FileBasedStorage)) continue;
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.add(storage2);
            }
            List list = result2;
            Collection collection = list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
            return collection;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Collection getCachedFileStorages$default(StateStorageManagerImpl stateStorageManagerImpl, Collection collection, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCachedFileStorages");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return stateStorageManagerImpl.getCachedFileStorages(collection, (Function1<? super String, String>)function1);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected StateStorage createStateStorage(@NotNull Class<? extends StateStorage> storageClass, @NotNull String collapsedPath, @NotNull RoamingType roamingType, @NotNull Class<? extends StateSplitter> stateSplitter) {
        block15: {
            Intrinsics.checkParameterIsNotNull(storageClass, (String)"storageClass");
            Intrinsics.checkParameterIsNotNull((Object)collapsedPath, (String)"collapsedPath");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(stateSplitter, (String)"stateSplitter");
            if (Intrinsics.areEqual(storageClass, StateStorage.class) ^ true) {
                v0 = storageClass.getConstructors()[0];
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                constructor = v0;
                constructor.setAccessible(true);
                v1 = new Object[2];
                v2 = this.componentManager;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                v1[0] = v2;
                v1[1] = this;
                v3 = constructor.newInstance(v1);
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.StateStorage");
                }
                return (StateStorage)v3;
            }
            if (!Intrinsics.areEqual((Object)this.isUseVfsListener, (Object)ThreeState.UNSURE)) break block15;
            if (this.streamProvider == null) ** GOTO lbl-1000
            v4 = this.streamProvider;
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            if (!v4.getEnabled()) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            v6 = ThreeState.fromBoolean((boolean)v5);
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"ThreeState.fromBoolean(s\u2026streamProvider!!.enabled)");
            this.isUseVfsListener = v6;
        }
        filePath = this.expandMacros(collapsedPath);
        if (Intrinsics.areEqual(stateSplitter, StateSplitter.class) ^ true && Intrinsics.areEqual(stateSplitter, StateSplitterEx.class) ^ true) {
            storage = this.createDirectoryBasedStorage(filePath, collapsedPath, (StateSplitter)ReflectionUtil.newInstance(stateSplitter));
            if (storage instanceof StorageVirtualFileTracker.TrackedStorage) {
                v7 = this.virtualFileTracker;
                if (v7 != null) {
                    v7.put(filePath, (StorageVirtualFileTracker.TrackedStorage)storage);
                    v8 = Unit.INSTANCE;
                } else {
                    v8 = null;
                }
            }
            return storage;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && StringsKt.lastIndexOf$default((CharSequence)PathUtilRt.getFileName((String)filePath), (char)'.', (int)0, (boolean)false, (int)6, null) < 0) {
            throw (Throwable)new IllegalArgumentException("Extension is missing for storage file: " + filePath);
        }
        effectiveRoamingType = Intrinsics.areEqual((Object)roamingType, (Object)RoamingType.DEFAULT) != false && Intrinsics.areEqual((Object)collapsedPath, (Object)"$WORKSPACE_FILE$") != false ? RoamingType.DISABLED : roamingType;
        storage = this.createFileBasedStorage(filePath, collapsedPath, effectiveRoamingType);
        if (Intrinsics.areEqual((Object)this.isUseVfsListener, (Object)ThreeState.YES) && storage instanceof StorageVirtualFileTracker.TrackedStorage) {
            v9 = this.virtualFileTracker;
            if (v9 != null) {
                v9.put(filePath, (StorageVirtualFileTracker.TrackedStorage)storage);
                v10 = Unit.INSTANCE;
            } else {
                v10 = null;
            }
        }
        return storage;
    }

    @NotNull
    protected StateStorage createFileBasedStorage(@NotNull String path, @NotNull String collapsedPath, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)collapsedPath, (String)"collapsedPath");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        return new MyFileStorage(this, new File(path), collapsedPath, this.rootTagName, roamingType, this.getMacroSubstitutor(collapsedPath), this.streamProvider);
    }

    @NotNull
    protected StateStorage createDirectoryBasedStorage(@NotNull String path, @NotNull String collapsedPath, @NotNull StateSplitter splitter) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)collapsedPath, (String)"collapsedPath");
        Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(path)");
        return new MyDirectoryStorage(this, path2, splitter);
    }

    protected void beforeElementSaved(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    protected void dataLoadedFromProvider(@NotNull FileBasedStorage storage2, @Nullable Element element) {
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rename(@NotNull String path, @NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Lock $receiver$iv = this.storageLock;
        $receiver$iv.lock();
        try {
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this, this.collapseMacros(path), RoamingType.DEFAULT, null, null, 12, null);
            if (stateStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.FileBasedStorage");
            }
            FileBasedStorage storage2 = (FileBasedStorage)stateStorage;
            VirtualFile file2 = storage2.getVirtualFile();
            try {
                if (file2 != null) {
                    file2.rename((Object)storage2, newName);
                } else if (Intrinsics.areEqual((Object)storage2.getFile().getName(), (Object)newName) ^ true) {
                    String expandedPath = this.expandMacros(path);
                    String parentPath = PathUtilRt.getParentPath((String)expandedPath);
                    storage2.setFile(null, new File(parentPath, newName));
                    this.pathRenamed(expandedPath, parentPath + "/" + newName, null);
                }
            }
            catch (IOException e) {
                ComponentStoreImplKt.getLOG().debug((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearStorages() {
        Lock $receiver$iv = this.storageLock;
        $receiver$iv.lock();
        try {
            try {
                if (this.virtualFileTracker != null) {
                    this.storages.forEachEntry(new TObjectObjectProcedure<K, V>(this){
                        final /* synthetic */ StateStorageManagerImpl this$0;

                        public final boolean execute(String collapsedPath, StateStorage storage2) {
                            StorageVirtualFileTracker storageVirtualFileTracker = StateStorageManagerImpl.access$getVirtualFileTracker$p(this.this$0);
                            String string = collapsedPath;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"collapsedPath");
                            storageVirtualFileTracker.remove(this.this$0.expandMacros(string));
                            return true;
                        }
                        {
                            this.this$0 = stateStorageManagerImpl;
                        }
                    });
                }
            }
            finally {
                this.storages.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    @Nullable
    protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        return this.pathMacroSubstitutor;
    }

    @Override
    @NotNull
    public String expandMacros(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Matcher matcher = StateStorageManagerImplKt.access$getMACRO_PATTERN$p().matcher(path);
        block0: while (matcher.find()) {
            String m = matcher.group(1);
            for (Macro macro : this.macros) {
                if (!Intrinsics.areEqual((Object)macro.getKey(), (Object)m)) continue;
                continue block0;
            }
            throw (Throwable)new IllegalArgumentException("Unknown macro: " + m + " in storage file spec: " + path);
        }
        String expanded = path;
        for (Macro macro : this.macros) {
            String key2 = macro.component1();
            String value = macro.component2();
            Intrinsics.checkExpressionValueIsNotNull((Object)StringUtil.replace((String)expanded, (String)key2, (String)value), (String)"StringUtil.replace(expanded, key, value)");
        }
        return expanded;
    }

    @NotNull
    public final String expandMacro(@NotNull String macro) {
        Intrinsics.checkParameterIsNotNull((Object)macro, (String)"macro");
        for (Macro macro2 : this.macros) {
            String key2 = macro2.component1();
            String value = macro2.component2();
            if (!Intrinsics.areEqual((Object)key2, (Object)macro)) continue;
            return value;
        }
        throw (Throwable)new IllegalArgumentException("Unknown macro " + macro);
    }

    @NotNull
    public final String collapseMacros(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String result2 = path;
        for (Macro macro : this.macros) {
            String key2 = macro.component1();
            String value = macro.component2();
            result2 = StringsKt.replace$default((String)result2, (String)value, (String)key2, (boolean)false, (int)4, null);
        }
        return this.normalizeFileSpec(result2);
    }

    @Override
    @NotNull
    public final StateStorageManager.ExternalizationSession startExternalization() {
        return new StateStorageManager.ExternalizationSession(this){
            private final LinkedHashMap<StateStorage, StateStorage.ExternalizationSession> sessions;
            final /* synthetic */ StateStorageManagerImpl this$0;

            public void setState(@NotNull Storage[] storageSpecs, @NotNull Object component, @NotNull String componentName, @NotNull Object state) {
                Intrinsics.checkParameterIsNotNull((Object)storageSpecs, (String)"storageSpecs");
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Object object = component;
                if (!(object instanceof StateStorageChooserEx)) {
                    object = null;
                }
                StateStorageChooserEx stateStorageChooser = (StateStorageChooserEx)object;
                for (int i = 0; i < storageSpecs.length; ++i) {
                    Unit unit;
                    StateStorageChooserEx.Resolution resolution;
                    Storage storageSpec = storageSpecs[i];
                    if (stateStorageChooser == null) {
                        resolution = StateStorageChooserEx.Resolution.DO;
                    } else {
                        StateStorageChooserEx.Resolution resolution2 = stateStorageChooser.getResolution(storageSpec, StateStorageOperation.WRITE);
                        resolution = resolution2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resolution2, (String)"stateStorageChooser.getR\u2026teStorageOperation.WRITE)");
                    }
                    StateStorageChooserEx.Resolution resolution3 = resolution;
                    if (Intrinsics.areEqual((Object)resolution3, (Object)StateStorageChooserEx.Resolution.SKIP)) continue;
                    StateStorage.ExternalizationSession externalizationSession = this.getExternalizationSession(this.this$0.getStateStorage(storageSpec));
                    if (externalizationSession != null) {
                        externalizationSession.setState(component, componentName, storageSpec.deprecated() || Intrinsics.areEqual((Object)resolution3, (Object)StateStorageChooserEx.Resolution.CLEAR) ? new Element("empty") : state);
                        unit = Unit.INSTANCE;
                        continue;
                    }
                    unit = null;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void setStateInOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull Object state) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                StateStorage stateStorage = this.this$0.getOldStorage(component, componentName, StateStorageOperation.WRITE);
                if (stateStorage != null) {
                    Unit unit2;
                    void $receiver$iv;
                    StateStorage stateStorage2 = stateStorage;
                    StateStorage it = (StateStorage)$receiver$iv;
                    StateStorage.ExternalizationSession externalizationSession = this.getExternalizationSession(it);
                    if (externalizationSession != null) {
                        externalizationSession.setState(component, componentName, state);
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    unit = unit2;
                } else {
                    unit = null;
                }
            }

            private final StateStorage.ExternalizationSession getExternalizationSession(StateStorage storage2) {
                StateStorage.ExternalizationSession session2 = this.sessions.get(storage2);
                if (session2 == null && (session2 = storage2.startExternalization()) != null) {
                    this.sessions.put(storage2, session2);
                }
                return session2;
            }

            @NotNull
            public List<StateStorage.SaveSession> createSaveSessions() {
                if (this.sessions.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                List saveSessions = null;
                Collection<StateStorage.ExternalizationSession> externalizationSessions = this.sessions.values();
                for (StateStorage.ExternalizationSession session2 : externalizationSessions) {
                    StateStorage.SaveSession saveSession = session2.createSaveSession();
                    if (saveSession == null) continue;
                    if (saveSessions == null) {
                        if (externalizationSessions.size() == 1) {
                            return CollectionsKt.listOf((Object)saveSession);
                        }
                        saveSessions = (List)new SmartList();
                    }
                    saveSessions.add(saveSession);
                }
                List list = saveSessions;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
            {
                this.this$0 = $outer;
                this.sessions = new LinkedHashMap<K, V>();
            }
        };
    }

    @Override
    @Nullable
    public final StateStorage getOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        String string = this.getOldStorageSpec(component, componentName, operation);
        if (string == null) {
            return null;
        }
        String oldStorageSpec = string;
        return StateStorageManagerImpl.getOrCreateStorage$default(this, oldStorageSpec, component instanceof RoamingTypeDisabled ? RoamingType.DISABLED : RoamingType.DEFAULT, null, null, 12, null);
    }

    @Nullable
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        return null;
    }

    @Nullable
    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public StateStorageManagerImpl(@NotNull String rootTagName, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @Nullable ComponentManager componentManager, @Nullable StorageVirtualFileTracker virtualFileTracker) {
        Intrinsics.checkParameterIsNotNull((Object)rootTagName, (String)"rootTagName");
        this.rootTagName = rootTagName;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        this.componentManager = componentManager;
        this.virtualFileTracker = virtualFileTracker;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLockFreeCopyOnWriteList()");
        this.macros = list;
        this.storageLock = new ReentrantLock();
        this.storages = new THashMap();
        this.isUseVfsListener = this.componentManager == null ? ThreeState.NO : ThreeState.UNSURE;
    }

    public /* synthetic */ StateStorageManagerImpl(String string, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, ComponentManager componentManager, StorageVirtualFileTracker storageVirtualFileTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 4) != 0) {
            componentManager = null;
        }
        if ((n & 8) != 0) {
            storageVirtualFileTracker = StateStorageManagerImpl.Companion.createDefaultVirtualTracker(componentManager);
        }
        this(string, trackingPathMacroSubstitutor, componentManager, storageVirtualFileTracker);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$Macro;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "setValue", "(Ljava/lang/String;)V", "component1", "component2", "copy", "configuration-store-impl"})
    private static final class Macro {
        @NotNull
        private final String key;
        @NotNull
        private String value;

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.value = string;
        }

        public Macro(@NotNull String key2, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.key = key2;
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final Macro copy(@NotNull String key2, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new Macro(key2, value);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Macro copy$default(Macro macro, String string, String string2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                string = macro.key;
            }
            if ((n & 2) != 0) {
                string2 = macro.value;
            }
            return macro.copy(string, string2);
        }

        public String toString() {
            return "Macro(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.key;
            String string2 = this.value;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Macro)) break block3;
                    Macro macro = (Macro)object;
                    if (!Intrinsics.areEqual((Object)this.key, (Object)macro.key) || !Intrinsics.areEqual((Object)this.value, (Object)macro.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$MyDirectoryStorage;", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "file", "Ljava/nio/file/Path;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "(Lcom/intellij/configurationStore/StateStorageManagerImpl;Ljava/nio/file/Path;Lcom/intellij/openapi/components/StateSplitter;)V", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "configuration-store-impl"})
    private static final class MyDirectoryStorage
    extends DirectoryBasedStorage
    implements StorageVirtualFileTracker.TrackedStorage {
        @NotNull
        private final StateStorageManagerImpl storageManager;

        @Override
        @NotNull
        public StateStorageManagerImpl getStorageManager() {
            return this.storageManager;
        }

        public MyDirectoryStorage(@NotNull StateStorageManagerImpl storageManager2, @NotNull Path file2, @NotNull StateSplitter splitter) {
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
            super(file2, splitter, storageManager2.pathMacroSubstitutor);
            this.storageManager = storageManager2;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0012\u0010\u001b\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0014\u0010\u0011\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$MyFileStorage;", "Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "file", "Ljava/io/File;", "fileSpec", "", "rootElementName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathMacroManager", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Lcom/intellij/configurationStore/StateStorageManagerImpl;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/configurationStore/StreamProvider;)V", "isUseXmlProlog", "", "()Z", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "beforeElementLoaded", "", "element", "Lorg/jdom/Element;", "beforeElementSaved", "dataLoadedFromProvider", "configuration-store-impl"})
    private static final class MyFileStorage
    extends FileBasedStorage
    implements StorageVirtualFileTracker.TrackedStorage {
        @NotNull
        private final StateStorageManagerImpl storageManager;

        @Override
        protected boolean isUseXmlProlog() {
            return this.getStorageManager().isUseXmlProlog();
        }

        @Override
        protected void beforeElementSaved(@NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.getStorageManager().beforeElementSaved(element);
            super.beforeElementSaved(element);
        }

        @Override
        protected void beforeElementLoaded(@NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.getStorageManager().beforeElementLoaded(element);
            super.beforeElementLoaded(element);
        }

        @Override
        protected void dataLoadedFromProvider(@Nullable Element element) {
            this.getStorageManager().dataLoadedFromProvider(this, element);
        }

        @Override
        @NotNull
        public StateStorageManagerImpl getStorageManager() {
            return this.storageManager;
        }

        public MyFileStorage(@NotNull StateStorageManagerImpl storageManager2, @NotNull File file2, @NotNull String fileSpec, @NotNull String rootElementName, @NotNull RoamingType roamingType, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @Nullable StreamProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            super(file2, fileSpec, rootElementName, pathMacroManager, roamingType, provider);
            this.storageManager = storageManager2;
        }

        public /* synthetic */ MyFileStorage(StateStorageManagerImpl stateStorageManagerImpl, File file2, String string, String string2, RoamingType roamingType, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                trackingPathMacroSubstitutor = null;
            }
            if ((n & 0x40) != 0) {
                streamProvider = null;
            }
            this(stateStorageManagerImpl, file2, string, string2, roamingType, trackingPathMacroSubstitutor, streamProvider);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$Companion;", "", "()V", "createDefaultVirtualTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "configuration-store-impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final StorageVirtualFileTracker createDefaultVirtualTracker(ComponentManager componentManager) {
            StorageVirtualFileTracker storageVirtualFileTracker;
            ComponentManager componentManager2 = componentManager;
            if (Intrinsics.areEqual((Object)componentManager2, null)) {
                storageVirtualFileTracker = null;
            } else if (componentManager2 instanceof Application) {
                MessageBus messageBus = ((Application)componentManager).getMessageBus();
                Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"componentManager.messageBus");
                storageVirtualFileTracker = new StorageVirtualFileTracker(messageBus);
            } else {
                void var3_3;
                StorageVirtualFileTracker tracker;
                StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
                if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
                    stateStorageManager = null;
                }
                StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
                StorageVirtualFileTracker storageVirtualFileTracker2 = tracker = stateStorageManagerImpl != null ? stateStorageManagerImpl.virtualFileTracker : null;
                if (tracker != null) {
                    Disposer.register((Disposable)((Disposable)componentManager), (Disposable)new Disposable(tracker, componentManager){
                        final /* synthetic */ StorageVirtualFileTracker $tracker;
                        final /* synthetic */ ComponentManager $componentManager;

                        public final void dispose() {
                            this.$tracker.remove((Function1<? super StorageVirtualFileTracker.TrackedStorage, Boolean>)((Function1)new Function1<StorageVirtualFileTracker.TrackedStorage, Boolean>(this){
                                final /* synthetic */ createDefaultVirtualTracker.1 this$0;

                                public final boolean invoke(@NotNull StorageVirtualFileTracker.TrackedStorage it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    return Intrinsics.areEqual((Object)it.getStorageManager().getComponentManager(), (Object)this.this$0.$componentManager);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }));
                        }
                        {
                            this.$tracker = storageVirtualFileTracker;
                            this.$componentManager = componentManager;
                        }
                    });
                }
                storageVirtualFileTracker = var3_3;
            }
            return storageVirtualFileTracker;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

