/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\bJ\u001a\u0010\u0012\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0014J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "(Lcom/intellij/util/messages/MessageBus;)V", "filePathToStorage", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "hasDirectoryBasedStorages", "", "vfsListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addVfsChangesListener", "", "put", "path", "storage", "remove", "processor", "Lkotlin/Function1;", "TrackedStorage", "configuration-store-impl"})
public final class StorageVirtualFileTracker {
    private final ConcurrentMap<String, TrackedStorage> filePathToStorage;
    private volatile boolean hasDirectoryBasedStorages;
    private final AtomicBoolean vfsListenerAdded;
    private final MessageBus messageBus;

    public final void put(@NotNull String path, @NotNull TrackedStorage storage2) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        this.filePathToStorage.put(path, storage2);
        if (storage2 instanceof DirectoryBasedStorage) {
            this.hasDirectoryBasedStorages = true;
        }
        if (this.vfsListenerAdded.compareAndSet(false, true)) {
            this.addVfsChangesListener();
        }
    }

    public final void remove(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.filePathToStorage.remove(path);
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(@NotNull Function1<? super TrackedStorage, Boolean> processor2) {
        void $receiver$iv;
        Iterator iterator;
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Iterator iterator2 = iterator = this.filePathToStorage.values().iterator();
        void var4_4 = $receiver$iv;
        while (var4_4.hasNext()) {
            TrackedStorage storage2;
            TrackedStorage trackedStorage = storage2 = (TrackedStorage)var4_4.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)trackedStorage, (String)"storage");
            if (!((Boolean)processor2.invoke((Object)trackedStorage)).booleanValue()) continue;
            iterator.remove();
        }
    }

    private final void addVfsChangesListener() {
        this.messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(this){
            final /* synthetic */ StorageVirtualFileTracker this$0;

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    ComponentManager componentManager;
                    String path;
                    StateStorage storage2;
                    if (vFileEvent instanceof VFilePropertyChangeEvent && "name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        String oldPath = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).remove(oldPath);
                        if (storage2 != null) {
                            StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).put(((VFilePropertyChangeEvent)vFileEvent).getPath(), storage2);
                            if (storage2 instanceof FileBasedStorage) {
                                ((FileBasedStorage)storage2).setFile(null, new File(((VFilePropertyChangeEvent)vFileEvent).getPath()));
                            }
                            StateStorageManagerImpl stateStorageManagerImpl = ((TrackedStorage)storage2).getStorageManager();
                            String string = oldPath;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldPath");
                            String string2 = ((VFilePropertyChangeEvent)vFileEvent).getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"event.path");
                            stateStorageManagerImpl.pathRenamed(string, string2, vFileEvent);
                        }
                    } else {
                        path = vFileEvent.getPath();
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).get(path);
                        if (storage2 == null && StorageVirtualFileTracker.access$getHasDirectoryBasedStorages$p(this.this$0) && StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)".xml")) {
                            storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).get(VfsUtil.getParentDir((String)path));
                        }
                    }
                    if (storage2 == null) continue;
                    path = vFileEvent;
                    if (path instanceof VFileMoveEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, new File(((VFileMoveEvent)vFileEvent).getPath()));
                        }
                    } else if (path instanceof VFileCreateEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(((VFileCreateEvent)vFileEvent).getFile(), null);
                        }
                    } else if (path instanceof VFileDeleteEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, null);
                        } else {
                            StateStorage stateStorage = storage2;
                            if (stateStorage == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DirectoryBasedStorage");
                            }
                            ((DirectoryBasedStorage)stateStorage).setVirtualDir$configuration_store_impl(null);
                        }
                    } else if (path instanceof VFileCopyEvent) continue;
                    if (((TrackedStorage)storage2).getStorageManager().getComponentManager() == null) {
                        Intrinsics.throwNpe();
                    }
                    ((StateStorageManager.IStorageManagerListener)componentManager.getMessageBus().syncPublisher(StateStorageManager.STORAGE_TOPIC)).storageFileChanged(vFileEvent, storage2, componentManager);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public StorageVirtualFileTracker(@NotNull MessageBus messageBus) {
        Intrinsics.checkParameterIsNotNull((Object)messageBus, (String)"messageBus");
        this.messageBus = messageBus;
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.filePathToStorage = concurrentMap;
        this.vfsListenerAdded = new AtomicBoolean();
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap access$getFilePathToStorage$p(StorageVirtualFileTracker $this) {
        return $this.filePathToStorage;
    }

    public static final /* synthetic */ boolean access$getHasDirectoryBasedStorages$p(StorageVirtualFileTracker $this) {
        return $this.hasDirectoryBasedStorages;
    }

    public static final /* synthetic */ void access$setHasDirectoryBasedStorages$p(StorageVirtualFileTracker $this, boolean bl) {
        $this.hasDirectoryBasedStorages = bl;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "Lcom/intellij/openapi/components/StateStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "configuration-store-impl"})
    public static interface TrackedStorage
    extends StateStorage {
        @NotNull
        public StateStorageManagerImpl getStorageManager();
    }
}

