/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmSmartStepIntoActionHandler
extends DebuggerActionHandler {
    @Override
    public void perform(@NotNull Project project2, AnActionEvent event) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "perform"));
        }
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession session2 = debuggerContext.getDebuggerSession();
        if (session2 != null) {
            JvmSmartStepIntoActionHandler.doStep(project2, debuggerContext.getSourcePosition(), session2);
        }
    }

    private static void doStep(@NotNull Project project2, @Nullable SourcePosition position, @NotNull DebuggerSession session2) {
        FileEditor fileEditor;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "doStep"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "doStep"));
        }
        VirtualFile file2 = position != null ? position.getFile().getVirtualFile() : null;
        FileEditor fileEditor2 = fileEditor = file2 != null ? FileEditorManager.getInstance((Project)project2).getSelectedEditor(file2) : null;
        if (fileEditor instanceof TextEditor) {
            for (JvmSmartStepIntoHandler handler2 : (JvmSmartStepIntoHandler[])Extensions.getExtensions(JvmSmartStepIntoHandler.EP_NAME)) {
                if (!handler2.isAvailable(position) || !handler2.doSmartStep(position, session2, (TextEditor)fileEditor)) continue;
                return;
            }
        }
        session2.sessionResumed();
        session2.stepInto(true, null);
    }

    @Override
    public boolean isEnabled(@NotNull Project project2, AnActionEvent event) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/actions/JvmSmartStepIntoActionHandler", "isEnabled"));
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession debuggerSession = context.getDebuggerSession();
        boolean isPaused = debuggerSession != null && debuggerSession.isPaused();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        boolean hasCurrentThread = suspendContext != null && suspendContext.getThread() != null;
        return isPaused && hasCurrentThread;
    }
}

