/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorAction
extends AnAction {
    private final AnAction myOrigin;
    private final Executor myExecutor;
    private final int myOrder;

    @NotNull
    public static AnAction[] getActions(int order) {
        AnAction[] anActionArray = (AnAction[])ContainerUtil.map2Array((Object[])ExecutorRegistry.getInstance().getRegisteredExecutors(), AnAction.class, executor -> new ExecutorAction(ActionManager.getInstance().getAction(executor.getContextActionId()), (Executor)executor, order));
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/ExecutorAction", "getActions"));
        }
        return anActionArray;
    }

    private ExecutorAction(@NotNull AnAction origin, @NotNull Executor executor, int order) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/execution/lineMarker/ExecutorAction", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/lineMarker/ExecutorAction", "<init>"));
        }
        this.myOrigin = origin;
        this.myExecutor = executor;
        this.myOrder = order;
        this.copyFrom(origin);
    }

    public void update(AnActionEvent e) {
        String name = this.getActionName(e.getDataContext(), this.myExecutor);
        e.getPresentation().setVisible(name != null);
        e.getPresentation().setText(name);
    }

    public void actionPerformed(AnActionEvent e) {
        this.myOrigin.actionPerformed(e);
    }

    private String getActionName(DataContext dataContext, @NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/lineMarker/ExecutorAction", "getActionName"));
        }
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        if (context.getLocation() == null) {
            return null;
        }
        List producers = RunConfigurationProducer.getProducers((Project)context.getProject());
        List list = ContainerUtil.mapNotNull((Collection)producers, producer -> ExecutorAction.createConfiguration(producer, context));
        if (list.isEmpty()) {
            return null;
        }
        ConfigurationFromContext configuration = (ConfigurationFromContext)list.get(this.myOrder < list.size() ? this.myOrder : 0);
        String actionName = BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration.getConfiguration());
        return executor.getStartActionText(actionName);
    }

    @Nullable
    private static ConfigurationFromContext createConfiguration(RunConfigurationProducer<?> producer, ConfigurationContext context) {
        RunConfiguration configuration = producer.createLightConfiguration(context);
        if (configuration == null) {
            return null;
        }
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.getInstanceImpl(context.getProject()), configuration, false);
        return new ConfigurationFromContextImpl(producer, (RunnerAndConfigurationSettings)settings, context.getPsiLocation());
    }
}

