/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeNodeDescriptor
extends PresentableNodeDescriptor<AbstractTreeNode> {
    private final AbstractTreeNode myElement;
    public static final FavoritesTreeNodeDescriptor[] EMPTY_ARRAY = new FavoritesTreeNodeDescriptor[0];

    public FavoritesTreeNodeDescriptor(Project project2, NodeDescriptor parentDescriptor, AbstractTreeNode element) {
        super(project2, parentDescriptor);
        this.myElement = element;
    }

    protected void update(PresentationData presentation) {
        this.myElement.update();
        presentation.copyFrom(this.myElement.getPresentation());
    }

    public String getLocation() {
        return FavoritesTreeNodeDescriptor.getLocation(this.myElement, this.myProject);
    }

    public static String getLocation(AbstractTreeNode element, @NotNull Project project2) {
        FavoriteNodeProvider[] nodeProviders;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesTreeNodeDescriptor", "getLocation"));
        }
        Object nodeElement = element.getValue();
        if (nodeElement instanceof SmartPsiElementPointer) {
            nodeElement = ((SmartPsiElementPointer)nodeElement).getElement();
        }
        if (nodeElement instanceof PsiElement) {
            if (nodeElement instanceof PsiDirectory) {
                return VfsUtilCore.getRelativeLocation((VirtualFile)((PsiDirectory)nodeElement).getVirtualFile(), (VirtualFile)project2.getBaseDir());
            }
            if (nodeElement instanceof PsiFile) {
                PsiFile containingFile = (PsiFile)nodeElement;
                return VfsUtilCore.getRelativeLocation((VirtualFile)containingFile.getVirtualFile(), (VirtualFile)project2.getBaseDir());
            }
        }
        if (nodeElement instanceof LibraryGroupElement) {
            return ((LibraryGroupElement)nodeElement).getModule().getName();
        }
        if (nodeElement instanceof NamedLibraryElement) {
            NamedLibraryElement namedLibraryElement = (NamedLibraryElement)nodeElement;
            Module module2 = namedLibraryElement.getModule();
            return (module2 != null ? module2.getName() : "") + ":" + namedLibraryElement.getOrderEntry().getPresentableName();
        }
        if (nodeElement instanceof File) {
            return VfsUtilCore.getRelativeLocation((VirtualFile)VfsUtil.findFileByIoFile((File)((File)nodeElement), (boolean)false), (VirtualFile)project2.getBaseDir());
        }
        for (FavoriteNodeProvider provider : nodeProviders = (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project2)) {
            String location = provider.getElementLocation(nodeElement);
            if (location == null) continue;
            return location;
        }
        return null;
    }

    public AbstractTreeNode getElement() {
        return this.myElement;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FavoritesTreeNodeDescriptor)) {
            return false;
        }
        return ((FavoritesTreeNodeDescriptor)((Object)object)).getElement().equals((Object)this.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @Nullable
    public FavoritesTreeNodeDescriptor getFavoritesRoot() {
        FavoritesTreeNodeDescriptor descriptor = this;
        while (descriptor != null && descriptor.getParentDescriptor() instanceof FavoritesTreeNodeDescriptor) {
            FavoritesTreeNodeDescriptor parent = (FavoritesTreeNodeDescriptor)descriptor.getParentDescriptor();
            if (parent != null && parent.getParentDescriptor() == null) {
                return descriptor;
            }
            descriptor = parent;
        }
        return descriptor;
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return this.myElement.getChildToHighlightAt(index);
    }
}

