/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;

public final class OutputPathMacro
extends Macro {
    @Override
    public String getName() {
        return "OutputPath";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.output.path", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        ProjectFileIndex projectFileIndex;
        Module module2;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file2 != null && (module2 = (projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex()).getModuleForFile(file2)) != null) {
            String outputPathUrl;
            boolean isTest = projectFileIndex.isInTestSourceContent(file2);
            String string = outputPathUrl = isTest ? CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputUrlForTests() : CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputUrl();
            if (outputPathUrl == null) {
                return null;
            }
            return VirtualFileManager.extractPath((String)outputPathUrl).replace('/', File.separatorChar);
        }
        Module[] allModules = ModuleManager.getInstance((Project)project2).getSortedModules();
        if (allModules.length == 0) {
            return null;
        }
        String[] paths = CompilerPathsEx.getOutputPaths((Module[])allModules);
        StringBuffer outputPath = new StringBuffer();
        for (int idx = 0; idx < paths.length; ++idx) {
            String path = paths[idx];
            if (idx > 0) {
                outputPath.append(File.pathSeparator);
            }
            outputPath.append(path);
        }
        return outputPath.toString();
    }
}

