/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class DetectedRootsChooser {
    private static final int CHECKBOX_COLUMN_WIDTH = new JCheckBox().getPreferredSize().width + 4;
    private final ColumnInfo<DetectedRootData, Boolean> myIncludedColumn = new ColumnInfo<DetectedRootData, Boolean>(""){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.isIncluded();
        }

        public boolean isCellEditable(DetectedRootData detectedRootData) {
            return true;
        }

        public int getWidth(JTable table) {
            return CHECKBOX_COLUMN_WIDTH;
        }

        public void setValue(DetectedRootData detectedRootData, Boolean value) {
            if (value.booleanValue() != detectedRootData.isIncluded()) {
                detectedRootData.setIncluded(value);
                ((RootSelectionListener)DetectedRootsChooser.this.myDispatcher.getMulticaster()).selectionChanged();
            }
        }
    };
    private static final ColumnInfo<DetectedRootData, String> ROOT_COLUMN = new ColumnInfo<DetectedRootData, String>(""){

        public String valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.getDirectory().getAbsolutePath();
        }
    };
    private static final ColumnInfo<DetectedRootData, DetectedProjectRoot> ROOT_TYPE_COLUMN = new ColumnInfo<DetectedRootData, DetectedProjectRoot>(""){

        public DetectedProjectRoot valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.getSelectedRoot();
        }

        public TableCellRenderer getRenderer(DetectedRootData detectedRootData) {
            if (this.isCellEditable(detectedRootData)) {
                return new ComboBoxTableRenderer<DetectedProjectRoot>(detectedRootData.getAllRoots()){

                    protected String getTextFor(@NotNull DetectedProjectRoot value) {
                        if (value == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/importProject/DetectedRootsChooser$3$1", "getTextFor"));
                        }
                        return value.getRootTypeName();
                    }
                };
            }
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof DetectedProjectRoot) {
                        this.setText(((DetectedProjectRoot)value).getRootTypeName());
                    }
                    return component;
                }
            };
        }

        public TableCellEditor getEditor(DetectedRootData o) {
            ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(o.getAllRoots()), (Object)o.getSelectedRoot()));
            comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DetectedProjectRoot>(){

                public void customize(JList list, DetectedProjectRoot value, int index, boolean selected, boolean hasFocus) {
                    this.setText(value.getRootTypeName());
                }
            });
            return new DefaultCellEditor((JComboBox<?>)comboBox);
        }

        public boolean isCellEditable(DetectedRootData detectedRootData) {
            return detectedRootData.getAllRoots().length > 1;
        }

        public void setValue(DetectedRootData detectedRootData, DetectedProjectRoot value) {
            detectedRootData.setSelectedRoot(value);
        }
    };
    private TableView<DetectedRootData> myTable;
    private JComponent myComponent;
    private final ListTableModel<DetectedRootData> myModel;
    private final EventDispatcher<RootSelectionListener> myDispatcher = EventDispatcher.create(RootSelectionListener.class);

    public DetectedRootsChooser() {
        this.myModel = new ListTableModel(new ColumnInfo[0]);
        this.myTable = new TableView(this.myModel);
        this.myTable.setTableHeader(null);
        this.myTable.setShowGrid(false);
        this.myComponent = ScrollPaneFactory.createScrollPane(this.myTable);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetectedRootsChooser.this.invertSelectedRows();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private void invertSelectedRows() {
        int[] selectedRows = this.myTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        boolean included = false;
        for (int selectedRow : selectedRows) {
            included |= ((DetectedRootData)this.myModel.getItems().get(selectedRow)).isIncluded();
        }
        int first = Integer.MAX_VALUE;
        int last = -1;
        for (int selectedRow : selectedRows) {
            first = Math.min(first, selectedRow);
            last = Math.max(last, selectedRow);
            ((DetectedRootData)this.myModel.getItems().get(selectedRow)).setIncluded(!included);
        }
        this.myModel.fireTableRowsUpdated(first, last + 1);
        ((RootSelectionListener)this.myDispatcher.getMulticaster()).selectionChanged();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void addSelectionListener(RootSelectionListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void setAllElementsMarked(boolean mark) {
        for (DetectedRootData data : this.myModel.getItems()) {
            data.setIncluded(mark);
        }
        this.myModel.fireTableRowsUpdated(0, this.myModel.getRowCount() - 1);
        ((RootSelectionListener)this.myDispatcher.getMulticaster()).selectionChanged();
    }

    public List<DetectedRootData> getMarkedElements() {
        ArrayList<DetectedRootData> result2 = new ArrayList<DetectedRootData>();
        for (DetectedRootData data : this.myModel.getItems()) {
            if (!data.isIncluded()) continue;
            result2.add(data);
        }
        return result2;
    }

    public void setElements(List<? extends DetectedRootData> roots) {
        HashSet<String> rootTypes = new HashSet<String>();
        for (DetectedRootData detectedRootData : roots) {
            for (DetectedProjectRoot projectRoot : detectedRootData.getAllRoots()) {
                rootTypes.add(projectRoot.getRootTypeName());
            }
        }
        this.myModel.setColumnInfos(new ColumnInfo[]{this.myIncludedColumn, ROOT_COLUMN, ROOT_TYPE_COLUMN});
        int max = 0;
        for (String rootType : rootTypes) {
            max = Math.max(max, this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(rootType));
        }
        TableColumn tableColumn = this.myTable.getColumnModel().getColumn(2);
        int width = max + 20;
        tableColumn.setPreferredWidth(width);
        tableColumn.setMaxWidth(width);
        this.myTable.updateColumnSizes();
        ArrayList<? extends DetectedRootData> sortedRoots = new ArrayList<DetectedRootData>(roots);
        Collections.sort(sortedRoots, (o1, o2) -> o1.getDirectory().compareTo(o2.getDirectory()));
        this.myModel.setItems(sortedRoots);
    }

    static interface RootSelectionListener
    extends EventListener {
        public void selectionChanged();
    }
}

