/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class BackwardParagraphAction
extends EditorAction {
    public BackwardParagraphAction() {
        super((EditorActionHandler)new MyHandler());
    }

    private static class MyHandler
    extends EditorActionHandler {
        private MyHandler() {
            super(true);
        }

        protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            boolean atLineStart;
            assert (caret != null);
            Document document2 = editor.getDocument();
            int currentLine = caret.getLogicalPosition().line;
            boolean bl = atLineStart = caret.getLogicalPosition().column == 0;
            if (MyHandler.isLineEmpty(document2, currentLine) || atLineStart) {
                while (--currentLine >= 0 && MyHandler.isLineEmpty(document2, currentLine)) {
                }
            }
            while (--currentLine >= 0 && !MyHandler.isLineEmpty(document2, currentLine)) {
            }
            int targetOffset = 0;
            if (currentLine >= 0) {
                int targetLineEnd;
                int targetLineStart = document2.getLineStartOffset(currentLine);
                targetOffset = targetLineStart == (targetLineEnd = document2.getLineEndOffset(currentLine)) ? targetLineStart : document2.getLineStartOffset(currentLine + 1);
            }
            caret.removeSelection();
            caret.moveToOffset(targetOffset);
            EditorModificationUtil.scrollToCaret((Editor)editor);
        }

        private static boolean isLineEmpty(Document document2, int line) {
            return StringUtil.equalsIgnoreWhitespaces((CharSequence)document2.getImmutableCharSequence().subSequence(document2.getLineStartOffset(line), document2.getLineEndOffset(line)), (CharSequence)"");
        }
    }
}

