/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiBasedStripTrailingSpacesFilter
implements StripTrailingSpacesFilter {
    @NotNull
    private final BitSet myDisabledLinesBitSet;
    @NotNull
    private final Document myDocument;
    private static Logger LOG = Logger.getInstance((String)("#" + PsiBasedStripTrailingSpacesFilter.class.getName()));

    protected PsiBasedStripTrailingSpacesFilter(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "<init>"));
        }
        this.myDocument = document2;
        this.myDisabledLinesBitSet = new BitSet(document2.getLineCount());
    }

    public boolean isStripSpacesAllowedForLine(int line) {
        return !this.myDisabledLinesBitSet.get(line);
    }

    protected abstract void process(@NotNull PsiFile var1);

    @Nullable
    private static Language getDocumentLanguage(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "getDocumentLanguage"));
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file2 = manager.getFile(document2);
        if (file2 != null && file2.isValid()) {
            return LanguageUtil.getFileLanguage((VirtualFile)file2);
        }
        return null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Project project2, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "getPsiFile"));
        }
        if (project2 != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            if (documentManager.isCommitted(document2)) {
                return documentManager.getCachedPsiFile(document2);
            }
        } else {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            LOG.warn("No current project is given, trailing spaces will be stripped later (postponed). File: " + (virtualFile != null ? virtualFile.getCanonicalPath() : "undefined"));
        }
        return null;
    }

    protected final void disableRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter", "disableRange"));
        }
        int startLine = this.myDocument.getLineNumber(range.getStartOffset());
        int endLine = this.myDocument.getLineNumber(range.getEndOffset());
        this.myDisabledLinesBitSet.set(startLine, endLine);
    }

    public static abstract class Factory
    extends StripTrailingSpacesFilterFactory {
        @NotNull
        public final StripTrailingSpacesFilter createFilter(@Nullable Project project2, @NotNull Document document2) {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
            }
            Language language = PsiBasedStripTrailingSpacesFilter.getDocumentLanguage(document2);
            if (language != null && this.isApplicableTo(language)) {
                PsiFile psiFile = PsiBasedStripTrailingSpacesFilter.getPsiFile(project2, document2);
                if (psiFile != null) {
                    PsiBasedStripTrailingSpacesFilter filter = this.createFilter(document2);
                    filter.process(psiFile);
                    PsiBasedStripTrailingSpacesFilter psiBasedStripTrailingSpacesFilter = filter;
                    if (psiBasedStripTrailingSpacesFilter == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
                    }
                    return psiBasedStripTrailingSpacesFilter;
                }
                StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.POSTPONED;
                if (stripTrailingSpacesFilter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
                }
                return stripTrailingSpacesFilter;
            }
            StripTrailingSpacesFilter stripTrailingSpacesFilter = StripTrailingSpacesFilter.ALL_LINES;
            if (stripTrailingSpacesFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesFilter$Factory", "createFilter"));
            }
            return stripTrailingSpacesFilter;
        }

        @NotNull
        protected abstract PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document var1);

        protected abstract boolean isApplicableTo(@NotNull Language var1);
    }
}

