/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentManagerImpl
extends FileDocumentManager
implements VirtualFileListener,
ProjectManagerListener,
SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create((String)"HARD_REF_TO_DOCUMENT_KEY");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create((String)"Must recompute file type");
    private final Set<Document> myUnsavedDocuments;
    private final MessageBus myBus;
    private static final Object lock = new Object();
    private final FileDocumentManagerListener myMultiCaster;
    private final TrailingSpacesStripper myTrailingSpacesStripper;
    private boolean myOnClose;
    private volatile PairProcessor<VirtualFile, Document> askReloadFromDisk;
    private final Map<VirtualFile, Document> myDocumentCache;

    public FileDocumentManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull ProjectManager projectManager) {
        if (virtualFileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileManager", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "<init>"));
        }
        if (projectManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectManager", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "<init>"));
        }
        this.myUnsavedDocuments = ContainerUtil.newConcurrentSet();
        this.myTrailingSpacesStripper = new TrailingSpacesStripper();
        this.askReloadFromDisk = (file2, document2) -> {
            String message = UIBundle.message((String)"file.cache.conflict.message.text", (Object[])new Object[]{file2.getPresentableUrl()});
            DialogBuilder builder = new DialogBuilder();
            builder.setCenterPanel((JComponent)new JLabel(message, Messages.getQuestionIcon(), 0));
            builder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.load.fs.changes.button", (Object[])new Object[0]));
            builder.addCancelAction().setText(UIBundle.message((String)"file.cache.conflict.keep.memory.changes.button", (Object[])new Object[0]));
            builder.addAction((Action)new AbstractAction(UIBundle.message((String)"file.cache.conflict.show.difference.button", (Object[])new Object[0]), (VirtualFile)file2, (Document)document2, builder){
                final /* synthetic */ VirtualFile val$file;
                final /* synthetic */ Document val$document;
                final /* synthetic */ DialogBuilder val$builder;
                {
                    this.val$file = virtualFile;
                    this.val$document = document2;
                    this.val$builder = dialogBuilder;
                    super(x0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectEx project2 = (ProjectEx)ProjectLocator.getInstance().guessProjectForFile(this.val$file);
                    FileType fileType = this.val$file.getFileType();
                    String fsContent = LoadTextUtil.loadText(this.val$file).toString();
                    DocumentContent content1 = DiffContentFactory.getInstance().create(fsContent, fileType);
                    DocumentContent content2 = DiffContentFactory.getInstance().create((Project)project2, this.val$document, this.val$file);
                    String title = UIBundle.message((String)"file.cache.conflict.for.file.dialog.title", (Object[])new Object[]{this.val$file.getPresentableUrl()});
                    String title1 = UIBundle.message((String)"file.cache.conflict.diff.content.file.system.content", (Object[])new Object[0]);
                    String title2 = UIBundle.message((String)"file.cache.conflict.diff.content.memory.content", (Object[])new Object[0]);
                    SimpleDiffRequest request = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
                    request.putUserData(DiffUserDataKeys.GO_TO_SOURCE_DISABLE, (Object)true);
                    DialogBuilder diffBuilder = new DialogBuilder((Project)project2);
                    DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel((Project)project2, (Disposable)diffBuilder, diffBuilder.getWindow());
                    diffPanel.setRequest((DiffRequest)request);
                    diffBuilder.setCenterPanel(diffPanel.getComponent());
                    diffBuilder.setDimensionServiceKey("FileDocumentManager.FileCacheConflict");
                    diffBuilder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.save.changes.button", (Object[])new Object[0]));
                    diffBuilder.addCancelAction();
                    diffBuilder.setTitle(title);
                    if (diffBuilder.show() == 0) {
                        this.val$builder.getDialogWrapper().close(1);
                    }
                }
            });
            builder.setTitle(UIBundle.message((String)"file.cache.conflict.dialog.title", (Object[])new Object[0]));
            builder.setButtonsAlignment(0);
            builder.setHelpId("reference.dialogs.fileCacheConflict");
            return builder.show() == 0;
        };
        this.myDocumentCache = ContainerUtil.createConcurrentWeakValueMap();
        virtualFileManager.addVirtualFileListener((VirtualFileListener)this);
        projectManager.addProjectManagerListener((ProjectManagerListener)this);
        this.myBus = ApplicationManager.getApplication().getMessageBus();
        InvocationHandler handler2 = new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                FileDocumentManagerImpl.this.multiCast(method, args);
                return null;
            }
        };
        ClassLoader loader = FileDocumentManagerListener.class.getClassLoader();
        this.myMultiCaster = (FileDocumentManagerListener)Proxy.newProxyInstance(loader, new Class[]{FileDocumentManagerListener.class}, handler2);
    }

    private static void unwrapAndRethrow(Exception e) {
        Exception unwrapped = e;
        if (e instanceof InvocationTargetException) {
            Throwable throwable = unwrapped = e.getCause() == null ? e : e.getCause();
        }
        if (unwrapped instanceof Error) {
            throw (Error)((Object)unwrapped);
        }
        if (unwrapped instanceof RuntimeException) {
            throw (RuntimeException)unwrapped;
        }
        LOG.error((Throwable)unwrapped);
    }

    private void multiCast(@NotNull Method method, Object[] args) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "multiCast"));
        }
        try {
            method.invoke(this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC), args);
        }
        catch (ClassCastException e) {
            LOG.error("Arguments: " + Arrays.toString(args), (Throwable)e);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
        for (FileDocumentManagerListener listener2 : FileDocumentManagerImpl.getListeners()) {
            try {
                method.invoke((Object)listener2, args);
            }
            catch (Exception e) {
                FileDocumentManagerImpl.unwrapAndRethrow(e);
            }
        }
        try {
            method.invoke((Object)this.myTrailingSpacesStripper, args);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getDocument"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document2 = (DocumentEx)this.getCachedDocument(file2);
        if (document2 == null) {
            if (!file2.isValid() || file2.isDirectory() || SingleRootFileViewProvider.isTooLargeForContentLoading(file2) || FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            CharSequence text = LoadTextUtil.loadText(file2);
            Object object = lock;
            synchronized (object) {
                document2 = (DocumentEx)this.getCachedDocument(file2);
                if (document2 != null) {
                    return document2;
                }
                document2 = (DocumentEx)FileDocumentManagerImpl.createDocument(text, file2);
                document2.setModificationStamp(file2.getModificationStamp());
                FileType fileType = file2.getFileType();
                document2.setReadOnly(!file2.isWritable() || fileType.isBinary());
                if (file2 instanceof LightVirtualFile) {
                    FileDocumentManagerImpl.registerDocument(document2, file2);
                } else {
                    this.cacheDocument(file2, document2);
                    document2.putUserData(FILE_KEY, file2);
                }
                if (!(file2 instanceof LightVirtualFile) && !(file2.getFileSystem() instanceof NonPhysicalFileSystem)) {
                    document2.addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void documentChanged(DocumentEvent e) {
                            Document document2 = e.getDocument();
                            FileDocumentManagerImpl.this.myUnsavedDocuments.add(document2);
                            Runnable currentCommand = CommandProcessor.getInstance().getCurrentCommand();
                            Project project2 = currentCommand == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
                            String lineSeparator = CodeStyleFacade.getInstance((Project)project2).getLineSeparator();
                            document2.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
                            if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                                FileDocumentManagerImpl.this.saveAllDocumentsLater();
                            }
                        }
                    });
                }
            }
            this.myMultiCaster.fileContentLoaded(file2, (Document)document2);
        }
        return document2;
    }

    public static boolean areTooManyDocumentsInTheQueue(Collection<Document> documents) {
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document2 : documents) {
            if ((totalSize += document2.getTextLength()) <= FileUtilRt.LARGE_FOR_CONTENT_LOADING) continue;
            return true;
        }
        return false;
    }

    private static Document createDocument(CharSequence text, VirtualFile file2) {
        boolean acceptSlashR = file2 instanceof LightVirtualFile && StringUtil.indexOf((CharSequence)text, (char)'\r') >= 0;
        boolean freeThreaded = Boolean.TRUE.equals(file2.getUserData(SingleRootFileViewProvider.FREE_THREADED));
        return ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(text, acceptSlashR, freeThreaded);
    }

    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getCachedDocument"));
        }
        Document hard = (Document)file2.getUserData(HARD_REF_TO_DOCUMENT_KEY);
        return hard != null ? hard : this.getDocumentFromCache(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(@NotNull Document document2, @NotNull VirtualFile virtualFile) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "registerDocument"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "registerDocument"));
        }
        Object object = lock;
        synchronized (object) {
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, (Object)document2);
            document2.putUserData(FILE_KEY, (Object)virtualFile);
        }
    }

    @Nullable
    public VirtualFile getFile(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getFile"));
        }
        return (VirtualFile)document2.getUserData(FILE_KEY);
    }

    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myUnsavedDocuments.clear();
            this.fireUnsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Document[] unsavedDocuments;
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            for (Document document2 : unsavedDocuments = this.getUnsavedDocuments()) {
                Project project2;
                VirtualFile file2 = this.getFile(document2);
                if (file2 == null || (project2 = ProjectUtil.guessProjectForFile((VirtualFile)file2)) == null || PsiDocumentManager.getInstance((Project)project2).isDocumentBlockedByPsi(document2)) continue;
                this.saveDocument(document2);
            }
        });
    }

    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        int count;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myMultiCaster.beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            for (Document document2 : this.myUnsavedDocuments) {
                if (failedToSave.containsKey(document2) || vetoed.contains(document2)) continue;
                try {
                    this.doSaveDocument(document2, isExplicit);
                }
                catch (IOException e) {
                    failedToSave.put(document2, e);
                }
                catch (SaveVetoException e) {
                    vetoed.add(document2);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    public void saveDocument(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocument"));
        }
        this.saveDocument(document2, true);
    }

    public void saveDocument(@NotNull Document document2, boolean explicit) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocument"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (!this.myUnsavedDocuments.contains(document2)) {
            return;
        }
        try {
            this.doSaveDocument(document2, explicit);
        }
        catch (IOException e) {
            this.handleErrorsOnSave(Collections.singletonMap(document2, e));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocumentAsIs(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocumentAsIs"));
        }
        VirtualFile file2 = this.getFile(document2);
        boolean spaceStrippingEnabled = true;
        if (file2 != null) {
            spaceStrippingEnabled = TrailingSpacesStripper.isEnabled(file2);
            TrailingSpacesStripper.setEnabled(file2, false);
        }
        try {
            this.saveDocument(document2);
        }
        finally {
            if (file2 != null) {
                TrailingSpacesStripper.setEnabled(file2, spaceStrippingEnabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveDocument(@NotNull Document document2, boolean isExplicit) throws IOException, SaveVetoException {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocument"));
        }
        VirtualFile file2 = this.getFile(document2);
        if (file2 == null || file2 instanceof LightVirtualFile || file2.isValid() && !this.isFileModified(file2)) {
            this.removeFromUnsaved(document2);
            return;
        }
        if (file2.isValid() && FileDocumentManagerImpl.needsRefresh(file2)) {
            file2.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document2)) {
                return;
            }
        }
        for (FileDocumentSynchronizationVetoer vetoer : (FileDocumentSynchronizationVetoer[])Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)) {
            if (vetoer.maySaveDocument(document2, isExplicit)) continue;
            throw new SaveVetoException();
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(((Object)((Object)this)).getClass());
        try {
            this.doSaveDocumentInWriteAction(document2, file2);
        }
        finally {
            token.finish();
        }
    }

    private void doSaveDocumentInWriteAction(@NotNull Document document2, @NotNull VirtualFile file2) throws IOException {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocumentInWriteAction"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocumentInWriteAction"));
        }
        if (!file2.isValid()) {
            this.removeFromUnsaved(document2);
            return;
        }
        if (!file2.equals(this.getFile(document2))) {
            FileDocumentManagerImpl.registerDocument(document2, file2);
        }
        if (!FileDocumentManagerImpl.isSaveNeeded(document2, file2)) {
            if (document2 instanceof DocumentEx) {
                ((DocumentEx)document2).setModificationStamp(file2.getModificationStamp());
            }
            this.removeFromUnsaved(document2);
            FileDocumentManagerImpl.updateModifiedProperty(file2);
            return;
        }
        PomModelImpl.guardPsiModificationsIn(() -> {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "lambda$doSaveDocumentInWriteAction$1"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "lambda$doSaveDocumentInWriteAction$1"));
            }
            this.myMultiCaster.beforeDocumentSaving(document2);
            LOG.assertTrue(file2.isValid());
            String text = document2.getText();
            String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document2, file2);
            if (!lineSeparator.equals("\n")) {
                text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
            }
            Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
            LoadTextUtil.write(project2, file2, (Object)this, text, document2.getModificationStamp());
            this.myUnsavedDocuments.remove(document2);
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document2));
            this.myTrailingSpacesStripper.clearLineModificationFlags(document2);
        });
    }

    private static void updateModifiedProperty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "updateModifiedProperty"));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
            for (FileEditor editor : fileEditorManager.getAllEditors(file2)) {
                if (!(editor instanceof TextEditorImpl)) continue;
                ((TextEditorImpl)editor).updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "removeFromUnsaved"));
        }
        this.myUnsavedDocuments.remove(document2);
        this.fireUnsavedDocumentsDropped();
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document2));
    }

    private static boolean isSaveNeeded(@NotNull Document document2, @NotNull VirtualFile file2) throws IOException {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isSaveNeeded"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isSaveNeeded"));
        }
        if (file2.getFileType().isBinary() || document2.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file2.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, file2, false, false);
        return !Comparing.equal((CharSequence)document2.getCharsSequence(), (CharSequence)loaded);
    }

    private static boolean needsRefresh(VirtualFile file2) {
        VirtualFileSystem fs = file2.getFileSystem();
        return fs instanceof NewVirtualFileSystem && file2.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file2);
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document2, @NotNull VirtualFile file2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file2);
        if (lineSeparator == null) {
            lineSeparator = (String)document2.getUserData(LINE_SEPARATOR_KEY);
            assert (lineSeparator != null) : document2;
        }
        String string = lineSeparator;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        return string;
    }

    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file2, @Nullable Project project2) {
        String lineSeparator;
        String string = lineSeparator = file2 == null ? null : LoadTextUtil.getDetectedLineSeparator(file2);
        if (lineSeparator == null) {
            CodeStyleFacade settingsManager = project2 == null ? CodeStyleFacade.getInstance() : CodeStyleFacade.getInstance((Project)project2);
            lineSeparator = settingsManager.getLineSeparator();
        }
        String string2 = lineSeparator;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        return string2;
    }

    public boolean requestWriting(@NotNull Document document2, Project project2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "requestWriting"));
        }
        VirtualFile file2 = FileDocumentManagerImpl.getInstance().getFile(document2);
        if (project2 != null && file2 != null && file2.isValid()) {
            return !file2.getFileType().isBinary() && ReadonlyStatusHandler.ensureFilesWritable((Project)project2, (VirtualFile[])new VirtualFile[]{file2});
        }
        if (document2.isWritable()) {
            return true;
        }
        document2.fireReadOnlyModificationAttempt();
        return false;
    }

    public void reloadFiles(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "reloadFiles"));
        }
        for (VirtualFile file2 : files) {
            Document doc;
            if (!file2.exists() || (doc = this.getCachedDocument(file2)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getUnsavedDocuments"));
            }
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list = new ArrayList<Document>(this.myUnsavedDocuments);
        Document[] documentArray = list.toArray(new Document[list.size()]);
        if (documentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getUnsavedDocuments"));
        }
        return documentArray;
    }

    public boolean isDocumentUnsaved(@NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isDocumentUnsaved"));
        }
        return this.myUnsavedDocuments.contains(document2);
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isFileModified"));
        }
        Document doc = this.getCachedDocument(file2);
        return doc != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file2.getModificationStamp();
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Document document2;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "propertyChanged"));
        }
        final VirtualFile file2 = event.getFile();
        if ("writable".equals(event.getPropertyName())) {
            final Document document3 = this.getCachedDocument(file2);
            if (document3 != null) {
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                    @Override
                    public void run() {
                        document3.setReadOnly(!file2.isWritable());
                    }
                });
            }
        } else if ("name".equals(event.getPropertyName()) && (document2 = this.getCachedDocument(file2)) != null && FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
            this.unbindFileFromDocument(file2, document2);
        }
    }

    private void unbindFileFromDocument(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "unbindFileFromDocument"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "unbindFileFromDocument"));
        }
        this.removeDocumentFromCache(file2);
        file2.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document2.putUserData(FILE_KEY, null);
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isBinaryWithDecompiler"));
        }
        FileType ft = file2.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isBinaryWithoutDecompiler"));
        }
        FileType fileType = file2.getFileType();
        return fileType.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType) == null;
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        long oldFileStamp;
        long documentStamp;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "contentsChanged"));
        }
        if (event.isFromSave()) {
            return;
        }
        VirtualFile file2 = event.getFile();
        Document document2 = this.getCachedDocument(file2);
        if (document2 == null) {
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
            return;
        }
        if (FileDocumentManagerImpl.isBinaryWithDecompiler(file2)) {
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
        }
        if ((documentStamp = document2.getModificationStamp()) != (oldFileStamp = event.getOldModificationStamp())) {
            LOG.info("reload " + file2.getName() + " from disk?");
            LOG.info("  documentStamp:" + documentStamp);
            LOG.info("  oldFileStamp:" + oldFileStamp);
            if (file2.isValid() && this.askReloadFromDisk(file2, document2)) {
                this.reloadFromDisk(document2);
            }
        } else {
            this.reloadFromDisk(document2);
        }
    }

    public void reloadFromDisk(final @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "reloadFromDisk"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final VirtualFile file2 = this.getFile(document2);
        assert (file2 != null);
        if (!this.fireBeforeFileContentReload(file2, document2)) {
            return;
        }
        if (file2.getLength() > (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
            this.unbindFileFromDocument(file2, document2);
            this.myUnsavedDocuments.remove(document2);
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
            return;
        }
        Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "lambda$reloadFromDisk$2"));
            }
            ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction.ExternalDocumentChange(document2, project2){

                @Override
                public void run() {
                    boolean wasWritable = document2.isWritable();
                    DocumentEx documentEx = (DocumentEx)document2;
                    documentEx.setReadOnly(false);
                    LoadTextUtil.setCharsetWasDetectedFromBytes(file2, null);
                    file2.setBOM(null);
                    file2.setCharset(null);
                    if (!FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                        documentEx.replaceText(LoadTextUtil.loadText(file2), file2.getModificationStamp());
                        documentEx.setReadOnly(!wasWritable);
                    }
                }
            });
        }, UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        this.myUnsavedDocuments.remove(document2);
        this.myMultiCaster.fileContentReloaded(file2, document2);
    }

    public void setAskReloadFromDisk(@NotNull Disposable disposable, @NotNull PairProcessor<VirtualFile, Document> newProcessor) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "setAskReloadFromDisk"));
        }
        if (newProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProcessor", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "setAskReloadFromDisk"));
        }
        final PairProcessor<VirtualFile, Document> old = this.askReloadFromDisk;
        this.askReloadFromDisk = newProcessor;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                FileDocumentManagerImpl.this.askReloadFromDisk = old;
            }
        });
    }

    private boolean askReloadFromDisk(VirtualFile file2, Document document2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isDocumentUnsaved(document2)) {
            return true;
        }
        return this.askReloadFromDisk.process((Object)file2, (Object)document2);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileCreated"));
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileDeleted"));
        }
        Document doc = this.getCachedDocument(event.getFile());
        if (doc != null) {
            this.myTrailingSpacesStripper.documentDeleted(doc);
        }
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileMoved"));
        }
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileCopied"));
        }
        this.fileCreated((VirtualFileEvent)event);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforePropertyChange"));
        }
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeContentsChange"));
        }
        VirtualFile virtualFile = event.getFile();
        if (virtualFile.getLength() == 0L && virtualFile.getFileType() == UnknownFileType.INSTANCE) {
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, (Object)Boolean.TRUE);
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "recomputeFileTypeIfNecessary"));
        }
        if (virtualFile.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile.getFileType();
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeFileDeletion"));
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeFileMovement"));
        }
    }

    public void projectOpened(Project project2) {
    }

    public boolean canCloseProject(Project project2) {
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myOnClose = true;
            try {
                this.saveAllDocuments();
            }
            finally {
                this.myOnClose = false;
            }
        }
        return this.myUnsavedDocuments.isEmpty();
    }

    public void projectClosed(Project project2) {
    }

    public void projectClosing(Project project2) {
    }

    private void fireUnsavedDocumentsDropped() {
        this.myMultiCaster.unsavedDocumentsDropped();
    }

    private boolean fireBeforeFileContentReload(VirtualFile file2, @NotNull Document document2) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fireBeforeFileContentReload"));
        }
        for (FileDocumentSynchronizationVetoer vetoer : (FileDocumentSynchronizationVetoer[])Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)) {
            try {
                if (vetoer.mayReloadFileContent(file2, document2)) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        this.myMultiCaster.beforeFileContentReload(file2, document2);
        return true;
    }

    @NotNull
    private static FileDocumentManagerListener[] getListeners() {
        FileDocumentManagerListener[] fileDocumentManagerListenerArray = (FileDocumentManagerListener[])FileDocumentManagerListener.EP_NAME.getExtensions();
        if (fileDocumentManagerListenerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getListeners"));
        }
        return fileDocumentManagerListenerArray;
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (failures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failures", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "handleErrorsOnSave"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException = (IOException)ContainerUtil.getFirstItem(failures.values());
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (IOException exception : failures.values()) {
            LOG.warn((Throwable)exception);
        }
        final String text = StringUtil.join(failures.values(), e -> e.getMessage(), (String)"\n");
        DialogWrapper dialog = new DialogWrapper(null){
            {
                super(arg0);
                this.init();
                this.setTitle(UIBundle.message((String)"cannot.save.files.dialog.title", (Object[])new Object[0]));
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myOKAction.putValue("Name", UIBundle.message((String)(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes"), (Object[])new Object[0]));
                this.myOKAction.putValue("DefaultAction", null);
                if (!FileDocumentManagerImpl.this.myOnClose) {
                    this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                }
            }

            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel(new BorderLayout(0, 5));
                panel.add((Component)new JLabel(UIBundle.message((String)"cannot.save.files.dialog.message", (Object[])new Object[0])), "North");
                JTextPane area = new JTextPane();
                area.setText(text);
                area.setEditable(false);
                area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                panel.add((Component)new JBScrollPane((Component)area, 22, 31), "Center");
                return panel;
            }
        };
        if (dialog.showAndGet()) {
            for (Document document2 : failures.keySet()) {
                this.reloadFromDisk(document2);
            }
        }
    }

    protected void cacheDocument(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "cacheDocument"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "cacheDocument"));
        }
        this.myDocumentCache.put(file2, document2);
    }

    protected void removeDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "removeDocumentFromCache"));
        }
        this.myDocumentCache.remove(file2);
    }

    protected Document getDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getDocumentFromCache"));
        }
        return this.myDocumentCache.get(file2);
    }

    private static class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }
}

