/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessProvider
extends WritingAccessProvider {
    private static final Key<Boolean> ENABLE_IN_TESTS = Key.create((String)"NON_PROJECT_FILE_ACCESS_ENABLE_IN_TESTS");
    private static final NotNullLazyKey<AtomicInteger, UserDataHolder> ACCESS_ALLOWED = NotNullLazyKey.create((String)"NON_PROJECT_FILE_ACCESS", holder -> new AtomicInteger());
    private static final AtomicBoolean myInitialized = new AtomicBoolean();
    @NotNull
    private final Project myProject;
    @Nullable
    private static NullableFunction<List<VirtualFile>, UnlockOption> ourCustomUnlocker;

    public static void setCustomUnlocker(@Nullable NullableFunction<List<VirtualFile>, UnlockOption> unlocker) {
        ourCustomUnlocker = unlocker;
    }

    public NonProjectFileWritingAccessProvider(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "<init>"));
        }
        this.myProject = project2;
        if (myInitialized.compareAndSet(false, true)) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new OurVirtualFileAdapter());
        }
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isPotentiallyWritable"));
        }
        return true;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        List<VirtualFile> deniedFiles = Stream.of(files).filter(o -> !NonProjectFileWritingAccessProvider.isWriteAccessAllowed(o, this.myProject)).collect(Collectors.toList());
        if (deniedFiles.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        UnlockOption unlockOption = this.askToUnlock(deniedFiles);
        if (unlockOption == null) {
            List<VirtualFile> list = deniedFiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        switch (unlockOption) {
            case UNLOCK: {
                NonProjectFileWritingAccessProvider.allowWriting(deniedFiles);
                break;
            }
            case UNLOCK_DIR: {
                NonProjectFileWritingAccessProvider.allowWriting(ContainerUtil.map(deniedFiles, VirtualFile::getParent));
                break;
            }
            case UNLOCK_ALL: {
                ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)NonProjectFileWritingAccessProvider.getApp())).incrementAndGet();
            }
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
        }
        return list;
    }

    @Nullable
    private UnlockOption askToUnlock(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "askToUnlock"));
        }
        if (ourCustomUnlocker != null) {
            return (UnlockOption)((Object)ourCustomUnlocker.fun(files));
        }
        NonProjectFileWritingAccessDialog dialog = new NonProjectFileWritingAccessDialog(this.myProject, files);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.getUnlockOption();
    }

    public static boolean isWriteAccessAllowed(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isWriteAccessAllowed"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isWriteAccessAllowed"));
        }
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            return true;
        }
        if (file2.isDirectory()) {
            return true;
        }
        if (!(file2.getFileSystem() instanceof LocalFileSystem)) {
            return true;
        }
        if (file2.getFileSystem() instanceof TempFileSystem) {
            return true;
        }
        if (!NonProjectFileWritingAccessProvider.getApp().isUnitTestMode() && FileUtil.isAncestor((File)new File(FileUtil.getTempDirectory()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (boolean)true)) {
            return true;
        }
        for (VirtualFile each = file2; each != null; each = each.getParent()) {
            if (((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)each)).get() <= 0) continue;
            return true;
        }
        return NonProjectFileWritingAccessProvider.isProjectFile(file2, project2);
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isProjectFile"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isProjectFile"));
        }
        for (NonProjectFileWritingAccessExtension each : (NonProjectFileWritingAccessExtension[])Extensions.getExtensions(NonProjectFileWritingAccessExtension.EP_NAME, (AreaInstance)project2)) {
            if (each.isWritable(file2)) {
                return true;
            }
            if (!each.isNotWritable(file2)) continue;
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        if (fileIndex.isInContent(file2)) {
            return true;
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && fileIndex.isExcluded(file2) && !fileIndex.isUnderIgnored(file2)) {
            return true;
        }
        if (project2 instanceof ProjectEx && !project2.isDefault()) {
            if (ProjectUtil.isDirectoryBased(project2)) {
                VirtualFile dotIdea;
                VirtualFile baseDir = project2.getBaseDir();
                VirtualFile virtualFile = dotIdea = baseDir == null ? null : baseDir.findChild(".idea");
                if (dotIdea != null && VfsUtilCore.isAncestor((VirtualFile)dotIdea, (VirtualFile)file2, (boolean)false)) {
                    return true;
                }
            }
            IProjectStore store = (IProjectStore)ServiceKt.getStateStore((ComponentManager)project2);
            String filePath = file2.getPath();
            if (FileUtil.namesEqual((String)filePath, (String)store.getWorkspaceFilePath()) || FileUtil.namesEqual((String)filePath, (String)store.getProjectFilePath())) {
                return true;
            }
            for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                if (!FileUtil.namesEqual((String)filePath, (String)module2.getModuleFilePath())) continue;
                return true;
            }
        }
        return false;
    }

    public static void allowWriting(VirtualFile ... allowedFiles) {
        NonProjectFileWritingAccessProvider.allowWriting(Arrays.asList(allowedFiles));
    }

    public static void allowWriting(Iterable<VirtualFile> allowedFiles) {
        for (VirtualFile eachAllowed : allowedFiles) {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)eachAllowed)).incrementAndGet();
        }
    }

    public static void disableChecksDuring(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "disableChecksDuring"));
        }
        Application app = NonProjectFileWritingAccessProvider.getApp();
        ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).incrementAndGet();
        try {
            runnable2.run();
        }
        finally {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).decrementAndGet();
        }
    }

    public static void enableChecksInTests(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "enableChecksInTests"));
        }
        NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, (Object)Boolean.TRUE);
        NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        Disposer.register((Disposable)disposable, () -> {
            NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, null);
            NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        });
    }

    private static boolean isAllAccessAllowed() {
        Application app = NonProjectFileWritingAccessProvider.getApp();
        if (app.isUnitTestMode() && app.getUserData(ENABLE_IN_TESTS) != Boolean.TRUE) {
            return true;
        }
        return ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).get() > 0;
    }

    private static Application getApp() {
        return ApplicationManager.getApplication();
    }

    private static class OurVirtualFileAdapter
    extends VirtualFileAdapter {
        private OurVirtualFileAdapter() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider$OurVirtualFileAdapter", "fileCreated"));
            }
            OurVirtualFileAdapter.unlock(event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider$OurVirtualFileAdapter", "fileCopied"));
            }
            OurVirtualFileAdapter.unlock((VirtualFileEvent)event);
        }

        private static void unlock(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider$OurVirtualFileAdapter", "unlock"));
            }
            if (!event.isFromRefresh() && !event.getFile().isDirectory()) {
                NonProjectFileWritingAccessProvider.allowWriting(event.getFile());
            }
        }
    }

    public static enum UnlockOption {
        UNLOCK,
        UNLOCK_DIR,
        UNLOCK_ALL;

    }
}

