/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class AsyncEditorLoader {
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((int)2);
    private static final Key<AsyncEditorLoader> ASYNC_LOADER = Key.create((String)"ASYNC_LOADER");
    private static boolean ourCreatingAsyncEditor;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextEditorImpl myTextEditor;
    @NotNull
    private final TextEditorComponent myEditorComponent;
    @NotNull
    private final TextEditorProvider myProvider;
    private boolean myLoaded;
    private final List<Runnable> myDelayedActions;
    private TextEditorState myDelayedState;

    AsyncEditorLoader(@NotNull TextEditorImpl textEditor, @NotNull TextEditorComponent component, @NotNull TextEditorProvider provider) {
        if (textEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "<init>"));
        }
        this.myDelayedActions = new ArrayList<Runnable>();
        this.myProvider = provider;
        this.myTextEditor = textEditor;
        this.myProject = textEditor.myProject;
        this.myEditorComponent = component;
        this.myEditor = textEditor.getEditor();
        this.myEditor.putUserData(ASYNC_LOADER, (Object)this);
        this.myEditorComponent.getContentPanel().setVisible(false);
    }

    void scheduleBackgroundLoading(boolean firstTime) {
        ReadTask task = new ReadTask(){
            PsiDocumentManager pdm;
            long startStamp;
            {
                this.pdm = PsiDocumentManager.getInstance((Project)AsyncEditorLoader.this.myProject);
                this.startStamp = AsyncEditorLoader.this.myEditor.getDocument().getModificationStamp();
            }

            @Override
            public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader$1", "runBackgroundProcess"));
                }
                return (ReadTask.Continuation)this.pdm.commitAndRunReadAction(() -> {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader$1", "lambda$runBackgroundProcess$1"));
                    }
                    if (Disposer.isDisposed((Disposable)AsyncEditorLoader.this.myTextEditor)) {
                        return null;
                    }
                    Runnable applyResults = AsyncEditorLoader.this.myTextEditor.loadEditorInBackground();
                    return new ReadTask.Continuation(() -> {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader$1", "lambda$null$0"));
                        }
                        if (Disposer.isDisposed((Disposable)AsyncEditorLoader.this.myTextEditor)) {
                            return;
                        }
                        if (this.startStamp != AsyncEditorLoader.this.myEditor.getDocument().getModificationStamp()) {
                            this.onCanceled(indicator);
                            return;
                        }
                        applyResults.run();
                        AsyncEditorLoader.this.loadingFinished();
                    });
                });
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader$1", "onCanceled"));
                }
                if (!Disposer.isDisposed((Disposable)AsyncEditorLoader.this.myTextEditor) && !AsyncEditorLoader.this.myProject.isDisposed()) {
                    AsyncEditorLoader.this.scheduleBackgroundLoading(false);
                }
            }
        };
        if (!firstTime || !this.loadImmediately(task)) {
            this.myEditorComponent.startLoading();
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(ourExecutor, task);
        }
    }

    private boolean loadImmediately(ReadTask task) {
        ReadTask.Continuation applyImmediately;
        if (PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments() || ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        Ref continuationRef = Ref.create();
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        ourExecutor.submit(() -> {
            try {
                ProgressIndicatorUtils.runWithWriteActionPriority(() -> continuationRef.set((Object)task.runBackgroundProcess(indicator)), indicator);
            }
            finally {
                semaphore.up();
            }
        });
        ReadTask.Continuation continuation = applyImmediately = semaphore.waitFor(200L) ? (ReadTask.Continuation)continuationRef.get() : null;
        if (applyImmediately != null) {
            applyImmediately.getAction().run();
            return true;
        }
        indicator.cancel();
        return false;
    }

    private void loadingFinished() {
        this.myLoaded = true;
        this.myEditor.putUserData(ASYNC_LOADER, null);
        this.myEditorComponent.stopLoading();
        this.myEditorComponent.getContentPanel().setVisible(true);
        if (this.myDelayedState != null) {
            TextEditorState state = new TextEditorState();
            state.setFoldingState(this.myDelayedState.getFoldingState());
            this.myProvider.setStateImpl(this.myProject, this.myEditor, state);
            this.myDelayedState = null;
        }
        for (Runnable runnable2 : (List)ObjectUtils.assertNotNull(this.myDelayedActions)) {
            this.myEditor.getScrollingModel().disableAnimation();
            runnable2.run();
        }
        this.myEditor.getScrollingModel().enableAnimation();
        if (FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor() == this.myEditor) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTextEditor.getPreferredFocusedComponent(), true);
        }
    }

    public static void performWhenLoaded(@NotNull Editor editor, @NotNull Runnable runnable2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "performWhenLoaded"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "performWhenLoaded"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AsyncEditorLoader loader = (AsyncEditorLoader)editor.getUserData(ASYNC_LOADER);
        if (loader == null) {
            runnable2.run();
        } else {
            loader.myDelayedActions.add(runnable2);
        }
    }

    @NotNull
    TextEditorState getEditorState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "getEditorState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TextEditorState state = this.myProvider.getStateImpl(this.myProject, this.myEditor, level);
        if (!this.myLoaded && this.myDelayedState != null) {
            state.setDelayedFoldState((Producer<CodeFoldingState>)((Producer)this.myDelayedState::getFoldingState));
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "getEditorState"));
        }
        return textEditorState;
    }

    void setEditorState(@NotNull TextEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "setEditorState"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myLoaded) {
            this.myDelayedState = state;
        }
        this.myProvider.setStateImpl(this.myProject, this.myEditor, state);
    }

    public static boolean isEditorLoaded(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/AsyncEditorLoader", "isEditorLoaded"));
        }
        return editor.getUserData(ASYNC_LOADER) == null;
    }
}

