/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemeImportUtil {
    @Nullable
    public static VirtualFile selectImportSource(@NotNull String[] sourceExtensions, @NotNull Component parent, @Nullable VirtualFile preselect) {
        VirtualFile[] preselectFiles;
        if (sourceExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceExtensions", "com/intellij/openapi/options/SchemeImportUtil", "selectImportSource"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/options/SchemeImportUtil", "selectImportSource"));
        }
        final HashSet<String> extensions = new HashSet<String>(Arrays.asList(sourceExtensions));
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return file2.isDirectory() || extensions.contains(file2.getExtension());
            }

            public boolean isFileSelectable(VirtualFile file2) {
                return !file2.isDirectory() && extensions.contains(file2.getExtension());
            }
        }, null, parent);
        VirtualFile[] virtualFiles = fileChooser.choose(null, preselectFiles = preselect != null ? new VirtualFile[]{preselect} : new VirtualFile[]{});
        if (virtualFiles.length != 1) {
            return null;
        }
        virtualFiles[0].refresh(false, false);
        return virtualFiles[0];
    }

    public static void showStatus(JComponent component, String message, MessageType messageType) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(5000L);
        Balloon balloon = balloonBuilder.createBalloon();
        balloon.showInCenterOf(component);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }
}

