/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SLRUMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class RootIndex {
    public static final Comparator<OrderEntry> BY_OWNER_MODULE = (o1, o2) -> {
        String name1 = o1.getOwnerModule().getName();
        String name2 = o2.getOwnerModule().getName();
        return name1.compareTo(name2);
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.RootIndex");
    private final Map<VirtualFile, String> myPackagePrefixByRoot;
    private final InfoCache myInfoCache;
    private final List<JpsModuleSourceRootType<?>> myRootTypes;
    private final TObjectIntHashMap<JpsModuleSourceRootType<?>> myRootTypeId;
    @NotNull
    private final Project myProject;
    private final PackageDirectoryCache myPackageDirectoryCache;
    private OrderEntryGraph myOrderEntryGraph;

    public RootIndex(@NotNull Project project2, @NotNull InfoCache cache) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/RootIndex", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/openapi/roots/impl/RootIndex", "<init>"));
        }
        this.myPackagePrefixByRoot = ContainerUtil.newHashMap();
        this.myRootTypes = ContainerUtil.newArrayList();
        this.myRootTypeId = new TObjectIntHashMap();
        this.myProject = project2;
        this.myInfoCache = cache;
        RootInfo info = this.buildRootInfo(project2);
        MultiMap rootsByPackagePrefix = MultiMap.create();
        Set<VirtualFile> allRoots = info.getAllRoots();
        for (VirtualFile root : allRoots) {
            Pair<DirectoryInfo, String> pair;
            List<VirtualFile> hierarchy = RootIndex.getHierarchy(root, allRoots, info);
            if (hierarchy != null) {
                pair = RootIndex.calcDirectoryInfo(root, hierarchy, info);
            } else {
                Pair<DirectoryInfo, String> pair2;
                pair = pair2;
                super((Object)NonProjectDirectoryInfo.IGNORED, null);
            }
            Pair<DirectoryInfo, String> pair3 = pair;
            this.cacheInfos(root, root, (DirectoryInfo)pair3.first);
            rootsByPackagePrefix.putValue(pair3.second, (Object)root);
            this.myPackagePrefixByRoot.put(root, (String)pair3.second);
        }
        this.myPackageDirectoryCache = new PackageDirectoryCache(rootsByPackagePrefix){

            @Override
            protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/RootIndex$1", "isPackageDirectory"));
                }
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/RootIndex$1", "isPackageDirectory"));
                }
                return RootIndex.this.getInfoForFile(dir).isInProject() && packageName.equals(RootIndex.this.getPackageName(dir));
            }
        };
    }

    @NotNull
    private RootInfo buildRootInfo(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/RootIndex", "buildRootInfo"));
        }
        RootInfo info = new RootInfo();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            for (VirtualFile virtualFile : moduleRootManager.getContentRoots()) {
                if (info.contentRootOf.containsKey(virtualFile)) continue;
                info.contentRootOf.put(virtualFile, module2);
            }
            for (VirtualFile virtualFile : moduleRootManager.getContentEntries()) {
                if (!(virtualFile instanceof ContentEntryImpl) || !((ContentEntryImpl)virtualFile).isDisposed()) {
                    for (VirtualFile virtualFile2 : virtualFile.getExcludeFolderFiles()) {
                        info.excludedFromModule.put(virtualFile2, module2);
                    }
                }
                for (VirtualFile virtualFile3 : virtualFile.getSourceFolders()) {
                    VirtualFile sourceFolderRoot = virtualFile3.getFile();
                    if (sourceFolderRoot == null) continue;
                    info.rootTypeId.put((Object)sourceFolderRoot, this.getRootTypeId(virtualFile3.getRootType()));
                    info.classAndSourceRoots.add(sourceFolderRoot);
                    info.sourceRootOf.putValue((Object)sourceFolderRoot, (Object)module2);
                    info.packagePrefix.put(sourceFolderRoot, virtualFile3.getPackagePrefix());
                }
            }
            for (VirtualFile virtualFile : moduleRootManager.getOrderEntries()) {
                Library library;
                if (!(virtualFile instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)virtualFile;
                VirtualFile[] sourceRoots = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile sourceRoot : sourceRoots) {
                    info.classAndSourceRoots.add(sourceRoot);
                    info.libraryOrSdkSources.add(sourceRoot);
                    info.packagePrefix.put(sourceRoot, "");
                }
                for (VirtualFile classRoot : classRoots) {
                    info.classAndSourceRoots.add(classRoot);
                    info.libraryOrSdkClasses.add(classRoot);
                    info.packagePrefix.put(classRoot, "");
                }
                if (!(virtualFile instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)virtualFile).getLibrary()) == null) continue;
                for (VirtualFile root : ((LibraryEx)library).getExcludedRoots()) {
                    info.excludedFromLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : sourceRoots) {
                    info.sourceOfLibraries.putValue((Object)root, (Object)library);
                }
                for (VirtualFile root : classRoots) {
                    info.classOfLibraries.putValue((Object)root, (Object)library);
                }
            }
        }
        for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)project2)) {
            Collections.addAll(info.excludedFromProject, directoryIndexExcludePolicy.getExcludeRootsForProject());
        }
        RootInfo rootInfo = info;
        if (rootInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "buildRootInfo"));
        }
        return rootInfo;
    }

    @NotNull
    private synchronized OrderEntryGraph getOrderEntryGraph() {
        if (this.myOrderEntryGraph == null) {
            RootInfo rootInfo = this.buildRootInfo(this.myProject);
            this.myOrderEntryGraph = new OrderEntryGraph(this.myProject, rootInfo);
        }
        OrderEntryGraph orderEntryGraph = this.myOrderEntryGraph;
        if (orderEntryGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntryGraph"));
        }
        return orderEntryGraph;
    }

    private int getRootTypeId(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/impl/RootIndex", "getRootTypeId"));
        }
        if (this.myRootTypeId.containsKey(rootType)) {
            return this.myRootTypeId.get(rootType);
        }
        int id = this.myRootTypes.size();
        if (id > 127) {
            LOG.error("Too many different types of module source roots (" + id + ") registered: " + this.myRootTypes);
        }
        this.myRootTypes.add(rootType);
        this.myRootTypeId.put(rootType, id);
        return id;
    }

    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        VirtualFile dir;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
        }
        if (!file2.isValid()) {
            NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.INVALID;
            if (nonProjectDirectoryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
            }
            return nonProjectDirectoryInfo;
        }
        if (!file2.isDirectory()) {
            DirectoryInfo info = this.myInfoCache.getCachedInfo(file2);
            if (info != null) {
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
                }
                return directoryInfo;
            }
            if (RootIndex.isIgnored(file2)) {
                NonProjectDirectoryInfo nonProjectDirectoryInfo = NonProjectDirectoryInfo.IGNORED;
                if (nonProjectDirectoryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
                }
                return nonProjectDirectoryInfo;
            }
            dir = file2.getParent();
        } else {
            dir = file2;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            DirectoryInfo info = this.myInfoCache.getCachedInfo(root);
            if (info != null) {
                if (!dir.equals(root)) {
                    this.cacheInfos(dir, root, info);
                }
                DirectoryInfo directoryInfo = info;
                if (directoryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
                }
                return directoryInfo;
            }
            if (!RootIndex.isIgnored(root)) continue;
            DirectoryInfo directoryInfo = this.cacheInfos(dir, root, NonProjectDirectoryInfo.IGNORED);
            if (directoryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
            }
            return directoryInfo;
        }
        DirectoryInfo directoryInfo = this.cacheInfos(dir, null, NonProjectDirectoryInfo.NOT_UNDER_PROJECT_ROOTS);
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getInfoForFile"));
        }
        return directoryInfo;
    }

    @NotNull
    private DirectoryInfo cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull DirectoryInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "cacheInfos"));
        }
        while (dir != null) {
            this.myInfoCache.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        DirectoryInfo directoryInfo = info;
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "cacheInfos"));
        }
        return directoryInfo;
    }

    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
        }
        List result2 = this.myPackageDirectoryCache.getDirectoriesByPackageName(packageName);
        if (!includeLibrarySources) {
            result2 = ContainerUtil.filter(result2, file2 -> {
                DirectoryInfo info = this.getInfoForFile((VirtualFile)file2);
                return info.isInProject() && (!info.isInLibrarySource() || info.isInModuleSource() || info.hasLibraryClassRoot());
            });
        }
        CollectionQuery collectionQuery = new CollectionQuery(result2);
        if (collectionQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getDirectoriesByPackageName"));
        }
        return collectionQuery;
    }

    @Nullable
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/RootIndex", "getPackageName"));
        }
        if (dir.isDirectory()) {
            if (RootIndex.isIgnored(dir)) {
                return null;
            }
            if (this.myPackagePrefixByRoot.containsKey(dir)) {
                return this.myPackagePrefixByRoot.get(dir);
            }
            VirtualFile parent = dir.getParent();
            if (parent != null) {
                return RootIndex.getPackageNameForSubdir(this.getPackageName(parent), dir.getName());
            }
        }
        return null;
    }

    @Nullable
    protected static String getPackageNameForSubdir(@Nullable String parentPackageName, @NotNull String subdirName) {
        if (subdirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "com/intellij/openapi/roots/impl/RootIndex", "getPackageNameForSubdir"));
        }
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo directoryInfo) {
        if (directoryInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryInfo", "com/intellij/openapi/roots/impl/RootIndex", "getSourceRootType"));
        }
        return this.myRootTypes.get(directoryInfo.getSourceRootTypeId());
    }

    boolean resetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/RootIndex", "resetOnEvents"));
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2 = vFileEvent.getFile();
            if (file2 != null && !file2.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @Nullable(value="returns null only if dir is under ignored folder")
    private static List<VirtualFile> getHierarchy(VirtualFile dir, @NotNull Set<VirtualFile> allRoots, @NotNull RootInfo info) {
        if (allRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRoots", "com/intellij/openapi/roots/impl/RootIndex", "getHierarchy"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "getHierarchy"));
        }
        ArrayList hierarchy = ContainerUtil.newArrayList();
        boolean hasContentRoots = false;
        while (dir != null) {
            if (!(hasContentRoots |= info.contentRootOf.get(dir) != null) && RootIndex.isIgnored(dir)) {
                return null;
            }
            if (allRoots.contains(dir)) {
                hierarchy.add(dir);
            }
            dir = dir.getParent();
        }
        return hierarchy;
    }

    private static boolean isIgnored(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/RootIndex", "isIgnored"));
        }
        return FileTypeRegistry.getInstance().isFileIgnored(dir);
    }

    @NotNull
    private static Pair<DirectoryInfo, String> calcDirectoryInfo(@NotNull VirtualFile root, @NotNull List<VirtualFile> hierarchy, @NotNull RootInfo info) {
        VirtualFile nearestContentRoot;
        boolean inProject;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        if (hierarchy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        VirtualFile moduleContentRoot = info.findModuleRootInfo(hierarchy);
        VirtualFile libraryClassRoot = info.findLibraryRootInfo(hierarchy, false);
        VirtualFile librarySourceRoot = info.findLibraryRootInfo(hierarchy, true);
        boolean bl = inProject = moduleContentRoot != null || libraryClassRoot != null || librarySourceRoot != null;
        if (inProject) {
            nearestContentRoot = moduleContentRoot;
        } else {
            nearestContentRoot = info.findNearestContentRootForExcluded(hierarchy);
            if (nearestContentRoot == null) {
                Pair pair = new Pair((Object)NonProjectDirectoryInfo.EXCLUDED, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
                }
                return pair;
            }
        }
        VirtualFile sourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, librarySourceRoot);
        VirtualFile moduleSourceRoot = info.findPackageRootInfo(hierarchy, moduleContentRoot, null, null);
        boolean inModuleSources = moduleSourceRoot != null;
        boolean inLibrarySource = librarySourceRoot != null;
        int typeId = moduleSourceRoot != null ? info.rootTypeId.get((Object)moduleSourceRoot) : 0;
        Module module2 = info.contentRootOf.get(nearestContentRoot);
        DirectoryInfoImpl directoryInfo = new DirectoryInfoImpl(root, module2, nearestContentRoot, sourceRoot, libraryClassRoot, inModuleSources, inLibrarySource, !inProject, typeId);
        String packagePrefix = info.calcPackagePrefix(root, hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
        Pair pair = Pair.create((Object)directoryInfo, (Object)packagePrefix);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "calcDirectoryInfo"));
        }
        return pair;
    }

    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
        }
        if (!(info instanceof DirectoryInfoImpl)) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
            }
            return list;
        }
        List list = this.getOrderEntryGraph().getOrderEntries(((DirectoryInfoImpl)info).getRoot());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex", "getOrderEntries"));
        }
        return list;
    }

    static abstract class SynchronizedSLRUCache<K, V>
    extends SLRUMap<K, V> {
        protected final Object myLock = new Object();

        protected SynchronizedSLRUCache(int protectedQueueSize, int probationalQueueSize) {
            super(protectedQueueSize, probationalQueueSize);
        }

        @NotNull
        public abstract V createValue(K var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public V get(K key2) {
            Object value;
            Object object = this.myLock;
            synchronized (object) {
                value = super.get(key2);
                if (value != null) {
                    Object object2 = value;
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (object2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
                    }
                    return (V)object2;
                }
            }
            value = this.createValue(key2);
            object = this.myLock;
            synchronized (object) {
                this.put(key2, value);
            }
            Object object3 = value;
            if (object3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$SynchronizedSLRUCache", "get"));
            }
            return (V)object3;
        }
    }

    public static interface InfoCache {
        @Nullable
        public DirectoryInfo getCachedInfo(@NotNull VirtualFile var1);

        public void cacheInfo(@NotNull VirtualFile var1, @NotNull DirectoryInfo var2);
    }

    private static class RootInfo {
        @NotNull
        final LinkedHashSet<VirtualFile> classAndSourceRoots = ContainerUtil.newLinkedHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkSources = ContainerUtil.newHashSet();
        @NotNull
        final Set<VirtualFile> libraryOrSdkClasses = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> contentRootOf = ContainerUtil.newHashMap();
        @NotNull
        final MultiMap<VirtualFile, Module> sourceRootOf = MultiMap.createSet();
        @NotNull
        final TObjectIntHashMap<VirtualFile> rootTypeId = new TObjectIntHashMap();
        @NotNull
        final MultiMap<VirtualFile, Library> excludedFromLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Library> classOfLibraries = MultiMap.createSmart();
        @NotNull
        final MultiMap<VirtualFile, Library> sourceOfLibraries = MultiMap.createSmart();
        @NotNull
        final Set<VirtualFile> excludedFromProject = ContainerUtil.newHashSet();
        @NotNull
        final Map<VirtualFile, Module> excludedFromModule = ContainerUtil.newHashMap();
        @NotNull
        final Map<VirtualFile, String> packagePrefix = ContainerUtil.newHashMap();

        private RootInfo() {
        }

        @NotNull
        Set<VirtualFile> getAllRoots() {
            LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
            result2.addAll(this.classAndSourceRoots);
            result2.addAll(this.contentRootOf.keySet());
            result2.addAll(this.excludedFromLibraries.keySet());
            result2.addAll(this.excludedFromModule.keySet());
            result2.addAll(this.excludedFromProject);
            LinkedHashSet linkedHashSet = result2;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getAllRoots"));
            }
            return linkedHashSet;
        }

        @Nullable
        private VirtualFile findModuleRootInfo(@NotNull List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findModuleRootInfo"));
            }
            for (VirtualFile root : hierarchy) {
                Module module2 = this.contentRootOf.get(root);
                Module excludedFrom = this.excludedFromModule.get(root);
                if (module2 != null && excludedFrom != module2) {
                    return root;
                }
                if (excludedFrom == null && !this.excludedFromProject.contains(root)) continue;
                return null;
            }
            return null;
        }

        @Nullable
        private VirtualFile findNearestContentRootForExcluded(@NotNull List<VirtualFile> hierarchy) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findNearestContentRootForExcluded"));
            }
            for (VirtualFile root : hierarchy) {
                if (!this.contentRootOf.containsKey(root)) continue;
                return root;
            }
            return null;
        }

        @Nullable
        private VirtualFile findLibraryRootInfo(@NotNull List<VirtualFile> hierarchy, boolean source) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findLibraryRootInfo"));
            }
            HashSet librariesToIgnore = ContainerUtil.newHashSet();
            for (VirtualFile root : hierarchy) {
                librariesToIgnore.addAll(this.excludedFromLibraries.get((Object)root));
                if (source && this.libraryOrSdkSources.contains(root) && (!this.sourceOfLibraries.containsKey((Object)root) || !librariesToIgnore.containsAll(this.sourceOfLibraries.get((Object)root)))) {
                    return root;
                }
                if (source || !this.libraryOrSdkClasses.contains(root) || this.classOfLibraries.containsKey((Object)root) && librariesToIgnore.containsAll(this.classOfLibraries.get((Object)root))) continue;
                return root;
            }
            return null;
        }

        private String calcPackagePrefix(@NotNull VirtualFile root, @NotNull List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "calcPackagePrefix"));
            }
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "calcPackagePrefix"));
            }
            VirtualFile packageRoot = this.findPackageRootInfo(hierarchy, moduleContentRoot, libraryClassRoot, librarySourceRoot);
            String prefix = this.packagePrefix.get(packageRoot);
            if (prefix != null && !root.equals(packageRoot)) {
                assert (packageRoot != null);
                String relative = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)packageRoot, (char)'.');
                prefix = StringUtil.isEmpty((String)prefix) ? relative : prefix + '.' + relative;
            }
            return prefix;
        }

        @Nullable
        private VirtualFile findPackageRootInfo(@NotNull List<VirtualFile> hierarchy, VirtualFile moduleContentRoot, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "findPackageRootInfo"));
            }
            for (VirtualFile root : hierarchy) {
                if (moduleContentRoot != null && this.sourceRootOf.get((Object)root).contains(this.contentRootOf.get(moduleContentRoot)) && librarySourceRoot == null) {
                    return root;
                }
                if (root.equals(libraryClassRoot) || root.equals(librarySourceRoot)) {
                    return root;
                }
                if (!root.equals(moduleContentRoot) || this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null || libraryClassRoot != null) continue;
                return null;
            }
            return null;
        }

        @NotNull
        private LinkedHashSet<OrderEntry> getLibraryOrderEntries(@NotNull List<VirtualFile> hierarchy, @Nullable VirtualFile libraryClassRoot, @Nullable VirtualFile librarySourceRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            if (libClassRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libClassRootEntries", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            if (libSourceRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libSourceRootEntries", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            LinkedHashSet orderEntries = ContainerUtil.newLinkedHashSet();
            for (VirtualFile root : hierarchy) {
                if (root.equals(libraryClassRoot) && !this.sourceRootOf.containsKey((Object)root)) {
                    orderEntries.addAll(libClassRootEntries.get((Object)root));
                }
                if (root.equals(librarySourceRoot) && libraryClassRoot == null) {
                    orderEntries.addAll(libSourceRootEntries.get((Object)root));
                }
                if (!libClassRootEntries.containsKey((Object)root) && (!this.sourceRootOf.containsKey((Object)root) || librarySourceRoot != null)) continue;
                break;
            }
            LinkedHashSet linkedHashSet = orderEntries;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getLibraryOrderEntries"));
            }
            return linkedHashSet;
        }

        @Nullable
        private ModuleSourceOrderEntry getModuleSourceEntry(@NotNull List<VirtualFile> hierarchy, @NotNull VirtualFile moduleContentRoot, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries) {
            if (hierarchy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchy", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getModuleSourceEntry"));
            }
            if (moduleContentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContentRoot", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getModuleSourceEntry"));
            }
            if (libClassRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libClassRootEntries", "com/intellij/openapi/roots/impl/RootIndex$RootInfo", "getModuleSourceEntry"));
            }
            Module module2 = this.contentRootOf.get(moduleContentRoot);
            for (VirtualFile root : hierarchy) {
                if (this.sourceRootOf.get((Object)root).contains(module2)) {
                    return (ModuleSourceOrderEntry)ContainerUtil.findInstance((Object[])ModuleRootManager.getInstance((Module)module2).getOrderEntries(), ModuleSourceOrderEntry.class);
                }
                if (!libClassRootEntries.containsKey((Object)root)) continue;
                return null;
            }
            return null;
        }
    }

    private static class OrderEntryGraph {
        final Project myProject;
        final RootInfo myRootInfo;
        final Set<VirtualFile> myAllRoots;
        Graph myGraph;
        MultiMap<VirtualFile, Node> myRoots;
        final SynchronizedSLRUCache<VirtualFile, List<OrderEntry>> myCache;
        private MultiMap<VirtualFile, OrderEntry> myLibClassRootEntries;
        private MultiMap<VirtualFile, OrderEntry> myLibSourceRootEntries;

        public OrderEntryGraph(Project project2, RootInfo rootInfo) {
            this.myProject = project2;
            this.myRootInfo = rootInfo;
            this.myAllRoots = this.myRootInfo.getAllRoots();
            int cacheSize = Math.max(25, this.myAllRoots.size() / 100 * 2);
            this.myCache = new SynchronizedSLRUCache<VirtualFile, List<OrderEntry>>(cacheSize, cacheSize){

                @Override
                @NotNull
                public List<OrderEntry> createValue(VirtualFile key2) {
                    List list = this.collectOrderEntries(key2);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph$1", "createValue"));
                    }
                    return list;
                }
            };
            this.initGraph();
            this.initLibraryRoots();
        }

        private void initGraph() {
            Graph graph = new Graph();
            MultiMap roots = MultiMap.createSmart();
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                List<OrderEnumerationHandler> handlers = OrderEnumeratorBase.getCustomHandlers(module2);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    ModuleOrderEntry moduleOrderEntry;
                    Module depModule;
                    if (!(orderEntry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                    Node node = graph.myNodes.get(depModule);
                    OrderEnumerator en = OrderEnumerator.orderEntries((Module)depModule).exportedOnly();
                    if (node == null) {
                        VirtualFile[] importedSourceRoots;
                        VirtualFile[] importedClassRoots;
                        node = new Node();
                        node.myKey = depModule;
                        graph.myNodes.put(depModule, node);
                        for (VirtualFile importedClassRoot : importedClassRoots = en.classes().usingCache().getRoots()) {
                            roots.putValue((Object)importedClassRoot, (Object)node);
                        }
                        for (VirtualFile sourceRoot : importedSourceRoots = en.sources().usingCache().getRoots()) {
                            roots.putValue((Object)sourceRoot, (Object)node);
                        }
                    }
                    boolean shouldRecurse = en.recursively().shouldRecurse(moduleOrderEntry, handlers);
                    node.myEdges.add(new Edge(module2, moduleOrderEntry, shouldRecurse));
                }
            }
            this.myGraph = graph;
            this.myRoots = roots;
        }

        private void initLibraryRoots() {
            MultiMap libClassRootEntries = MultiMap.createSmart();
            MultiMap libSourceRootEntries = MultiMap.createSmart();
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    for (VirtualFile sourceRoot : entry.getRootFiles(OrderRootType.SOURCES)) {
                        libSourceRootEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                    }
                    for (VirtualFile classRoot : entry.getRootFiles(OrderRootType.CLASSES)) {
                        libClassRootEntries.putValue((Object)classRoot, (Object)orderEntry);
                    }
                }
            }
            this.myLibClassRootEntries = libClassRootEntries;
            this.myLibSourceRootEntries = libSourceRootEntries;
        }

        private List<OrderEntry> getOrderEntries(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph", "getOrderEntries"));
            }
            return this.myCache.get(file2);
        }

        private List<OrderEntry> collectOrderEntries(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/RootIndex$OrderEntryGraph", "collectOrderEntries"));
            }
            List roots = RootIndex.getHierarchy(file2, this.myAllRoots, this.myRootInfo);
            if (roots == null) {
                return Collections.emptyList();
            }
            ArrayList<OrderEntry> result2 = new ArrayList<OrderEntry>();
            Stack<Node> stack = new Stack<Node>();
            for (VirtualFile root : roots) {
                Collection nodes = this.myRoots.get((Object)root);
                Iterator iterator = nodes.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    stack.push(node);
                }
            }
            HashSet<Node> seen = new HashSet<Node>();
            while (!stack.isEmpty()) {
                Node node = (Node)stack.pop();
                if (seen.contains(node)) continue;
                seen.add(node);
                for (Edge edge : node.myEdges) {
                    Node targetNode;
                    result2.add((OrderEntry)edge.myOrderEntry);
                    if (!edge.myRecursive || (targetNode = this.myGraph.myNodes.get(edge.myKey)) == null) continue;
                    stack.push(targetNode);
                }
            }
            VirtualFile libraryClassRoot = this.myRootInfo.findLibraryRootInfo(roots, false);
            VirtualFile librarySourceRoot = this.myRootInfo.findLibraryRootInfo(roots, true);
            result2.addAll(this.myRootInfo.getLibraryOrderEntries(roots, libraryClassRoot, librarySourceRoot, (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)this.myLibSourceRootEntries));
            VirtualFile moduleContentRoot = this.myRootInfo.findModuleRootInfo(roots);
            if (moduleContentRoot != null) {
                ContainerUtil.addIfNotNull(result2, (Object)this.myRootInfo.getModuleSourceEntry(roots, moduleContentRoot, (MultiMap<VirtualFile, OrderEntry>)this.myLibClassRootEntries));
            }
            Collections.sort(result2, BY_OWNER_MODULE);
            return result2;
        }

        private static class Graph {
            Map<Module, Node> myNodes = new HashMap<Module, Node>();

            private Graph() {
            }
        }

        private static class Node {
            Module myKey;
            List<Edge> myEdges = new ArrayList<Edge>();

            private Node() {
            }

            public String toString() {
                return this.myKey.toString();
            }
        }

        private static class Edge {
            Module myKey;
            ModuleOrderEntry myOrderEntry;
            boolean myRecursive;

            public Edge(Module key2, ModuleOrderEntry orderEntry, boolean recursive) {
                this.myKey = key2;
                this.myOrderEntry = orderEntry;
                this.myRecursive = recursive;
            }

            public String toString() {
                return this.myOrderEntry.toString();
            }
        }
    }
}

