/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.AnnotateCurrentRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotatePreviousRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.AnnotationGutterLineConvertorProxy;
import com.intellij.openapi.vcs.actions.AnnotationPresentation;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.actions.CopyRevisionNumberFromAnnotateAction;
import com.intellij.openapi.vcs.actions.CurrentRevisionAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ExtraFieldGutter;
import com.intellij.openapi.vcs.actions.HighlightedAdditionalColumn;
import com.intellij.openapi.vcs.actions.HistoryIdColumn;
import com.intellij.openapi.vcs.actions.MergeSourceAvailableMarkerGutter;
import com.intellij.openapi.vcs.actions.ShowDiffFromAnnotation;
import com.intellij.openapi.vcs.actions.SwitchAnnotationSourceAction;
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateToggleAction
extends ToggleAction
implements DumbAware {
    public static final ExtensionPointName<Provider> EP_NAME = ExtensionPointName.create((String)"com.intellij.openapi.vcs.actions.AnnotateToggleAction.Provider");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "update"));
        }
        super.update(e);
        Provider provider = AnnotateToggleAction.getProvider(e);
        e.getPresentation().setEnabled(provider != null && !provider.isSuspended(e));
    }

    public boolean isSelected(AnActionEvent e) {
        Provider provider = AnnotateToggleAction.getProvider(e);
        return provider != null && provider.isAnnotated(e);
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        Provider provider = AnnotateToggleAction.getProvider(e);
        if (provider != null) {
            provider.perform(e, selected);
        }
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project2, @Nullable VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        AnnotateToggleAction.doAnnotate(editor, project2, currentFile, fileAnnotation, vcs, null);
    }

    public static void doAnnotate(final @NotNull Editor editor, final @NotNull Project project2, @Nullable VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @Nullable UpToDateLineNumberProvider getUpToDateLineNumber) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (fileAnnotation.getFile() != null && fileAnnotation.getFile().isInLocalFileSystem()) {
            ProjectLevelVcsManager.getInstance((Project)project2).getAnnotationLocalChangesListener().registerAnnotation(fileAnnotation.getFile(), fileAnnotation);
        }
        editor.getGutter().closeAllAnnotations();
        fileAnnotation.setCloser(new Runnable(){

            @Override
            public void run() {
                if (project2.isDisposed()) {
                    return;
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (project2.isDisposed()) {
                            return;
                        }
                        editor.getGutter().closeAllAnnotations();
                    }
                });
            }
        });
        EditorGutterComponentEx editorGutter = (EditorGutterComponentEx)editor.getGutter();
        ArrayList<AnnotationFieldGutter> gutters = new ArrayList<AnnotationFieldGutter>();
        AnnotationSourceSwitcher switcher = fileAnnotation.getAnnotationSourceSwitcher();
        if (getUpToDateLineNumber == null) {
            getUpToDateLineNumber = new UpToDateLineNumberProviderImpl(editor.getDocument(), project2);
        }
        AnnotationPresentation presentation = new AnnotationPresentation(fileAnnotation, getUpToDateLineNumber, switcher);
        if (currentFile != null && vcs.getCommittedChangesProvider() != null) {
            presentation.addAction((AnAction)new ShowDiffFromAnnotation(fileAnnotation, vcs, currentFile));
        }
        presentation.addAction((AnAction)new CopyRevisionNumberFromAnnotateAction(fileAnnotation));
        presentation.addAction((AnAction)Separator.getInstance());
        Couple<Map<VcsRevisionNumber, Color>> bgColorMap = AnnotateToggleAction.computeBgColors(fileAnnotation, editor);
        Map<VcsRevisionNumber, Integer> historyIds = AnnotateToggleAction.computeLineNumbers(fileAnnotation);
        if (switcher != null) {
            switcher.switchTo(switcher.getDefaultSource());
            LineAnnotationAspect revisionAspect = switcher.getRevisionAspect();
            CurrentRevisionAnnotationFieldGutter currentRevisionGutter = new CurrentRevisionAnnotationFieldGutter(fileAnnotation, revisionAspect, presentation, bgColorMap);
            MergeSourceAvailableMarkerGutter mergeSourceGutter = new MergeSourceAvailableMarkerGutter(fileAnnotation, null, presentation, bgColorMap);
            SwitchAnnotationSourceAction switchAction = new SwitchAnnotationSourceAction(switcher, editorGutter);
            presentation.addAction(switchAction);
            switchAction.addSourceSwitchListener(currentRevisionGutter);
            switchAction.addSourceSwitchListener(mergeSourceGutter);
            currentRevisionGutter.consume(switcher.getDefaultSource());
            mergeSourceGutter.consume(switcher.getDefaultSource());
            gutters.add(currentRevisionGutter);
            gutters.add(mergeSourceGutter);
        }
        LineAnnotationAspect[] aspects = fileAnnotation.getAspects();
        for (LineAnnotationAspect aspect : aspects) {
            gutters.add(new AnnotationFieldGutter(fileAnnotation, aspect, presentation, bgColorMap));
        }
        if (historyIds != null) {
            gutters.add(new HistoryIdColumn(fileAnnotation, presentation, bgColorMap, historyIds));
        }
        gutters.add(new HighlightedAdditionalColumn(fileAnnotation, null, presentation, bgColorMap));
        AnnotateActionGroup actionGroup = new AnnotateActionGroup(gutters, editorGutter, bgColorMap);
        presentation.addAction((AnAction)actionGroup, 1);
        gutters.add(new ExtraFieldGutter(fileAnnotation, presentation, bgColorMap, actionGroup));
        presentation.addAction(new AnnotateCurrentRevisionAction(fileAnnotation, vcs));
        presentation.addAction(new AnnotatePreviousRevisionAction(fileAnnotation, vcs));
        AnnotateToggleAction.addActionsFromExtensions(presentation, fileAnnotation);
        for (AnnotationFieldGutter gutter : gutters) {
            AnnotationGutterLineConvertorProxy proxy = new AnnotationGutterLineConvertorProxy(getUpToDateLineNumber, gutter);
            if (gutter.isGutterAction()) {
                editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy, (EditorGutterAction)proxy);
                continue;
            }
            editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy);
        }
    }

    private static void addActionsFromExtensions(@NotNull AnnotationPresentation presentation, @NotNull FileAnnotation fileAnnotation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "addActionsFromExtensions"));
        }
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "addActionsFromExtensions"));
        }
        AnnotationGutterActionProvider[] extensions = (AnnotationGutterActionProvider[])AnnotationGutterActionProvider.EP_NAME.getExtensions();
        if (extensions.length > 0) {
            presentation.addAction((AnAction)new Separator());
        }
        for (AnnotationGutterActionProvider provider : extensions) {
            presentation.addAction(provider.createAction(fileAnnotation));
        }
    }

    @Nullable
    private static Map<VcsRevisionNumber, Integer> computeLineNumbers(@NotNull FileAnnotation fileAnnotation) {
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "computeLineNumbers"));
        }
        HashMap<VcsRevisionNumber, Integer> numbers = new HashMap<VcsRevisionNumber, Integer>();
        List fileRevisionList = fileAnnotation.getRevisions();
        if (fileRevisionList != null) {
            int size = fileRevisionList.size();
            for (int i = 0; i < size; ++i) {
                VcsFileRevision revision = (VcsFileRevision)fileRevisionList.get(i);
                VcsRevisionNumber number = revision.getRevisionNumber();
                numbers.put(number, size - i);
            }
        }
        return numbers.size() < 2 ? null : numbers;
    }

    @Nullable
    private static Couple<Map<VcsRevisionNumber, Color>> computeBgColors(@NotNull FileAnnotation fileAnnotation, @NotNull Editor editor) {
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "computeBgColors"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "computeBgColors"));
        }
        List fileRevisionList = fileAnnotation.getRevisions();
        if (ContainerUtil.isEmpty((Collection)fileRevisionList)) {
            return null;
        }
        HashMap<VcsRevisionNumber, Color> commitOrderColors = new HashMap<VcsRevisionNumber, Color>();
        HashMap commitAuthorColors = new HashMap();
        HashMap<String, Color> authorColors = new HashMap<String, Color>();
        EditorColorsScheme colorScheme = editor.getColorsScheme();
        AnnotationsSettings settings = AnnotationsSettings.getInstance();
        List<Color> authorsColorPalette = settings.getAuthorsColors(colorScheme);
        List<Color> orderedColorPalette = settings.getOrderedColors(colorScheme);
        int revisionsCount = fileRevisionList.size();
        for (int i = 0; i < fileRevisionList.size(); ++i) {
            VcsFileRevision revision = (VcsFileRevision)fileRevisionList.get(i);
            VcsRevisionNumber number = revision.getRevisionNumber();
            String author = revision.getAuthor();
            if (number == null) continue;
            if (!commitAuthorColors.containsKey(number)) {
                if (author != null && !authorColors.containsKey(author)) {
                    int index = authorColors.size();
                    Color color = authorsColorPalette.get(index % authorsColorPalette.size());
                    authorColors.put(author, color);
                }
                commitAuthorColors.put(number, authorColors.get(author));
            }
            if (commitOrderColors.containsKey(number)) continue;
            Color color = orderedColorPalette.get(orderedColorPalette.size() * i / revisionsCount);
            commitOrderColors.put(number, color);
        }
        return Couple.of(commitOrderColors.size() > 1 ? commitOrderColors : null, commitAuthorColors.size() > 1 ? commitAuthorColors : null);
    }

    @Nullable
    private static Provider getProvider(AnActionEvent e) {
        for (Provider provider : (Provider[])EP_NAME.getExtensions()) {
            if (!provider.isEnabled(e)) continue;
            return provider;
        }
        return null;
    }

    public static interface Provider {
        public boolean isEnabled(AnActionEvent var1);

        public boolean isSuspended(AnActionEvent var1);

        public boolean isAnnotated(AnActionEvent var1);

        public void perform(AnActionEvent var1, boolean var2);
    }
}

