/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnversionedViewDialog
extends DialogWrapper {
    private JPanel myPanel;
    private final ChangesListView myView;
    private final ChangeListManager myChangeListManager;
    private boolean myInRefresh;
    private final Project myProject;
    private AnAction myDeleteActionWithCustomShortcut;

    public UnversionedViewDialog(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "<init>"));
        }
        super(project2, true);
        this.setTitle("Unversioned Files");
        this.myProject = project2;
        final Runnable closer = new Runnable(){

            @Override
            public void run() {
                UnversionedViewDialog.this.close(0);
            }
        };
        this.myView = new ChangesListView(project2){

            @Override
            public void calcData(DataKey key2, DataSink sink) {
                super.calcData(key2, sink);
                if (ChangesListView.UNVERSIONED_FILES_DATA_KEY.is(key2.getName())) {
                    sink.put(key2, Arrays.asList(this.getSelectedFiles()));
                }
            }

            @Override
            protected void editSourceRegistration() {
                EditSourceOnDoubleClickHandler.install((JTree)((Object)this), (Runnable)closer);
                EditSourceOnEnterKeyHandler.install((JComponent)((Object)this), (Runnable)closer);
            }
        };
        this.myChangeListManager = ChangeListManager.getInstance((Project)project2);
        this.createPanel();
        this.setOKButtonText("Close");
        this.init();
        this.initData(((ChangeListManagerImpl)this.myChangeListManager).getUnversionedFiles());
        this.myView.setMinimumSize(new Dimension(100, 100));
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "createActions"));
        }
        return actionArray;
    }

    private void initData(List<VirtualFile> files) {
        TreeState state = TreeState.createOn((JTree)((Object)this.myView), (DefaultMutableTreeNode)((ChangesBrowserNode)this.myView.getModel().getRoot()));
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.myView.isShowFlatten());
        DefaultTreeModel model = builder.buildModelFromFiles(files);
        this.myView.setModel(model);
        this.myView.expandPath(new TreePath(((ChangesBrowserNode)model.getRoot()).getPath()));
        state.applyTo((JTree)((Object)this.myView));
    }

    private void createPanel() {
        this.myPanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UNVERSIONED_DIALOG", (ActionGroup)group, true);
        List<AnAction> actions = UnversionedViewDialog.registerUnversionedActionsShortcuts(actionToolbar.getToolbarDataContext(), (JComponent)((Object)this.myView));
        this.myDeleteActionWithCustomShortcut = EmptyAction.registerWithShortcutSet((String)"ChangesView.DeleteUnversioned.From.Dialog", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)((Object)this.myView));
        actions.add(this.myDeleteActionWithCustomShortcut);
        this.refreshViewAfterActionPerformed(actions);
        group.add((AnAction)UnversionedViewDialog.getUnversionedActionGroup());
        CommonActionsManager cam = CommonActionsManager.getInstance();
        Expander expander = new Expander();
        group.addSeparator();
        group.add((AnAction)new ToggleShowFlattenAction());
        group.add(cam.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        group.add(cam.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)this.myView)));
        this.myPanel.add((Component)actionToolbar.getComponent(), "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myView)), "Center");
        DefaultActionGroup secondGroup = new DefaultActionGroup();
        secondGroup.addAll(UnversionedViewDialog.getUnversionedActionGroup());
        this.myView.setMenuActions((ActionGroup)secondGroup);
        this.myView.setShowFlatten(false);
    }

    private void refreshViewAfterActionPerformed(final @NotNull List<AnAction> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "refreshViewAfterActionPerformed"));
        }
        ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (actions.contains(action)) {
                    UnversionedViewDialog.this.refreshView();
                    if (UnversionedViewDialog.this.myDeleteActionWithCustomShortcut.equals(action)) {
                        UnversionedViewDialog.refreshChanges(UnversionedViewDialog.this.myProject, (ChangesBrowserBase)ChangesBrowserBase.DATA_KEY.getData(DataManager.getInstance().getDataContext((Component)((Object)UnversionedViewDialog.this.myView))));
                    }
                }
            }
        }, this.myDisposable);
    }

    @NotNull
    public static ActionGroup getUnversionedActionGroup() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Unversioned.Files.Dialog");
        if (actionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "getUnversionedActionGroup"));
        }
        return actionGroup;
    }

    @NotNull
    public static List<AnAction> registerUnversionedActionsShortcuts(@NotNull DataContext dataContext, @NotNull JComponent component) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "registerUnversionedActionsShortcuts"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "registerUnversionedActionsShortcuts"));
        }
        ActionManager manager = ActionManager.getInstance();
        ArrayList actions = ContainerUtil.newArrayList();
        Utils.expandActionGroup(UnversionedViewDialog.getUnversionedActionGroup(), actions, new PresentationFactory(), dataContext, "", manager);
        for (AnAction action : actions) {
            action.registerCustomShortcutSet(action.getShortcutSet(), component);
        }
        ArrayList arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "registerUnversionedActionsShortcuts"));
        }
        return arrayList;
    }

    public static void refreshChanges(@NotNull Project project2, @Nullable ChangesBrowserBase browser) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/UnversionedViewDialog", "refreshChanges"));
        }
        if (browser != null) {
            ChangeListManager.getInstance((Project)project2).invokeAfterUpdate(browser::rebuildList, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Delete files", null);
        }
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.openapi.vcs.changes.UnversionedViewDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myView;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void refreshView() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myInRefresh) {
            return;
        }
        this.myInRefresh = true;
        this.myChangeListManager.invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                try {
                    UnversionedViewDialog.this.initData(((ChangeListManagerImpl)UnversionedViewDialog.this.myChangeListManager).getUnversionedFiles());
                }
                finally {
                    UnversionedViewDialog.this.myInRefresh = false;
                }
            }
        }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE, "", ModalityState.current());
    }

    public class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !UnversionedViewDialog.this.myView.isShowFlatten();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            UnversionedViewDialog.this.myView.setShowFlatten(!state);
            UnversionedViewDialog.this.refreshView();
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)UnversionedViewDialog.this.myView));
        }

        public boolean canExpand() {
            return !UnversionedViewDialog.this.myView.isShowFlatten();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)UnversionedViewDialog.this.myView), (int)1);
            TreeUtil.expand((JTree)((Object)UnversionedViewDialog.this.myView), (int)0);
        }

        public boolean canCollapse() {
            return !UnversionedViewDialog.this.myView.isShowFlatten();
        }
    }
}

